/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;

public class HighlighterPipeline
implements Highlighter.UIHighlighter {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected List<Highlighter> highlighters = new ArrayList<Highlighter>();
    private static final Highlighter nullHighlighter = new Highlighter(null, null, true);
    private ChangeListener highlighterChangeListener;

    public HighlighterPipeline() {
    }

    public HighlighterPipeline(Highlighter[] highlighterArray) {
        this();
        for (int i = 0; i < highlighterArray.length; ++i) {
            this.addHighlighter(highlighterArray[i]);
        }
    }

    public void addHighlighter(Highlighter highlighter) {
        this.addHighlighter(highlighter, false);
    }

    public void addHighlighter(Highlighter highlighter, boolean bl) {
        if (bl) {
            this.highlighters.add(0, highlighter);
        } else {
            this.highlighters.add(this.highlighters.size(), highlighter);
        }
        this.updateUI(highlighter);
        highlighter.addChangeListener(this.getHighlighterChangeListener());
        this.fireStateChanged();
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    HighlighterPipeline.this.fireStateChanged();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    public void removeHighlighter(Highlighter highlighter) {
        boolean bl = this.highlighters.remove(highlighter);
        if (bl) {
            highlighter.removeChangeListener(this.getHighlighterChangeListener());
            this.fireStateChanged();
        }
    }

    public Highlighter[] getHighlighters() {
        return this.highlighters.toArray(new Highlighter[this.highlighters.size()]);
    }

    public Component apply(Component component, ComponentAdapter componentAdapter) {
        if (componentAdapter.getComponent() instanceof JTable) {
            component = nullHighlighter.highlight(component, componentAdapter);
        }
        Iterator<Highlighter> iterator = this.highlighters.iterator();
        while (iterator.hasNext()) {
            component = iterator.next().highlight(component, componentAdapter);
        }
        return component;
    }

    public void updateUI() {
        for (Highlighter highlighter : this.highlighters) {
            this.updateUI(highlighter);
        }
    }

    private void updateUI(Highlighter highlighter) {
        if (highlighter instanceof Highlighter.UIHighlighter) {
            ((Highlighter.UIHighlighter)((Object)highlighter)).updateUI();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }
}

