/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class MatteBorderExt
extends MatteBorder {
    protected Icon[] tileIcons = null;
    private Icon defaultIcon = null;

    public MatteBorderExt(int n, int n2, int n3, int n4, Icon[] iconArray) {
        super(n, n2, n3, n4, iconArray == null || iconArray.length == 0 ? null : iconArray[0]);
        this.tileIcons = iconArray;
    }

    public MatteBorderExt(int n, int n2, int n3, int n4, Color color) {
        super(n, n2, n3, n4, color);
    }

    public MatteBorderExt(Insets insets, Color color) {
        super(insets, color);
    }

    public MatteBorderExt(int n, int n2, int n3, int n4, Icon icon) {
        super(n, n2, n3, n4, icon);
    }

    public MatteBorderExt(Insets insets, Icon icon) {
        super(insets, icon);
    }

    public MatteBorderExt(Icon icon) {
        super(icon);
    }

    public Icon[] getTileIcons() {
        return this.tileIcons;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons == null || this.tileIcons.length < 2) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            return;
        }
        Insets insets = this.getBorderInsets(component);
        int n5 = Math.min(n3, insets.left);
        int n6 = Math.min(n4, insets.top);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        Color color = graphics.getColor();
        graphics.translate(n, n2);
        for (int i = 0; i < this.tileIcons.length; ++i) {
            if (this.tileIcons[i] != null) continue;
            this.tileIcons[i] = this.getDefaultIcon();
        }
        this.paintTopLeft(component, graphics, 0, 0, insets.left, insets.top);
        this.paintTop(component, graphics, insets.left, 0, n3 - insets.left - insets.right, insets.top);
        this.paintTopRight(component, graphics, n3 - insets.right, 0, insets.right, insets.top);
        this.paintRight(component, graphics, n3 - insets.right, insets.top, insets.right, n4 - insets.top - insets.bottom);
        this.paintBottomRight(component, graphics, n3 - insets.right, n4 - insets.bottom, insets.right, insets.bottom);
        this.paintBottom(component, graphics, insets.left, n4 - insets.bottom, n3 - insets.left - insets.right, insets.bottom);
        this.paintBottomLeft(component, graphics, 0, n4 - insets.bottom, insets.left, insets.bottom);
        this.paintLeft(component, graphics, 0, insets.top, insets.left, n4 - insets.top - insets.bottom);
        graphics.translate(-n, -n2);
        graphics.setColor(color);
    }

    protected void paint(Icon icon, Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        graphics2.setClip(n, n2, n3, n4);
        int n5 = icon.getIconWidth();
        int n6 = icon.getIconHeight();
        int n7 = 0;
        while (n4 - n7 > 0) {
            int n8 = 0;
            while (n3 - n8 > 0) {
                icon.paintIcon(component, graphics2, n + n8, n2 + n7);
                n8 += n5;
            }
            n7 += n6;
        }
        graphics2.dispose();
    }

    protected void paintTopLeft(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics graphics2 = graphics.create();
        graphics2.setClip(n, n2, n3, n4);
        this.tileIcons[0].paintIcon(component, graphics2, n, n2);
        graphics2.dispose();
    }

    protected void paintTop(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        this.paint(this.tileIcons[1], component, graphics, n, n2, n3, n4);
    }

    protected void paintTopRight(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[2], component, graphics, n, n2, n3, n4);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintRight(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[3], component, graphics, n, n2, n3, n4);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected void paintBottomRight(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[4], component, graphics, n, n2, n3, n4);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintBottom(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[5], component, graphics, n, n2, n3, n4);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected void paintBottomLeft(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[6], component, graphics, n, n2, n3, n4);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintLeft(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[7], component, graphics, n, n2, n3, n4);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected Icon getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = new Icon(){
                private int width = 3;
                private int height = 3;

                public int getIconWidth() {
                    return this.width;
                }

                public int getIconHeight() {
                    return this.height;
                }

                public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                    graphics.setColor(component.getBackground().darker().darker());
                    graphics.fillRect(n, n2, this.width, this.height);
                }
            };
        }
        return this.defaultIcon;
    }
}

