/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.AbstractSearchable;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.LinkModel;
import org.jdesktop.swingx.LinkRenderer;
import org.jdesktop.swingx.RolloverProducer;
import org.jdesktop.swingx.SearchFactory;
import org.jdesktop.swingx.Searchable;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterPipeline;
import org.jdesktop.swingx.decorator.PatternHighlighter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SearchHighlighter;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.SizeSequenceMapper;
import org.jdesktop.swingx.decorator.Sorter;
import org.jdesktop.swingx.icon.ColumnControlIcon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class JXTable
extends JTable {
    private static final Logger LOG = Logger.getLogger(JXTable.class.getName());
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    public static final String HORIZONTALSCROLL_ACTION_COMMAND = "column.horizontalScroll";
    public static final String PACKALL_ACTION_COMMAND = "column.packAll";
    public static final String PACKSELECTED_ACTION_COMMAND = "column.packSelected";
    public static final String UIPREFIX = "JXTable.";
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";
    protected FilterPipeline filters;
    protected HighlighterPipeline highlighters;
    protected ComponentAdapter dataAdapter;
    private SelectionMapper selectionMapper;
    private boolean sortable;
    private PipelineListener pipelineListener;
    private ChangeListener highlighterChangeListener;
    private ColumnFactory columnFactory;
    private int visibleRowCount = 18;
    private SizeSequenceMapper rowModelMapper;
    private Field rowModelField;
    private boolean rowHeightEnabled;
    private boolean columnControlVisible;
    private int verticalScrollPolicy;
    private JComponent columnControlButton;
    private RolloverProducer rolloverProducer;
    private LinkController linkController;
    private int oldAutoResizeMode;
    protected boolean isXTableRowHeightSet;
    protected Searchable searchable;

    public JXTable() {
        this.init();
    }

    public JXTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    public JXTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.init();
    }

    public JXTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.init();
    }

    public JXTable(int n, int n2) {
        super(n, n2);
        this.init();
    }

    public JXTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.init();
    }

    public JXTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.init();
    }

    protected void init() {
        this.setSortable(true);
        this.setFilters(null);
        this.initActionsAndBindings();
        this.updateRowHeightUI(false);
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.isRolloverEnabled();
        if (bl == bl2) {
            return;
        }
        if (bl) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", bl2, this.isRolloverEnabled());
    }

    protected LinkController getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected LinkController createLinkController() {
        return new LinkController();
    }

    protected RolloverProducer createRolloverProducer() {
        RolloverProducer rolloverProducer = new RolloverProducer(){

            protected void updateRolloverPoint(JComponent jComponent, Point point) {
                JXTable jXTable = (JXTable)jComponent;
                int n = jXTable.columnAtPoint(point);
                int n2 = jXTable.rowAtPoint(point);
                if (n < 0 || n2 < 0) {
                    n2 = -1;
                    n = -1;
                }
                this.rollover.x = n;
                this.rollover.y = n2;
            }
        };
        return rolloverProducer;
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    public void setDefaultLinkVisitor(ActionListener actionListener) {
        TableCellRenderer tableCellRenderer;
        TableCellEditor tableCellEditor = this.getDefaultEditor(LinkModel.class);
        if (tableCellEditor instanceof LinkRenderer) {
            ((LinkRenderer)tableCellEditor).setVisitingDelegate(actionListener);
        }
        if ((tableCellRenderer = this.getDefaultRenderer(LinkModel.class)) instanceof LinkRenderer) {
            ((LinkRenderer)tableCellRenderer).setVisitingDelegate(actionListener);
        }
        this.setRolloverEnabled(true);
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.configureColumnControl();
        this.configureViewportBackground();
    }

    protected void configureViewportBackground() {
        Container container = this.getParent();
        if (container instanceof JViewport) {
            container.setBackground(this.getBackground());
        }
    }

    private void configureColumnControl() {
        Container container;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            JViewport jViewport = jScrollPane.getViewport();
            if (jViewport == null || jViewport.getView() != this) {
                return;
            }
            if (this.isColumnControlVisible()) {
                this.verticalScrollPolicy = jScrollPane.getVerticalScrollBarPolicy();
                jScrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnControl());
                jScrollPane.setVerticalScrollBarPolicy(22);
            } else {
                if (this.verticalScrollPolicy != 0) {
                    jScrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
                }
                try {
                    jScrollPane.setCorner("UPPER_TRAILING_CORNER", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this.configureColumnControl();
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public JComponent getColumnControl() {
        if (this.columnControlButton == null) {
            this.columnControlButton = new ColumnControlButton(this, (Icon)new ColumnControlIcon());
        }
        return this.columnControlButton;
    }

    public void setColumnControlVisible(boolean bl) {
        boolean bl2 = this.columnControlVisible;
        this.columnControlVisible = bl;
        this.configureColumnControl();
        this.firePropertyChange("columnControlVisible", bl2, this.columnControlVisible);
    }

    private void initActionsAndBindings() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("print", new Actions("print"));
        actionMap.put("find", new Actions("find"));
        actionMap.put(PACKALL_ACTION_COMMAND, this.createPackAllAction());
        actionMap.put(PACKSELECTED_ACTION_COMMAND, this.createPackSelectedAction());
        actionMap.put(HORIZONTALSCROLL_ACTION_COMMAND, this.createHorizontalScrollAction());
        KeyStroke keyStroke = KeyStroke.getKeyStroke("control F");
        this.getInputMap(1).put(keyStroke, "find");
    }

    private Action createHorizontalScrollAction() {
        String string = this.getUIString(HORIZONTALSCROLL_ACTION_COMMAND);
        BoundAction boundAction = new BoundAction(string, HORIZONTALSCROLL_ACTION_COMMAND);
        boundAction.setStateAction();
        boundAction.registerCallback(this, "setHorizontalScrollEnabled");
        boundAction.setSelected(this.isHorizontalScrollEnabled());
        return boundAction;
    }

    private String getUIString(String string) {
        String string2 = UIManager.getString(UIPREFIX + string);
        return string2 != null ? string2 : string;
    }

    private Action createPackSelectedAction() {
        String string = this.getUIString(PACKSELECTED_ACTION_COMMAND);
        BoundAction boundAction = new BoundAction(string, PACKSELECTED_ACTION_COMMAND);
        boundAction.registerCallback(this, "packSelected");
        boundAction.setEnabled(this.getSelectedColumnCount() > 0);
        return boundAction;
    }

    private Action createPackAllAction() {
        String string = this.getUIString(PACKALL_ACTION_COMMAND);
        BoundAction boundAction = new BoundAction(string, PACKALL_ACTION_COMMAND);
        boundAction.registerCallback(this, "packAll");
        return boundAction;
    }

    public void packAll() {
        this.packTable(this.getDefaultPackMargin());
    }

    public void packSelected() {
        int n = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n >= 0) {
            this.packColumn(n, this.getDefaultPackMargin());
        }
    }

    public void setHorizontalScrollEnabled(boolean bl) {
        if (bl == this.isHorizontalScrollEnabled()) {
            return;
        }
        if (bl) {
            this.oldAutoResizeMode = this.getAutoResizeMode();
            this.setAutoResizeMode(0);
        } else {
            this.setAutoResizeMode(this.oldAutoResizeMode);
        }
    }

    private boolean isHorizontalScrollEnabled() {
        return this.getAutoResizeMode() == 0;
    }

    private int getDefaultPackMargin() {
        return 4;
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        super.columnSelectionChanged(listSelectionEvent);
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Action action = this.getActionMap().get(PACKSELECTED_ACTION_COMMAND);
        if (action != null) {
            action.setEnabled(!((ListSelectionModel)listSelectionEvent.getSource()).isSelectionEmpty());
        }
    }

    public void setAutoResizeMode(int n) {
        super.setAutoResizeMode(n);
        Action action = this.getActionMap().get(HORIZONTALSCROLL_ACTION_COMMAND);
        if (action instanceof BoundAction) {
            ((BoundAction)action).setSelected(this.isHorizontalScrollEnabled());
        }
    }

    public int getRowCount() {
        return this.filters == null ? super.getRowCount() : this.filters.getOutputSize();
    }

    public boolean isHierarchical(int n) {
        return false;
    }

    public int convertRowIndexToModel(int n) {
        return this.getFilters().convertRowIndexToModel(n);
    }

    public int convertRowIndexToView(int n) {
        return this.getFilters().convertRowIndexToView(n);
    }

    public Object getValueAt(int n, int n2) {
        return this.getModel().getValueAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
    }

    public void setValueAt(Object object, int n, int n2) {
        this.getModel().setValueAt(object, this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
    }

    public boolean isCellEditable(int n, int n2) {
        return this.getModel().isCellEditable(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
    }

    public void setModel(TableModel tableModel) {
        this.getSelectionMapper().lock();
        super.setModel(tableModel);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.getSelectionModel().getValueIsAdjusting()) {
            this.getSelectionModel().setValueIsAdjusting(false);
        }
        this.getSelectionMapper().lock();
        super.tableChanged(tableModelEvent);
        this.updateSelectionAndRowModel(tableModelEvent);
        this.use(this.filters);
    }

    private void updateSelectionAndRowModel(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 1) {
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getLastRow();
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = this.getModel().getRowCount() - 1;
            }
            int n3 = n2 - n + 1;
            this.getSelectionMapper().insertIndexInterval(n, n3, true);
            this.getRowModelMapper().insertIndexInterval(n, n3, this.getRowHeight());
        } else if (tableModelEvent.getType() == -1) {
            int n = tableModelEvent.getFirstRow();
            int n4 = tableModelEvent.getLastRow();
            if (n < 0) {
                n = 0;
            }
            if (n4 < 0) {
                n4 = this.getModel().getRowCount() - 1;
            }
            int n5 = n4 - n + 1;
            this.getSelectionMapper().removeIndexInterval(n, n4);
            this.getRowModelMapper().removeIndexInterval(n, n5);
        } else if (this.getSelectionModel().isSelectionEmpty()) {
            this.getSelectionMapper().clearModelSelection();
            this.getRowModelMapper().clearModelSizes();
            this.updateViewSizeSequence();
        }
    }

    protected void updateViewSizeSequence() {
        SizeSequence sizeSequence = null;
        if (this.isRowHeightEnabled()) {
            sizeSequence = this.getSuperRowModel();
        }
        this.getRowModelMapper().setViewSizeSequence(sizeSequence, this.getRowHeight());
    }

    private SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new SelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        return this.filters;
    }

    private void use(FilterPipeline filterPipeline) {
        if (filterPipeline != null) {
            if (this.initialUse(filterPipeline)) {
                filterPipeline.addPipelineListener(this.getFilterPipelineListener());
                filterPipeline.assign(this.getComponentAdapter());
            } else {
                filterPipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline filterPipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] pipelineListenerArray = filterPipeline.getPipelineListeners();
        for (int i = 0; i < pipelineListenerArray.length; ++i) {
            if (!this.pipelineListener.equals(pipelineListenerArray[i])) continue;
            return false;
        }
        return true;
    }

    public void setFilters(FilterPipeline filterPipeline) {
        FilterPipeline filterPipeline2 = this.getFilters();
        Sorter sorter = null;
        if (filterPipeline2 != null) {
            filterPipeline2.removePipelineListener(this.pipelineListener);
            sorter = filterPipeline2.getSorter();
        }
        if (filterPipeline == null) {
            filterPipeline = new FilterPipeline();
        }
        this.filters = filterPipeline;
        this.filters.setSorter(sorter);
        this.use(this.filters);
        this.getRowModelMapper().setFilters(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        PipelineListener pipelineListener = new PipelineListener(){

            public void contentsChanged(PipelineEvent pipelineEvent) {
                JXTable.this.updateOnFilterContentChanged();
            }
        };
        return pipelineListener;
    }

    protected void updateOnFilterContentChanged() {
        this.revalidate();
        this.repaint();
    }

    public void setSortable(boolean bl) {
        if (bl == this.isSortable()) {
            return;
        }
        this.sortable = bl;
        if (!this.isSortable()) {
            this.resetSorter();
        }
        this.firePropertyChange("sortable", !bl, bl);
    }

    public boolean isSortable() {
        return this.sortable;
    }

    private void setInteractiveSorter(Sorter sorter) {
        if (this.filters == null) {
            return;
        }
        this.getFilters().setSorter(sorter);
    }

    private Sorter getInteractiveSorter() {
        if (this.filters == null) {
            return null;
        }
        return this.getFilters().getSorter();
    }

    protected void resetSorter() {
        this.setInteractiveSorter(null);
        this.getTableHeader().repaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.updateSorterAfterColumnRemoved();
        super.columnRemoved(tableColumnModelEvent);
    }

    private void updateSorterAfterColumnRemoved() {
        Sorter sorter = this.getInteractiveSorter();
        if (sorter != null) {
            int n = sorter.getColumnIndex();
            List list = this.getColumns(true);
            for (TableColumn tableColumn : list) {
                if (tableColumn.getModelIndex() != n) continue;
                return;
            }
            this.resetSorter();
        }
    }

    protected void setSorter(int n) {
        if (!this.isSortable()) {
            return;
        }
        Sorter sorter = this.getInteractiveSorter();
        if (sorter != null && sorter.getColumnIndex() == this.convertColumnIndexToModel(n)) {
            sorter.toggle();
        } else {
            TableColumnExt tableColumnExt = this.getColumnExt(n);
            this.getFilters().setSorter(tableColumnExt != null ? tableColumnExt.getSorter() : null);
        }
    }

    public Sorter getSorter(int n) {
        Sorter sorter = this.getInteractiveSorter();
        return sorter == null ? null : (sorter.getColumnIndex() == this.convertColumnIndexToModel(n) ? sorter : null);
    }

    protected void removeColumns() {
        List list = this.getColumns(true);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.getColumnModel().removeColumn((TableColumn)iterator.next());
        }
    }

    public List getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public List getColumns(boolean bl) {
        if (bl && this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumns(bl);
        }
        return this.getColumns();
    }

    public int getColumnCount(boolean bl) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnCount(bl);
        }
        return this.getColumnCount();
    }

    public void setColumnSequence(Object[] objectArray) {
        List list = this.getColumns(true);
        HashMap<Object, TableColumn> hashMap = new HashMap<Object, TableColumn>();
        for (TableColumn tableColumn : list) {
            hashMap.put(tableColumn.getIdentifier(), tableColumn);
            this.getColumnModel().removeColumn(tableColumn);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            TableColumn tableColumn;
            tableColumn = (TableColumn)hashMap.get(objectArray[i]);
            if (tableColumn == null) continue;
            this.getColumnModel().addColumn(tableColumn);
            list.remove(tableColumn);
        }
        for (TableColumn tableColumn : list) {
            this.getColumnModel().addColumn(tableColumn);
        }
    }

    public TableColumnExt getColumnExt(Object object) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnExt(object);
        }
        try {
            TableColumn tableColumn = this.getColumn(object);
            if (tableColumn instanceof TableColumnExt) {
                return (TableColumnExt)tableColumn;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public TableColumnExt getColumnExt(int n) {
        return (TableColumnExt)this.getColumnModel().getColumn(n);
    }

    public void createDefaultColumnsFromModel() {
        TableModel tableModel = this.getModel();
        if (tableModel != null) {
            int n;
            int n2 = tableModel.getColumnCount();
            TableColumn[] tableColumnArray = new TableColumn[n2];
            for (n = 0; n < tableColumnArray.length; ++n) {
                tableColumnArray[n] = this.createAndConfigureColumn(tableModel, n);
            }
            this.removeColumns();
            for (n = 0; n < tableColumnArray.length; ++n) {
                this.addColumn(tableColumnArray[n]);
            }
        }
    }

    protected TableColumn createAndConfigureColumn(TableModel tableModel, int n) {
        return this.getColumnFactory().createAndConfigureTableColumn(tableModel, n);
    }

    protected ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            this.columnFactory = ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int n) {
        this.getColumnModel().setColumnMargin(n);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    private void find() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TableSearchable();
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension dimension = super.getPreferredScrollableViewportSize();
        if (dimension.getWidth() == 450.0 && dimension.getHeight() == 400.0) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n = tableColumnModel.getColumnCount();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                this.initializeColumnPreferredWidth(tableColumn);
                n2 += tableColumn.getPreferredWidth();
            }
            dimension.width = n2;
            JTableHeader jTableHeader = this.getTableHeader();
            int n3 = this.getVisibleRowCount();
            dimension.height = n3 * this.getRowHeight() + (jTableHeader != null ? jTableHeader.getPreferredSize().height : 0);
            this.setPreferredScrollableViewportSize(dimension);
        }
        return dimension;
    }

    public void packTable(int n) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.packColumn(i, n, -1);
        }
    }

    public void packColumn(int n, int n2) {
        this.packColumn(n, n2, -1);
    }

    public void packColumn(int n, int n2, int n3) {
        this.getColumnFactory().packColumn(this, this.getColumnExt(n), n2, n3);
    }

    protected void initializeColumnPreferredWidth(TableColumn tableColumn) {
        if (tableColumn instanceof TableColumnExt) {
            this.getColumnFactory().configureColumnWidths(this, (TableColumnExt)tableColumn);
        }
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TableAdapter(this);
        }
        return this.dataAdapter;
    }

    public HighlighterPipeline getHighlighters() {
        return this.highlighters;
    }

    public void setHighlighters(HighlighterPipeline highlighterPipeline) {
        HighlighterPipeline highlighterPipeline2 = this.getHighlighters();
        if (highlighterPipeline2 != null) {
            highlighterPipeline2.removeChangeListener(this.getHighlighterChangeListener());
        }
        this.highlighters = highlighterPipeline;
        if (this.highlighters != null) {
            this.highlighters.addChangeListener(this.getHighlighterChangeListener());
        }
        this.firePropertyChange("highlighters", highlighterPipeline2, this.getHighlighters());
        this.repaint();
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    JXTable.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        this.adjustComponentOrientation(component);
        if (this.highlighters == null) {
            return component;
        }
        ComponentAdapter componentAdapter = this.getComponentAdapter();
        componentAdapter.row = n;
        componentAdapter.column = n2;
        return this.highlighters.apply(component, componentAdapter);
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        Component component = super.prepareEditor(tableCellEditor, n, n2);
        this.adjustComponentOrientation(component);
        return component;
    }

    protected void adjustComponentOrientation(Component component) {
        if (component.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        component.applyComponentOrientation(this.getComponentOrientation());
    }

    public TableCellRenderer getNewDefaultRenderer(Class clazz) {
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(clazz);
        if (tableCellRenderer != null) {
            try {
                return (TableCellRenderer)tableCellRenderer.getClass().newInstance();
            }
            catch (Exception exception) {
                LOG.fine("could not create renderer for " + clazz);
            }
        }
        return null;
    }

    protected void createDefaultEditors() {
        super.createDefaultEditors();
        this.setLazyEditor(LinkModel.class, "org.jdesktop.swingx.LinkRenderer");
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.setLazyRenderer(Object.class, "javax.swing.table.DefaultTableCellRenderer");
        this.setLazyRenderer(Number.class, "org.jdesktop.swingx.JXTable$NumberRenderer");
        this.setLazyRenderer(Float.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        this.setLazyRenderer(Double.class, "org.jdesktop.swingx.JXTable$DoubleRenderer");
        this.setLazyRenderer(Date.class, "org.jdesktop.swingx.JXTable$DateRenderer");
        this.setLazyRenderer(Icon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        this.setLazyRenderer(ImageIcon.class, "org.jdesktop.swingx.JXTable$IconRenderer");
        this.setLazyRenderer(Boolean.class, "org.jdesktop.swingx.JXTable$BooleanRenderer");
        this.setLazyRenderer(LinkModel.class, "org.jdesktop.swingx.LinkRenderer");
    }

    private void setLazyValue(Hashtable hashtable, Class clazz, String string) {
        hashtable.put(clazz, new UIDefaults.ProxyLazyValue(string));
    }

    private void setLazyRenderer(Class clazz, String string) {
        this.setLazyValue(this.defaultRenderersByColumnClass, clazz, string);
    }

    private void setLazyEditor(Class clazz, String string) {
        this.setLazyValue(this.defaultEditorsByColumnClass, clazz, string);
    }

    public void updateUI() {
        super.updateUI();
        if (this.columnControlButton != null) {
            this.columnControlButton.updateUI();
        }
        Object object = this.defaultEditorsByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateEditorUI(object.nextElement());
        }
        object = this.defaultRenderersByColumnClass.elements();
        while (object.hasMoreElements()) {
            this.updateRendererUI(object.nextElement());
        }
        object = this.getColumns(true);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            TableColumn tableColumn = (TableColumn)iterator.next();
            this.updateEditorUI(tableColumn.getCellEditor());
            this.updateRendererUI(tableColumn.getCellRenderer());
            this.updateRendererUI(tableColumn.getHeaderRenderer());
        }
        this.updateRowHeightUI(true);
        this.updateHighlighters();
        this.configureViewportBackground();
    }

    protected void updateHighlighters() {
        if (this.getHighlighters() == null) {
            return;
        }
        this.getHighlighters().updateUI();
    }

    private void updateRowHeightUI(boolean bl) {
        if (bl && this.isXTableRowHeightSet) {
            return;
        }
        int n = this.getFont().getSize() + 6;
        int n2 = UIManager.getInt("JXTable.rowHeight");
        this.setRowHeight(Math.max(n, n2 != 0 ? n2 : 18));
        this.isXTableRowHeightSet = false;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (n > 0) {
            this.isXTableRowHeightSet = true;
        }
        this.updateViewSizeSequence();
    }

    public void setRowHeight(int n, int n2) {
        if (!this.isRowHeightEnabled()) {
            return;
        }
        super.setRowHeight(n, n2);
        this.updateViewSizeSequence();
        this.resizeAndRepaint();
    }

    public void setRowHeightEnabled(boolean bl) {
        boolean bl2 = this.isRowHeightEnabled();
        if (bl2 == bl) {
            return;
        }
        if (bl && !this.canEnableRowHeight()) {
            return;
        }
        this.rowHeightEnabled = bl;
        if (!bl) {
            this.adminSetRowHeight(this.getRowHeight());
        }
        this.firePropertyChange("rowHeightEnabled", bl2, this.rowHeightEnabled);
    }

    private boolean canEnableRowHeight() {
        return this.getRowModelField() != null;
    }

    public boolean isRowHeightEnabled() {
        return this.rowHeightEnabled;
    }

    private SizeSequence getSuperRowModel() {
        try {
            Field field = this.getRowModelField();
            if (field != null) {
                return (SizeSequence)field.get(this);
            }
        }
        catch (SecurityException securityException) {
            LOG.fine("cannot use reflection  - expected behaviour in sandbox");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.fine("problem while accessing super's private field - private api changed?");
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.fine("cannot access private field  - expected behaviour in sandbox. Could be program logic running wild in unrestricted contexts");
        }
        return null;
    }

    private Field getRowModelField() {
        if (this.rowModelField == null) {
            try {
                this.rowModelField = JTable.class.getDeclaredField("rowModel");
                this.rowModelField.setAccessible(true);
            }
            catch (SecurityException securityException) {
                this.rowModelField = null;
                LOG.fine("cannot access JTable private field rowModel - expected behaviour in sandbox");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LOG.fine("problem while accessing super's private field - private api changed?");
            }
        }
        return this.rowModelField;
    }

    protected SizeSequenceMapper getRowModelMapper() {
        if (this.rowModelMapper == null) {
            this.rowModelMapper = new SizeSequenceMapper(this.filters);
        }
        return this.rowModelMapper;
    }

    protected void adminSetRowHeight(int n) {
        boolean bl = this.isXTableRowHeightSet;
        this.setRowHeight(n);
        this.isXTableRowHeightSet = bl;
    }

    private void updateEditorUI(Object object) {
        if (!(object instanceof TableCellEditor)) {
            return;
        }
        if (object instanceof JComponent || object instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component component = ((TableCellEditor)object).getTableCellEditorComponent(this, null, false, -1, -1);
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(Object object) {
        if (!(object instanceof TableCellRenderer)) {
            return;
        }
        if (object instanceof JComponent) {
            return;
        }
        try {
            Component component = ((TableCellRenderer)object).getTableCellRendererComponent(this, null, false, false, -1, -1);
            if (component instanceof JComponent) {
                ((JComponent)component).updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int rowAtPoint(Point point) {
        if (point.y < 0) {
            return -1;
        }
        return super.rowAtPoint(point);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.columnModel);
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModelExt();
    }

    static {
        LookAndFeelAddons.getAddon();
    }

    public static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    public static class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object object) {
            this.setIcon(object instanceof Icon ? (Icon)object : null);
        }
    }

    public static class DateRenderer
    extends DefaultTableCellRenderer {
        private final DateFormat formatter;

        public DateRenderer() {
            this((DateFormat)null);
        }

        public DateRenderer(DateFormat dateFormat) {
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateInstance();
            }
            this.formatter = dateFormat;
        }

        public void setValue(Object object) {
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    public static class DoubleRenderer
    extends NumberRenderer {
        private final NumberFormat formatter;

        public DoubleRenderer() {
            this((NumberFormat)null);
        }

        public DoubleRenderer(NumberFormat numberFormat) {
            if (numberFormat == null) {
                numberFormat = NumberFormat.getInstance();
            }
            this.formatter = numberFormat;
        }

        public void setValue(Object object) {
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    public static class NumberRenderer
    extends DefaultTableCellRenderer {
        public NumberRenderer() {
            this.setHorizontalAlignment(11);
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final JXTable table;

        public TableAdapter(JXTable jXTable) {
            super(jXTable);
            this.table = jXTable;
        }

        public JXTable getTable() {
            return this.table;
        }

        public String getColumnName(int n) {
            TableColumn tableColumn = this.getColumnByModelIndex(n);
            return tableColumn == null ? "" : tableColumn.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int n) {
            List list = this.table.getColumns(true);
            for (TableColumn tableColumn : list) {
                if (tableColumn.getModelIndex() != n) continue;
                return tableColumn;
            }
            return null;
        }

        public String getColumnIdentifier(int n) {
            TableColumn tableColumn = this.getColumnByModelIndex(n);
            Object object = tableColumn != null ? tableColumn.getIdentifier() : null;
            return object != null ? object.toString() : null;
        }

        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        public Object getValueAt(int n, int n2) {
            return this.table.getModel().getValueAt(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.table.getModel().setValueAt(object, n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.table.getModel().isCellEditable(n, n2);
        }

        public boolean isTestable(int n) {
            return this.getColumnByModelIndex(n) != null;
        }

        public Object getFilteredValueAt(int n, int n2) {
            return this.getValueAt(this.table.convertRowIndexToModel(n), n2);
        }

        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        public boolean hasFocus() {
            boolean bl = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean bl2 = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && bl && bl2;
        }

        public int modelToView(int n) {
            return this.table.convertColumnIndexToView(n);
        }

        public int viewToModel(int n) {
            return this.table.convertColumnIndexToModel(n);
        }
    }

    public class TableSearchable
    extends AbstractSearchable {
        private SearchHighlighter searchHighlighter;

        protected void findMatchAndUpdateState(Pattern pattern, int n, boolean bl) {
            AbstractSearchable.SearchResult searchResult = null;
            if (bl) {
                for (int i = n; i >= -1 && searchResult == null; --i) {
                    searchResult = this.findMatchBackwardsInRow(pattern, i);
                    this.updateState(searchResult);
                }
            } else {
                for (int i = n; i <= this.getSize() && searchResult == null; ++i) {
                    searchResult = this.findMatchForwardInRow(pattern, i);
                    this.updateState(searchResult);
                }
            }
        }

        protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int n) {
            return this.findMatchAt(pattern, n, this.lastSearchResult.foundColumn);
        }

        private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int n) {
            int n2;
            int n3 = n2 = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
            if (this.isValidIndex(n)) {
                for (int i = n2; i < JXTable.this.getColumnCount(); ++i) {
                    AbstractSearchable.SearchResult searchResult = this.findMatchAt(pattern, n, i);
                    if (searchResult == null) continue;
                    return searchResult;
                }
            }
            return null;
        }

        private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int n) {
            int n2;
            int n3 = n2 = this.lastSearchResult.foundColumn < 0 ? JXTable.this.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
            if (this.isValidIndex(n)) {
                for (int i = n2; i >= 0; --i) {
                    AbstractSearchable.SearchResult searchResult = this.findMatchAt(pattern, n, i);
                    if (searchResult == null) continue;
                    return searchResult;
                }
            }
            return null;
        }

        protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int n, int n2) {
            Matcher matcher;
            Object object = JXTable.this.getValueAt(n, n2);
            if (object != null && (matcher = pattern.matcher(object.toString())).find()) {
                return this.createSearchResult(matcher, n, n2);
            }
            return null;
        }

        protected int adjustStartPosition(int n, boolean bl) {
            this.lastSearchResult.foundColumn = -1;
            return super.adjustStartPosition(n, bl);
        }

        protected int moveStartPosition(int n, boolean bl) {
            if (bl) {
                --this.lastSearchResult.foundColumn;
                if (this.lastSearchResult.foundColumn < 0) {
                    --n;
                }
            } else {
                ++this.lastSearchResult.foundColumn;
                if (this.lastSearchResult.foundColumn >= JXTable.this.getColumnCount()) {
                    this.lastSearchResult.foundColumn = -1;
                    ++n;
                }
            }
            return n;
        }

        protected boolean isEqualStartIndex(int n) {
            return super.isEqualStartIndex(n) && this.isValidColumn(this.lastSearchResult.foundColumn);
        }

        private boolean isValidColumn(int n) {
            return n >= 0 && n < JXTable.this.getColumnCount();
        }

        protected int getSize() {
            return JXTable.this.getRowCount();
        }

        protected void moveMatchMarker() {
            int n = this.lastSearchResult.foundRow;
            int n2 = this.lastSearchResult.foundColumn;
            Pattern pattern = this.lastSearchResult.pattern;
            if (n < 0 || n2 < 0) {
                if (this.markByHighlighter()) {
                    this.getSearchHighlighter().setPattern(null);
                }
                return;
            }
            if (this.markByHighlighter()) {
                Rectangle rectangle = JXTable.this.getCellRect(n, n2, true);
                if (rectangle != null) {
                    JXTable.this.scrollRectToVisible(rectangle);
                }
                this.ensureInsertedSearchHighlighters();
                this.getSearchHighlighter().setPattern(pattern);
                int n3 = JXTable.this.convertColumnIndexToModel(n2);
                this.getSearchHighlighter().setHighlightCell(n, n3);
            } else {
                Rectangle rectangle;
                JXTable.this.changeSelection(n, n2, false, false);
                if (!JXTable.this.getAutoscrolls() && (rectangle = JXTable.this.getCellRect(n, n2, true)) != null) {
                    JXTable.this.scrollRectToVisible(rectangle);
                }
            }
        }

        private boolean markByHighlighter() {
            return Boolean.TRUE.equals(JXTable.this.getClientProperty(JXTable.MATCH_HIGHLIGHTER));
        }

        private SearchHighlighter getSearchHighlighter() {
            if (this.searchHighlighter == null) {
                this.searchHighlighter = this.createSearchHighlighter();
            }
            return this.searchHighlighter;
        }

        private void ensureInsertedSearchHighlighters() {
            if (JXTable.this.getHighlighters() == null) {
                JXTable.this.setHighlighters(new HighlighterPipeline(new Highlighter[]{this.getSearchHighlighter()}));
            } else if (!this.isInPipeline(this.getSearchHighlighter())) {
                JXTable.this.getHighlighters().addHighlighter(this.getSearchHighlighter());
            }
        }

        private boolean isInPipeline(PatternHighlighter patternHighlighter) {
            Highlighter[] highlighterArray = JXTable.this.getHighlighters().getHighlighters();
            if (highlighterArray.length > 0 && patternHighlighter.equals(highlighterArray[highlighterArray.length - 1])) {
                return true;
            }
            JXTable.this.getHighlighters().removeHighlighter(patternHighlighter);
            return false;
        }

        protected SearchHighlighter createSearchHighlighter() {
            return new SearchHighlighter();
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("print".equals(this.getName())) {
                try {
                    JXTable.this.print();
                }
                catch (PrinterException printerException) {
                    LOG.log(Level.WARNING, "", printerException);
                }
            } else if ("find".equals(this.getName())) {
                JXTable.this.find();
            }
        }
    }

    public static class LinkController
    implements PropertyChangeListener {
        private Cursor oldCursor;
        private JXTable table;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("swingx.rollover".equals(propertyChangeEvent.getPropertyName())) {
                this.rollover((JXTable)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getNewValue());
            } else if ("swingx.clicked".equals(propertyChangeEvent.getPropertyName())) {
                this.click((JXTable)propertyChangeEvent.getSource(), (Point)propertyChangeEvent.getOldValue(), (Point)propertyChangeEvent.getNewValue());
            }
        }

        public void install(JXTable jXTable) {
            this.release();
            this.table = jXTable;
            jXTable.addPropertyChangeListener(this);
            this.registerExecuteButtonAction();
        }

        public void release() {
            if (this.table == null) {
                return;
            }
            this.table.removePropertyChangeListener(this);
            this.unregisterExecuteButtonAction();
        }

        private void rollover(JXTable jXTable, Point point, Point point2) {
            Rectangle rectangle;
            if (point != null) {
                rectangle = jXTable.getCellRect(point.y, point.x, false);
                rectangle.x = 0;
                rectangle.width = jXTable.getWidth();
                jXTable.repaint(rectangle);
            }
            if (point2 != null) {
                rectangle = jXTable.getCellRect(point2.y, point2.x, false);
                rectangle.x = 0;
                rectangle.width = jXTable.getWidth();
                jXTable.repaint(rectangle);
            }
            this.setLinkCursor(jXTable, point2);
        }

        private void click(JXTable jXTable, Point point, Point point2) {
            if (!this.isLinkColumn(jXTable, point2)) {
                return;
            }
            if (jXTable.isCellEditable(point2.y, point2.x)) {
                return;
            }
            TableCellRenderer tableCellRenderer = jXTable.getCellRenderer(point2.y, point2.x);
            Component component = jXTable.prepareRenderer(tableCellRenderer, point2.y, point2.x);
            if (component instanceof AbstractButton) {
                ((AbstractButton)component).doClick();
                jXTable.repaint();
            }
        }

        private void setLinkCursor(JXTable jXTable, Point point) {
            if (this.isLinkColumn(jXTable, point)) {
                if (this.oldCursor == null) {
                    this.oldCursor = jXTable.getCursor();
                    jXTable.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.oldCursor != null) {
                jXTable.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }

        private boolean isLinkColumn(JXTable jXTable, Point point) {
            if (point == null || point.x < 0) {
                return false;
            }
            return jXTable.getColumnClass(point.x) == LinkModel.class;
        }

        private void unregisterExecuteButtonAction() {
            this.table.getActionMap().put(JXTable.EXECUTE_BUTTON_ACTIONCOMMAND, null);
            KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
            this.table.getInputMap(1).put(keyStroke, null);
        }

        private void registerExecuteButtonAction() {
            this.table.getActionMap().put(JXTable.EXECUTE_BUTTON_ACTIONCOMMAND, this.createExecuteButtonAction());
            KeyStroke keyStroke = KeyStroke.getKeyStroke("released SPACE");
            this.table.getInputMap(1).put(keyStroke, JXTable.EXECUTE_BUTTON_ACTIONCOMMAND);
        }

        private Action createExecuteButtonAction() {
            AbstractAction abstractAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractButton abstractButton = this.getClickableRendererComponent();
                    if (abstractButton != null) {
                        abstractButton.doClick();
                        LinkController.this.table.repaint();
                    }
                }

                public boolean isEnabled() {
                    return this.isClickable();
                }

                private boolean isClickable() {
                    return this.getClickableRendererComponent() != null;
                }

                private AbstractButton getClickableRendererComponent() {
                    if (LinkController.this.table == null || !LinkController.this.table.isEnabled() || !LinkController.this.table.hasFocus()) {
                        return null;
                    }
                    int n = LinkController.this.table.getSelectionModel().getLeadSelectionIndex();
                    int n2 = LinkController.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                    if (n < 0 || n2 < 0 || LinkController.this.table.isCellEditable(n, n2)) {
                        return null;
                    }
                    TableCellRenderer tableCellRenderer = LinkController.this.table.getCellRenderer(n, n2);
                    Component component = LinkController.this.table.prepareRenderer(tableCellRenderer, n, n2);
                    return component instanceof AbstractButton ? (AbstractButton)component : null;
                }
            };
            return abstractAction;
        }
    }
}

