/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx.adapter;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.binding.IndexMapper;
import org.jdesktop.binding.SelectionBinding;
import org.jdesktop.binding.SelectionModel;
import org.jdesktop.binding.SelectionModelEvent;
import org.jdesktop.binding.SelectionModelListener;

public class ListSelectionBinding
extends SelectionBinding {
    private boolean indexIsChanging = false;
    private IndexMapper indexMapper;
    private ListSelectionModel listSelectionModel;

    public ListSelectionBinding(SelectionModel selectionModel, ListSelectionModel listSelectionModel) {
        this(selectionModel, listSelectionModel, null);
    }

    public ListSelectionBinding(SelectionModel selectionModel, ListSelectionModel listSelectionModel, IndexMapper indexMapper) {
        super(selectionModel);
        this.indexMapper = indexMapper;
        this.listSelectionModel = listSelectionModel;
        this.installViewSelectionListener();
        this.installDataSelectionListener();
        this.updateViewSelectionModelFromData();
    }

    private void installDataSelectionListener() {
        this.selectionModel.addSelectionModelListener(new SelectionModelListener(){

            public void selectionChanged(SelectionModelEvent selectionModelEvent) {
                ListSelectionBinding.this.updateViewSelectionModelFromData();
            }
        });
    }

    private void installViewSelectionListener() {
        this.listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting() && !ListSelectionBinding.this.indexIsChanging) {
                    ListSelectionBinding.this.selectionModel.setSelectionIndices(ListSelectionBinding.this.getSelectedIndices(ListSelectionBinding.this.listSelectionModel));
                }
            }
        });
    }

    private int[] getSelectedIndices(ListSelectionModel listSelectionModel) {
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n < 0 || n2 < 0) {
            return new int[0];
        }
        int[] nArray = new int[1 + (n2 - n)];
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            nArray[n3++] = i;
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        nArray2 = this.convertIndicesToModel(nArray2);
        return nArray2;
    }

    private void setSelectedIndices(int[] nArray, ListSelectionModel listSelectionModel) {
        listSelectionModel.clearSelection();
        nArray = this.convertIndicesToView(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            listSelectionModel.addSelectionInterval(nArray[i], nArray[i]);
        }
    }

    private int[] convertIndicesToView(int[] nArray) {
        if (this.indexMapper == null) {
            return nArray;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.indexMapper.modelToView(nArray[i]);
        }
        return nArray;
    }

    private int[] convertIndicesToModel(int[] nArray) {
        if (this.indexMapper == null) {
            return nArray;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.indexMapper.viewToModel(nArray[i]);
        }
        return nArray;
    }

    private void updateViewSelectionModelFromData() {
        this.indexIsChanging = true;
        this.setSelectedIndices(this.selectionModel.getSelectionIndices(), this.listSelectionModel);
        this.indexIsChanging = false;
    }
}

