/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.swingx.AbstractBinding;
import org.jdesktop.swingx.JXHyperlink;

public class LabelMetaBinding
extends AbstractBinding {
    private JLabel label;
    private Icon requiredIcon;

    public LabelMetaBinding(JLabel jLabel, DataModel dataModel, String string) {
        super(jLabel, dataModel, string, 2);
        this.pull();
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean push() {
        return true;
    }

    public boolean pull() {
        if (this.metaData != null) {
            this.setComponentValue(this.metaData.getLabel());
            this.updateRequiredFeedBack(this.metaData.isRequired());
        }
        return true;
    }

    public JComponent getComponent() {
        return this.label;
    }

    protected void setComponent(JComponent jComponent) {
        this.label = (JLabel)jComponent;
    }

    protected void installDataModelListener() {
    }

    protected void installMetaDataListener() {
        this.metaData.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!"label".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                LabelMetaBinding.this.pull();
            }
        });
    }

    protected Object getComponentValue() {
        return this.label.getText();
    }

    protected void setComponentValue(Object object) {
        this.label.setText(this.createColonedText(object));
    }

    protected void updateRequiredFeedBack(boolean bl) {
        if (bl) {
            this.label.setIcon(this.getRequiredIcon());
        } else {
            this.label.setIcon(null);
        }
    }

    protected Icon getRequiredIcon() {
        if (this.requiredIcon == null) {
            URL uRL = JXHyperlink.class.getResource("resources/asterisk.8x8.png");
            this.requiredIcon = new ImageIcon(uRL);
        }
        return this.requiredIcon;
    }

    protected String createColonedText(Object object) {
        if (this.isEmpty(object)) {
            return "";
        }
        String string = object.toString();
        return this.getComponent().getComponentOrientation().isLeftToRight() ? string + this.getColon() : this.getColon() + string;
    }

    protected String getColon() {
        return ":";
    }
}

