/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freehep.swing.layout.StackedLayout;

public class JSubToolBar
extends JLayeredPane {
    JPopupMenu popup;
    JToolBar subToolBar;
    JComponent selectedComponent = null;
    MousePanel interceptor;
    LinkedList buttonList = new LinkedList();

    public JSubToolBar() {
        this.setLayout(new StackedLayout());
        this.interceptor = new MousePanel();
        this.add((Component)this.interceptor, DRAG_LAYER);
        this.subToolBar = new JToolBar();
        this.subToolBar.setFloatable(false);
        this.subToolBar.setBorderPainted(false);
        this.subToolBar.setMargin(new Insets(1, 1, 1, 1));
        this.popup = new JPopupMenu();
        this.popup.add(this.subToolBar);
        this.popup.setBorderPainted(true);
        Dimension d = new Dimension(10, 10);
        this.setPreferredSize(d);
    }

    protected JButton makeButtonFromAction(Action action) {
        JButton button = new JButton(){

            public Dimension getPreferredSize() {
                if (this.getIcon() != null) {
                    return new Dimension(24, 24);
                }
                Dimension d = super.getPreferredSize();
                d.height = 24;
                return d;
            }

            public String getText() {
                return this.getIcon() == null ? super.getText() : null;
            }
        };
        button.setAction(action);
        return button;
    }

    public void add(Action action) {
        JButton button = this.makeButtonFromAction(action);
        button.addActionListener(this.interceptor);
        this.subToolBar.add(button);
        this.buttonList.add(button);
        this.updatePreferredSize(button.getPreferredSize());
        if (this.selectedComponent == null) {
            this.setSelectedComponent(button);
        }
    }

    public void setDelay(int msDelay) {
        this.interceptor.setDelay(msDelay);
    }

    public int getDelay() {
        return this.interceptor.getDelay();
    }

    public void setSelectedComponent(JComponent component) {
        if (this.buttonList.contains(component)) {
            if (this.selectedComponent != null) {
                this.remove(this.selectedComponent);
            }
            this.selectedComponent = component;
            this.add((Component)component, DEFAULT_LAYER);
            component.requestFocus();
            this.validate();
            this.subToolBar.removeAll();
            Iterator i = this.buttonList.iterator();
            while (i.hasNext()) {
                Component c = (Component)i.next();
                if (c == this.selectedComponent) continue;
                this.subToolBar.add(c);
            }
        }
    }

    protected void updatePreferredSize(Dimension dim) {
        Dimension currentDim = this.getPreferredSize();
        if (dim.width > currentDim.width) {
            currentDim.width = dim.width;
        }
        if (dim.height > currentDim.height) {
            currentDim.height = dim.height;
        }
        this.setPreferredSize(currentDim);
        this.setMaximumSize(currentDim);
        this.setMinimumSize(currentDim);
    }

    private void updateOrientation() {
        int parentOrientation;
        JToolBar parent = (JToolBar)SwingUtilities.getAncestorOfClass(JToolBar.class, this);
        int orientation = 0;
        if (parent != null && (parentOrientation = parent.getOrientation()) == 0) {
            orientation = 1;
        }
        this.subToolBar.setOrientation(orientation);
    }

    private class MousePanel
    extends JPanel
    implements MouseListener,
    ActionListener {
        private Timer timer;
        private int delay = 300;

        public MousePanel() {
            this.setOpaque(false);
            this.timer = new Timer(this.delay, this);
            this.timer.setRepeats(false);
            this.addMouseListener(this);
        }

        public void setDelay(int msDelay) {
            this.delay = msDelay;
        }

        public int getDelay() {
            return this.delay;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.timer.stop();
        }

        public void mousePressed(MouseEvent e) {
            this.timer.start();
        }

        public void mouseReleased(MouseEvent e) {
            this.timer.stop();
        }

        public void mouseClicked(MouseEvent e) {
            this.timer.stop();
            if (!JSubToolBar.this.popup.isVisible() && JSubToolBar.this.selectedComponent != null && JSubToolBar.this.selectedComponent instanceof AbstractButton) {
                ((AbstractButton)JSubToolBar.this.selectedComponent).doClick();
            }
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof Timer) {
                JSubToolBar.this.updateOrientation();
                int orientation = JSubToolBar.this.subToolBar.getOrientation();
                int x0 = 0;
                int y0 = 0;
                if (orientation == 0) {
                    x0 = this.getWidth();
                } else {
                    y0 = this.getHeight();
                }
                JSubToolBar.this.popup.show(this, x0, y0);
                int w = JSubToolBar.this.popup.getWidth();
                int h = JSubToolBar.this.popup.getHeight();
                Point point = new Point(x0 + w, y0 + h);
                SwingUtilities.convertPointToScreen(point, this);
                GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice gd = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc2 = gd.getDefaultConfiguration();
                Rectangle screenBounds = gc2.getBounds();
                if (!screenBounds.contains(point)) {
                    if (JSubToolBar.this.subToolBar.getOrientation() == 0) {
                        int x = -w;
                        int y = 0;
                        JSubToolBar.this.popup.setVisible(false);
                        JSubToolBar.this.popup.show(this, x, y);
                    } else {
                        int x = 0;
                        int y = -h;
                        JSubToolBar.this.popup.setVisible(false);
                        JSubToolBar.this.popup.show(this, x, y);
                    }
                }
            } else if (source instanceof JComponent) {
                JSubToolBar.this.popup.setVisible(false);
                JSubToolBar.this.setSelectedComponent((JComponent)source);
            }
        }
    }
}

