/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import org.freehep.math.minuit.ContoursError;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MinosError;
import org.freehep.math.minuit.MinuitParameter;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnGlobalCorrelationCoeff;
import org.freehep.math.minuit.MnPlot;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.Point;

public abstract class MnPrint {
    private static final NumberFormat format = new DecimalFormat("0.#######E00");

    private MnPrint() {
    }

    static String toString(MnAlgebraicVector x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MnAlgebraicVector vec) {
        os2.println("LAVector parameters:");
        os2.println();
        int nrow = vec.size();
        for (int i = 0; i < nrow; ++i) {
            os2.print(format.format(vec.get(i)));
            os2.print(' ');
        }
        os2.println();
    }

    static String toString(MnAlgebraicSymMatrix x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MnAlgebraicSymMatrix matrix) {
        os2.println("LASymMatrix parameters:");
        os2.println();
        int n = matrix.nrow();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                os2.print(format.format(matrix.get(i, j)));
                os2.print(' ');
            }
            os2.println();
        }
    }

    static String toString(FunctionMinimum min) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, min);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, FunctionMinimum min) {
        os2.println();
        if (!min.isValid()) {
            os2.println();
            os2.println("WARNING: Minuit did not converge.");
            os2.println();
        } else {
            os2.println();
            os2.println("Minuit did successfully converge.");
            os2.println();
        }
        os2.println("# of function calls: " + min.nfcn());
        os2.println("minimum function value: " + format.format(min.fval()));
        os2.println("minimum edm: " + format.format(min.edm()));
        os2.println("minimum internal state vector: " + min.parameters().vec());
        if (min.hasValidCovariance()) {
            os2.println("minimum internal covariance matrix: " + min.error().matrix());
        }
        os2.println(min.userParameters());
        os2.println(min.userCovariance());
        os2.println(min.userState().globalCC());
        if (!min.isValid()) {
            os2.println("WARNING: FunctionMinimum is invalid.");
        }
        os2.println();
    }

    static String toString(MinimumState x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MinimumState min) {
        os2.println();
        os2.println("minimum function value: " + format.format(min.fval()));
        os2.println("minimum edm: " + format.format(min.edm()));
        os2.println("minimum internal state vector: " + min.vec());
        os2.println("minimum internal gradient vector: " + min.gradient().vec());
        if (min.hasCovariance()) {
            os2.println("minimum internal covariance matrix: " + min.error().matrix());
        }
        os2.println();
    }

    static String toString(MnUserParameters x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MnUserParameters par) {
        os2.println();
        os2.println("# ext. ||   name    ||   type  ||   value   ||  error +/- ");
        os2.println();
        boolean atLoLim = false;
        boolean atHiLim = false;
        Iterator iter = par.parameters().iterator();
        while (iter.hasNext()) {
            MinuitParameter ipar = (MinuitParameter)iter.next();
            os2.print(" " + ipar.number() + " || " + ipar.name() + " || ");
            if (ipar.isConst()) {
                os2.print("         || " + format.format(ipar.value()) + "   ||");
                continue;
            }
            if (ipar.isFixed()) {
                os2.println("  fixed  || " + format.format(ipar.value()) + "   ||");
                continue;
            }
            if (ipar.hasLimits()) {
                if (ipar.error() > 0.0) {
                    os2.print(" limited || " + format.format(ipar.value()));
                    if (Math.abs(ipar.value() - ipar.lowerLimit()) < par.precision().eps2()) {
                        os2.print("* ");
                        atLoLim = true;
                    }
                    if (Math.abs(ipar.value() - ipar.upperLimit()) < par.precision().eps2()) {
                        os2.print("**");
                        atHiLim = true;
                    }
                    os2.println(" || " + format.format(ipar.error()));
                    continue;
                }
                os2.println("  free   || " + format.format(ipar.value()) + " || no");
                continue;
            }
            if (ipar.error() > 0.0) {
                os2.println("  free   || " + format.format(ipar.value()) + " || " + format.format(ipar.error()));
                continue;
            }
            os2.println("  free   || " + format.format(ipar.value()) + " || no");
        }
        os2.println();
        if (atLoLim) {
            os2.print("* parameter is at lower limit");
        }
        if (atHiLim) {
            os2.print("** parameter is at upper limit");
        }
        os2.println();
    }

    static String toString(MnUserCovariance x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MnUserCovariance matrix) {
        int i;
        os2.println();
        os2.println("MnUserCovariance: ");
        os2.println();
        int n = matrix.nrow();
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                os2.print(format.format(matrix.get(i, j)));
                os2.print(' ');
            }
            os2.println();
        }
        os2.println();
        os2.println("MnUserCovariance parameter correlations: ");
        os2.println();
        n = matrix.nrow();
        for (i = 0; i < n; ++i) {
            double di = matrix.get(i, i);
            for (int j = 0; j < n; ++j) {
                double dj = matrix.get(j, j);
                os2.print(format.format(matrix.get(i, j) / Math.sqrt(Math.abs(di * dj))));
                os2.print(' ');
            }
            os2.println();
        }
    }

    static String toString(MnGlobalCorrelationCoeff x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MnGlobalCorrelationCoeff coeff) {
        os2.println();
        os2.println("MnGlobalCorrelationCoeff: ");
        os2.println();
        for (int i = 0; i < coeff.globalCC().length; ++i) {
            os2.println(format.format(coeff.globalCC()[i]));
        }
    }

    static String toString(MnUserParameterState x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MnUserParameterState state) {
        os2.println();
        if (!state.isValid()) {
            os2.println();
            os2.println("WARNING: MnUserParameterState is not valid.");
            os2.println();
        }
        os2.println("# of function calls: " + state.nfcn());
        os2.println("function value: " + state.fval());
        os2.println("expected distance to the minimum (edm): " + state.edm());
        os2.println("external parameters: " + state.parameters());
        if (state.hasCovariance()) {
            os2.println("covariance matrix: " + state.covariance());
        }
        if (state.hasGlobalCC()) {
            os2.println("global correlation coefficients : " + state.globalCC());
        }
        if (!state.isValid()) {
            os2.println("WARNING: MnUserParameterState is not valid.");
        }
        os2.println();
    }

    static String toString(MinosError x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, MinosError me) {
        os2.println();
        os2.println("Minos # of function calls: " + me.nfcn());
        if (!me.isValid()) {
            os2.println("Minos error is not valid.");
        }
        if (!me.lowerValid()) {
            os2.println("lower Minos error is not valid.");
        }
        if (!me.upperValid()) {
            os2.println("upper Minos error is not valid.");
        }
        if (me.atLowerLimit()) {
            os2.println("Minos error is lower limit of parameter " + me.parameter());
        }
        if (me.atUpperLimit()) {
            os2.println("Minos error is upper limit of parameter " + me.parameter());
        }
        if (me.atLowerMaxFcn()) {
            os2.println("Minos number of function calls for lower error exhausted.");
        }
        if (me.atUpperMaxFcn()) {
            os2.println("Minos number of function calls for upper error exhausted.");
        }
        if (me.lowerNewMin()) {
            os2.println("Minos found a new minimum in negative direction.");
            os2.println(me.lowerState());
        }
        if (me.upperNewMin()) {
            os2.println("Minos found a new minimum in positive direction.");
            os2.println(me.upperState());
        }
        os2.println("# ext. ||   name    || value@min ||  negative || positive  ");
        os2.println(me.parameter() + "||" + me.lowerState().name(me.parameter()) + "||" + format.format(me.min()) + "||" + format.format(me.lower()) + "||" + format.format(me.upper()));
        os2.println();
    }

    static String toString(ContoursError x) {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        MnPrint.print(pw, x);
        pw.close();
        return writer.toString();
    }

    public static void print(PrintWriter os2, ContoursError ce) {
        os2.println();
        os2.println("Contours # of function calls: " + ce.nfcn());
        os2.println("MinosError in x: ");
        os2.println(ce.xMinosError());
        os2.println("MinosError in y: ");
        os2.println(ce.yMinosError());
        MnPlot plot = new MnPlot();
        plot.plot(ce.xmin(), ce.ymin(), ce.points());
        int i = 0;
        Iterator iter = ce.points().iterator();
        while (iter.hasNext()) {
            Point ipoint = (Point)iter.next();
            os2.println(i++ + " " + format.format(ipoint.first) + " " + format.format(ipoint.second));
        }
        os2.println();
    }
}

