/*
 * Decompiled with CFR 0.152.
 */
package ice.util.StructuredDeviceList;

import ice.Global;
import ice.data.tas.bt7.Instrument;
import ice.util.StructuredDeviceList.StructuredDeviceList;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StructuredDeviceListReader {
    private static final String deviceOrderFileNameSuffix = "-DeviceOrder.xml";

    private static void addDeviceToStructuredList(Element deviceNode, StructuredDeviceList structuredDeviceList) {
        NodeList elementList = deviceNode.getElementsByTagName("Device");
        int elementListLength = -1;
        if (structuredDeviceList != null) {
            elementListLength = elementList.getLength();
            int i = 0;
            while (i < elementListLength) {
                String childName;
                boolean readOnlyDevice;
                Element childElement;
                Element parentElement = childElement = (Element)elementList.item(i);
                boolean isClientSideContainer = childElement.hasAttribute("clientContainer");
                if (isClientSideContainer) {
                    Attr attribute = null;
                    String value = null;
                    attribute = childElement.getAttributeNode("clientContainer");
                    value = attribute.getValue();
                    isClientSideContainer = value.compareToIgnoreCase("true") == 0;
                }
                if (readOnlyDevice = childElement.hasAttribute("readOnlyDevice")) {
                    Attr attribute = null;
                    String value = null;
                    attribute = childElement.getAttributeNode("readOnlyDevice");
                    value = attribute.getValue();
                    readOnlyDevice = value.compareToIgnoreCase("true") == 0;
                }
                boolean visibleExists = childElement.hasAttribute("visible");
                boolean visible = true;
                if (visibleExists) {
                    Attr attribute = null;
                    String value = null;
                    attribute = childElement.getAttributeNode("visible");
                    value = attribute.getValue();
                    visible = value.compareToIgnoreCase("false") != 0;
                }
                String path = childName = childElement.getAttribute("name");
                String parentName = null;
                String parentTag = null;
                while (true) {
                    if ((parentTag = (parentElement = (Element)parentElement.getParentNode()).getNodeName()).compareTo("DeviceList") == 0) break;
                    parentName = parentElement.getAttribute("name");
                    path = String.valueOf(parentName) + ":" + path;
                }
                structuredDeviceList.add(path, isClientSideContainer, readOnlyDevice, visible);
                ++i;
            }
        }
    }

    public static void read(StructuredDeviceList structuredDeviceList) {
        File deviceOrderXmlFile = null;
        boolean deviceOrderXmlFileExists = false;
        String configPath = null;
        Instrument instrument = null;
        String instrumentName = null;
        String filePath = null;
        instrument = Instrument.getInstance();
        instrumentName = instrument.getName();
        if (instrumentName == null) {
            instrumentName = "";
        }
        if (deviceOrderXmlFileExists = (deviceOrderXmlFile = new File(filePath = String.valueOf(configPath = Global.getConfigPath()) + instrumentName + deviceOrderFileNameSuffix)).exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(deviceOrderXmlFile);
                StructuredDeviceListReader.addDeviceToStructuredList(document.getDocumentElement(), structuredDeviceList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

