/*
 * Decompiled with CFR 0.152.
 */
package ice.util.StructuredDeviceList;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.util.StructuredDeviceList.DeviceNode;
import ice.util.StructuredDeviceList.StructuredDeviceListReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class StructuredDeviceList {
    static StructuredDeviceList instance = null;
    HashMap<String, DeviceNode> lookupTable = null;
    DeviceNode topNode = null;
    ArrayList<DeviceNode> itemsNotSpecifiedInConfig = null;

    protected StructuredDeviceList() {
        this.init();
    }

    protected void init() {
        Controller controller = null;
        this.lookupTable = new HashMap();
        this.topNode = new DeviceNode();
        this.itemsNotSpecifiedInConfig = new ArrayList();
        StructuredDeviceListReader.read(this);
        controller = Controller.getReference();
        this.fillInInstalledDevices(controller.getDeviceList());
    }

    public static StructuredDeviceList getInstance() {
        if (instance == null) {
            instance = new StructuredDeviceList();
        }
        return instance;
    }

    private void addToStructure(String path, DeviceNode node, boolean isClientSideContainer, boolean readOnlyDevice, boolean visible) {
        int index = -1;
        String pathElement = null;
        if (path != null) {
            index = path.indexOf(58);
            if (index != -1) {
                pathElement = path.substring(0, index);
                path = path.substring(index + 1);
            } else {
                pathElement = path;
                path = null;
            }
            DeviceNode childNode = null;
            childNode = node.hasChild(pathElement);
            if (childNode != null) {
                this.addToStructure(path, childNode, isClientSideContainer, readOnlyDevice, visible);
            } else {
                DeviceNode newChildNode = null;
                newChildNode = this.lookupTable.get(pathElement);
                if (newChildNode == null) {
                    newChildNode = new DeviceNode(isClientSideContainer, readOnlyDevice, visible);
                    newChildNode.setName(pathElement);
                    this.lookupTable.put(pathElement, newChildNode);
                }
                node.add(newChildNode);
                this.addToStructure(path, newChildNode, isClientSideContainer, readOnlyDevice, visible);
            }
        }
    }

    void add(String path) {
        this.add(path, false, false, true);
    }

    void add(String path, boolean isClientSideContainer, boolean readOnlyDevice, boolean visible) {
        this.addToStructure(path, this.topNode, isClientSideContainer, readOnlyDevice, visible);
    }

    private void clearOutInstalledDevices() {
        Collection<DeviceNode> deviceNodes = null;
        DeviceNode deviceNode2 = null;
        Iterator<DeviceNode> deviceIterator = null;
        for (DeviceNode aDevice : this.itemsNotSpecifiedInConfig) {
            this.lookupTable.remove(aDevice);
        }
        deviceNodes = this.lookupTable.values();
        for (DeviceNode deviceNode2 : deviceNodes) {
            deviceNode2.setInstalledDevice(null);
        }
        this.itemsNotSpecifiedInConfig.clear();
    }

    public void fillInInstalledDevices(ArrayList<InstalledDevice> installedDevices) {
        int numInstalledDevices = -1;
        InstalledDevice installedDevice = null;
        String deviceName = null;
        boolean inLookup = false;
        this.clearOutInstalledDevices();
        numInstalledDevices = installedDevices.size();
        int i = 0;
        while (i < numInstalledDevices) {
            installedDevice = installedDevices.get(i);
            deviceName = installedDevice.getRealNameButReturnAliasIfCounter();
            inLookup = this.lookupTable.containsKey(deviceName);
            if (inLookup) {
                DeviceNode theDeviceNode = null;
                theDeviceNode = this.lookupTable.get(deviceName);
                theDeviceNode.setInstalledDevice(installedDevice);
            } else {
                DeviceNode newDeviceNode = null;
                newDeviceNode = new DeviceNode();
                newDeviceNode.setName(deviceName);
                this.lookupTable.put(deviceName, newDeviceNode);
                newDeviceNode.setInstalledDevice(installedDevice);
                this.itemsNotSpecifiedInConfig.add(newDeviceNode);
            }
            ++i;
        }
    }

    public ArrayList<DeviceNode> getStructuredDeviceList() {
        ArrayList<DeviceNode> completeList = null;
        completeList = new ArrayList<DeviceNode>();
        completeList.addAll(this.topNode.getChildren());
        completeList.addAll(this.itemsNotSpecifiedInConfig);
        return completeList;
    }

    public DeviceNode getNodeByName(String deviceName) {
        DeviceNode deviceNode = null;
        boolean exists = false;
        exists = this.lookupTable.containsKey(deviceName);
        if (exists) {
            deviceNode = this.lookupTable.get(deviceName);
        }
        return deviceNode;
    }
}

