/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import de.schlichtherle.io.FileOutputStream;
import ice.Global;
import ice.data.IceFileType;
import ice.data.IcePanelInfo;
import ice.data.IceWindowInfo;
import ice.data.tas.bt7.Instrument;
import ice.util.math.MathUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IcePanelXMLPropertyParser {
    private static final String lastSessionFileNameSuffix = "-LastSession.xml";
    private static final String configPath = Global.getConfigPath();
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private static final String xAttr = "x";
    private static final String yAttr = "y";
    private static final String widthAttr = "width";
    private static final String heightAttr = "height";
    private static final String panelNameAttr = "panelName";
    private static final String windowTag = "Window";
    private static final String classAttr = "class";
    private static final String panelTag = "Panel";
    private static final String fileTypeAttr = "fileType";
    private static final String fileNameAttr = "fileName";
    private static final String parentNameAttr = "parentName";
    private static final String sessionTag = "Session";

    public static ArrayList<IceWindowInfo> readXMLSessionFile() {
        File xmlFile = null;
        Instrument instrument = null;
        String instrumentName = null;
        String filePath = null;
        ArrayList<IceWindowInfo> windowInfoList = null;
        instrument = Instrument.getInstance();
        instrumentName = instrument.getName();
        if (instrumentName == null) {
            instrumentName = "";
        }
        if ((xmlFile = new File(filePath = String.valueOf(configPath) + instrumentName + lastSessionFileNameSuffix)).exists()) {
            try {
                DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = domFactory.newDocumentBuilder();
                Document document = docBuilder.parse(xmlFile);
                Element root = document.getDocumentElement();
                windowInfoList = new ArrayList<IceWindowInfo>();
                NodeList windowList = root.getElementsByTagName(windowTag);
                int i = 0;
                while (i < windowList.getLength()) {
                    Node windowNode = windowList.item(i);
                    if (windowNode.getNodeType() == 1) {
                        Element windowElement = (Element)windowNode;
                        String height = windowElement.getAttribute(heightAttr);
                        String width = windowElement.getAttribute(widthAttr);
                        String x = windowElement.getAttribute(xAttr);
                        String y = windowElement.getAttribute(yAttr);
                        int iHeight = MathUtils.parseAsInteger(height, 100);
                        int iWidth = MathUtils.parseAsInteger(width, 100);
                        int iX = MathUtils.parseAsInteger(x, 100);
                        int iY = MathUtils.parseAsInteger(y, 100);
                        Dimension size = new Dimension(iWidth, iHeight);
                        Point position = new Point(iX, iY);
                        NodeList panelList = windowElement.getElementsByTagName(panelTag);
                        ArrayList<IcePanelInfo> panelInfoList = new ArrayList<IcePanelInfo>();
                        int j = 0;
                        while (j < panelList.getLength()) {
                            Node panelNode = panelList.item(j);
                            if (panelNode.getNodeType() == 1) {
                                Element panelElement = (Element)panelNode;
                                String className = panelElement.getAttribute(classAttr);
                                String panelName = panelElement.getAttribute(panelNameAttr);
                                String fileTypeString = panelElement.getAttribute(fileTypeAttr);
                                String fileName = panelElement.getAttribute(fileNameAttr);
                                IceFileType fileType = IceFileType.valueFromName(fileTypeString);
                                String parentName = panelElement.getAttribute(parentNameAttr);
                                IcePanelInfo panelInfo = new IcePanelInfo(className, panelName, parentName, fileName, fileType);
                                panelInfoList.add(panelInfo);
                            }
                            ++j;
                        }
                        IceWindowInfo windowInfo = new IceWindowInfo();
                        windowInfo.setPanelInfoList(panelInfoList);
                        windowInfo.setDimension(size);
                        windowInfo.setPosition(position);
                        windowInfoList.add(windowInfo);
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                logger.error(ex);
            }
            catch (SAXException ex) {
                logger.error(ex);
            }
            catch (ParserConfigurationException ex) {
                logger.error(ex);
            }
            catch (FactoryConfigurationError ex) {
                logger.error(ex);
            }
        }
        return windowInfoList;
    }

    public static void writeXmlSessionFile(ArrayList<IceWindowInfo> infoList) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Instrument instrument = null;
        String instrumentName = null;
        String filePath = null;
        instrument = Instrument.getInstance();
        instrumentName = instrument.getName();
        if (instrumentName == null) {
            instrumentName = "";
        }
        filePath = String.valueOf(configPath) + instrumentName + lastSessionFileNameSuffix;
        try {
            DocumentBuilder db = factory.newDocumentBuilder();
            Document dom = db.newDocument();
            Element root = dom.createElement(sessionTag);
            dom.appendChild(root);
            for (IceWindowInfo info : infoList) {
                Element windowNode = dom.createElement(windowTag);
                Point p = info.getPosition();
                Dimension d = info.getDimension();
                windowNode.setAttribute(xAttr, Integer.toString(p.x));
                windowNode.setAttribute(yAttr, Integer.toString(p.y));
                windowNode.setAttribute(widthAttr, Integer.toString(d.width));
                windowNode.setAttribute(heightAttr, Integer.toString(d.height));
                root.appendChild(windowNode);
                ArrayList<IcePanelInfo> panelInfoList = info.getIcePanelInfoList();
                for (IcePanelInfo panelInfo : panelInfoList) {
                    Element panelNode = dom.createElement(panelTag);
                    String className = panelInfo.getClassName();
                    panelNode.setAttribute(classAttr, className);
                    String panelName = panelInfo.getPanelName();
                    panelNode.setAttribute(panelNameAttr, panelName);
                    String fileName = panelInfo.getFileName();
                    panelNode.setAttribute(fileNameAttr, fileName);
                    IceFileType fileType = panelInfo.getFileType();
                    if (fileType == null) {
                        fileType = IceFileType.unknown;
                    }
                    panelNode.setAttribute(fileTypeAttr, fileType.getName());
                    String parentName = null;
                    parentName = panelInfo.getParentName();
                    if (parentName == null) {
                        parentName = "";
                    }
                    panelNode.setAttribute(parentNameAttr, parentName);
                    windowNode.appendChild(panelNode);
                }
            }
            IcePanelXMLPropertyParser.printToFile(filePath, dom);
        }
        catch (Exception pce) {
            logger.error(pce);
            pce.printStackTrace();
        }
    }

    private static void printToFile(String filePath, Document dom) {
        try {
            OutputFormat format = new OutputFormat(dom);
            format.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer(new FileOutputStream(new File(filePath)), format);
            serializer.serialize(dom);
        }
        catch (IOException ie) {
            logger.error(ie);
            ie.printStackTrace();
        }
    }
}

