/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.textFields;

import ice.swing.textFields.ChangeBackgroundOnEditTextField;
import java.awt.Toolkit;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class ICECharLimitTextField
extends ChangeBackgroundOnEditTextField {
    protected int charLimit;
    LimitIntputToNumberOfCharsFilter theFilterReference;

    public ICECharLimitTextField() {
        this.init(Integer.MAX_VALUE);
    }

    public ICECharLimitTextField(boolean isBeep) {
        super(isBeep);
        this.init(Integer.MAX_VALUE);
    }

    public ICECharLimitTextField(int charLimit) {
        this.init(charLimit);
    }

    protected void init(int charLimit) {
        AbstractDocument theDocument = (AbstractDocument)this.getDocument();
        this.theFilterReference = new LimitIntputToNumberOfCharsFilter(charLimit);
        theDocument.setDocumentFilter(this.theFilterReference);
    }

    public int getCharLimit() {
        return this.theFilterReference.getCharLimit();
    }

    public void setCharLimit(int charLimit) {
        this.theFilterReference.setCharLimit(charLimit);
    }

    @Override
    public void setText(String text) {
        int maxChar = -1;
        String newText = null;
        int textLength = -1;
        if (text != null) {
            maxChar = this.getCharLimit();
            textLength = text.length();
            newText = textLength > maxChar ? text.substring(0, maxChar) : text;
        }
        super.setText(newText);
    }

    class LimitIntputToNumberOfCharsFilter
    extends DocumentFilter {
        protected int charLimit;

        public LimitIntputToNumberOfCharsFilter(int charLimit) {
            this.charLimit = charLimit;
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (fb.getDocument().getLength() + text.length() - length <= this.charLimit) {
                super.replace(fb, offset, length, text, attrs);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (fb.getDocument().getLength() + string.length() <= this.charLimit) {
                super.insertString(fb, offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public int getCharLimit() {
            return this.charLimit;
        }

        public void setCharLimit(int charLimit) {
            this.charLimit = charLimit;
        }
    }
}

