/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.datatransfer;

import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.swing.IceFileTableModel;
import ice.swing.TableClipboardOwner;
import ice.swing.datatransfer.CutCopySelection;
import ice.swing.datatransfer.EmptyTransferable;
import ice.swing.datatransfer.IceFileListSelection;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public class ResourceTableTransferHandler
extends TransferHandler {
    private SendQueueManager sendManager;

    public ResourceTableTransferHandler(SendQueueManager sendManager) {
        this.sendManager = sendManager;
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        ArrayList<IceFile> fileList;
        block5: {
            try {
                JTable table = (JTable)c;
                int[] selectedRows = table.getSelectedRows();
                fileList = new ArrayList<IceFile>();
                int i = 0;
                while (i < selectedRows.length) {
                    IceFile file = (IceFile)table.getValueAt(selectedRows[i], 0);
                    if (IceFileType.directory != file.getFileType()) {
                        fileList.add(file);
                    }
                    ++i;
                }
                if (fileList.size() != 0) break block5;
                return null;
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
        return new IceFileListSelection(fileList);
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent ie, int action) {
        super.exportAsDrag(comp, ie, action);
    }

    @Override
    public void exportDone(JComponent source, Transferable data, int action) {
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
        CutCopySelection.TransferType transferType = null;
        Transferable t = this.createTransferable(comp);
        transferType = 1 == action ? CutCopySelection.TransferType.COPY : CutCopySelection.TransferType.MOVE;
        if (t != null && transferType != null) {
            CutCopySelection selection = new CutCopySelection(t, transferType);
            try {
                clip.setContents(selection, new TableClipboardOwner((JTable)comp));
                this.exportDone(comp, selection, action);
                return;
            }
            catch (IllegalStateException ise) {
                this.exportDone(comp, selection, 0);
                throw ise;
            }
        }
        this.exportDone(comp, null, 0);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        int i = 0;
        while (i < transferFlavors.length) {
            if (transferFlavors[i].equals(IceFileListSelection.IceFileListFlavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        ArrayList files = null;
        JTable table = (JTable)comp;
        IceFileTableModel model = (IceFileTableModel)table.getModel();
        CutCopySelection.TransferType transferType = CutCopySelection.TransferType.MOVE;
        try {
            if (t.isDataFlavorSupported(CutCopySelection.CUTCOPY_FLAVOR)) {
                CutCopySelection selection = (CutCopySelection)t.getTransferData(CutCopySelection.CUTCOPY_FLAVOR);
                transferType = selection.getTransferType();
                files = (ArrayList)t.getTransferData(IceFileListSelection.IceFileListFlavor);
            } else {
                files = (ArrayList)t.getTransferData(IceFileListSelection.IceFileListFlavor);
            }
            for (IceFile file : files) {
                String command = this.buildCopyOrMoveCommand(file, model.getRoot(), transferType);
                this.sendManager.addMessage(command, true);
            }
            if (CutCopySelection.TransferType.MOVE == transferType) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new EmptyTransferable(), null);
            }
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private CutCopySelection.TransferType determineType(Transferable transferable) throws UnsupportedFlavorException, IOException {
        CutCopySelection selection = (CutCopySelection)transferable.getTransferData(CutCopySelection.CUTCOPY_FLAVOR);
        return selection.getTransferType();
    }

    private String buildCopyOrMoveCommand(IceFile file, IceFile destination, CutCopySelection.TransferType transferType) {
        String namePrefixAndSuffix = "";
        String filename = file.getName();
        String subCommand = "";
        String sourcePath = "";
        String destinationPath = "";
        IceFile source = file;
        while (!source.isMagicWord()) {
            sourcePath = "/" + source.getName() + sourcePath;
            source = source.getParent();
        }
        if (sourcePath.length() > 0) {
            sourcePath = sourcePath.substring(1);
        }
        sourcePath = String.valueOf(source.getName()) + ":" + sourcePath;
        IceFile destinationTracer = destination;
        while (!destinationTracer.isMagicWord()) {
            destinationPath = "/" + destinationTracer.getName() + destinationPath;
            destinationTracer = destinationTracer.getParent();
        }
        if (destinationPath.length() > 0) {
            destinationPath = String.valueOf(destinationPath.substring(1)) + "/";
        }
        destinationPath = String.valueOf(destinationTracer.getName()) + ":" + destinationPath;
        if (CutCopySelection.TransferType.COPY.equals((Object)transferType)) {
            subCommand = "copy ";
        } else if (CutCopySelection.TransferType.MOVE.equals((Object)transferType)) {
            subCommand = "move ";
        }
        if (filename.contains(" ")) {
            namePrefixAndSuffix = "\"";
        }
        String message = "file " + subCommand + namePrefixAndSuffix + sourcePath + namePrefixAndSuffix + " " + namePrefixAndSuffix + destinationPath + filename + namePrefixAndSuffix;
        return message;
    }
}

