/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.datatransfer;

import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.swing.IceFileTree;
import ice.swing.datatransfer.CutCopySelection;
import ice.swing.datatransfer.EmptyTransferable;
import ice.swing.datatransfer.IceFileListSelection;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class IceFileTreeTransferHandler
extends TransferHandler {
    static final Logger logger = Logger.getLogger(IceFileTreeTransferHandler.class);
    private SendQueueManager sendManager;

    public static Action getCutAction() {
        System.out.println("getCutAction");
        return null;
    }

    public IceFileTreeTransferHandler(SendQueueManager sendManager) {
        this.sendManager = sendManager;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        int i = 0;
        while (i < transferFlavors.length) {
            if (IceFileListSelection.IceFileListFlavor.equals(transferFlavors[i])) {
                logger.debug("returning true");
                return true;
            }
            ++i;
        }
        logger.debug("returning false");
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable transferable) {
        IceFileTree tree = (IceFileTree)comp;
        TreePath selectionPath = tree.getSelectionPath();
        CutCopySelection.TransferType transferType = CutCopySelection.TransferType.MOVE;
        ArrayList files = null;
        IceFile destination = (IceFile)((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
        try {
            if (transferable.isDataFlavorSupported(CutCopySelection.CUTCOPY_FLAVOR)) {
                CutCopySelection selection = (CutCopySelection)transferable.getTransferData(CutCopySelection.CUTCOPY_FLAVOR);
                transferType = selection.getTransferType();
                files = (ArrayList)transferable.getTransferData(IceFileListSelection.IceFileListFlavor);
            } else {
                files = (ArrayList)transferable.getTransferData(IceFileListSelection.IceFileListFlavor);
            }
            for (IceFile file : files) {
                String command = this.buildCopyOrMoveCommand(file, destination, transferType);
                logger.debug("command: " + command);
                this.sendManager.addMessage(command, true);
            }
            if (CutCopySelection.TransferType.MOVE == transferType) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new EmptyTransferable(), null);
            }
            return true;
        }
        catch (UnsupportedFlavorException ufe) {
            logger.error("Transferable was not a CutCopySelection.  Ignoring.", ufe);
        }
        catch (IOException ioe) {
            logger.error("Unable to get transferable.  Aborting.", ioe);
        }
        return false;
    }

    private String buildCopyOrMoveCommand(IceFile file, IceFile destination, CutCopySelection.TransferType transferType) {
        String namePrefixAndSuffix = "";
        String filename = file.getName();
        String subCommand = "";
        String sourcePath = "";
        String destinationPath = "";
        IceFile source = file;
        while (!source.isMagicWord()) {
            sourcePath = "/" + source.getName() + sourcePath;
            source = source.getParent();
        }
        if (sourcePath.length() > 0) {
            sourcePath = sourcePath.substring(1);
        }
        sourcePath = String.valueOf(source.getName()) + ":" + sourcePath;
        IceFile destinationTracer = destination;
        while (!destinationTracer.isMagicWord()) {
            destinationPath = "/" + destinationTracer.getName() + destinationPath;
            destinationTracer = destinationTracer.getParent();
        }
        if (destinationPath.length() > 0) {
            destinationPath = String.valueOf(destinationPath.substring(1)) + "/";
        }
        destinationPath = String.valueOf(destinationTracer.getName()) + ":" + destinationPath;
        if (CutCopySelection.TransferType.COPY.equals((Object)transferType)) {
            subCommand = "copy ";
        } else if (CutCopySelection.TransferType.MOVE.equals((Object)transferType)) {
            subCommand = "move ";
        }
        if (filename.contains(" ")) {
            namePrefixAndSuffix = "\"";
        }
        String message = "file " + subCommand + namePrefixAndSuffix + sourcePath + namePrefixAndSuffix + " " + namePrefixAndSuffix + destinationPath + filename + namePrefixAndSuffix;
        return message;
    }
}

