/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.ScanList;
import ice.event.IceFileEvent;
import ice.event.IceFileListener;
import ice.gui.core.controls.serverFileView.data.ScanFolder;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;

public class ResourceMgrTreeModel
extends DefaultTreeModel
implements IceFileListener {
    private static Logger logger = Logger.getLogger("IceFileLogger.TreeModelLogger");
    private DefaultMutableTreeNode rootNode;
    private IceFile rootFile;
    private ScanList scanList;
    private DefaultMutableTreeNode scanListNode;

    public ResourceMgrTreeModel(ScanFolder scanFolder, ScanList scanList) {
        super(new DefaultMutableTreeNode(scanFolder));
        this.rootFile = scanFolder;
        try {
            this.rootFile.addIceFileListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ResourceMgrTreeModel " + e);
        }
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
        this.addChildren(this.rootNode);
    }

    public ResourceMgrTreeModel(IceFile rootFile, ScanList scanList) {
        this(rootFile, scanList, false);
    }

    public ResourceMgrTreeModel(IceFile rootFile, ScanList scanList, boolean noScanList) {
        super(new DefaultMutableTreeNode(rootFile));
        this.rootFile = rootFile;
        this.scanList = scanList;
        try {
            rootFile.addIceFileListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ResourceMgrTreeModel " + e);
        }
        this.rootNode = (DefaultMutableTreeNode)this.getRoot();
        if (!noScanList) {
            this.scanListNode = new DefaultMutableTreeNode("Server Scan List");
            this.rootNode.add(this.scanListNode);
        }
        this.addChildren(this.rootNode);
    }

    private synchronized void addChildren(DefaultMutableTreeNode parentNode) {
        for (IceFile child : ((IceFile)parentNode.getUserObject()).getChildren()) {
            if (child.getFileType() != IceFileType.directory) continue;
            try {
                child.addIceFileListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("ResourceMgrTreeModel.addChildren " + e);
            }
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
            this.addChildren(childNode);
            parentNode.add(childNode);
        }
    }

    public synchronized void childrenAdded(IceFileEvent ife) {
        logger.debug("children added to " + ife.getParent().getName());
        IceFile parent = ife.getParent();
        int[] indices = ife.getIndices();
        if (parent == this.rootFile) {
            int i = 0;
            while (i < indices.length) {
                IceFile child = parent.getChildAt(indices[i]);
                if (child.getFileType() == IceFileType.directory) {
                    DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                    this.rootNode.add(childNode);
                    try {
                        child.addIceFileListener(this);
                    }
                    catch (ICEListenerListExceptionBase e) {
                        logger.error("ResourceMgrTreeModel.childrenAdded " + e);
                    }
                    logger.debug(childNode.getUserObject() + " added at index " + indices[i]);
                }
                ++i;
            }
            this.nodeStructureChanged(this.rootNode);
        } else {
            int childCount = this.rootNode.getChildCount();
            int i = 0;
            while (i < childCount) {
                if (parent == ((DefaultMutableTreeNode)this.rootNode.getChildAt(i)).getUserObject()) {
                    int j = 0;
                    while (j < indices.length) {
                        IceFile child = parent.getChildAt(indices[j]);
                        if (child.getFileType() == IceFileType.directory) {
                            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                            ((DefaultMutableTreeNode)this.rootNode.getChildAt(i)).add(childNode);
                            try {
                                child.addIceFileListener(this);
                            }
                            catch (ICEListenerListExceptionBase e) {
                                logger.error("ResourceMgrTreeModel.childrenAdded " + e);
                            }
                            logger.debug(childNode.getUserObject() + " added at index " + indices[j]);
                        }
                        ++j;
                    }
                    this.nodeStructureChanged(this.rootNode.getChildAt(i));
                    break;
                }
                ++i;
            }
        }
    }

    public synchronized void childrenRemoved(IceFileEvent ife) {
        IceFile[] childrenRemoved;
        logger.debug("children removed");
        IceFile parent = ife.getParent();
        IceFile[] iceFileArray = childrenRemoved = ife.getRemovedChildren();
        int n = childrenRemoved.length;
        int n2 = 0;
        while (n2 < n) {
            IceFile iceFile = iceFileArray[n2];
            iceFile.removeIceFileListener(this);
            ++n2;
        }
        int childCount = this.rootNode.getChildCount();
        int i = 0;
        while (i < childCount) {
            if (parent == ((DefaultMutableTreeNode)this.rootNode.getChildAt(i)).getUserObject()) {
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                int parentChildCount = parentNode.getChildCount();
                break;
            }
            ++i;
        }
    }

    public void propertyChanged(IceFileEvent ife) {
    }

    @Override
    public void actionPerformed(IceFileEvent ife) {
        IceFileEvent.Type theType = ife.getType();
        switch (theType) {
            case ADDED: {
                this.childrenAdded(ife);
                break;
            }
            case REMOVED: {
                this.childrenRemoved(ife);
                break;
            }
            default: {
                logger.error("ResourceMgrTreeMode.actionPerformed(ICEFileEvent) illegal event sent should be of type ADDED or REMOVED");
            }
        }
    }
}

