/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.event.ListControlEvent;
import ice.event.ListControlListener;
import ice.gui.core.IcePanelDataLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListControl
extends JPanel
implements ListSelectionListener {
    private JLabel hideLabel;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton removeBtn;
    private JButton selectBtn;
    private JList selectedList;
    private JLabel showLabel;
    private JList freeList;
    private DefaultListModel selectedListModel;
    private DefaultListModel freeListModel;
    private String instrumentName;
    private String deviceName;
    protected ArrayList<ListControlListener> listControlListeners = new ArrayList();
    private SortedMap<Integer, String> selectedChannels;
    private SortedMap<Integer, String> freeChannels;
    private SortedMap<Integer, String> selectedA4Channels;
    private SortedMap<Integer, String> freeA4Channels;
    private TreeMap<String, Integer> priorityMap;
    private TreeMap<String, Integer> priorityA4Map;
    private SortedMap<Integer, String> currentSelChannels;
    private SortedMap<Integer, String> currentFreeChannels;
    private TreeMap<String, Integer> currentPriorMap;

    public ListControl(String name) {
        this.instrumentName = name;
        this.deviceName = "NONE";
        this.buldLists();
        this.buildGUI();
        this.notifyOfSelectionChange();
    }

    private void buildGUI() {
        this.removeBtn = new JButton();
        this.selectBtn = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.selectedList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.freeList = new JList();
        this.showLabel = new JLabel();
        this.hideLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.removeBtn.setText(">>");
        this.removeBtn.setEnabled(false);
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListControl.this.removeBtnAction(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.removeBtn, gridBagConstraints);
        this.selectBtn.setText("<<");
        this.selectBtn.setEnabled(false);
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListControl.this.selectBtnAction(evt);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.selectBtn, gridBagConstraints);
        this.selectedList.setModel(this.selectedListModel);
        this.selectedList.addListSelectionListener(this);
        this.selectedList.setFixedCellWidth(100);
        this.selectedList.setFixedCellHeight(20);
        this.jScrollPane1.setViewportView(this.selectedList);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.freeList.setFixedCellWidth(100);
        this.freeList.setFixedCellHeight(20);
        this.freeList.setModel(this.freeListModel);
        this.freeList.addListSelectionListener(this);
        this.jScrollPane2.setViewportView(this.freeList);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 40;
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.showLabel.setText("Show Series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.add((Component)this.showLabel, gridBagConstraints);
        this.hideLabel.setText("Hide Series");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.hideLabel, gridBagConstraints);
    }

    private void buldLists() {
        Object[] items;
        this.selectedListModel = new DefaultListModel();
        this.freeListModel = new DefaultListModel();
        this.selectedChannels = new TreeMap<Integer, String>();
        this.freeChannels = new TreeMap<Integer, String>();
        this.priorityMap = new TreeMap();
        this.selectedA4Channels = new TreeMap<Integer, String>();
        this.freeA4Channels = new TreeMap<Integer, String>();
        this.priorityA4Map = new TreeMap();
        Object[] col = this.selectedChannels.values().toArray();
        int i = 0;
        String counterName = null;
        String key = null;
        do {
            if ((counterName = IcePanelDataLoader.getValue(key = String.valueOf(this.instrumentName) + ".livedata.panel.counter" + i)) == null) continue;
            if (counterName.equals("DIFF") || counterName.equals("SPEC") || counterName.equals("Time")) {
                this.freeA4Channels.put(i, counterName);
                this.priorityA4Map.put(counterName, i);
            }
            this.freeListModel.addElement(counterName);
            this.freeChannels.put(i, counterName);
            this.priorityMap.put(counterName, i++);
        } while (counterName != null);
        Object[] objectArray = items = new Object[]{"DIFF", "SPEC"};
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            Integer location = this.priorityMap.get(item);
            if (location != null) {
                this.freeChannels.remove(location);
                this.freeA4Channels.remove(location);
                this.freeListModel.removeElement(item);
                this.selectedChannels.put(location, (String)item);
                this.selectedA4Channels.put(this.priorityA4Map.get(item), (String)item);
                this.selectedListModel.addElement(item);
            }
            ++n2;
        }
        this.currentFreeChannels = this.freeChannels;
        this.currentSelChannels = this.selectedChannels;
        this.currentPriorMap = this.priorityMap;
    }

    private void removeBtnAction(ActionEvent evt) {
        Object[] items;
        Object[] objectArray = items = this.selectedList.getSelectedValues();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.currentSelChannels.remove(this.currentPriorMap.get(item));
            this.selectedListModel.removeElement(item);
            this.currentFreeChannels.put(this.currentPriorMap.get(item), (String)item);
            ++n2;
        }
        int size = this.selectedListModel.getSize();
        if (size == 0) {
            this.removeBtn.setEnabled(false);
        }
        if (this.currentFreeChannels != null) {
            Object[] list = this.currentFreeChannels.values().toArray();
            this.freeListModel.clear();
            Object[] objectArray2 = list;
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                Object item = objectArray2[n4];
                this.freeListModel.addElement(item);
                ++n4;
            }
        }
        this.notifyOfSelectionChange();
    }

    private void selectBtnAction(ActionEvent evt) {
        Object[] items;
        Object[] objectArray = items = this.freeList.getSelectedValues();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this.currentFreeChannels.remove(this.currentPriorMap.get(item));
            this.freeListModel.removeElement(item);
            this.currentSelChannels.put(this.currentPriorMap.get(item), (String)item);
            ++n2;
        }
        int size = this.freeListModel.getSize();
        if (size == 0) {
            this.selectBtn.setEnabled(false);
        }
        if (this.currentSelChannels != null) {
            Object[] list = this.currentSelChannels.values().toArray();
            this.selectedListModel.clear();
            Object[] objectArray2 = list;
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                Object item = objectArray2[n4];
                this.selectedListModel.addElement(item);
                ++n4;
            }
        }
        this.notifyOfSelectionChange();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.freeList.getSelectedIndex() == -1) {
                this.selectBtn.setEnabled(false);
            } else {
                this.selectBtn.setEnabled(true);
            }
            if (this.selectedList.getSelectedIndex() == -1) {
                this.removeBtn.setEnabled(false);
            } else {
                this.removeBtn.setEnabled(true);
            }
        }
    }

    public Collection<String> getSelectedItems() {
        return this.currentSelChannels.values();
    }

    public void updateCurrentDevice(String name) {
        if (!this.deviceName.equals(name)) {
            this.currentSelChannels = this.selectedChannels;
            this.currentFreeChannels = this.freeChannels;
            this.currentPriorMap = this.priorityMap;
            this.updateModel();
            this.notifyOfSelectionChange();
        }
    }

    public Collection<String> getFreeItems() {
        return this.currentFreeChannels.values();
    }

    public void notifyOfSelectionChange() {
        Iterator<ListControlListener> iterator = this.listControlListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().selectionChanged(new ListControlEvent(this));
        }
    }

    public void addListControlListener(ListControlListener lcl) {
        this.listControlListeners.add(lcl);
    }

    public void removeListControlListener(ListControlListener lcl) {
        this.listControlListeners.remove(lcl);
    }

    private void updateModel() {
        Object item;
        if (this.freeChannels == null) {
            return;
        }
        Object[] list = this.freeChannels.values().toArray();
        this.freeListModel.clear();
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            item = objectArray[n2];
            this.freeListModel.addElement(item);
            ++n2;
        }
        if (this.selectedChannels == null) {
            return;
        }
        list = this.selectedChannels.values().toArray();
        this.selectedListModel.clear();
        objectArray = list;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            item = objectArray[n2];
            this.selectedListModel.addElement(item);
            ++n2;
        }
    }

    private void updateA4Model() {
        Object item;
        if (this.freeA4Channels == null) {
            return;
        }
        Object[] list = this.freeA4Channels.values().toArray();
        this.freeListModel.clear();
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            item = objectArray[n2];
            this.freeListModel.addElement(item);
            ++n2;
        }
        if (this.selectedA4Channels == null) {
            return;
        }
        list = this.selectedA4Channels.values().toArray();
        this.selectedListModel.clear();
        objectArray = list;
        n = list.length;
        n2 = 0;
        while (n2 < n) {
            item = objectArray[n2];
            this.selectedListModel.addElement(item);
            ++n2;
        }
    }

    public class ChannelCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ChannelCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value.toString());
            if (isSelected) {
                this.setBackground(Color.LIGHT_GRAY);
            } else {
                this.setBackground(Color.WHITE);
            }
            return this;
        }
    }
}

