/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.swing.ResourceMgrTreeModel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class IceFileTree
extends JTree
implements TreeSelectionListener {
    private ResourceMgrTreeModel model;
    private SendQueueManager sendManager;
    private static Logger logger = Logger.getLogger("ErrorLogger");

    public IceFileTree(ResourceMgrTreeModel rmtm, SendQueueManager sendManager) {
        super(rmtm);
        this.sendManager = sendManager;
        this.addTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        try {
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)tse.getNewLeadSelectionPath().getLastPathComponent();
            IceFile file = (IceFile)dmtn.getUserObject();
            if (!file.isInitialized()) {
                String path = "";
                IceFile tempFile = file;
                while (!tempFile.isMagicWord()) {
                    path = "\\" + tempFile.getName() + path;
                    tempFile = tempFile.getParent();
                }
                if (path.length() > 0) {
                    path = path.substring(1);
                }
                path = String.valueOf(tempFile.getName()) + ":" + path;
                System.out.println("path: " + path);
                this.sendManager.addMessage("file dir " + path);
            }
        }
        catch (NullPointerException npe) {
            logger.error("tree node null.  Ignoring: " + npe.getMessage());
        }
        catch (ClassCastException cce) {
            logger.error("Class cast exception: " + cce.getMessage());
        }
    }
}

