/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class DeviceFixCheckBox
extends JCheckBox
implements DeviceValueChangedListener {
    private InstalledDevice device;
    private boolean inTransit;

    public DeviceFixCheckBox(InstalledDevice device, AbstractAction action) {
        super(action);
        this.device = device;
        this.inTransit = false;
        this.setSelected(device.isFixed());
        try {
            device.addValueChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("DeviceFixCheckBox " + e);
        }
        this.setText("Fixed");
    }

    @Override
    public synchronized void actionPerformed(DeviceValueChangedEvent pce) {
        if (this.inTransit) {
            this.inTransit = false;
            return;
        }
        if (pce.getSource() != this.device) {
            return;
        }
        SwingUtilities.invokeLater(new UpdateCheckBox(this, this.device.isFixed()));
    }

    public void ignoreNextState() {
        this.inTransit = true;
    }

    private class UpdateCheckBox
    implements Runnable {
        private JCheckBox checkBox;
        private boolean checked;

        public UpdateCheckBox(JCheckBox checkBox, boolean checked) {
            this.checkBox = checkBox;
            this.checked = checked;
        }

        @Override
        public void run() {
            this.checkBox.setSelected(this.checked);
        }
    }
}

