/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.scan;

import ice.Controller;
import ice.Global;
import ice.IconManager;
import ice.communication.SendQueueManager;
import ice.data.BaseScan;
import ice.data.InstalledDevice;
import ice.data.InstalledMagnetDevice;
import ice.data.InstalledMiscDevice;
import ice.data.InstalledPressureDevice;
import ice.data.InstalledTempDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.SaveScanListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceEditPanel;
import ice.gui.tas.bt7.scan.DryRunScanWindow;
import ice.swing.Bag;
import ice.swing.DataOfInterestIceComboBox;
import ice.swing.actions.IceMenuAction;
import ice.util.I18N;
import ice.util.PreferencesManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public abstract class BaseScanPanel
extends IceEditPanel
implements ItemListener,
KeyListener,
DocumentListener,
ChangeListener,
DeviceListListener {
    protected static Logger logger = Logger.getLogger("WidgetLogger.ScanLogger");
    protected static final int INITIAL_FINAL = 0;
    protected static final int INITIAL_STEP = 1;
    protected static final int CENTER_STEP = 2;
    protected static final String INITIAL = "Initial      ";
    protected static final String FINAL = "Final        ";
    protected static final String CENTER = "Center       ";
    protected static final String STEP = "Step         ";
    protected static final String fixedFinal = "Fixed Ef";
    protected static final String fixedInitial = "Fixed Ei";
    protected JTextField eTransferField;
    protected JTextField eFixedField;
    protected JComboBox eFixedCB;
    protected JTextField hField;
    protected JTextField kField;
    protected JTextField lField;
    protected ArrayList<String> skipDevices;
    protected int mode;
    protected int scanPanelNumber;
    protected String exptID;
    protected ArrayList<SaveScanListener> saveScanListeners;
    protected JLabel scanNameLabel;
    protected JLabel prefixLabel;
    protected JLabel commentsLabel;
    protected JTextField scanNameField;
    protected JTextField prefixField;
    protected JTextArea commentsTextArea;
    protected JTextField delayBeforeScanField;
    protected ButtonGroup modeGroup;
    protected JTextField numPointsField;
    protected JTextField baseCountField;
    protected JTextField prefactorField;
    protected JComboBox dataInterestCB;
    protected JComboBox countTypeCB;
    protected JTextField timeoutField;
    protected SendQueueManager sendManager;
    protected JPanel envPanel;
    protected JPanel modePanel;
    protected JPanel instrumentPanel;
    protected JPanel btnPanel;
    protected JPanel descrPanel;
    protected JPanel parameterPanel;
    protected JRadioButton initialFinalButton;
    protected JRadioButton initialStepButton;
    protected JRadioButton centerStepButton;
    protected boolean baseScanDebug = false;
    protected ArrayList<ScanEntry> scanEntries;
    protected ArrayList<ScanEntry> scanEntries_add;
    protected ArrayList<ScanEntry> scanEntries_env;
    protected JLabel column1Label;
    protected JLabel column2Label;
    protected JLabel column3Label;
    protected JLabel column4Label;
    protected static final String dataMonitor = "Monitor";
    protected static final String dataDetector = "Detector";
    protected static final String countMonitor = "Monitor";
    protected static final String countTime = "Time";
    protected Collection<InstalledDevice> allDevices;
    protected IceMenuAction saveScanAction;
    protected SaveAndRunScanAction saveAndRunScanAction;
    private boolean acceptClose;
    private boolean modified;
    private boolean panelReady;
    protected static final String TEMPERATURE = "Temp";
    protected static final String MAGNET = "Magfield";
    protected static final String PRESSURE = "Pressure";
    protected static final String OTHER = "Other";
    protected static final String EMPTY = "Please Select Device...";
    protected JPanel propertiesPanel;
    protected JComboBox controllerTypeBox;
    protected TemperatureScanPropertiesPanel tempProperties;
    protected MagnetScanPropertiesPanel magnetProperties;
    protected PressureScanPropertiesPanel pressureProperties;
    protected OtherScanPropertiesPanel otherProperties;
    protected Vector<String> controllerBoxItems;
    protected Vector<InstalledTempDevice> installedTempDevices;
    protected Vector<InstalledMagnetDevice> installedMagnetDevices;
    protected DryRunScanWindow dryRunWindow;
    private HashMap<String, IceMenuAction> actionMap;
    Controller controller;

    public BaseScanPanel(BaseScan scan) throws IcePanelException {
        super("*Untitled" + Global.getPanelNumber(), scan);
    }

    private void initBaseScanPanel() {
        this.controller = Controller.getReference();
        this.dryRunWindow = DryRunScanWindow.getInstance();
        this.exptID = this.controller.getExperiment().getID();
        this.sendManager = this.controller.getSendManager();
        this.scanPanelNumber = Global.getPanelNumber();
        Global.incrementPanelNumber();
        this.allDevices = this.controller.getDeviceList();
        this.controller.addDeviceListListener(this);
    }

    @Override
    public final void processIcePanel() throws IcePanelException {
        try {
            this.initBaseScanPanel();
            this.buildBaseScanPanel();
            this.init();
            this.buildGUI();
            this.loadResource();
        }
        catch (Exception e) {
            this.handleIcePanelException(this.getName(), e);
        }
    }

    private void buildBaseScanPanel() {
        this.saveScanListeners = new ArrayList();
        this.scanNameLabel = this.createLabel("Scan Name:");
        this.prefixLabel = this.createLabel("Data File Prefix:");
        this.commentsLabel = this.createLabel("Comments:");
        this.scanNameField = new JTextField(6);
        this.scanNameField.getDocument().addDocumentListener(this);
        this.prefixField = new JTextField(6);
        this.prefixField.getDocument().addDocumentListener(this);
        this.commentsTextArea = new JTextArea(4, 10);
        this.commentsTextArea.getDocument().addDocumentListener(this);
        this.delayBeforeScanField = new JTextField(6);
        this.delayBeforeScanField.getDocument().addDocumentListener(this);
        this.modeGroup = new ButtonGroup();
        this.numPointsField = new JTextField(6);
        this.numPointsField.addKeyListener(this);
        this.numPointsField.getDocument().addDocumentListener(this);
        this.baseCountField = new JTextField(6);
        this.baseCountField.getDocument().addDocumentListener(this);
        this.prefactorField = new JTextField(6);
        this.prefactorField.setText("1");
        this.prefactorField.getDocument().addDocumentListener(this);
        new ValidFloatChecker(this.numPointsField, "number of points");
        new ValidFloatChecker(this.baseCountField, "base count");
        new ValidFloatChecker(this.prefactorField, "prefactor");
        this.dataInterestCB = new DataOfInterestIceComboBox(this);
        this.dataInterestCB.addItemListener(this);
        String[] countTypes = new String[]{"Monitor", countTime};
        this.countTypeCB = new JComboBox<String>(countTypes);
        this.countTypeCB.addItemListener(this);
        this.timeoutField = new JTextField(6);
        this.timeoutField.setEnabled(false);
        this.timeoutField.setEditable(false);
        this.timeoutField.getDocument().addDocumentListener(this);
        this.initialFinalButton = new JRadioButton("Initial/Final");
        this.initialFinalButton.addItemListener(this);
        this.initialStepButton = new JRadioButton("Initial/Step");
        this.initialStepButton.addItemListener(this);
        this.centerStepButton = new JRadioButton("Center/Step");
        this.centerStepButton.addItemListener(this);
        this.scanEntries = new ArrayList();
        this.scanEntries_add = new ArrayList();
        this.scanEntries_env = new ArrayList();
        this.column1Label = this.createLabel(INITIAL, 2);
        Dimension d = this.column1Label.getPreferredSize();
        double height = d.getHeight();
        d.setSize(75.0, height);
        this.column1Label.setPreferredSize(d);
        this.column2Label = this.createLabel(FINAL, 2);
        this.column2Label.setPreferredSize(d);
        this.column3Label = this.createLabel(CENTER, 2);
        this.column3Label.setPreferredSize(d);
        this.column4Label = this.createLabel(STEP, 2);
        this.column4Label.setPreferredSize(d);
        this.mode = 0;
        this.saveScanAction = new SaveScanAction();
        this.actionMap = new HashMap();
        this.actionMap.put("Save", this.saveScanAction);
        this.saveAndRunScanAction = new SaveAndRunScanAction();
        this.acceptClose = true;
        this.modified = false;
        this.panelReady = false;
        this.skipDevices = new ArrayList();
        this.skipDevices.add("A1");
        this.skipDevices.add("A2");
        this.skipDevices.add("A3");
        this.skipDevices.add("A4");
        this.skipDevices.add("A5");
        this.skipDevices.add("A6");
        this.skipDevices.add("H");
        this.skipDevices.add("K");
        this.skipDevices.add("L");
        this.skipDevices.add("Ei");
        this.skipDevices.add("Ef");
        this.skipDevices.add("E");
        this.installedTempDevices = new Vector();
        this.installedMagnetDevices = new Vector();
        this.controllerBoxItems = new Vector();
        this.controllerTypeBox = new JComboBox<String>(this.controllerBoxItems);
        this.tempProperties = new TemperatureScanPropertiesPanel();
        this.magnetProperties = new MagnetScanPropertiesPanel();
        this.pressureProperties = new PressureScanPropertiesPanel();
        this.otherProperties = new OtherScanPropertiesPanel();
        this.propertiesPanel = new JPanel(new CardLayout());
        this.controllerTypeBox.addItemListener(new ControllerTypeItemListener());
        this.tempProperties.resetValuesButton.addActionListener(new ResetTempDefaultValuesActionListener());
        this.magnetProperties.resetValuesButton.addActionListener(new ResetMagnetDefaultValuesActionListener());
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
    }

    @Override
    protected abstract void init();

    @Override
    protected abstract void buildGUI();

    @Override
    public abstract void loadResource();

    protected void createPanels() {
        this.modePanel = this.createModePanel();
        this.parameterPanel = this.createParameterPanel();
        this.instrumentPanel = this.createInstrumentPanel();
        this.envPanel = this.createEnvironmentPanel();
        this.descrPanel = this.createScanDescriptionPanel();
        this.btnPanel = this.createBtnPanel();
        this.panelReady = true;
    }

    protected void loadPanels(BaseScan input) {
        int mode = input.getRangeMode();
        if (mode == BaseScan.INITIAL_FINAL) {
            this.mode = 0;
        } else if (mode == BaseScan.CENTER_STEP) {
            this.mode = 2;
        } else if (mode == BaseScan.INITIAL_STEP) {
            this.mode = 1;
        }
        this.modePanel = this.createModePanel();
        if (this.mode == 0) {
            this.initialFinalButton.setSelected(true);
        } else if (this.mode == 1) {
            this.initialStepButton.setSelected(true);
        } else if (this.mode == 2) {
            this.centerStepButton.setSelected(true);
        }
        this.loadParameterPanel(input);
        this.loadScanDescriptionPanel(input);
        this.loadEnvironmentPanel(input);
        this.loadInstrumentPanel(input);
        this.instrumentPanel = this.createInstrumentPanel();
        String scanName = this.scanNameField.getText().trim();
        String oldName = this.getName();
        this.setName(scanName);
        this.notifyNameChangeListeners(scanName, oldName);
        this.recalculateAllRows();
        SwingUtilities.invokeLater(new RebuildGUI());
        this.modified = false;
    }

    protected abstract JPanel createInstrumentPanel();

    protected abstract void loadInstrumentPanel(BaseScan var1);

    protected void addSingleDevice(String name, String units) {
        this.scanEntries.add(new ScanEntry(name, units));
    }

    protected void addSingleDeviceEditable(String name, String units, boolean editable) {
        this.scanEntries.add(new ScanEntry(name, units, editable));
    }

    protected void addSingleDeviceEnabled(String name, String units, boolean enabled) {
        ScanEntry entry = new ScanEntry(name, units);
        entry.setEnabled(enabled);
        this.scanEntries.add(entry);
    }

    protected JPanel createScanDescriptionPanel() {
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        descriptionPanel.setBorder(BorderFactory.createTitledBorder("Scan Description"));
        GridBagConstraints descriptionConstraints = new GridBagConstraints();
        descriptionConstraints.gridx = 0;
        descriptionConstraints.gridy = 0;
        descriptionConstraints.weightx = 0.0;
        descriptionConstraints.weighty = 0.0;
        descriptionConstraints.insets = new Insets(5, 5, 5, 5);
        descriptionConstraints.anchor = 23;
        GridBagConstraints column1Constraints = (GridBagConstraints)descriptionConstraints.clone();
        column1Constraints.gridx = 0;
        column1Constraints.gridy = 0;
        column1Constraints.fill = 0;
        column1Constraints.weightx = 0.0;
        descriptionPanel.add((Component)this.scanNameLabel, column1Constraints);
        ++column1Constraints.gridy;
        descriptionPanel.add((Component)this.prefixLabel, column1Constraints);
        ++column1Constraints.gridy;
        descriptionPanel.add((Component)this.commentsLabel, column1Constraints);
        GridBagConstraints column2Constraints = (GridBagConstraints)descriptionConstraints.clone();
        column2Constraints.gridx = 1;
        column2Constraints.gridy = 0;
        column2Constraints.fill = 2;
        column2Constraints.weightx = 1.0;
        column2Constraints.weighty = 0.0;
        descriptionPanel.add((Component)this.scanNameField, column2Constraints);
        ++column2Constraints.gridy;
        descriptionPanel.add((Component)this.prefixField, column2Constraints);
        ++column2Constraints.gridy;
        column2Constraints.fill = 1;
        column2Constraints.weighty = 1.0;
        descriptionPanel.add((Component)new JScrollPane(this.commentsTextArea, 22, 31), column2Constraints);
        return descriptionPanel;
    }

    protected void clearScanDescriptionPanel() {
        this.scanNameField.setText("");
        this.commentsTextArea.setText("");
        this.prefixField.setText("");
    }

    protected void loadScanDescriptionPanel(BaseScan input) {
        this.scanNameField.setText(input.getName());
        if (input.getComments() != null) {
            this.commentsTextArea.setText(input.getComments());
        }
        if (input.getPrefix() != null) {
            this.prefixField.setText(input.getPrefix());
        }
    }

    protected void fillEnvScanEntries() {
        this.scanEntries_env = new ArrayList();
        Iterator<InstalledDevice> devIter = this.allDevices.iterator();
        this.installedTempDevices.clear();
        this.installedMagnetDevices.clear();
        while (devIter.hasNext()) {
            InstalledDevice device = devIter.next();
            if (device.getType() != InstalledDevice.Type.environment) continue;
            ScanEntry entry = new ScanEntry(device.getName(), device.getUnits());
            entry.setSingleValue(true);
            this.scanEntries_env.add(entry);
            if (device instanceof InstalledTempDevice) {
                this.installedTempDevices.add((InstalledTempDevice)device);
                continue;
            }
            if (device instanceof InstalledMagnetDevice) {
                this.installedMagnetDevices.add((InstalledMagnetDevice)device);
                continue;
            }
            if (device instanceof InstalledPressureDevice) continue;
            boolean cfr_ignored_0 = device instanceof InstalledMiscDevice;
        }
    }

    protected void setControllerBoxItems() {
        String addTolerance;
        String addSetPoint;
        String addController;
        this.controllerBoxItems.clear();
        this.controllerBoxItems.add(EMPTY);
        this.propertiesPanel.add((Component)this.otherProperties, EMPTY);
        if (this.installedTempDevices.size() != 0) {
            addController = "Temp (" + this.installedTempDevices.get(0).getRealName() + ")";
            addSetPoint = "Set Point(" + this.installedTempDevices.get(0).getUnits() + "):";
            addTolerance = "Tolerance(" + this.installedTempDevices.get(0).getUnits() + "):";
            String addTempName = "Temp (" + this.installedTempDevices.get(0).getRealName() + ")";
            this.controllerBoxItems.add(addController);
            this.tempProperties.setPointLabel.setText(addSetPoint);
            this.tempProperties.toleranceLabel.setText(addTolerance);
            this.propertiesPanel.add((Component)this.tempProperties, addTempName);
        }
        if (this.installedMagnetDevices.size() != 0) {
            addController = "Magfield (" + this.installedMagnetDevices.get(0).getRealName() + ")";
            addSetPoint = "Set Point(" + this.installedMagnetDevices.get(0).getUnits() + "):";
            addTolerance = "Tolerance(" + this.installedMagnetDevices.get(0).getUnits() + "):";
            String addMagName = "Magfield (" + this.installedMagnetDevices.get(0).getRealName() + ")";
            this.controllerBoxItems.add(addController);
            this.magnetProperties.setPointLabel.setText(addSetPoint);
            this.magnetProperties.toleranceLabel.setText(addTolerance);
            this.propertiesPanel.add((Component)this.magnetProperties, addMagName);
        }
        this.controllerTypeBox.setSelectedIndex(0);
        this.controllerTypeBox.updateUI();
    }

    protected JPanel createEnvironmentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        return this.createEnvironmentPanel(panel);
    }

    protected JPanel createEnvironmentPanel(JPanel panel) {
        JLabel emptyLabel = new JLabel();
        JLabel instructionsLabel = new JLabel("<html>Environment parameter will be set to target value before scan is started. <br>Any device with fields left blank will not be moved and will stay at whatever<br> the current position is at run time.</html>");
        JLabel controllerTypeLabel = new JLabel("Controller Type:");
        Bag constraints = new Bag();
        JPanel subPanel = new JPanel(new GridBagLayout());
        int x = 0;
        int y = 0;
        panel.removeAll();
        this.fillEnvScanEntries();
        this.setControllerBoxItems();
        panel.setBorder(BorderFactory.createTitledBorder("Environment"));
        subPanel.add((Component)controllerTypeLabel, constraints.cell(x, y));
        subPanel.add((Component)this.controllerTypeBox, constraints.cell(++x, y));
        subPanel.add((Component)emptyLabel, constraints.cell(++x, y).fillx());
        x = 0;
        y = 0;
        panel.add((Component)instructionsLabel, constraints.cell(x, y).colspan(1));
        panel.add((Component)subPanel, constraints.cell(x, ++y));
        x = 0;
        panel.add((Component)this.propertiesPanel, constraints.cell(x, ++y).fillx());
        this.defaultTemperatureEnvironment();
        this.defaultMagnetEnvironment();
        return panel;
    }

    protected void clearEnvironmentPanel() {
        if (this.installedTempDevices.size() != 0) {
            this.tempProperties.setPointField.setText("");
            this.tempProperties.toleranceField.setText("");
            this.tempProperties.toleranceBandTimeField.setText("");
            this.tempProperties.maxWaitTimeField.setText("");
            this.tempProperties.initialHoldTimeField.setText("");
        }
        if (this.installedMagnetDevices.size() != 0) {
            this.magnetProperties.setPointField.setText("");
            this.magnetProperties.toleranceField.setText("");
            this.magnetProperties.initialHoldTimeField.setText("");
        }
    }

    protected void defaultTemperatureEnvironment() {
        this.tempProperties.setPointField.setText("");
        this.tempProperties.toleranceField.setText(PreferencesManager.getPreferenceString("nonEnvironment.temperatureTolerance"));
        this.tempProperties.toleranceBandTimeField.setText(PreferencesManager.getPreferenceString("nonEnvironment.temperatureToleranceBandTime"));
        this.tempProperties.maxWaitTimeField.setText(PreferencesManager.getPreferenceString("nonEnvironment.temperatureMaxWaitTime"));
        this.tempProperties.initialHoldTimeField.setText(PreferencesManager.getPreferenceString("nonEnvironment.temperatureInitialHoldTime"));
        this.tempProperties.setPointField.setEnabled(true);
        this.tempProperties.toleranceField.setEnabled(false);
        this.tempProperties.toleranceBandTimeField.setEnabled(false);
        this.tempProperties.maxWaitTimeField.setEnabled(false);
        this.tempProperties.initialHoldTimeField.setEnabled(false);
    }

    protected void defaultMagnetEnvironment() {
        this.magnetProperties.setPointField.setText("");
        this.magnetProperties.toleranceField.setText(PreferencesManager.getPreferenceString("nonEnvironment.magnetTolerance"));
        this.magnetProperties.initialHoldTimeField.setText(PreferencesManager.getPreferenceString("nonEnvironment.magnetInitialHoldTime"));
        this.magnetProperties.setPointField.setEnabled(true);
        this.magnetProperties.toleranceField.setEnabled(false);
        this.magnetProperties.initialHoldTimeField.setEnabled(false);
    }

    protected void loadEnvironmentPanel(BaseScan input) {
        HashMap<String, BaseScan.Range> devHash = input.getDeviceRanges();
        if (input.gettempSetPoint() != null) {
            this.tempProperties.setPointField.setText(new Double(input.gettempSetPoint()).toString());
        }
        if (input.gettempTolerance() != null) {
            this.tempProperties.toleranceField.setText(new Double(input.gettempTolerance()).toString());
        }
        if (input.gettempToleranceBT() != null) {
            this.tempProperties.toleranceBandTimeField.setText(new Double(input.gettempToleranceBT() / 60.0).toString());
        }
        if (input.gettempMaxWaitTime() != null) {
            this.tempProperties.maxWaitTimeField.setText(new Double(input.gettempMaxWaitTime() / 60.0).toString());
        }
        if (input.getPreScanHold() != null) {
            this.tempProperties.initialHoldTimeField.setText(new Double(input.getPreScanHold() / 60.0).toString());
        }
        if (input.getmagSetPoint() != null) {
            this.magnetProperties.setPointField.setText(new Double(input.getmagSetPoint()).toString());
        }
        if (input.getmagTolerance() != null) {
            this.magnetProperties.toleranceField.setText(new Double(input.getmagTolerance()).toString());
        }
        if (input.getPreScanHold() != null) {
            this.magnetProperties.initialHoldTimeField.setText(new Double(input.getPreScanHold() / 60.0).toString());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        logger.debug("ChangeEvent!");
        this.removeAll();
        this.buildGUI();
        this.invalidate();
    }

    protected JPanel createModePanel() {
        logger.debug("MODE = " + this.mode);
        JLabel modeLabel = new JLabel("Mode:");
        this.modeGroup.add(this.initialFinalButton);
        this.modeGroup.add(this.initialStepButton);
        this.modeGroup.add(this.centerStepButton);
        JPanel modePanel = new JPanel();
        modePanel.setLayout(new BoxLayout(modePanel, 2));
        modePanel.setBorder(BorderFactory.createBevelBorder(0));
        modePanel.add(Box.createHorizontalGlue());
        modePanel.add(modeLabel);
        modePanel.add(Box.createRigidArea(new Dimension(15, 0)));
        modePanel.add(this.initialFinalButton);
        modePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        modePanel.add(this.initialStepButton);
        modePanel.add(Box.createRigidArea(new Dimension(10, 0)));
        modePanel.add(this.centerStepButton);
        modePanel.add(Box.createHorizontalGlue());
        if (this.mode == 0) {
            this.initialFinalButton.setSelected(true);
        } else if (this.mode == 1) {
            this.initialStepButton.setSelected(true);
        } else if (this.mode == 2) {
            this.centerStepButton.setSelected(true);
        }
        return modePanel;
    }

    protected void modeChange(String modeString) {
        if (modeString.equals("Initial/Final")) {
            logger.debug("init final");
            this.mode = 0;
            Thread thread2 = new Thread(new ChangeMode(this.column1Label, this.column2Label, this.column3Label, this.column4Label, INITIAL, FINAL, CENTER, STEP));
            SwingUtilities.invokeLater(thread2);
        } else if (modeString.equals("Initial/Step")) {
            logger.debug("init step");
            this.mode = 1;
            Thread thread3 = new Thread(new ChangeMode(this.column1Label, this.column2Label, this.column3Label, this.column4Label, INITIAL, STEP, CENTER, FINAL));
            SwingUtilities.invokeLater(thread3);
        } else if (modeString.equals("Center/Step")) {
            logger.debug("center step");
            this.mode = 2;
            Thread thread4 = new Thread(new ChangeMode(this.column1Label, this.column2Label, this.column3Label, this.column4Label, CENTER, STEP, INITIAL, FINAL));
            SwingUtilities.invokeLater(thread4);
        }
        this.recalculateAllRows();
    }

    protected void setModified() {
        this.modified = true;
        String scanName = this.scanNameField.getText().trim();
        String oldName = this.getName();
        if (scanName.length() > 0) {
            this.setName("*" + scanName);
            this.notifyNameChangeListeners("*" + scanName, oldName);
        } else {
            this.setName("*Untitled" + this.scanPanelNumber);
            this.notifyNameChangeListeners("*Untitled" + this.scanPanelNumber, oldName);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (!this.panelReady) {
            return;
        }
        this.modified = true;
        String scanName = this.scanNameField.getText().trim();
        String oldName = this.getName();
        if (scanName.length() > 0) {
            this.setName("*" + scanName);
            this.notifyNameChangeListeners("*" + scanName, oldName);
        } else {
            this.setName("*Untitled" + this.scanPanelNumber);
            this.notifyNameChangeListeners("*Untitled" + this.scanPanelNumber, oldName);
        }
        if (ie.getStateChange() != 1) {
            return;
        }
        Object source = ie.getSource();
        if (source instanceof JRadioButton) {
            this.modeChange(((JRadioButton)source).getText());
        } else if (source instanceof JComboBox) {
            if (source == this.countTypeCB) {
                this.countTypeChange((String)((JComboBox)source).getSelectedItem());
            } else {
                logger.debug("additional item selected");
            }
        }
    }

    protected void recalculateAllRows() {
        Iterator<ScanEntry> iterator = this.scanEntries.iterator();
        while (iterator.hasNext()) {
            iterator.next().recalculate();
        }
        iterator = this.scanEntries_add.iterator();
        while (iterator.hasNext()) {
            iterator.next().recalculate();
        }
    }

    private void NAlabels(JLabel label1, JLabel label2) {
        Thread thread2 = new Thread(new UpdateLabels(label1, label2, "N/A", "N/A"));
        SwingUtilities.invokeLater(thread2);
    }

    protected JPanel createParameterPanel() {
        JLabel numPointsLabel = new JLabel("Number of Points:");
        JLabel baseCountLabel = new JLabel("Base Count:");
        JLabel prefactorLabel = new JLabel("Prefactor:");
        JLabel dataInterestLabel = new JLabel("Data of Interest:");
        JLabel countTypeLabel = new JLabel("Count Against:");
        JLabel timeoutLabel = new JLabel("Timeout:");
        JPanel parameterPanel = new JPanel(new GridBagLayout());
        parameterPanel.setBorder(BorderFactory.createTitledBorder("Scan Parameters"));
        Bag parameterConstraints = new Bag();
        int x = 0;
        int y = 0;
        parameterPanel.add((Component)numPointsLabel, parameterConstraints.cell(x, y));
        parameterPanel.add((Component)this.numPointsField, parameterConstraints.cell(++x, y));
        parameterPanel.add((Component)dataInterestLabel, parameterConstraints.cell(++x, y));
        parameterPanel.add((Component)this.dataInterestCB, parameterConstraints.cell(++x, y));
        x = 0;
        parameterPanel.add((Component)baseCountLabel, parameterConstraints.cell(x, ++y));
        parameterPanel.add((Component)this.baseCountField, parameterConstraints.cell(++x, y));
        parameterPanel.add((Component)countTypeLabel, parameterConstraints.cell(++x, y));
        parameterPanel.add((Component)this.countTypeCB, parameterConstraints.cell(++x, y));
        x = 0;
        parameterPanel.add((Component)prefactorLabel, parameterConstraints.cell(x, ++y));
        parameterPanel.add((Component)this.prefactorField, parameterConstraints.cell(++x, y));
        parameterPanel.add((Component)timeoutLabel, parameterConstraints.cell(++x, y));
        parameterPanel.add((Component)this.timeoutField, parameterConstraints.cell(++x, y));
        return parameterPanel;
    }

    protected void clearParameterPanel() {
        this.numPointsField.setText("");
        this.baseCountField.setText("");
        this.prefactorField.setText("1");
        this.timeoutField.setText("");
    }

    protected void loadParameterPanel(BaseScan input) {
        Double timeout;
        BaseScan.DataOfInterest data = input.getDataOfInterest();
        if (data == BaseScan.DataOfInterest.monitor) {
            this.dataInterestCB.setSelectedItem("Monitor");
        } else {
            this.dataInterestCB.setSelectedItem(dataDetector);
        }
        BaseScan.CountType count = input.getCountType();
        this.countTypeCB.setSelectedItem("Monitor");
        if (count == BaseScan.CountType.time) {
            this.countTypeCB.setSelectedItem(countTime);
        }
        if ((timeout = input.getCountTimeout()) != null) {
            this.timeoutField.setText(new Double(timeout).toString());
        }
        this.numPointsField.setText(new Long(input.getNumPoints()).toString());
        this.baseCountField.setText(new Double(input.getBaseCount()).toString());
        this.prefactorField.setText(new Double(input.getPrefactor()).toString());
    }

    protected void createAdditionalDevice() {
        this.createAdditionalDevice(true);
    }

    protected void createAdditionalDevice(boolean filter) {
        ScanEntry entry = new ScanEntry(true, filter);
        entry.addDeleteButton(this.scanEntries_add);
        this.scanEntries_add.add(entry);
    }

    public abstract void updateAdditionalDevices();

    protected JPanel createBtnPanel() {
        JButton clearBtn = new JButton(new ClearAction());
        JButton dryRunBtn = new JButton(new DryRunScanAction());
        JButton saveBtn = new JButton(this.saveScanAction);
        JButton saveAndRunBtn = new JButton(this.saveAndRunScanAction);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalGlue());
        panel.add(clearBtn);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(dryRunBtn);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(saveBtn);
        panel.add(Box.createRigidArea(new Dimension(5, 0)));
        panel.add(saveAndRunBtn);
        if (this.baseScanDebug) {
            JButton testBtn = new JButton(new TestAction());
            panel.add(Box.createRigidArea(new Dimension(5, 0)));
            panel.add(testBtn);
        }
        return panel;
    }

    protected String getParamDescr() {
        String countType;
        String dataInterest;
        Double prefactor;
        Double baseCount;
        Integer numPoints;
        Integer timeout = new Integer(-1);
        try {
            numPoints = Integer.valueOf(this.numPointsField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            logger.debug("Blank or invalid number for number of points.  Save cancelled:");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify a valid whole number for number of points.");
            return null;
        }
        try {
            baseCount = Double.valueOf(this.baseCountField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            logger.debug("Blank or invalid number for base count.  Save cancelled:");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify a float for base count.");
            return null;
        }
        try {
            prefactor = Double.valueOf(this.prefactorField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            logger.debug("Blank or invalid number for prefactor.  Save cancelled:");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify a valid whole number for prefactor.");
            return null;
        }
        try {
            dataInterest = this.dataInterestCB.getSelectedItem().toString();
            countType = this.countTypeCB.getSelectedItem().toString();
            if (countType.equalsIgnoreCase(dataDetector) && this.timeoutField.getText().trim().length() != 0) {
                timeout = Integer.valueOf(this.timeoutField.getText().trim());
            }
        }
        catch (NumberFormatException nfe) {
            logger.debug("Blank or invalid number for timeout.  Save cancelled:");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify a valid whole number for timeout.");
            return null;
        }
        String scanDescr = ":Npts=" + numPoints + ":Counts=" + baseCount + ":Prefac=" + prefactor + ":DetectorType=" + dataInterest + ":CountType=" + countType;
        if (timeout != -1) {
            scanDescr = scanDescr.concat(":timeout=" + timeout);
        }
        return scanDescr;
    }

    protected String getEnvironmentDescr() {
        Double setPointTemp = 0.0;
        Double toleranceTemp = 0.0;
        Double toleranceBandTimeTemp = 0.0;
        Double maxWaitTimeTemp = 0.0;
        Double initialHoldTimeTemp = 0.0;
        Double setPointMagnet = 0.0;
        Double toleranceMagnet = 0.0;
        Double initialHoldTimeMagnet = 0.0;
        String scanDescr = "";
        String presetProperties = "";
        int setPointTempLength = this.tempProperties.setPointField.getText().trim().length();
        if (this.installedTempDevices.size() != 0 && setPointTempLength != 0) {
            try {
                setPointTemp = Double.valueOf(this.tempProperties.setPointField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.setPointWarning"));
                return "";
            }
            try {
                if (this.tempProperties.toleranceField.isEnabled()) {
                    toleranceTemp = Double.valueOf(this.tempProperties.toleranceField.getText().trim());
                }
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                return "";
            }
            try {
                if (this.tempProperties.toleranceBandTimeField.isEnabled()) {
                    toleranceBandTimeTemp = Double.valueOf(this.tempProperties.toleranceBandTimeField.getText().trim()) * 60.0;
                }
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceBandTimeWarning"));
                return "";
            }
            try {
                if (this.tempProperties.maxWaitTimeField.isEnabled()) {
                    maxWaitTimeTemp = Double.valueOf(this.tempProperties.maxWaitTimeField.getText().trim()) * 60.0;
                }
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.maxWaitTimeWarning"));
                return "";
            }
            try {
                if (this.tempProperties.initialHoldTimeField.isEnabled()) {
                    initialHoldTimeTemp = Double.valueOf(this.tempProperties.initialHoldTimeField.getText().trim()) * 60.0;
                }
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.initialHoldTimeWarning"));
                return "";
            }
            String deviceName = this.installedTempDevices.get(0).getRealName();
            if (this.mode == 0) {
                scanDescr = scanDescr.concat(":Range=" + deviceName + "=" + setPointTemp + " " + setPointTemp + " s");
            } else if (this.mode == 1) {
                scanDescr = scanDescr.concat(":Range=" + deviceName + "=" + setPointTemp + " 0.0 i");
            } else if (this.mode == 2) {
                scanDescr = scanDescr.concat(":Range=" + deviceName + "=" + setPointTemp + " 0.0");
            }
            presetProperties = ":presetdevicesproperties=" + deviceName + " tolerance " + toleranceTemp + ", toleranceDT " + toleranceBandTimeTemp + ", timeout " + maxWaitTimeTemp;
        }
        int setPointMagLength = this.magnetProperties.setPointField.getText().trim().length();
        if (this.installedMagnetDevices.size() != 0 && setPointMagLength != 0) {
            try {
                setPointMagnet = Double.valueOf(this.magnetProperties.setPointField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.setPointWarning"));
                return "";
            }
            try {
                if (this.magnetProperties.toleranceField.isEnabled()) {
                    toleranceMagnet = Double.valueOf(this.magnetProperties.toleranceField.getText().trim());
                }
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                return "";
            }
            try {
                if (this.magnetProperties.initialHoldTimeField.isEnabled()) {
                    initialHoldTimeMagnet = Double.valueOf(this.magnetProperties.initialHoldTimeField.getText().trim()) * 60.0;
                }
            }
            catch (NumberFormatException nfe) {
                this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.initialHoldTimeWarning"));
                return "";
            }
            String deviceName = this.installedMagnetDevices.get(0).getRealName();
            if (this.mode == 0) {
                scanDescr = scanDescr.concat(":Range=" + deviceName + "=" + setPointMagnet + " " + setPointMagnet + " s");
            } else if (this.mode == 1) {
                scanDescr = scanDescr.concat(":Range=" + deviceName + "=" + setPointMagnet + " 0.0 i");
            } else if (this.mode == 2) {
                scanDescr = scanDescr.concat(":Range=" + deviceName + "=" + setPointMagnet + " 0.0");
            }
            presetProperties = presetProperties.equals("") ? ":presetdevicesproperties=" + deviceName + " tolerance " + toleranceMagnet : String.valueOf(presetProperties) + "|" + deviceName + " tolerance " + toleranceMagnet;
        }
        scanDescr = scanDescr.concat(presetProperties);
        scanDescr = initialHoldTimeTemp > initialHoldTimeMagnet ? scanDescr.concat(":HoldScan=" + initialHoldTimeTemp) : scanDescr.concat(":HoldScan=" + initialHoldTimeMagnet);
        if (this.installedTempDevices.size() != 0 && setPointTempLength == 0 && this.installedMagnetDevices.size() != 0 && setPointMagLength == 0) {
            scanDescr = "noSetPoint";
        }
        return scanDescr;
    }

    public String getComments(String commentsin) {
        if (commentsin == null) {
            return commentsin;
        }
        try {
            String comments = commentsin.trim();
            comments = comments.replaceAll("\r\n", " ");
            comments = comments.replaceAll("\n", " ");
            if (comments.startsWith("\"")) {
                if (comments.endsWith("\"")) {
                    if (comments.length() > 2) {
                        comments = "\"" + comments.substring(1, comments.length() - 1).replaceAll("\"", "\\\\\"") + "\"";
                    }
                } else {
                    comments = "\"" + comments.replaceAll("\"", "\\\\\"") + "\"";
                }
            } else if (comments.length() > 0) {
                comments = "\"" + comments.replaceAll("\"", "\\\\\"") + "\"";
            }
            return comments;
        }
        catch (Exception e) {
            return commentsin;
        }
    }

    protected abstract String getDescr();

    protected abstract void clearFields();

    @Override
    public boolean panelClosing() {
        logger.debug("in PanelClosing");
        this.acceptClose = true;
        if (!this.modified) {
            return this.acceptClose;
        }
        String scanName = this.scanNameField.getText().trim();
        ArrayList<JButton> btns = new ArrayList<JButton>();
        JButton yesBtn = new JButton(this.saveScanAction);
        JButton noBtn = new JButton("No");
        JButton cancelBtn = new JButton(new CloseCancelAction());
        btns.add(yesBtn);
        btns.add(noBtn);
        btns.add(cancelBtn);
        String message = "Do you want to save changes to " + this.getName().substring(1);
        if (scanName.length() > 0) {
            message = "Do you want to save changes to " + scanName;
        }
        this.throwConfirmDialog("Confirm Save", message, btns);
        return this.acceptClose;
    }

    @Override
    public IceMenuAction getIceMenuAction(String actionName) {
        IceMenuAction action = this.actionMap.get(actionName);
        if (action == null) {
            return new IceMenuAction(actionName);
        }
        return action;
    }

    protected void countTypeChange(String countType) {
        Thread thread2;
        if (countType.equalsIgnoreCase(dataDetector)) {
            logger.debug("timeout field editable");
            thread2 = new Thread(new SetEditable(this.timeoutField, true));
        } else {
            logger.debug("timeout field uneditable");
            thread2 = new Thread(new SetEditable(this.timeoutField, false));
        }
        SwingUtilities.invokeLater(thread2);
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.documentChanged(arg0);
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
    }

    public void documentChanged(DocumentEvent de) {
        if (!this.panelReady) {
            return;
        }
        this.modified = true;
        String scanName = this.scanNameField.getText().trim();
        String oldName = this.getName();
        if (scanName.length() > 0) {
            this.setName("*" + scanName);
            this.notifyNameChangeListeners("*" + scanName, oldName);
        } else {
            this.setName("*Untitled" + this.scanPanelNumber);
            this.notifyNameChangeListeners("*Untitled" + this.scanPanelNumber, oldName);
        }
    }

    private void fillDeviceComboBox(JComboBox box, boolean filter) {
        for (InstalledDevice dev : this.allDevices) {
            if (dev.getType() == InstalledDevice.Type.environment || dev.getType() == InstalledDevice.Type.counter || filter && this.skipDevices.contains(dev.getName())) continue;
            box.addItem(dev);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent event) {
        this.allDevices = event.getNewList();
        logger.debug("Device list changed " + this.allDevices.size());
        int i = 0;
        while (i < this.scanEntries_add.size()) {
            SwingUtilities.invokeLater(new UpdateDeviceComboBox(this.scanEntries_add.get(i).getComboBox(), this.scanEntries_add.get(i).getUnitLabel(), true));
            ++i;
        }
        SwingUtilities.invokeLater(new CreateEnvPanel(this.envPanel));
    }

    public static void main(String[] args) {
    }

    public JLabel createLabel(String name) {
        JLabel label = new JLabel(name);
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(2);
        return label;
    }

    public JLabel createLabel(String name, int horizAlign) {
        JLabel label = new JLabel(name);
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(horizAlign);
        return label;
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getSource() == this.numPointsField) {
            this.recalculateAllRows();
        }
    }

    protected QandEPoint getBraggInfo() {
        String fixedString;
        QandEPoint bragg = new QandEPoint();
        if (this.eTransferField.getText().trim().length() != 0) {
            try {
                Double eTransfer = Double.valueOf(this.eTransferField.getText().trim());
                bragg.setE(eTransfer);
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid number for energy transfer.  Save cancelled:");
                logger.debug(nfe.getMessage());
                this.throwErrorDialog("Input Error", "Please specify a valid value for energy transfer.");
                return null;
            }
        }
        if ((fixedString = this.eFixedCB.getSelectedItem().toString()).equalsIgnoreCase(fixedFinal)) {
            bragg.setFixedFlag(1);
        } else if (fixedString.equalsIgnoreCase(fixedInitial)) {
            bragg.setFixedFlag(0);
        } else {
            logger.debug("Internal error with eFixedCB.  Save cancelled:");
            this.throwErrorDialog("Error", "Internal error selecting fixed energy.");
            return null;
        }
        if (this.eFixedField.getText().trim().length() != 0) {
            try {
                Double fixedEnergy = Double.valueOf(this.eFixedField.getText().trim());
                bragg.setFixedE(fixedEnergy);
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid number for fixed energy.  Save cancelled:");
                logger.debug(nfe.getMessage());
                this.throwErrorDialog("Input Error", "Please specify a valid value for fixed energy.");
                return null;
            }
        }
        if (this.hField.getText().trim().length() != 0) {
            try {
                Double hValue = Double.valueOf(this.hField.getText().trim());
                bragg.setH(hValue);
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid number for H.  Save cancelled:");
                logger.debug(nfe.getMessage());
                this.throwErrorDialog("Input Error", "Please specify a valid value for H.");
                return null;
            }
        }
        if (this.kField.getText().trim().length() != 0) {
            try {
                Double kValue = Double.valueOf(this.kField.getText().trim());
                bragg.setK(kValue);
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid number for K.  Save cancelled:");
                logger.debug(nfe.getMessage());
                this.throwErrorDialog("Input Error", "Please specify a valid value for K.");
                return null;
            }
        }
        if (this.lField.getText().trim().length() != 0) {
            try {
                Double lValue = Double.valueOf(this.lField.getText().trim());
                bragg.setL(lValue);
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid number for L.  Save cancelled:");
                logger.debug(nfe.getMessage());
                this.throwErrorDialog("Input Error", "Please specify a valid value for L.");
                return null;
            }
        }
        return bragg;
    }

    protected String getBraggDescr() {
        QandEPoint bragg = this.getBraggInfo();
        if (bragg == null || !bragg.isValid()) {
            return null;
        }
        String scanDescr = "";
        scanDescr = scanDescr.concat(":Fixed=" + bragg.getFixedFlag());
        scanDescr = scanDescr.concat(":FixedE=" + bragg.getFixedE());
        String tag = "";
        if (this.mode == 0) {
            tag = " s";
        } else if (this.mode == 1) {
            tag = " i";
        }
        if (this.mode == 0) {
            scanDescr = scanDescr.concat(":Range=E=" + bragg.getE() + " " + bragg.getE() + tag);
            String qstring = ":Range=Q=" + bragg.getH() + "~" + bragg.getK() + "~" + bragg.getL() + " " + bragg.getH() + "~" + bragg.getK() + "~" + bragg.getL();
            scanDescr = scanDescr.concat(String.valueOf(qstring) + tag);
        } else {
            scanDescr = scanDescr.concat(":Range=Q=" + bragg.getH() + "~" + bragg.getK() + "~" + bragg.getL() + " 0~0~0" + tag);
            scanDescr = scanDescr.concat(":Range=E=" + bragg.getE() + " 0" + tag);
        }
        return scanDescr;
    }

    private InstalledDevice getFirstDevice(String deviceName) {
        for (InstalledDevice device : this.allDevices) {
            if (!device.getName().equalsIgnoreCase(deviceName) && !device.getRealName().equalsIgnoreCase(deviceName)) continue;
            return device;
        }
        return null;
    }

    protected class AddDeviceAction
    extends AbstractAction {
        public AddDeviceAction() {
            this.putValue("Name", "Include Another Device in Scan");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("Trying to add a new device");
            BaseScanPanel.this.createAdditionalDevice();
            SwingUtilities.invokeLater(new RebuildGUI());
        }
    }

    protected class AddDeviceComboAction
    extends AbstractAction {
        public AddDeviceComboAction() {
            this.putValue("Name", "Additional Device Selection");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object obj = ae.getSource();
            if (!(obj instanceof JComboBox)) {
                return;
            }
            JComboBox jcbox = (JComboBox)obj;
            int pos = -1;
            int i = 0;
            while (i < BaseScanPanel.this.scanEntries_add.size()) {
                if (jcbox == BaseScanPanel.this.scanEntries_add.get(i).getComboBox()) {
                    pos = i;
                    break;
                }
                ++i;
            }
            if (pos == -1) {
                return;
            }
            logger.debug("combo action! " + pos);
            if (jcbox.getSelectedItem() != null) {
                String units = ((InstalledDevice)jcbox.getSelectedItem()).getUnits();
                if (units.equalsIgnoreCase("deg") || units.equalsIgnoreCase("degrees")) {
                    units = Global.degreeSign();
                } else if (units.equalsIgnoreCase("None")) {
                    units = "";
                }
                logger.debug("new device selected" + units);
                Thread thread1 = new Thread(new SetText(BaseScanPanel.this.scanEntries_add.get(pos).getUnitLabel(), units));
                SwingUtilities.invokeLater(thread1);
            }
        }
    }

    protected class AddSingleDevice
    implements Runnable {
        protected String name;
        protected String units;

        public AddSingleDevice(String name, String units) {
            this.name = name;
            this.units = units;
        }

        @Override
        public void run() {
            BaseScanPanel.this.addSingleDevice(this.name, this.units);
            BaseScanPanel.this.invalidate();
        }
    }

    private class ChangeMode
    implements Runnable {
        private JLabel column1;
        private JLabel column2;
        private JLabel column3;
        private JLabel column4;
        private String label1;
        private String label2;
        private String label3;
        private String label4;

        public ChangeMode(JLabel column1, JLabel column2, JLabel column3, JLabel column4, String label1, String label2, String label3, String label4) {
            this.column1 = column1;
            this.column2 = column2;
            this.column3 = column3;
            this.column4 = column4;
            this.label1 = label1;
            this.label2 = label2;
            this.label3 = label3;
            this.label4 = label4;
        }

        @Override
        public void run() {
            this.column1.setText(this.label1);
            this.column2.setText(this.label2);
            this.column3.setText(this.label3);
            this.column4.setText(this.label4);
        }
    }

    public class ClearAction
    extends IceMenuAction {
        public ClearAction() {
            super("Clear");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseScanPanel.this.clearFields();
        }
    }

    protected class CloseCancelAction
    extends AbstractAction {
        public CloseCancelAction() {
            this.putValue("Name", "Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseScanPanel.this.acceptClose = false;
        }
    }

    public class ControllerTypeItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (ie.getStateChange() == 1) {
                CardLayout cl = (CardLayout)BaseScanPanel.this.propertiesPanel.getLayout();
                cl.show(BaseScanPanel.this.propertiesPanel, (String)ie.getItem());
            }
        }
    }

    protected class CreateEnvPanel
    implements Runnable {
        protected JPanel panel;

        public CreateEnvPanel(JPanel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            BaseScanPanel.this.createEnvironmentPanel(this.panel);
            BaseScanPanel.this.validate();
        }
    }

    protected class DryRunScanAction
    extends AbstractAction {
        public DryRunScanAction() {
            this.putValue("Name", "Dry Run Scan");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String scanDescr = BaseScanPanel.this.getDescr();
            String scanName = BaseScanPanel.this.scanNameField.getText().trim();
            String prefix = "";
            String suffix = "";
            if (scanName.contains(" ")) {
                prefix = "\"";
                suffix = "\"";
            }
            if (scanDescr.length() > 0) {
                BaseScanPanel.this.sendManager.addMessage("scan descrtolist " + prefix + scanName + "_tmp" + suffix + " " + scanDescr);
                BaseScanPanel.this.sendManager.addMessage("scan dryrun " + prefix + scanName + "_tmp" + suffix);
                BaseScanPanel.this.sendManager.addMessage("scan delete " + prefix + scanName + "_tmp" + suffix);
                logger.debug(scanDescr);
            }
        }
    }

    public class MagnetScanPropertiesPanel
    extends JPanel {
        public JTextField setPointField;
        public JTextField toleranceField;
        public JTextField initialHoldTimeField;
        public JButton resetValuesButton;
        public JLabel setPointLabel;
        public JLabel toleranceLabel;

        public MagnetScanPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel initialHoldTimeLabel = new JLabel(I18N.getString("sampleEnvironment.initialHoldTime"));
            Bag parameterConstraints = new Bag();
            this.setPointLabel = new JLabel(I18N.getString("sampleEnvironment.setPoint"));
            this.toleranceLabel = new JLabel(I18N.getString("sampleEnvironment.tolerance"));
            this.setPointField = new JTextField(5);
            this.toleranceField = new JTextField(5);
            this.initialHoldTimeField = new JTextField(5);
            this.resetValuesButton = new JButton(I18N.getString("sampleEnvironment.resetValues"));
            this.setPointField.getDocument().addDocumentListener(new SetPointDocumentListener());
            this.setPointField.getDocument().putProperty("name", "magnet");
            int x = 0;
            int y = 0;
            this.add((Component)this.setPointLabel, parameterConstraints.cell(x, y));
            this.add((Component)this.setPointField, parameterConstraints.cell(++x, y));
            this.add((Component)this.toleranceLabel, parameterConstraints.cell(++x, y));
            this.add((Component)this.toleranceField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)initialHoldTimeLabel, parameterConstraints.cell(x, ++y));
            this.add((Component)this.initialHoldTimeField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)this.resetValuesButton, parameterConstraints.cell(x, ++y));
        }
    }

    public class NameUnitPair
    implements Comparable {
        private String name;
        private String unit;

        public NameUnitPair(String name, String unit) {
            this.name = name;
            this.unit = unit;
        }

        public String getName() {
            return this.name;
        }

        public String getUnit() {
            return this.unit;
        }

        public int compareTo(Object nameUnitPair) {
            return this.name.compareTo(((NameUnitPair)nameUnitPair).getName());
        }
    }

    public class OtherScanPropertiesPanel
    extends JPanel {
    }

    public class PressureScanPropertiesPanel
    extends JPanel {
        public JTextField setPointField;

        public PressureScanPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel setPointLabel = new JLabel(I18N.getString("sampleEnvironment.setPoint"));
            Bag parameterConstraints = new Bag();
            this.setPointField = new JTextField(5);
            int x = 0;
            int y = 0;
            this.add((Component)setPointLabel, parameterConstraints.cell(x, y));
            this.add((Component)this.setPointField, parameterConstraints.cell(++x, y));
        }
    }

    protected class QandEPoint {
        protected static final int E_INITIAL = 0;
        protected static final int E_FINAL = 1;
        private Double eFixed;
        private Integer fixedFlag;
        private Double eTransfer;
        private Double h;
        private Double k;
        private Double l;

        public QandEPoint() {
            this.eFixed = null;
            this.fixedFlag = null;
            this.eTransfer = null;
            this.h = null;
            this.k = null;
            this.l = null;
        }

        public QandEPoint(Double eFixed, Integer fixedFlag, Double eTransfer, Double h, Double k, Double l) {
            this.eFixed = eFixed;
            this.fixedFlag = fixedFlag;
            this.eTransfer = eTransfer;
            this.h = h;
            this.k = k;
            this.l = l;
        }

        public String getEfixedString() {
            if (this.fixedFlag == 0) {
                return "i";
            }
            if (this.fixedFlag == 1) {
                return "f";
            }
            logger.debug("Could not determine fixed energy");
            BaseScanPanel.this.throwErrorDialog("Error", "Internal error selecting fixed energy.");
            return "";
        }

        public void setFixedFlag(Integer fixedFlag) {
            this.fixedFlag = fixedFlag;
        }

        public Integer getFixedFlag() {
            return this.fixedFlag;
        }

        public Double getFixedE() {
            return this.eFixed;
        }

        public void setFixedE(Double eFixed) {
            this.eFixed = eFixed;
        }

        public Double getE() {
            return this.eTransfer;
        }

        public void setE(Double eTransfer) {
            this.eTransfer = eTransfer;
        }

        public Double getH() {
            return this.h;
        }

        public void setH(Double h) {
            this.h = h;
        }

        public Double getK() {
            return this.k;
        }

        public void setK(Double k) {
            this.k = k;
        }

        public Double getL() {
            return this.l;
        }

        public void setL(Double l) {
            this.l = l;
        }

        public boolean isValid() {
            return this.eFixed != null & this.eTransfer != null & this.fixedFlag != null & this.h != null & this.k != null & this.l != null;
        }
    }

    public class RebuildGUI
    implements Runnable {
        @Override
        public void run() {
            logger.debug("Rebuilding GUI");
            BaseScanPanel.this.removeAll();
            BaseScanPanel.this.buildGUI();
            BaseScanPanel.this.validate();
        }
    }

    public class RemoveAdditionalItem
    implements Runnable {
        int pos;

        public RemoveAdditionalItem(int pos) {
            this.pos = pos;
        }

        @Override
        public void run() {
            BaseScanPanel.this.scanEntries_add.remove(this.pos);
        }
    }

    public class ResetMagnetDefaultValuesActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseScanPanel.this.defaultMagnetEnvironment();
        }
    }

    public class ResetTempDefaultValuesActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseScanPanel.this.defaultTemperatureEnvironment();
        }
    }

    protected class SaveAndRunScanAction
    extends AbstractAction {
        public SaveAndRunScanAction() {
            this.putValue("Name", "Save and Run Scan");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String scanDescr = BaseScanPanel.this.getDescr();
            String scanName = BaseScanPanel.this.scanNameField.getText().trim();
            if (scanDescr.length() > 0) {
                BaseScanPanel.this.sendManager.addMessage("scan descrtolist \"" + scanName + "\" " + scanDescr);
                BaseScanPanel.this.sendManager.addMessage("scan load \"" + scanName + "\"");
                BaseScanPanel.this.sendManager.addMessage("scan runscan \"" + scanName + "\"");
                String oldName = BaseScanPanel.this.getName();
                BaseScanPanel.this.setName(BaseScanPanel.this.scanNameField.getText().trim());
                BaseScanPanel.this.notifyNameChangeListeners(BaseScanPanel.this.scanNameField.getText().trim(), oldName);
                BaseScanPanel.this.acceptClose = true;
                BaseScanPanel.this.modified = false;
            } else {
                BaseScanPanel.this.acceptClose = false;
            }
        }
    }

    protected class SaveScanAction
    extends IceMenuAction {
        public SaveScanAction() {
            super("Save Scan");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String scanDescr = BaseScanPanel.this.getDescr();
            String scanName = BaseScanPanel.this.scanNameField.getText().trim();
            String comments = BaseScanPanel.this.commentsTextArea.getText();
            String dataPrefix = BaseScanPanel.this.prefixField.getText();
            if (comments.indexOf(58) != -1 || scanName.indexOf(58) != -1 || dataPrefix.indexOf(58) != -1) {
                logger.debug("Scan field included a ':' character.  Save cancelled.");
                BaseScanPanel.this.throwErrorDialog("Invalid character.", "Scan fields cannot include a ':' character.");
                BaseScanPanel.this.acceptClose = false;
            } else if (scanDescr.length() > 0) {
                BaseScanPanel.this.sendManager.addMessage("scan descrtolist \"" + scanName + "\" " + scanDescr);
                String oldName = BaseScanPanel.this.getName();
                BaseScanPanel.this.setName(BaseScanPanel.this.scanNameField.getText().trim());
                BaseScanPanel.this.notifyNameChangeListeners(BaseScanPanel.this.scanNameField.getText().trim(), oldName);
                BaseScanPanel.this.acceptClose = true;
                BaseScanPanel.this.modified = false;
            } else {
                BaseScanPanel.this.acceptClose = false;
            }
        }
    }

    public class ScanEntry
    implements DocumentListener,
    KeyListener,
    ItemListener {
        protected JLabel name;
        protected JTextField firstField;
        protected JLabel units;
        protected JTextField secondField;
        protected JLabel infoField1;
        protected JLabel infoField2;
        protected JComboBox name_CB;
        protected boolean isCombo;
        protected JButton deleteButton;
        protected boolean isSingleValue;

        public ScanEntry(boolean isCombo, boolean filter) {
            this("Scan entry", "None");
            logger.debug("creating combo box");
            this.isCombo = isCombo;
            this.name_CB = new JComboBox();
            String defaultUnits = "";
            baseScanPanel.fillDeviceComboBox(this.name_CB, filter);
            defaultUnits = ((InstalledDevice)this.name_CB.getSelectedItem()).getUnits();
            this.units = baseScanPanel.createLabel(defaultUnits, 2);
            this.name_CB.setAction(baseScanPanel.new AddDeviceComboAction());
            this.name_CB.addItemListener(this);
        }

        public ScanEntry(String name, String units, boolean editable) {
            this(name, units);
            this.firstField.setEditable(editable);
            this.secondField.setEditable(editable);
        }

        public ScanEntry(String name, String units) {
            this.name = BaseScanPanel.this.createLabel(name);
            this.isCombo = false;
            this.firstField = new JTextField(6);
            this.firstField.addKeyListener(this);
            this.firstField.setName("first");
            this.secondField = new JTextField(6);
            this.secondField.addKeyListener(this);
            this.secondField.setName("second");
            this.units = BaseScanPanel.this.createLabel(units, 2);
            this.infoField1 = BaseScanPanel.this.createLabel("N/A", 2);
            this.infoField2 = BaseScanPanel.this.createLabel("N/A", 2);
            this.deleteButton = null;
            this.isSingleValue = false;
        }

        public void addDeleteButton(ArrayList<ScanEntry> array) {
            this.deleteButton = new JButton(new DeleteEntryAction(this, array));
        }

        public void setSingleValue(boolean isSingleValue) {
            this.isSingleValue = isSingleValue;
        }

        public JButton getDeleteButton() {
            return this.deleteButton;
        }

        public String getName() {
            if (this.isCombo) {
                return ((InstalledDevice)this.name_CB.getSelectedItem()).getName();
            }
            return this.name.getText();
        }

        public void setEnabled(boolean enabled) {
            this.firstField.setEnabled(enabled);
            this.secondField.setEnabled(enabled);
        }

        public JLabel getNameLabel() {
            return this.name;
        }

        public JLabel getUnitLabel() {
            return this.units;
        }

        public JLabel getInfoLabel1() {
            return this.infoField1;
        }

        public JLabel getInfoLabel2() {
            return this.infoField2;
        }

        public JTextField getFirstField() {
            return this.firstField;
        }

        public JTextField getSecondField() {
            return this.secondField;
        }

        public JComboBox getComboBox() {
            return this.name_CB;
        }

        @Override
        public void keyTyped(KeyEvent ke) {
        }

        @Override
        public void keyReleased(KeyEvent ke) {
            Component source = ke.getComponent();
            if (source instanceof JTextField) {
                this.checkNumberValidity((JTextField)ke.getComponent(), this.name.getText());
            }
            this.recalculate();
        }

        @Override
        public void keyPressed(KeyEvent ke) {
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BaseScanPanel.this.documentChanged(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BaseScanPanel.this.documentChanged(e);
        }

        protected boolean checkNumberValidity(JTextField textField, String compName) {
            InstalledDevice device;
            Double value;
            if (textField.getText().length() == 0) {
                BaseScanPanel.this.removeErrorMessage(textField);
                return true;
            }
            try {
                value = Double.parseDouble(textField.getText());
                BaseScanPanel.this.removeErrorMessage(textField);
            }
            catch (NumberFormatException nfe) {
                if (!BaseScanPanel.this.errorMessages.containsKey(textField)) {
                    BaseScanPanel.this.appendErrorMessage(textField, "Invalid number for " + compName + " field!");
                }
                return false;
            }
            if (this.isSingleValue && (device = BaseScanPanel.this.getFirstDevice(this.getName())) != null) {
                Double lower = device.getLowerLimit();
                Double upper = device.getUpperLimit();
                if (upper != null && lower != null) {
                    if (value < lower || value > upper) {
                        BaseScanPanel.this.appendErrorMessage(textField, "Value out of range for " + this.getName());
                    } else {
                        BaseScanPanel.this.removeErrorMessage(textField);
                    }
                }
            }
            return true;
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            if (!BaseScanPanel.this.panelReady) {
                return;
            }
            BaseScanPanel.this.modified = true;
            String scanName = BaseScanPanel.this.scanNameField.getText().trim();
            String oldName = this.getName();
            if (scanName.length() > 0) {
                BaseScanPanel.this.setName("*" + scanName);
                BaseScanPanel.this.notifyNameChangeListeners("*" + scanName, oldName);
            } else {
                BaseScanPanel.this.setName("*Untitled" + BaseScanPanel.this.scanPanelNumber);
                BaseScanPanel.this.notifyNameChangeListeners("*Untitled" + BaseScanPanel.this.scanPanelNumber, oldName);
            }
            if (ie.getStateChange() != 1) {
                return;
            }
            Object source = ie.getSource();
            if (source instanceof JComboBox) {
                if (source == BaseScanPanel.this.countTypeCB) {
                    BaseScanPanel.this.countTypeChange((String)((JComboBox)source).getSelectedItem());
                } else {
                    logger.debug("additional item selected");
                }
            }
        }

        public void recalculate() {
            Double numPoints = null;
            try {
                numPoints = Double.valueOf(BaseScanPanel.this.numPointsField.getText().trim());
                if (numPoints <= 0.0) {
                    BaseScanPanel.this.NAlabels(this.infoField1, this.infoField2);
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                logger.debug("Invalid value in number of points field.  Skipping calculations.");
                BaseScanPanel.this.NAlabels(this.infoField1, this.infoField2);
                return;
            }
            Double init = null;
            Double step = null;
            Double fin = null;
            Double center = null;
            DecimalFormat df = Global.createDecimalValue();
            if (BaseScanPanel.this.mode == 0) {
                try {
                    init = Double.valueOf(this.firstField.getText().trim());
                    fin = Double.valueOf(this.secondField.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Unable to parse init and final.  Skipping calculation.");
                    logger.debug(nfe.getMessage());
                    BaseScanPanel.this.NAlabels(this.infoField1, this.infoField2);
                    return;
                }
                center = (fin + init) / 2.0;
                step = numPoints == 1.0 ? Double.valueOf(0.0) : Double.valueOf((fin - init) / (numPoints - 1.0));
                Thread thread2 = new Thread(new UpdateLabels(this.infoField1, this.infoField2, df.format(center), df.format(step)));
                logger.debug("center: " + center + ", step:" + step);
                SwingUtilities.invokeLater(thread2);
            } else if (BaseScanPanel.this.mode == 1) {
                try {
                    init = Double.valueOf(this.firstField.getText().trim());
                    step = Double.valueOf(this.secondField.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Unable to parse init and step.  Skipping calculation.");
                    logger.debug(nfe.getMessage());
                    BaseScanPanel.this.NAlabels(this.infoField1, this.infoField2);
                    return;
                }
                fin = init + step * (numPoints - 1.0);
                center = init + step * Math.floor(numPoints / 2.0) - (1.0 - numPoints % 2.0) * (step / 2.0);
                logger.debug("fin: " + fin + ", center: " + center);
                Thread thread3 = new Thread(new UpdateLabels(this.infoField1, this.infoField2, df.format(center), df.format(fin)));
                SwingUtilities.invokeLater(thread3);
            } else if (BaseScanPanel.this.mode == 2) {
                Thread thread4;
                try {
                    center = Double.valueOf(this.firstField.getText().trim());
                    step = Double.valueOf(this.secondField.getText().trim());
                }
                catch (NumberFormatException nfe) {
                    logger.debug("Unable to parse center and step.  Skipping calculation.");
                    logger.debug(nfe.getMessage());
                    BaseScanPanel.this.NAlabels(this.infoField1, this.infoField2);
                    return;
                }
                if (numPoints % 2.0 == 0.0) {
                    init = center - step / 2.0 - step * (numPoints / 2.0 - 1.0);
                    fin = center + step / 2.0 + step * (numPoints / 2.0 - 1.0);
                    thread4 = new Thread(new UpdateLabels(this.infoField1, this.infoField2, df.format(init), df.format(fin)));
                } else {
                    logger.debug("odd");
                    init = center - step * ((numPoints - 1.0) / 2.0);
                    fin = center + step * ((numPoints - 1.0) / 2.0);
                    thread4 = new Thread(new UpdateLabels(this.infoField1, this.infoField2, df.format(init), df.format(fin)));
                }
                SwingUtilities.invokeLater(thread4);
            } else {
                return;
            }
            InstalledDevice device = BaseScanPanel.this.getFirstDevice(this.getName());
            if (device != null) {
                Double lower = device.getLowerLimit();
                Double upper = device.getUpperLimit();
                if (upper != null && lower != null) {
                    if (init < lower || init > upper) {
                        BaseScanPanel.this.appendErrorMessage(this.firstField, "Initial value out of range for " + this.getName());
                    } else {
                        BaseScanPanel.this.removeErrorMessage(this.firstField);
                    }
                    if (fin < lower || fin > upper) {
                        BaseScanPanel.this.appendErrorMessage(this.secondField, "Final value out of range for " + this.getName());
                    } else {
                        BaseScanPanel.this.removeErrorMessage(this.secondField);
                    }
                }
            }
        }

        protected class DeleteEntryAction
        extends AbstractAction {
            ScanEntry toDelete;
            ArrayList<ScanEntry> array;

            public DeleteEntryAction(ScanEntry toDelete, ArrayList<ScanEntry> array) {
                this.toDelete = toDelete;
                this.array = array;
                this.putValue("SmallIcon", IconManager.getIcon("remove16x16"));
                this.putValue("ShortDescription", "Click to remove additional device");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                this.array.remove(this.toDelete);
                BaseScanPanel.this.updateAdditionalDevices();
                BaseScanPanel.this.setModified();
            }
        }
    }

    protected class SetEditable
    extends SetEnabled
    implements Runnable {
        public SetEditable(JTextField component, boolean enable) {
            super(component, enable);
        }

        @Override
        public void run() {
            super.run();
            this.component.setEditable(this.enable);
            if (!this.enable) {
                this.component.setText("");
            }
        }
    }

    protected class SetEnabled
    implements Runnable {
        JTextField component;
        boolean enable;

        public SetEnabled(JTextField component, boolean enable) {
            this.component = component;
            this.enable = enable;
        }

        @Override
        public void run() {
            this.component.setEnabled(this.enable);
        }
    }

    public class SetPointDocumentListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent de) {
            this.setPointExists(de);
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.setPointExists(de);
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        private void setPointExists(DocumentEvent de) {
            if (de.getDocument().getProperty("name").equals("temperature")) {
                if (BaseScanPanel.this.tempProperties.setPointField.getText().length() == 0) {
                    BaseScanPanel.this.tempProperties.toleranceField.setEnabled(false);
                    BaseScanPanel.this.tempProperties.toleranceBandTimeField.setEnabled(false);
                    BaseScanPanel.this.tempProperties.maxWaitTimeField.setEnabled(false);
                    BaseScanPanel.this.tempProperties.initialHoldTimeField.setEnabled(false);
                } else {
                    BaseScanPanel.this.tempProperties.toleranceField.setEnabled(true);
                    BaseScanPanel.this.tempProperties.toleranceBandTimeField.setEnabled(true);
                    BaseScanPanel.this.tempProperties.maxWaitTimeField.setEnabled(true);
                    BaseScanPanel.this.tempProperties.initialHoldTimeField.setEnabled(true);
                }
            } else if (de.getDocument().getProperty("name").equals("magnet")) {
                if (BaseScanPanel.this.magnetProperties.setPointField.getText().length() == 0) {
                    BaseScanPanel.this.magnetProperties.toleranceField.setEnabled(false);
                    BaseScanPanel.this.magnetProperties.initialHoldTimeField.setEnabled(false);
                } else {
                    BaseScanPanel.this.magnetProperties.toleranceField.setEnabled(true);
                    BaseScanPanel.this.magnetProperties.initialHoldTimeField.setEnabled(true);
                }
            }
        }
    }

    protected class SetText
    implements Runnable {
        JLabel component;
        String text;

        public SetText(JLabel component, String text) {
            this.component = component;
            this.text = text;
        }

        @Override
        public void run() {
            this.component.setText(this.text);
        }
    }

    public class TemperatureScanPropertiesPanel
    extends JPanel {
        public JTextField setPointField;
        public JTextField toleranceField;
        public JTextField toleranceBandTimeField;
        public JTextField maxWaitTimeField;
        public JTextField initialHoldTimeField;
        public JButton resetValuesButton;
        public JLabel setPointLabel;
        public JLabel toleranceLabel;

        public TemperatureScanPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel toleranceBandTimeLabel = new JLabel(I18N.getString("sampleEnvironment.toleranceBandTime"));
            JLabel maxWaitTimeLabel = new JLabel(I18N.getString("sampleEnvironment.maxWaitTime"));
            JLabel initialHoldTimeLabel = new JLabel(I18N.getString("sampleEnvironment.initialHoldTime"));
            Bag parameterConstraints = new Bag();
            this.setPointField = new JTextField(5);
            this.toleranceField = new JTextField(5);
            this.toleranceBandTimeField = new JTextField(5);
            this.maxWaitTimeField = new JTextField(5);
            this.initialHoldTimeField = new JTextField(5);
            this.resetValuesButton = new JButton(I18N.getString("sampleEnvironment.resetValues"));
            this.setPointLabel = new JLabel(I18N.getString("sampleEnvironment.setPoint"));
            this.toleranceLabel = new JLabel(I18N.getString("sampleEnvironment.tolerance"));
            this.setPointField.getDocument().addDocumentListener(new SetPointDocumentListener());
            this.setPointField.getDocument().putProperty("name", "temperature");
            int x = 0;
            int y = 0;
            this.add((Component)this.setPointLabel, parameterConstraints.cell(x, y));
            this.add((Component)this.setPointField, parameterConstraints.cell(++x, y));
            this.add((Component)this.toleranceLabel, parameterConstraints.cell(++x, y));
            this.add((Component)this.toleranceField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)toleranceBandTimeLabel, parameterConstraints.cell(x, ++y));
            this.add((Component)this.toleranceBandTimeField, parameterConstraints.cell(++x, y));
            this.add((Component)maxWaitTimeLabel, parameterConstraints.cell(++x, y));
            this.add((Component)this.maxWaitTimeField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)initialHoldTimeLabel, parameterConstraints.cell(x, ++y));
            this.add((Component)this.initialHoldTimeField, parameterConstraints.cell(++x, y));
            x = 0;
            this.add((Component)this.resetValuesButton, parameterConstraints.cell(x, ++y));
        }
    }

    protected class TestAction
    extends AbstractAction {
        public TestAction() {
            this.putValue("Name", "Test");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseScanPanel.this.removeAll();
            BaseScanPanel.this.buildGUI();
            BaseScanPanel.this.invalidate();
        }
    }

    public class UpdateDeviceComboBox
    implements Runnable {
        protected JComboBox devbox;
        protected JLabel unitsLabel;
        protected boolean filter;
        protected DeviceListEvent deviceEvent;

        public UpdateDeviceComboBox(JComboBox devbox, JLabel unitsLabel, boolean filter) {
            this.devbox = devbox;
            this.unitsLabel = unitsLabel;
            this.filter = filter;
        }

        @Override
        public void run() {
            InstalledDevice selected = (InstalledDevice)this.devbox.getSelectedItem();
            this.devbox.removeAllItems();
            BaseScanPanel.this.fillDeviceComboBox(this.devbox, this.filter);
            int j = 0;
            while (j < this.devbox.getItemCount()) {
                if (selected.getName().compareToIgnoreCase(this.devbox.getItemAt(j).toString()) == 0) {
                    this.devbox.setSelectedIndex(j);
                    this.unitsLabel.setText(selected.getUnits());
                }
                ++j;
            }
        }
    }

    protected class UpdateLabels
    implements Runnable {
        JLabel label1;
        JLabel label2;
        String text1;
        String text2;

        public UpdateLabels(JLabel label1, JLabel label2, String text1, String text2) {
            this.label1 = label1;
            this.label2 = label2;
            this.text1 = text1;
            this.text2 = text2;
        }

        @Override
        public void run() {
            this.label1.setText(this.text1);
            this.label2.setText(this.text2);
        }
    }

    protected class ValidFloatChecker
    implements DocumentListener {
        private JTextField textField;
        private String compName;

        public ValidFloatChecker(JTextField textField, String compName) {
            this.textField = textField;
            this.compName = compName;
            textField.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent de) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkNumberValidity();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkNumberValidity();
        }

        protected boolean checkNumberValidity() {
            if (this.textField.getText().length() == 0) {
                BaseScanPanel.this.removeErrorMessage(this.textField);
                return true;
            }
            try {
                Double.parseDouble(this.textField.getText());
                BaseScanPanel.this.removeErrorMessage(this.textField);
                return true;
            }
            catch (NumberFormatException nfe) {
                if (!BaseScanPanel.this.errorMessages.containsKey(this.textField)) {
                    BaseScanPanel.this.appendErrorMessage(this.textField, "Invalid number for " + this.compName + " field!");
                }
                return false;
            }
        }
    }
}

