/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.sampleAlignment.ubMatrix;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.PeakSet;
import ice.data.tas.bt7.UBMatrix;
import ice.event.LoadPeakScanEvent;
import ice.event.LoadPeakScanListener;
import ice.event.UBIncludedPrimaryListener;
import ice.event.UBMatrixPropertyChangedEvent;
import ice.event.UBMatrixPropertyChangedListener;
import ice.event.communication.AngleCalcEvent;
import ice.event.communication.AngleCalcListener;
import ice.event.communication.UBMatrixAskCommandListener;
import ice.event.communication.UBMatrixChangeEvent;
import ice.event.communication.UBMatrixChangeListener;
import ice.event.communication.util.UBMatrixAskCommandEnums;
import ice.event.communication.util.UBMatrixAskCommandListenerUtil;
import ice.event.communication.util.UBMatrixParsedAskResponse;
import ice.event.tas.bt7.PeakSetChangeRequestListener;
import ice.event.tas.bt7.PeakSetListModifiedEvent;
import ice.event.tas.bt7.PeakSetListModifiedListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceDialog;
import ice.gui.tas.BaseSampleAlignmentPanel;
import ice.gui.tas.bt7.sampleAlignment.PeakScanLinkPanel;
import ice.gui.tas.bt7.sampleAlignment.ubMatrix.NewPeakSetButton;
import ice.gui.tas.bt7.sampleAlignment.ubMatrix.OrientationPanel;
import ice.gui.tas.bt7.sampleAlignment.ubMatrix.ReferencePlaneSelectionListener;
import ice.gui.tas.bt7.sampleAlignment.ubMatrix.UBReflectionSetPanel;
import ice.swing.Bag;
import ice.swing.IceTextField;
import ice.swing.tas.bt7.PeakSetRow;
import ice.util.CommandBuilder;
import ice.util.I18N;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PropertiesManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class UBSampleAlignmentPanel
extends BaseSampleAlignmentPanel
implements PeakSetChangeRequestListener,
PeakSetListModifiedListener,
UBIncludedPrimaryListener,
UBMatrixPropertyChangedListener,
AngleCalcListener,
ChangeListener,
UBMatrixAskCommandListener,
UBMatrixChangeListener,
DocumentListener {
    protected static final String DELETE_DIALOG_TITLE_KEY = "ice.gui.tas.bt7.sampleAlignment.ubMatrix.deleteDialog.title";
    protected static final String DELETE_DIALOG_MESSAGE_KEY = "ice.gui.tas.bt7.sampleAlignment.ubMatrix.deleteDialog.message";
    protected static Logger logger = Logger.getLogger("PanelLogger.tas.bt7.UBSampleAlignmentPanel");
    protected UBMatrix ubMatrix;
    protected JRadioButton minTiltRB;
    protected JRadioButton regularTiltRB;
    protected JPanel peakSetContainer;
    protected ArrayList<PeakSetRow> peakSetRowList;
    protected Action calculateUBMatrixAction;
    protected InstalledDevice initialEnergy;
    protected InstalledDevice finalEnergy;
    protected InstalledDevice A3;
    protected InstalledDevice A4;
    protected IceTextField hField;
    protected IceTextField kField;
    protected IceTextField lField;
    protected JLabel calculatedA3ValueLabel;
    protected JLabel calculatedA4ValueLabel;
    protected JLabel primaryLabel;
    protected JLabel secondaryLabel;
    protected JLabel ubModeLink;
    protected ICEListenerList<LoadPeakScanListener, LoadPeakScanEvent> loadPeakScanListenerList;
    protected ICEListenerList<UBMatrixChangeListener, UBMatrixChangeEvent> ubMatrixChangeListeners;
    protected ICEListenerList<UBMatrixAskCommandListener, UBMatrixParsedAskResponse> ubMatrixAskCommandListeners;
    protected ArrayList<ChangeListener> changeListeners;
    Controller controller;

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        this.ubMatrixChangeListeners = new ICEListenerList();
        this.ubMatrixAskCommandListeners = new ICEListenerList();
        this.changeListeners = new ArrayList();
        this.ubMatrix = this.controller.getUbMatrix();
        this.initialEnergy = this.controller.getFirstDevice("Ei");
        this.finalEnergy = this.controller.getFirstDevice("Ef");
        this.A3 = this.controller.getFirstDevice("A3");
        this.A4 = this.controller.getFirstDevice("A4");
        this.sendManager = this.controller.getSendManager();
        this.sample = this.controller.getSample();
        this.minTiltRB = new JRadioButton(I18N.getString("tas.core.minTiltRefPlane.radioButton"));
        this.regularTiltRB = new JRadioButton(I18N.getString("tas.core.regTiltRefPlane.radioButton"));
        this.peakSetContainer = new JPanel();
        this.peakSetRowList = new ArrayList();
        this.calculateUBMatrixAction = new CalculateUBMatrixAction();
        ButtonGroup refPlaneGroup = new ButtonGroup();
        ReferencePlaneSelectionListener refPlaneListener = new ReferencePlaneSelectionListener(this.sendManager);
        this.loadPeakScanListenerList = new ICEListenerList();
        this.ubModeLink = new JLabel(I18N.getString("ubSampleAlignment.disableUBMode.label"));
        this.hField = new IceTextField();
        this.kField = new IceTextField();
        this.lField = new IceTextField();
        this.calculatedA4ValueLabel = new JLabel(I18N.getString("notAvailableMessage.short"));
        this.calculatedA3ValueLabel = new JLabel(I18N.getString("notAvailableMessage.short"));
        this.minTiltRB.setActionCommand("b");
        this.regularTiltRB.setActionCommand("a");
        this.minTiltRB.addActionListener(refPlaneListener);
        this.regularTiltRB.addActionListener(refPlaneListener);
        refPlaneGroup.add(this.minTiltRB);
        refPlaneGroup.add(this.regularTiltRB);
        try {
            this.ubMatrix.addPeakSetListModifiedListener(this);
            this.ubMatrix.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("UBSampleAlignmentPanel.init can not add listener  " + e);
        }
        this.ubModeLink.setForeground(Color.BLUE);
        this.ubModeLink.setCursor(new Cursor(12));
        BoxLayout boxLayout = new BoxLayout(this.peakSetContainer, 1);
        this.peakSetContainer.setLayout(boxLayout);
        this.initState();
    }

    @Override
    protected void buildGUI() {
        OrientationPanel orientationPanel = null;
        JPanel peakSetPanel = this.createPeakSetPanel();
        GridBagConstraints gridBagConstraints = null;
        GridBagLayout gridBagLayout = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        orientationPanel = new OrientationPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)orientationPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)peakSetPanel, gridBagConstraints);
    }

    protected void addUBMatrixChangeListener(UBMatrixChangeListener ubMatrixChangeListener) throws ICEListenerListExceptionBase {
        this.ubMatrixChangeListeners.addListener(ubMatrixChangeListener);
    }

    protected void removeUBMatrixChangeListener(UBMatrixChangeListener ubMatrixChangeListener) {
        this.ubMatrixChangeListeners.removeListener(ubMatrixChangeListener);
    }

    protected void addUBMatrixAskCommandListener(UBMatrixAskCommandListener ubMatrixAskCommandListener) throws ICEListenerListExceptionBase {
        this.ubMatrixAskCommandListeners.addListener(ubMatrixAskCommandListener);
    }

    protected void removeUBMatrixAskCommandListener(UBMatrixAskCommandListener ubMatrixAskCommandListener) {
        this.ubMatrixAskCommandListeners.removeListener(ubMatrixAskCommandListener);
    }

    protected void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    protected void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void initState() {
        this.determineRefPlaneState();
        this.determineUBCalculationPossibility();
    }

    protected JPanel createPeakSetPanel() {
        JPanel driveHKLPanel = this.createDriveHKLPanel();
        JPanel calculatedPanel = this.createCalculatedA3A4Panel();
        JPanel calcUBPanel = null;
        JPanel panel = new JPanel();
        Bag bag = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 2;
        JLabel instructionsLabel = new JLabel(I18N.getString("ubSampleAlignment.peakSetPanel.instructions"));
        PeakScanLinkPanel linkPanel = new PeakScanLinkPanel();
        this.addMouseListener(linkPanel);
        this.populatePeakSetContainer();
        this.peakSetContainer.setMinimumSize(new Dimension(500, 500));
        JScrollPane peakSetContainerScrollPane = new JScrollPane(this.peakSetContainer);
        JPanel peakSetPanel = new JPanel();
        GridBagLayout peakSetPanelGridBagLayout = new GridBagLayout();
        GridBagConstraints peakSetPanelGridBagConstraints = new GridBagConstraints();
        peakSetPanel.setLayout(peakSetPanelGridBagLayout);
        peakSetPanel.setBorder(BorderFactory.createTitledBorder("Reflections for UB Calculation:"));
        peakSetPanel.setMinimumSize(new Dimension(500, 300));
        peakSetPanel.setMaximumSize(new Dimension(500, 300));
        peakSetPanel.setPreferredSize(new Dimension(500, 300));
        Insets insets = null;
        insets = new Insets(0, 0, 10, 0);
        NewPeakSetButton newPeakSetButton = new NewPeakSetButton(this.sendManager);
        peakSetPanelGridBagConstraints.gridx = 0;
        peakSetPanelGridBagConstraints.gridy = 0;
        peakSetPanelGridBagConstraints.fill = 0;
        peakSetPanelGridBagConstraints.anchor = 12;
        peakSetPanelGridBagConstraints.weightx = 1.0;
        peakSetPanelGridBagConstraints.weighty = 1.0;
        peakSetPanelGridBagConstraints.insets = insets;
        peakSetPanel.add((Component)newPeakSetButton, peakSetPanelGridBagConstraints);
        peakSetContainerScrollPane.setVerticalScrollBarPolicy(22);
        peakSetPanelGridBagConstraints.gridy = 1;
        peakSetPanelGridBagConstraints.anchor = 18;
        peakSetPanelGridBagConstraints.weighty = 100.0;
        peakSetPanelGridBagConstraints.fill = 1;
        peakSetPanel.add((Component)peakSetContainerScrollPane, peakSetPanelGridBagConstraints);
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(I18N.getString("ubSampleAlignment.peakSetPanel.title")));
        panel.add((Component)instructionsLabel, bag.cell(x, y).fillx().colspan(maxCols));
        panel.add((Component)driveHKLPanel, bag.cell(x, ++y).fillx().colspan(maxCols));
        panel.add((Component)calculatedPanel, bag.cell(x, ++y).fillx().colspan(maxCols));
        panel.add((Component)linkPanel, bag.cell(x, ++y).northwest());
        panel.add(Box.createVerticalStrut(1), bag.cell(x, ++y));
        calcUBPanel = this.createCalculateUBPanel();
        panel.add((Component)calcUBPanel, bag.cell(x, ++y).fillx());
        panel.add((Component)peakSetPanel, bag.cell(x, ++y).fillx());
        return panel;
    }

    protected JPanel createDriveHKLPanel() {
        JPanel panel = new JPanel();
        JLabel hLabel = new JLabel(I18N.getString("h.inputLabel"));
        JLabel kLabel = new JLabel(I18N.getString("k.inputLabel"));
        JLabel lLabel = new JLabel(I18N.getString("l.inputLabel"));
        this.hField = new IceTextField(3);
        this.kField = new IceTextField(3);
        this.lField = new IceTextField(3);
        JButton driveA4Btn = new JButton(new DriveA4Action());
        JButton driveQBtn = new JButton(new DriveQAction());
        JLabel spacer = new JLabel();
        Bag bag = new Bag();
        int x = 0;
        int y = 0;
        int maxCols = 9;
        this.hField.setColumns(5);
        this.kField.setColumns(5);
        this.lField.setColumns(5);
        this.hField.getDocument().addDocumentListener(this);
        this.kField.getDocument().addDocumentListener(this);
        this.lField.getDocument().addDocumentListener(this);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)hLabel, bag.cell(x, y));
        panel.add((Component)this.hField, bag.cell(++x, y));
        panel.add((Component)kLabel, bag.cell(++x, y));
        panel.add((Component)this.kField, bag.cell(++x, y));
        panel.add((Component)lLabel, bag.cell(++x, y));
        panel.add((Component)this.lField, bag.cell(++x, y));
        panel.add((Component)spacer, bag.cell(++x, y).fillx());
        panel.add((Component)driveA4Btn, bag.cell(++x, y));
        panel.add((Component)driveQBtn, bag.cell(++x, y));
        return panel;
    }

    protected JPanel createCalculatedA3A4Panel() {
        JPanel panel = new JPanel();
        JPanel calculatedPanel = new JPanel();
        JLabel calculatedA4Label = new JLabel("\u04e8 (A4):");
        JLabel calculatedA3Label = new JLabel("\u04e8 (A3):");
        JLabel spacer = new JLabel();
        calculatedPanel.setSize(new Dimension(500, 200));
        calculatedPanel.setBorder(new TitledBorder(I18N.getString("tas.core.sampleAlignmentPanel.calculatedA4A3.title")));
        calculatedPanel.setLayout(new BoxLayout(calculatedPanel, 0));
        calculatedPanel.add(Box.createHorizontalStrut(20));
        calculatedPanel.add(calculatedA4Label);
        calculatedPanel.add(Box.createHorizontalStrut(2));
        calculatedPanel.add(this.calculatedA4ValueLabel);
        calculatedPanel.add(Box.createHorizontalStrut(90));
        calculatedPanel.add(calculatedA3Label);
        calculatedPanel.add(Box.createHorizontalStrut(2));
        calculatedPanel.add(this.calculatedA3ValueLabel);
        calculatedPanel.add(Box.createHorizontalStrut(20));
        Bag bag = new Bag();
        int x = 0;
        int y = 0;
        panel.setLayout(new GridBagLayout());
        panel.add((Component)spacer, bag.cell(x, y).fillx());
        panel.add((Component)calculatedPanel, bag.cell(++x, y));
        return panel;
    }

    protected JPanel createHeaderSubPanel() {
        JPanel panel = new JPanel();
        Bag bag = new Bag();
        int x = 0;
        int y = 0;
        this.primaryLabel = new JLabel(I18N.getString("ubSampleAlignment.peakSetPanel.primaryHeader.label"));
        this.secondaryLabel = new JLabel(I18N.getString("ubSampleAlignment.peakSetPanel.secondaryHeader.label"));
        JLabel hklLabel = new JLabel(I18N.getString("ubSampleAlignment.peakSetPanel.hklHeader.label"));
        JLabel spacer = new JLabel();
        panel.setBackground(Color.WHITE);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.primaryLabel, bag.cell(x, y));
        panel.add((Component)this.secondaryLabel, bag.cell(++x, y));
        panel.add((Component)hklLabel, bag.cell(++x, y));
        panel.add((Component)spacer, bag.cell(++x, y).fillx());
        ++x;
        return panel;
    }

    protected void populatePeakSetContainer() {
        ArrayList<PeakSet> peakSetList = this.ubMatrix.getPeakSetList();
        for (PeakSet peakSet : peakSetList) {
            PeakSetRow row = new PeakSetRow(peakSet, this.ubMatrix, this.sendManager);
            row.addPeakSetChangeRequestListener(this);
            row.addUBIncludedPrimaryListener(this);
            this.peakSetContainer.add((Component)row, Float.valueOf(0.0f));
            try {
                this.addUBMatrixAskCommandListener(row);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("Could not add listener " + e);
            }
        }
    }

    protected JPanel createCalculateUBPanel() {
        JPanel panel = null;
        UBReflectionSetPanel ubReflectionSetPanel = null;
        JButton calcBtn = null;
        GridBagLayout gridBagLayout = null;
        GridBagConstraints gridBagConstraints = null;
        panel = new JPanel();
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        ubReflectionSetPanel = new UBReflectionSetPanel(this.sendManager);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        panel.add((Component)ubReflectionSetPanel, gridBagConstraints);
        calcBtn = new JButton(this.calculateUBMatrixAction);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 14;
        panel.add((Component)calcBtn, gridBagConstraints);
        try {
            this.addUBMatrixChangeListener(ubReflectionSetPanel);
            this.addUBMatrixAskCommandListener(ubReflectionSetPanel);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("UBSampleAlignmentPanel.init could not add listener " + e);
        }
        return panel;
    }

    @Override
    public void changePeakSetHKL(PeakSet ps) {
    }

    @Override
    public void deletePeakSet(PeakSet ps) {
        int response = -1;
        String deleteTitle = null;
        String deleteMessage = null;
        deleteTitle = I18N.getString(DELETE_DIALOG_TITLE_KEY);
        deleteMessage = I18N.getString(DELETE_DIALOG_MESSAGE_KEY);
        response = JOptionPane.showConfirmDialog(this, deleteMessage, deleteTitle, 2);
        if (response == 0) {
            String command = null;
            String[] args = null;
            args = new String[]{Integer.toString(ps.getId())};
            command = CommandBuilder.build(PropertiesManager.Properties.UB_DELETE_PEAKSET_CMD, args);
            this.sendManager.addMessage(command);
        }
    }

    @Override
    public void actionPerformed(PeakSetListModifiedEvent plme) {
        PeakSetListModifiedEvent.EventType eventType = plme.getEventType();
        PeakSet peakSet = plme.getPeakSet();
        if (eventType == PeakSetListModifiedEvent.EventType.PEAK_SET_ADDED) {
            this.addPeakSetRow(peakSet);
        } else if (eventType == PeakSetListModifiedEvent.EventType.PEAK_SET_REMOVED) {
            this.removePeakSetRow(peakSet);
        }
    }

    protected void addPeakSetRow(PeakSet peakSet) {
        PeakSetRow row = null;
        row = new PeakSetRow(peakSet, this.ubMatrix, this.sendManager);
        row.addPeakSetChangeRequestListener(this);
        row.addUBIncludedPrimaryListener(this);
        this.peakSetContainer.add(row);
        try {
            this.addUBMatrixAskCommandListener(row);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("UBSampleAlignmentPanel.addPeakSetRow " + e);
        }
        this.peakSetContainer.revalidate();
        this.peakSetContainer.repaint();
    }

    protected void removePeakSetRow(PeakSet peakSet) {
        Component[] components = this.peakSetContainer.getComponents();
        int numComponents = components.length;
        int i = 0;
        while (i < numComponents) {
            PeakSetRow row = (PeakSetRow)components[i];
            if (row.getPeakSet() == peakSet) {
                row.beingRemoved();
                row.removePeakSetChangeRequestListener(this);
                row.removeUBIncludedPrimaryListener(this);
                this.removeUBMatrixAskCommandListener(row);
                this.peakSetContainer.remove(row);
                this.peakSetContainer.revalidate();
                this.peakSetContainer.repaint();
            }
            ++i;
        }
    }

    public void addLoadPeakScanListener(LoadPeakScanListener lpsl) throws ICEListenerListExceptionBase {
        this.loadPeakScanListenerList.addListener(lpsl);
    }

    public void removeLoadPeakScanListener(LoadPeakScanListener lpsl) {
        this.loadPeakScanListenerList.removeListener(lpsl);
    }

    @Override
    public void noPrimarySelected() {
        this.calculateUBMatrixAction.setEnabled(false);
    }

    @Override
    public void numIncludedChanged() {
        this.determineUBCalculationPossibility();
    }

    @Override
    public void primarySelected() {
        this.determineUBCalculationPossibility();
    }

    protected void determineUBCalculationPossibility() {
        boolean enabled = PeakSetRow.isPrimarySelected() && PeakSetRow.getNumIncluded() >= 2;
        this.calculateUBMatrixAction.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(UBMatrixPropertyChangedEvent pce) {
        Object source = pce.getSource();
        String propertyName = pce.getPropertyName();
        if (UBMatrix.referencePlaneFieldName.equals(propertyName)) {
            this.determineRefPlaneState();
        }
    }

    protected void determineRefPlaneState() {
        UBMatrix.ReferencePlane refPlane = this.ubMatrix.getReferencePlane();
        if (refPlane == UBMatrix.ReferencePlane.A) {
            this.regularTiltRB.setSelected(true);
        } else if (refPlane == UBMatrix.ReferencePlane.B) {
            this.minTiltRB.setSelected(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        logger.debug("insert: " + de.getDocument());
        this.recalculateAngles();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        logger.debug("remove: " + de.getDocument());
        this.recalculateAngles();
    }

    protected void recalculateAngles() {
        logger.debug("recalc");
        if (this.initialEnergy == null || this.finalEnergy == null) {
            logger.error("Necessary energy value not present (Ei or Ef).  Forced to cancel calculation.");
            return;
        }
        logger.debug("Ei: " + this.initialEnergy.getCurrValue());
        logger.debug("Ef: set to Ei -> is really " + this.finalEnergy.getCurrValue());
        try {
            double targetH = Double.valueOf(this.hField.getText());
            double targetK = Double.valueOf(this.kField.getText());
            double targetL = Double.valueOf(this.lField.getText());
            double energyTransfer = 0.0;
            this.sendManager.addMessage("ask calcA3A4fromHKL instrument action angles " + energyTransfer + " i " + this.initialEnergy.getCurrValue() + " " + targetH + " " + targetK + " " + targetL, false);
        }
        catch (NumberFormatException nfe) {
            logger.error("Invalid input for target HKL or energy value.  Cancelling.");
            this.calculatedA3ValueLabel.setText("N/A");
            this.calculatedA4ValueLabel.setText("N/A");
        }
    }

    @Override
    public void actionPerformed(AngleCalcEvent ace) {
        logger.debug("Updating angles");
        double calculatedA3 = ace.getAngleValueFor(2);
        double calculatedA4 = ace.getAngleValueFor(3);
        boolean A3Error = false;
        boolean A4Error = false;
        if (calculatedA3 < this.A3.getLowerLimit() || calculatedA3 > this.A3.getUpperLimit()) {
            A3Error = true;
        }
        if (calculatedA4 < this.A4.getLowerLimit() || calculatedA4 > this.A4.getUpperLimit()) {
            A4Error = true;
        }
        SwingUtilities.invokeLater(new UpdateAngleCalcFields(calculatedA3, calculatedA4));
        if (A3Error || A4Error) {
            String messagePrefix = "Calcualated value for ";
            String messageSuffix = " outside of its limit range!";
            String devices = "";
            if (A3Error) {
                devices = "A3";
                if (A4Error) {
                    devices = String.valueOf(devices) + " and A4";
                    messageSuffix = " outside of their limit ranges!";
                }
            } else {
                devices = "A4";
            }
            final String message = String.valueOf(messagePrefix) + devices + messageSuffix;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UBSampleAlignmentPanel.this.appendErrorMessage(UBSampleAlignmentPanel.this.calculatedA3ValueLabel, message);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UBSampleAlignmentPanel.this.removeErrorMessage(UBSampleAlignmentPanel.this.calculatedA3ValueLabel);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stateChanged(ChangeEvent ce) {
        Object cl = null;
        ArrayList<ChangeListener> arrayList = this.changeListeners;
        synchronized (arrayList) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(ce);
            }
        }
    }

    protected void DisplayUBMatrixAskError(UBMatrixParsedAskResponse theParsedResponse) {
        Boolean errorFound = false;
        String askCommandResponse = null;
        errorFound = theParsedResponse.isErrorCondition();
        if (errorFound.booleanValue()) {
            IceDialog iceDialog = null;
            iceDialog = new IceDialog((Frame)this.getTopLevelAncestor());
            askCommandResponse = theParsedResponse.getTheResponse();
            iceDialog.throwErrorDialog("UB Matrix Error", askCommandResponse);
        }
    }

    @Override
    public void actionPerformed(UBMatrixParsedAskResponse ubMatrixParsedAskResponse) {
        Boolean errorFound = false;
        errorFound = ubMatrixParsedAskResponse.isErrorCondition();
        if (errorFound.booleanValue()) {
            this.DisplayUBMatrixAskError(ubMatrixParsedAskResponse);
        }
        this.ubMatrixAskCommandListeners.notifyListeners(ubMatrixParsedAskResponse);
    }

    @Override
    public void actionPerformed(UBMatrixChangeEvent ubmce) {
        this.ubMatrixChangeListeners.notifyListeners(ubmce);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    private class CalculateUBMatrixAction
    extends AbstractAction {
        public CalculateUBMatrixAction() {
            super(I18N.getString("ubSampleAlignment.calculateUBMatrix.button"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String calcTag = null;
            calcTag = UBMatrixAskCommandListenerUtil.buildAskResponseTag(UBMatrixAskCommandEnums.CALCULATE);
            UBSampleAlignmentPanel.this.sendManager.addMessage("ask " + calcTag + " ub calculate", true);
        }
    }

    protected class DriveA4Action
    extends AbstractAction {
        public DriveA4Action() {
            this.putValue("Name", "Drive A4");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double A4 = Double.parseDouble(UBSampleAlignmentPanel.this.calculatedA4ValueLabel.getText());
                UBSampleAlignmentPanel.this.sendManager.addMessage("move A4 " + A4, true);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number for A4.  Ignoring operation.", nfe);
            }
        }
    }

    protected class DriveQAction
    extends AbstractAction {
        public DriveQAction() {
            this.putValue("Name", "Drive Q (A3/A4)");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                double A3 = Double.parseDouble(UBSampleAlignmentPanel.this.calculatedA3ValueLabel.getText());
                double A4 = Double.parseDouble(UBSampleAlignmentPanel.this.calculatedA4ValueLabel.getText());
                UBSampleAlignmentPanel.this.sendManager.addMessage("move A3 " + A3 + " A4 " + A4, true);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number for A3/A4.  Ignoring operation.", nfe);
            }
        }
    }

    protected class UpdateAngleCalcFields
    implements Runnable {
        private double newA3;
        private double newA4;

        public UpdateAngleCalcFields(double newA3, double newA4) {
            this.newA3 = newA3;
            this.newA4 = newA4;
        }

        @Override
        public void run() {
            UBSampleAlignmentPanel.this.calculatedA3ValueLabel.setText(String.valueOf(this.newA3));
            UBSampleAlignmentPanel.this.calculatedA4ValueLabel.setText(String.valueOf(this.newA4));
        }
    }
}

