/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.sampleAlignment.nonUbMatrix;

import ice.Controller;
import ice.event.LoadPeakScanListener;
import ice.event.communication.AngleCalcEvent;
import ice.event.communication.AngleCalcListener;
import ice.exceptions.IcePanelException;
import ice.exceptions.IcePanelUncheckedException;
import ice.gui.core.IceViewPanel;
import ice.gui.tas.SampleAlignmentNonWizardPanel;
import ice.gui.tas.SampleAlignmentWizardPanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class SampleAlignmentPanel
extends IceViewPanel
implements ChangeListener,
AngleCalcListener {
    private SampleAlignmentWizardPanel wizardPanel;
    private SampleAlignmentNonWizardPanel nonWizardPanel;
    private static final String wizardName = "wizard";
    private static final String nonWizardName = "nonWizard";
    protected static Logger logger = Logger.getLogger("PanelLogger.tas.bt7.UBSampleAlignmentPanel");
    private Controller controller;

    public SampleAlignmentPanel() throws IcePanelException {
        super("Sample Alignment");
    }

    @Override
    protected void init() {
        try {
            this.wizardPanel = new SampleAlignmentWizardPanel();
            this.wizardPanel.processIcePanel();
            this.nonWizardPanel = new SampleAlignmentNonWizardPanel();
            this.nonWizardPanel.processIcePanel();
        }
        catch (IcePanelException e) {
            throw new IcePanelUncheckedException(e);
        }
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new CardLayout());
        this.add((Component)this.nonWizardPanel, nonWizardName);
        this.initState();
    }

    private void initState() {
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, nonWizardName);
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.wizardPanel.stateChanged(ce);
        this.nonWizardPanel.stateChanged(ce);
    }

    @Override
    public void actionPerformed(AngleCalcEvent ace) {
        this.wizardPanel.actionPerformed(ace);
        this.nonWizardPanel.actionPerformed(ace);
    }

    public void addPeakScanListener(LoadPeakScanListener psl) {
        try {
            this.wizardPanel.addPeakScanListener(psl);
            this.nonWizardPanel.addPeakScanListener(psl);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("SampleAlignmentPanel.addPeakScanListener " + e);
        }
    }

    public class ModeSwitcher
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent me) {
            ((CardLayout)SampleAlignmentPanel.this.getLayout()).next(SampleAlignmentPanel.this);
        }
    }
}

