/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.config;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.AvailableMagnetDevice;
import ice.data.AvailableMiscDevice;
import ice.data.AvailablePressureDevice;
import ice.data.AvailableTempDevice;
import ice.data.Device;
import ice.data.InstalledDevice;
import ice.data.InstalledMagnetDevice;
import ice.data.InstalledMiscDevice;
import ice.data.InstalledPressureDevice;
import ice.data.InstalledTempDevice;
import ice.event.AvailableDeviceEvent;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.AvailableDeviceListListener;
import ice.gui.core.config.BaseConfigPanel;
import ice.gui.tas.bt7.config.ExpConfigWindow;
import ice.util.I18N;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SampleEnvironmentPanel
extends BaseConfigPanel
implements DeviceListListener,
AvailableDeviceListListener {
    protected static Logger logger = Logger.getLogger("WidgetLogger.SampleEnvironmentConfigLogger");
    protected static final String EMPTY = "";
    protected static final String TEMPERATURE = "Temp";
    protected static final String MAGNET = "MagField";
    protected static final String PRESSURE = "Pressure";
    protected static final String OTHER = "Other";
    protected JList listBox;
    protected JPanel propertiesPanel;
    protected JComboBox controllerTypeBox;
    protected JComboBox controllerBox;
    protected JTextField aliasField;
    protected JButton addButton;
    protected JButton updateButton;
    protected JButton removeButton;
    protected Vector<String> listBoxItems;
    protected Vector<String> controllerTypeBoxItems;
    protected Vector<Device> controllerBoxItems;
    protected Vector<AvailableTempDevice> availableTempDevices;
    protected Vector<AvailableMagnetDevice> availableMagnetDevices;
    protected Vector<AvailablePressureDevice> availablePressureDevices;
    protected Vector<AvailableMiscDevice> availableOtherDevices;
    protected Vector<InstalledTempDevice> installedTempDevices;
    protected Vector<InstalledMagnetDevice> installedMagnetDevices;
    protected Vector<InstalledPressureDevice> installedPressureDevices;
    protected Vector<InstalledMiscDevice> installedOtherDevices;
    protected SendQueueManager sendManager;
    protected TemperaturePropertiesPanel tempProperties;
    protected MagnetPropertiesPanel magnetProperties;
    protected PressurePropertiesPanel pressureProperties;
    protected OtherPropertiesPanel otherProperties;
    protected InstalledDevice sampleLowerTilt;
    protected InstalledDevice sampleUpperTilt;
    protected boolean listBoxFlag;
    protected String aliasBug;
    private Controller controller = Controller.getReference();

    public SampleEnvironmentPanel(ExpConfigWindow realParent) {
        super(realParent);
        this.sendManager = this.controller.getSendManager();
        this.sampleLowerTilt = this.controller.getFirstDevice("SmplLTilt");
        this.sampleUpperTilt = this.controller.getFirstDevice("SmplUTilt");
        this.installedMagnetDevices = new Vector();
        this.installedOtherDevices = new Vector();
        this.installedPressureDevices = new Vector();
        this.installedTempDevices = new Vector();
        this.listBoxItems = new Vector();
        this.availableTempDevices = new Vector();
        this.availableMagnetDevices = new Vector();
        this.availablePressureDevices = new Vector();
        this.availableOtherDevices = new Vector();
        this.controllerTypeBoxItems = new Vector();
        this.controllerBoxItems = new Vector();
        this.listBox = new JList<String>(this.listBoxItems);
        this.controllerTypeBox = new JComboBox<String>(this.controllerTypeBoxItems);
        this.controllerBox = new JComboBox<Device>(this.controllerBoxItems);
        this.aliasField = new JTextField(20);
        this.tempProperties = new TemperaturePropertiesPanel();
        this.magnetProperties = new MagnetPropertiesPanel();
        this.pressureProperties = new PressurePropertiesPanel();
        this.otherProperties = new OtherPropertiesPanel();
        this.propertiesPanel = new JPanel(new CardLayout());
        this.addButton = new JButton(I18N.getString("sampleEnvironment.addDevice"));
        this.updateButton = new JButton(I18N.getString("sampleEnvironment.updateDevice"));
        this.removeButton = new JButton(I18N.getString("sampleEnvironment.removeDevice"));
        this.setName(I18N.getString("sampleEnvironment.sampleEnvironment"));
        this.listBoxFlag = false;
        this.aliasBug = EMPTY;
        ArrayList<InstalledDevice> devicesOnSystem = this.controller.getDeviceList();
        this.setInstalledDevices(devicesOnSystem);
        this.controller.getDeviceListeners().add(this);
        this.controllerTypeBoxItems.add(EMPTY);
        this.controllerTypeBoxItems.add(TEMPERATURE);
        this.controllerTypeBoxItems.add(MAGNET);
        this.controllerTypeBoxItems.add(PRESSURE);
        this.controllerTypeBoxItems.add(OTHER);
        this.controllerBoxItems.add(new AvailableMiscDevice(EMPTY, EMPTY));
        this.listBox.setSelectionMode(0);
        this.listBox.setFixedCellHeight(10);
        this.controllerBox.setEnabled(false);
        this.aliasField.setEnabled(false);
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder("Properties"));
        this.propertiesPanel.add((Component)this.otherProperties, OTHER);
        this.propertiesPanel.add((Component)this.tempProperties, TEMPERATURE);
        this.propertiesPanel.add((Component)this.magnetProperties, MAGNET);
        this.propertiesPanel.add((Component)this.pressureProperties, PRESSURE);
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.controllerBox.addItemListener(new ControllerItemListener());
        this.controllerTypeBox.addItemListener(new ControllerTypeItemListener());
        this.listBox.addListSelectionListener(new ListBoxSelectionListener());
        this.addButton.addActionListener(new AddDeviceActionListener());
        this.updateButton.addActionListener(new UpdateDeviceActionListener());
        this.removeButton.addActionListener(new RemoveDeviceActionListener());
        this.buildGUI();
        this.reload();
    }

    public void buildGUI() {
        this.setLayout(new GridBagLayout());
        JLabel introLabel = new JLabel(I18N.getString("sampleEnvironment.Introduction"));
        JLabel devicesSystemLabel = new JLabel(I18N.getString("sampleEnvironment.deviceSystemLabel"));
        GridBagConstraints constraints = new GridBagConstraints();
        JScrollPane paneListBox = new JScrollPane(this.listBox, 22, 31);
        paneListBox.setMinimumSize(new Dimension(0, 70));
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)introLabel, constraints);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.gridwidth = 1;
        constraints.insets = new Insets(0, 5, 0, 5);
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add((Component)devicesSystemLabel, constraints);
        constraints.fill = 2;
        constraints.gridwidth = 3;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.add((Component)paneListBox, constraints);
        constraints.fill = 2;
        ++constraints.gridy;
        this.add((Component)this.createControllerPanel(), constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        ++constraints.gridy;
        constraints.gridx = 0;
        this.add((Component)this.propertiesPanel, constraints);
        ++constraints.gridy;
        this.add((Component)this.createButtonsPanel(), constraints);
    }

    protected JPanel createControllerPanel() {
        JLabel controllerTypeLabel = new JLabel(I18N.getString("sampleEnvironment.controllerType"));
        JLabel controllerLabel = new JLabel(I18N.getString("sampleEnvironment.controller"));
        JLabel aliasLabel = this.createLabel(I18N.getString("sampleEnvironment.alias"), true);
        JPanel controllerPanel = new JPanel(new GridLayout(2, 3, 20, 0));
        controllerPanel.add(controllerTypeLabel);
        controllerPanel.add(controllerLabel);
        controllerPanel.add(aliasLabel);
        controllerPanel.add(this.controllerTypeBox);
        controllerPanel.add(this.controllerBox);
        controllerPanel.add(this.aliasField);
        return controllerPanel;
    }

    protected JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout(0));
        buttonsPanel.add(this.addButton);
        buttonsPanel.add(this.updateButton);
        buttonsPanel.add(this.removeButton);
        return buttonsPanel;
    }

    protected void setInstalledDevices(Collection<InstalledDevice> devices) {
        this.installedTempDevices.clear();
        this.installedMagnetDevices.clear();
        this.installedPressureDevices.clear();
        this.installedOtherDevices.clear();
        this.listBoxItems.clear();
        for (InstalledDevice device : devices) {
            String addToList;
            if (device.getType() != InstalledDevice.Type.environment) continue;
            if (device instanceof InstalledTempDevice) {
                addToList = "Temp (" + device.getRealName().toUpperCase() + ")";
                this.installedTempDevices.add((InstalledTempDevice)device);
                this.listBoxItems.add(addToList);
                continue;
            }
            if (device instanceof InstalledMagnetDevice) {
                addToList = "MagField (" + device.getRealName().toUpperCase() + ")";
                this.installedMagnetDevices.add((InstalledMagnetDevice)device);
                this.listBoxItems.add(addToList);
                continue;
            }
            if (device instanceof InstalledPressureDevice) {
                addToList = "Pressure (" + device.getRealName().toUpperCase() + ")";
                this.installedPressureDevices.add((InstalledPressureDevice)device);
                this.listBoxItems.add(addToList);
                continue;
            }
            if (!(device instanceof InstalledMiscDevice)) continue;
            this.installedOtherDevices.add((InstalledMiscDevice)device);
            if (device.getAlias() == null) {
                addToList = String.valueOf(this.aliasBug) + " (" + device.getRealName().toUpperCase() + ")";
                this.listBoxItems.add(addToList);
                continue;
            }
            addToList = String.valueOf(device.getAlias()) + " (" + device.getRealName().toUpperCase() + ")";
            this.listBoxItems.add(addToList);
        }
    }

    public void setAliasField() {
        if (this.controllerTypeBox.getSelectedItem() == EMPTY) {
            this.aliasField.setText(EMPTY);
            this.aliasField.setEnabled(false);
        } else if (this.controllerTypeBox.getSelectedItem() == TEMPERATURE) {
            this.aliasField.setText(TEMPERATURE);
            this.aliasField.setEnabled(false);
        } else if (this.controllerTypeBox.getSelectedItem() == MAGNET) {
            this.aliasField.setText(MAGNET);
            this.aliasField.setEnabled(false);
        } else if (this.controllerTypeBox.getSelectedItem() == PRESSURE) {
            this.aliasField.setText(PRESSURE);
            this.aliasField.setEnabled(false);
        } else if (this.controllerTypeBox.getSelectedItem() == OTHER) {
            this.aliasField.setText(EMPTY);
            this.aliasField.setEnabled(true);
        }
    }

    public void setTempProperties(String selectedController, boolean isInstalled) {
        int x;
        String upperTilt = EMPTY;
        String lowerTilt = EMPTY;
        String units = EMPTY;
        int sampleChannel = 0;
        int controlChannel = 0;
        int numChannels = 0;
        Character letter = Character.valueOf('A');
        if (isInstalled) {
            upperTilt = Double.toString(this.installedTempDevices.get(0).getMaxUpperTilt());
            lowerTilt = Double.toString(this.installedTempDevices.get(0).getMaxLowerTilt());
            units = this.installedTempDevices.get(0).getUnits().toLowerCase();
            sampleChannel = this.installedTempDevices.get(0).getSampleChannel();
            controlChannel = this.installedTempDevices.get(0).getControlChannel();
            numChannels = this.installedTempDevices.get(0).getNumChannels();
        } else if (!isInstalled) {
            x = 0;
            while (x < this.availableTempDevices.size()) {
                if (selectedController.equals(this.availableTempDevices.get(x).getName().toLowerCase())) {
                    upperTilt = Double.toString(this.availableTempDevices.get(x).getMaxUpperTilt());
                    lowerTilt = Double.toString(this.availableTempDevices.get(x).getMaxLowerTilt());
                    units = this.availableTempDevices.get(x).getUnits().toLowerCase();
                    sampleChannel = this.availableTempDevices.get(x).getSampleChannel();
                    controlChannel = this.availableTempDevices.get(x).getControlChannel();
                    numChannels = this.availableTempDevices.get(x).getNumChannels();
                    break;
                }
                ++x;
            }
        }
        this.tempProperties.maxUpperTiltField.setText(upperTilt);
        this.tempProperties.maxLowerTiltField.setText(lowerTilt);
        this.tempProperties.celsiusRadioButton.setEnabled(false);
        this.tempProperties.celsiusRadioButton.setSelected(false);
        this.tempProperties.kelvinRadioButton.setEnabled(false);
        this.tempProperties.kelvinRadioButton.setSelected(false);
        if (units.equals("kelvin")) {
            this.tempProperties.kelvinRadioButton.setEnabled(true);
            this.tempProperties.kelvinRadioButton.setSelected(true);
        } else if (units.equals("celsius")) {
            this.tempProperties.celsiusRadioButton.setEnabled(true);
            this.tempProperties.celsiusRadioButton.setSelected(true);
        }
        letter = Character.valueOf('A');
        this.tempProperties.numChannelList.clear();
        x = 0;
        while (x < numChannels) {
            this.tempProperties.numChannelList.add(letter);
            letter = Character.valueOf((char)(letter.charValue() + '\u0001'));
            ++x;
        }
        this.tempProperties.sampleChannelBox.setSelectedIndex(sampleChannel);
        this.tempProperties.controlChannelBox.setSelectedIndex(controlChannel);
        this.tempProperties.sampleChannelBox.updateUI();
        this.tempProperties.controlChannelBox.updateUI();
    }

    public void setMagnetProperties(String selectedController, boolean isInstalled) {
        String upperTilt = EMPTY;
        String lowerTilt = EMPTY;
        String units = EMPTY;
        boolean persistenceMode = true;
        if (isInstalled) {
            upperTilt = Double.toString(this.installedMagnetDevices.get(0).getMaxUpperTilt());
            lowerTilt = Double.toString(this.installedMagnetDevices.get(0).getMaxLowerTilt());
            units = this.installedMagnetDevices.get(0).getUnits().toLowerCase();
            persistenceMode = this.installedMagnetDevices.get(0).isPersistenceMode();
        } else if (!isInstalled) {
            int x = 0;
            while (x < this.availableMagnetDevices.size()) {
                if (selectedController.equals(this.availableMagnetDevices.get(x).getName().toLowerCase())) {
                    upperTilt = Double.toString(this.availableMagnetDevices.get(x).getMaxUpperTilt());
                    lowerTilt = Double.toString(this.availableMagnetDevices.get(x).getMaxLowerTilt());
                    units = this.availableMagnetDevices.get(x).getUnits().toLowerCase();
                    persistenceMode = this.availableMagnetDevices.get(x).isPersistenceMode();
                    break;
                }
                ++x;
            }
        }
        this.magnetProperties.maxUpperTiltField.setText(upperTilt);
        this.magnetProperties.maxLowerTiltField.setText(lowerTilt);
        this.magnetProperties.teslaRadioButton.setSelected(false);
        this.magnetProperties.gaussRadioButton.setSelected(false);
        this.magnetProperties.kiloGaussRadioButton.setSelected(false);
        this.magnetProperties.teslaRadioButton.setEnabled(false);
        this.magnetProperties.gaussRadioButton.setEnabled(false);
        this.magnetProperties.kiloGaussRadioButton.setEnabled(false);
        if (units.equals("tesla")) {
            this.magnetProperties.teslaRadioButton.setEnabled(true);
            this.magnetProperties.teslaRadioButton.setSelected(true);
        } else if (units.equals("gauss")) {
            this.magnetProperties.gaussRadioButton.setEnabled(true);
            this.magnetProperties.gaussRadioButton.setSelected(true);
        } else if (units.equals("kilogauss")) {
            this.magnetProperties.gaussRadioButton.setEnabled(true);
            this.magnetProperties.gaussRadioButton.setSelected(true);
        }
        this.magnetProperties.persistenceRadioButton.setSelected(false);
        this.magnetProperties.nonPersistenceRadioButton.setSelected(false);
        this.magnetProperties.persistenceRadioButton.setSelected(false);
        this.magnetProperties.nonPersistenceRadioButton.setSelected(false);
        this.magnetProperties.persistenceRadioButton.setEnabled(false);
        this.magnetProperties.nonPersistenceRadioButton.setEnabled(false);
        this.magnetProperties.persistenceRadioButton.setEnabled(false);
        this.magnetProperties.nonPersistenceRadioButton.setEnabled(false);
        if (persistenceMode) {
            this.magnetProperties.persistenceRadioButton.setEnabled(true);
            this.magnetProperties.persistenceRadioButton.setSelected(true);
            this.magnetProperties.nonPersistenceRadioButton.setEnabled(true);
        } else if (!persistenceMode) {
            this.magnetProperties.persistenceRadioButton.setEnabled(true);
            this.magnetProperties.nonPersistenceRadioButton.setEnabled(true);
            this.magnetProperties.nonPersistenceRadioButton.setSelected(true);
        }
    }

    public boolean isErrorMessage() {
        block16: {
            String controllerTypeItem = (String)this.controllerTypeBox.getSelectedItem();
            if (controllerTypeItem == TEMPERATURE) {
                int length;
                block15: {
                    try {
                        length = this.tempProperties.maxUpperTiltField.getText().trim().length();
                        if (length != 0) {
                            Double upperTilt = Double.valueOf(this.tempProperties.maxUpperTiltField.getText().trim());
                            break block15;
                        }
                        JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.upperTiltWarning"));
                        logger.error("Invalid input for upper tilt field");
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.upperTiltWarning"));
                        logger.error("Invalid input for upper tilt field");
                        return true;
                    }
                }
                try {
                    length = this.tempProperties.maxLowerTiltField.getText().trim().length();
                    if (length != 0) {
                        Double lowerTilt = Double.valueOf(this.tempProperties.maxLowerTiltField.getText().trim());
                        break block16;
                    }
                    JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.lowerTiltWarning"));
                    logger.error("Invalid input for lower tilt field");
                    return true;
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.lowerTiltWarning"));
                    logger.error("Invalid input for lower tilt field");
                    return true;
                }
            }
            if (controllerTypeItem == MAGNET) {
                block17: {
                    try {
                        if (this.magnetProperties.maxUpperTiltField.getText().trim().length() != 0) {
                            Double upperTilt = Double.valueOf(this.magnetProperties.maxUpperTiltField.getText().trim());
                            break block17;
                        }
                        JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.upperTiltWarning"));
                        logger.error("Invalid input for upper tilt field");
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.upperTiltWarning"));
                        logger.error("Invalid input for upper tilt field");
                        return true;
                    }
                }
                try {
                    if (this.magnetProperties.maxLowerTiltField.getText().trim().length() != 0) {
                        Double lowerTilt = Double.valueOf(this.magnetProperties.maxLowerTiltField.getText().trim());
                        break block16;
                    }
                    JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.lowerTiltWarning"));
                    logger.error("Invalid input for lower tilt field");
                    return true;
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.lowerTiltWarning"));
                    logger.error("Invalid input for lower tilt field");
                    return true;
                }
            }
            if (controllerTypeItem != PRESSURE && controllerTypeItem == OTHER && this.aliasField.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this.realParent, I18N.getString("sampleEnvironment.aliasTiltWarning"));
                logger.error("Invalid input for alias field");
                return true;
            }
        }
        return false;
    }

    public void setController(String controller) {
        int counter = 0;
        for (Device device : this.controllerBoxItems) {
            String deviceName = device.getName().toUpperCase();
            if (deviceName.equals(controller)) {
                this.controllerBox.setSelectedIndex(counter);
            }
            ++counter;
        }
    }

    public boolean updateTiltDevices(String controllerType) {
        Double newLowerTiltField = 0.0;
        Double newUpperTiltField = 0.0;
        boolean deviceFlag = false;
        if (controllerType == TEMPERATURE) {
            newLowerTiltField = Double.valueOf(this.tempProperties.maxLowerTiltField.getText());
            newUpperTiltField = Double.valueOf(this.tempProperties.maxUpperTiltField.getText());
            deviceFlag = true;
        } else if (controllerType == MAGNET) {
            newLowerTiltField = Double.valueOf(this.magnetProperties.maxLowerTiltField.getText());
            newUpperTiltField = Double.valueOf(this.magnetProperties.maxUpperTiltField.getText());
            deviceFlag = true;
        }
        if (deviceFlag && this.sampleLowerTilt != null && this.sampleUpperTilt != null) {
            String messagePos;
            String messagePos2;
            String messageNeg;
            double oldLowerTiltLowerLimit = this.sampleLowerTilt.getLowerLimit();
            double oldLowerTiltUpperLimit = this.sampleLowerTilt.getUpperLimit();
            double oldUpperTiltLowerLimit = this.sampleUpperTilt.getLowerLimit();
            double oldUpperTiltUpperLimit = this.sampleUpperTilt.getUpperLimit();
            if (-newLowerTiltField.doubleValue() >= oldLowerTiltLowerLimit && newLowerTiltField <= oldLowerTiltUpperLimit) {
                messageNeg = "device setlowerlimit SmplLowerTilt -" + newLowerTiltField;
                messagePos2 = "device setupperlimit SmplLowerTilt " + newLowerTiltField;
                this.sendManager.addMessage(messageNeg);
                this.sendManager.addMessage(messagePos2);
            } else if (!(-newLowerTiltField.doubleValue() <= oldLowerTiltLowerLimit) || !(newLowerTiltField >= oldLowerTiltUpperLimit)) {
                if (-newLowerTiltField.doubleValue() <= oldLowerTiltLowerLimit && newLowerTiltField <= oldLowerTiltUpperLimit && newLowerTiltField >= oldLowerTiltLowerLimit) {
                    messagePos = "device setupperlimit SmplLowerTilt " + newLowerTiltField;
                    this.sendManager.addMessage(messagePos);
                } else if (-newLowerTiltField.doubleValue() >= oldLowerTiltLowerLimit && newLowerTiltField >= oldLowerTiltUpperLimit && -newLowerTiltField.doubleValue() <= oldLowerTiltUpperLimit) {
                    messageNeg = "device setlowerlimit SmplLowerTilt -" + newLowerTiltField;
                    this.sendManager.addMessage(messageNeg);
                }
            }
            if (-newUpperTiltField.doubleValue() >= oldUpperTiltLowerLimit && newUpperTiltField <= oldUpperTiltUpperLimit) {
                messageNeg = "device setlowerlimit SmplUpperTilt -" + newUpperTiltField;
                messagePos2 = "device setupperlimit SmplUpperTilt " + newUpperTiltField;
                this.sendManager.addMessage(messageNeg);
                this.sendManager.addMessage(messagePos2);
            } else if (!(-newUpperTiltField.doubleValue() <= oldUpperTiltLowerLimit) || !(newUpperTiltField >= oldUpperTiltUpperLimit)) {
                if (-newUpperTiltField.doubleValue() <= oldUpperTiltLowerLimit && newUpperTiltField <= oldUpperTiltUpperLimit && newUpperTiltField >= oldUpperTiltLowerLimit) {
                    messagePos = "device setupperlimit SmplUpperTilt " + newUpperTiltField;
                    this.sendManager.addMessage(messagePos);
                } else if (-newUpperTiltField.doubleValue() >= oldUpperTiltLowerLimit && newUpperTiltField >= oldUpperTiltUpperLimit && -newUpperTiltField.doubleValue() <= oldUpperTiltUpperLimit) {
                    messageNeg = "device setlowerlimit SmplUpperTilt -" + newUpperTiltField;
                    this.sendManager.addMessage(messageNeg);
                }
            }
            if (newLowerTiltField < oldLowerTiltLowerLimit || newUpperTiltField < oldUpperTiltLowerLimit) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        this.setInstalledDevices(dle.getNewList());
    }

    @Override
    public void actionPerformed(AvailableDeviceEvent availableDeviceEvent) {
        AvailableDeviceEvent.Type theType = availableDeviceEvent.getTheType();
        List theList = availableDeviceEvent.getDeviceList();
        switch (theType) {
            case MAGNET: {
                this.receiveAvailableMagnetDevices(theList);
                break;
            }
            case OTHER: {
                this.receiveAvailableOtherDevices(theList);
                break;
            }
            case TEMP: {
                this.receiveAvailableTempDevices(theList);
                break;
            }
            case PRESSURE: {
                this.receiveAvailablePressureDevices(theList);
            }
        }
    }

    public void receiveAvailableMagnetDevices(List<AvailableMagnetDevice> devices) {
        logger.debug("Receiving list of available magnet devices.");
        AvailableMagnetDevice emptyDevice = new AvailableMagnetDevice(EMPTY, EMPTY, 0.0, 0.0, true);
        this.availableMagnetDevices.clear();
        this.controllerBoxItems.clear();
        this.availableMagnetDevices.add(emptyDevice);
        this.availableMagnetDevices.addAll(devices);
    }

    public void receiveAvailableOtherDevices(List<AvailableMiscDevice> devices) {
        logger.debug("Receiving list of available other devices.");
        AvailableMiscDevice emptyDevice = new AvailableMiscDevice(EMPTY, EMPTY);
        this.availableOtherDevices.clear();
        this.controllerBoxItems.clear();
        this.availableOtherDevices.add(emptyDevice);
        this.availableOtherDevices.addAll(devices);
    }

    public void receiveAvailablePressureDevices(List<AvailablePressureDevice> devices) {
        logger.debug("Receiving list of available pressure devices.");
        AvailablePressureDevice emptyDevice = new AvailablePressureDevice(EMPTY, EMPTY);
        this.availablePressureDevices.clear();
        this.controllerBoxItems.clear();
        this.availablePressureDevices.add(emptyDevice);
        this.availablePressureDevices.addAll(devices);
    }

    public void receiveAvailableTempDevices(List<AvailableTempDevice> devices) {
        logger.debug("Receiving list of available temperature devices.");
        AvailableTempDevice emptyDevice = new AvailableTempDevice(EMPTY, EMPTY, 0, 0, 0, 0.0, 0.0);
        this.availableTempDevices.clear();
        this.controllerBoxItems.clear();
        this.availableTempDevices.add(emptyDevice);
        this.availableTempDevices.addAll(devices);
    }

    @Override
    protected boolean commitChanges(SendQueueManager sendManager) {
        return false;
    }

    @Override
    protected String getCompletionErrorString() {
        return null;
    }

    @Override
    protected boolean isCompleted() {
        return true;
    }

    @Override
    protected void reload() {
        this.controllerTypeBox.setSelectedItem(EMPTY);
    }

    private class AddDeviceActionListener
    implements ActionListener {
        private AddDeviceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Device controllerItem = (Device)SampleEnvironmentPanel.this.controllerBox.getSelectedItem();
            String controllerTypeItem = (String)SampleEnvironmentPanel.this.controllerTypeBox.getSelectedItem();
            String deviceAddMessage = "device add env " + controllerItem;
            String deviceAddAliasMessage = "device add alias " + SampleEnvironmentPanel.this.aliasField.getText() + " " + controllerItem;
            logger.debug("Attempting to add device: " + controllerItem);
            if (SampleEnvironmentPanel.this.isErrorMessage()) {
                return;
            }
            if (SampleEnvironmentPanel.this.updateTiltDevices(controllerTypeItem)) {
                SampleEnvironmentPanel.this.addButton.setEnabled(false);
                SampleEnvironmentPanel.this.updateButton.setEnabled(true);
                SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                SampleEnvironmentPanel.this.sendManager.addMessage(deviceAddMessage);
                SampleEnvironmentPanel.this.sendManager.addMessage(deviceAddAliasMessage);
                if (controllerTypeItem == SampleEnvironmentPanel.TEMPERATURE) {
                    String upperTiltLimitMessage = "device setproperty " + controllerItem + " " + "upperTiltLimit " + SampleEnvironmentPanel.this.tempProperties.maxUpperTiltField.getText();
                    String lowerTiltLimitMessage = "device setproperty " + controllerItem + " " + "lowerTiltLimit " + SampleEnvironmentPanel.this.tempProperties.maxLowerTiltField.getText();
                    String sampleChannelMessage = "device setproperty " + controllerItem + " " + "sampleSensorIndex " + SampleEnvironmentPanel.this.tempProperties.sampleChannelBox.getSelectedIndex();
                    String controlChannelMessage = "device setproperty " + controllerItem + " " + "controlSensorIndex " + SampleEnvironmentPanel.this.tempProperties.controlChannelBox.getSelectedIndex();
                    SampleEnvironmentPanel.this.sendManager.addMessage(upperTiltLimitMessage);
                    SampleEnvironmentPanel.this.sendManager.addMessage(lowerTiltLimitMessage);
                    SampleEnvironmentPanel.this.sendManager.addMessage(sampleChannelMessage);
                    SampleEnvironmentPanel.this.sendManager.addMessage(controlChannelMessage);
                } else if (controllerTypeItem == SampleEnvironmentPanel.MAGNET) {
                    int i = SampleEnvironmentPanel.this.magnetProperties.persistenceRadioButton.isSelected() ? 1 : 0;
                    String persistenceFlagMessage = "device setproperty " + controllerItem + " " + "persistenceFlag " + Integer.toString(i);
                    SampleEnvironmentPanel.this.sendManager.addMessage(persistenceFlagMessage);
                } else if (controllerTypeItem != SampleEnvironmentPanel.PRESSURE && controllerTypeItem == SampleEnvironmentPanel.OTHER) {
                    SampleEnvironmentPanel.this.aliasField.setEnabled(false);
                    SampleEnvironmentPanel.this.addButton.setEnabled(false);
                    SampleEnvironmentPanel.this.updateButton.setEnabled(false);
                    SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                    SampleEnvironmentPanel.this.aliasBug = SampleEnvironmentPanel.this.aliasField.getText();
                }
            } else {
                JOptionPane.showMessageDialog(SampleEnvironmentPanel.this.realParent, I18N.getString("sampleEnvironment.incompatibleLimits"));
            }
        }
    }

    private class ControllerItemListener
    implements ItemListener {
        private ControllerItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            CardLayout cl = (CardLayout)SampleEnvironmentPanel.this.propertiesPanel.getLayout();
            String selectedControllerType = SampleEnvironmentPanel.this.controllerTypeBox.getSelectedItem().toString();
            String selectedController = SampleEnvironmentPanel.this.controllerBox.getSelectedItem().toString().toLowerCase();
            String installedController = SampleEnvironmentPanel.EMPTY;
            logger.debug("Controller combo box selected: " + selectedController);
            if (ie.getStateChange() == 1) {
                cl.show(SampleEnvironmentPanel.this.propertiesPanel, selectedControllerType);
                SampleEnvironmentPanel.this.addButton.setEnabled(false);
                SampleEnvironmentPanel.this.updateButton.setEnabled(false);
                SampleEnvironmentPanel.this.removeButton.setEnabled(false);
                if (selectedController == SampleEnvironmentPanel.EMPTY) {
                    cl.show(SampleEnvironmentPanel.this.propertiesPanel, SampleEnvironmentPanel.OTHER);
                    SampleEnvironmentPanel.this.listBox.clearSelection();
                } else if (selectedControllerType == SampleEnvironmentPanel.TEMPERATURE) {
                    if (SampleEnvironmentPanel.this.installedTempDevices.size() > 0) {
                        installedController = SampleEnvironmentPanel.this.installedTempDevices.get(0).getRealName().toLowerCase();
                    }
                    SampleEnvironmentPanel.this.setAliasField();
                    if (selectedController.equals(installedController)) {
                        SampleEnvironmentPanel.this.setTempProperties(selectedController, true);
                        SampleEnvironmentPanel.this.addButton.setEnabled(false);
                        SampleEnvironmentPanel.this.updateButton.setEnabled(true);
                        SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                        SampleEnvironmentPanel.this.listBox.setSelectedIndex(SampleEnvironmentPanel.this.listBoxItems.indexOf(String.valueOf(selectedControllerType) + " (" + selectedController.toUpperCase() + ")"));
                    } else {
                        SampleEnvironmentPanel.this.setTempProperties(selectedController, false);
                        if (SampleEnvironmentPanel.this.installedTempDevices.size() == 0) {
                            SampleEnvironmentPanel.this.addButton.setEnabled(true);
                            SampleEnvironmentPanel.this.updateButton.setEnabled(false);
                            SampleEnvironmentPanel.this.removeButton.setEnabled(false);
                        }
                        SampleEnvironmentPanel.this.listBox.clearSelection();
                    }
                } else if (selectedControllerType == SampleEnvironmentPanel.MAGNET) {
                    if (SampleEnvironmentPanel.this.installedMagnetDevices.size() > 0) {
                        installedController = SampleEnvironmentPanel.this.installedMagnetDevices.get(0).getRealName().toLowerCase();
                    }
                    SampleEnvironmentPanel.this.setAliasField();
                    if (selectedController.equals(installedController)) {
                        SampleEnvironmentPanel.this.setMagnetProperties(selectedController, true);
                        SampleEnvironmentPanel.this.addButton.setEnabled(false);
                        SampleEnvironmentPanel.this.updateButton.setEnabled(true);
                        SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                        SampleEnvironmentPanel.this.listBox.setSelectedIndex(SampleEnvironmentPanel.this.listBoxItems.indexOf(String.valueOf(selectedControllerType) + " (" + selectedController.toUpperCase() + ")"));
                    } else {
                        SampleEnvironmentPanel.this.setMagnetProperties(selectedController, false);
                        if (SampleEnvironmentPanel.this.installedMagnetDevices.size() == 0) {
                            SampleEnvironmentPanel.this.addButton.setEnabled(true);
                            SampleEnvironmentPanel.this.updateButton.setEnabled(false);
                            SampleEnvironmentPanel.this.removeButton.setEnabled(false);
                        }
                        SampleEnvironmentPanel.this.listBox.clearSelection();
                    }
                } else if (selectedControllerType != SampleEnvironmentPanel.PRESSURE && selectedControllerType == SampleEnvironmentPanel.OTHER) {
                    boolean isInstalled = false;
                    int x = 0;
                    while (x < SampleEnvironmentPanel.this.installedOtherDevices.size()) {
                        installedController = SampleEnvironmentPanel.this.installedOtherDevices.get(x).getRealName().toLowerCase();
                        if (selectedController.equals(installedController)) {
                            String aliasName = SampleEnvironmentPanel.this.installedOtherDevices.get(x).getAlias();
                            SampleEnvironmentPanel.this.aliasField.setText(aliasName);
                            SampleEnvironmentPanel.this.aliasField.setEnabled(false);
                            SampleEnvironmentPanel.this.addButton.setEnabled(false);
                            SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                            SampleEnvironmentPanel.this.listBox.setSelectedIndex(SampleEnvironmentPanel.this.listBoxItems.indexOf(String.valueOf(aliasName) + " (" + selectedController.toUpperCase() + ")"));
                            isInstalled = true;
                            break;
                        }
                        ++x;
                    }
                    if (!isInstalled) {
                        SampleEnvironmentPanel.this.aliasField.setText(SampleEnvironmentPanel.EMPTY);
                        SampleEnvironmentPanel.this.aliasField.setEnabled(true);
                        SampleEnvironmentPanel.this.addButton.setEnabled(true);
                        SampleEnvironmentPanel.this.removeButton.setEnabled(false);
                        SampleEnvironmentPanel.this.listBox.clearSelection();
                    }
                }
            }
        }
    }

    private class ControllerTypeItemListener
    implements ItemListener {
        private ControllerTypeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ie) {
            logger.debug("Controller type combo box selected: " + ie.getItem());
            CardLayout cl = (CardLayout)SampleEnvironmentPanel.this.propertiesPanel.getLayout();
            if (ie.getStateChange() == 1) {
                SampleEnvironmentPanel.this.aliasField.setText(SampleEnvironmentPanel.EMPTY);
                cl.show(SampleEnvironmentPanel.this.propertiesPanel, SampleEnvironmentPanel.OTHER);
                SampleEnvironmentPanel.this.controllerBox.setEnabled(true);
                if (ie.getItem() == SampleEnvironmentPanel.EMPTY) {
                    SampleEnvironmentPanel.this.controllerBox.setEnabled(false);
                    SampleEnvironmentPanel.this.controllerBox.setSelectedIndex(0);
                    SampleEnvironmentPanel.this.addButton.setEnabled(false);
                    SampleEnvironmentPanel.this.removeButton.setEnabled(false);
                    SampleEnvironmentPanel.this.updateButton.setEnabled(false);
                } else if (ie.getItem() == SampleEnvironmentPanel.TEMPERATURE) {
                    SampleEnvironmentPanel.this.controllerBoxItems.clear();
                    SampleEnvironmentPanel.this.controllerBoxItems.addAll(SampleEnvironmentPanel.this.availableTempDevices);
                    if (SampleEnvironmentPanel.this.listBoxFlag) {
                        String value = (String)SampleEnvironmentPanel.this.listBox.getSelectedValue();
                        String controllerItemList = value.substring(value.indexOf("(") + 1, value.length() - 1);
                        SampleEnvironmentPanel.this.setController(controllerItemList);
                        SampleEnvironmentPanel.this.listBoxFlag = false;
                    } else {
                        SampleEnvironmentPanel.this.controllerBox.setSelectedIndex(0);
                    }
                } else if (ie.getItem() == SampleEnvironmentPanel.MAGNET) {
                    SampleEnvironmentPanel.this.controllerBoxItems.clear();
                    SampleEnvironmentPanel.this.controllerBoxItems.addAll(SampleEnvironmentPanel.this.availableMagnetDevices);
                    if (SampleEnvironmentPanel.this.listBoxFlag) {
                        String value = (String)SampleEnvironmentPanel.this.listBox.getSelectedValue();
                        String controllerItemList = value.substring(value.indexOf("(") + 1, value.length() - 1);
                        SampleEnvironmentPanel.this.setController(controllerItemList);
                        SampleEnvironmentPanel.this.listBoxFlag = false;
                    } else {
                        SampleEnvironmentPanel.this.controllerBox.setSelectedIndex(0);
                    }
                } else if (ie.getItem() == SampleEnvironmentPanel.PRESSURE) {
                    SampleEnvironmentPanel.this.controllerBoxItems.clear();
                    SampleEnvironmentPanel.this.controllerBoxItems.addAll(SampleEnvironmentPanel.this.availableMagnetDevices);
                    SampleEnvironmentPanel.this.controllerBox.setEnabled(false);
                } else if (ie.getItem() == SampleEnvironmentPanel.OTHER) {
                    SampleEnvironmentPanel.this.controllerBoxItems.clear();
                    SampleEnvironmentPanel.this.controllerBoxItems.addAll(SampleEnvironmentPanel.this.availableOtherDevices);
                    if (SampleEnvironmentPanel.this.listBoxFlag) {
                        String value = (String)SampleEnvironmentPanel.this.listBox.getSelectedValue();
                        String controllerItemList = value.substring(value.indexOf("(") + 1, value.length() - 1);
                        SampleEnvironmentPanel.this.setController(controllerItemList);
                        SampleEnvironmentPanel.this.listBoxFlag = false;
                    } else {
                        SampleEnvironmentPanel.this.controllerBox.setSelectedIndex(0);
                    }
                }
            }
        }
    }

    private class ListBoxSelectionListener
    implements ListSelectionListener {
        private ListBoxSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (!SampleEnvironmentPanel.this.listBox.isSelectionEmpty() && SampleEnvironmentPanel.this.listBox.getValueIsAdjusting()) {
                String value = (String)SampleEnvironmentPanel.this.listBox.getSelectedValue();
                String controllerTypeItemList = value.substring(0, value.indexOf("(") - 1);
                String controllerItemList = value.substring(value.indexOf("(") + 1, value.length() - 1).toUpperCase();
                String controllerTypeItemBox = (String)SampleEnvironmentPanel.this.controllerTypeBox.getSelectedItem();
                logger.debug("List box selected: " + value);
                if (controllerTypeItemBox.equals(controllerTypeItemList)) {
                    SampleEnvironmentPanel.this.setController(controllerItemList);
                } else {
                    SampleEnvironmentPanel.this.listBoxFlag = true;
                    if (controllerTypeItemList.equals(SampleEnvironmentPanel.TEMPERATURE)) {
                        SampleEnvironmentPanel.this.controllerTypeBox.setSelectedItem(SampleEnvironmentPanel.TEMPERATURE);
                    } else if (controllerTypeItemList.equals(SampleEnvironmentPanel.MAGNET)) {
                        SampleEnvironmentPanel.this.controllerTypeBox.setSelectedItem(SampleEnvironmentPanel.MAGNET);
                    } else if (controllerTypeItemList.equals(SampleEnvironmentPanel.PRESSURE)) {
                        SampleEnvironmentPanel.this.controllerTypeBox.setSelectedItem(SampleEnvironmentPanel.PRESSURE);
                    } else {
                        SampleEnvironmentPanel.this.controllerTypeBox.setSelectedItem(SampleEnvironmentPanel.OTHER);
                    }
                }
                if (!(controllerTypeItemList.equals(SampleEnvironmentPanel.TEMPERATURE) || controllerTypeItemList.equals(SampleEnvironmentPanel.MAGNET) || controllerTypeItemList.equals(SampleEnvironmentPanel.PRESSURE))) {
                    SampleEnvironmentPanel.this.setController(controllerItemList);
                    SampleEnvironmentPanel.this.aliasField.setText(controllerTypeItemList);
                    SampleEnvironmentPanel.this.aliasField.setEnabled(false);
                    SampleEnvironmentPanel.this.addButton.setEnabled(false);
                    SampleEnvironmentPanel.this.updateButton.setEnabled(false);
                    SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                } else {
                    SampleEnvironmentPanel.this.addButton.setEnabled(false);
                    SampleEnvironmentPanel.this.updateButton.setEnabled(true);
                    SampleEnvironmentPanel.this.removeButton.setEnabled(true);
                }
            }
        }
    }

    private class MagnetPropertiesPanel
    extends JPanel {
        public JRadioButton teslaRadioButton;
        public JRadioButton gaussRadioButton;
        public JRadioButton kiloGaussRadioButton;
        public JRadioButton persistenceRadioButton;
        public JRadioButton nonPersistenceRadioButton;
        public JTextField maxUpperTiltField;
        public JTextField maxLowerTiltField;

        public MagnetPropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel maxUpperTiltLabel = SampleEnvironmentPanel.this.createLabel(I18N.getString("sampleEnvironment.upperTilt"), true);
            JLabel maxLowerTiltLabel = SampleEnvironmentPanel.this.createLabel(I18N.getString("sampleEnvironment.lowerTilt"), true);
            JLabel unitMeasurementLabel = new JLabel(I18N.getString("sampleEnvironment.unitOfMeasurement"), 2);
            JLabel modeLabel = new JLabel(I18N.getString("sampleEnvironment.mode"), 2);
            JLabel emptyLabel = new JLabel(SampleEnvironmentPanel.EMPTY);
            JLabel tiltWarningMessageLabel = SampleEnvironmentPanel.this.createLabel(I18N.getString("sampleEnvironment.TiltWarningMessage"), true);
            this.teslaRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.tesla"));
            this.gaussRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.gauss"));
            this.kiloGaussRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.kiloGauss"));
            this.persistenceRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.persistence"));
            this.nonPersistenceRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.nonPersistence"));
            this.maxUpperTiltField = new JTextField("5", 11);
            this.maxLowerTiltField = new JTextField("5", 11);
            GridBagConstraints constraints = new GridBagConstraints();
            ButtonGroup unitGroup = new ButtonGroup();
            ButtonGroup modeGroup = new ButtonGroup();
            this.teslaRadioButton.setEnabled(false);
            this.gaussRadioButton.setEnabled(false);
            this.kiloGaussRadioButton.setEnabled(false);
            this.maxUpperTiltField.setEnabled(false);
            this.maxLowerTiltField.setEnabled(false);
            unitGroup.add(this.teslaRadioButton);
            unitGroup.add(this.gaussRadioButton);
            unitGroup.add(this.kiloGaussRadioButton);
            modeGroup.add(this.persistenceRadioButton);
            modeGroup.add(this.nonPersistenceRadioButton);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.gridwidth = 5;
            constraints.insets = new Insets(0, 0, 0, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.add((Component)tiltWarningMessageLabel, constraints);
            constraints.insets = new Insets(5, 0, 0, 20);
            constraints.gridwidth = 1;
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.add((Component)maxUpperTiltLabel, constraints);
            ++constraints.gridx;
            this.add((Component)maxLowerTiltLabel, constraints);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.add((Component)this.maxUpperTiltField, constraints);
            ++constraints.gridx;
            this.add((Component)this.maxLowerTiltField, constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 0, 0, 10);
            constraints.gridx = 0;
            constraints.gridy = 3;
            this.add((Component)unitMeasurementLabel, constraints);
            constraints.insets = new Insets(5, 0, 0, 25);
            ++constraints.gridx;
            this.add((Component)this.teslaRadioButton, constraints);
            constraints.insets = new Insets(5, 0, 0, 42);
            ++constraints.gridx;
            this.add((Component)this.gaussRadioButton, constraints);
            constraints.insets = new Insets(5, 0, 0, 100);
            ++constraints.gridx;
            this.add((Component)this.kiloGaussRadioButton, constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 0, 0, 85);
            constraints.gridx = 0;
            constraints.gridy = 4;
            this.add((Component)modeLabel, constraints);
            constraints.insets = new Insets(5, 5, 0, 0);
            ++constraints.gridx;
            this.add((Component)this.persistenceRadioButton, constraints);
            constraints.insets = new Insets(5, 5, 0, 0);
            ++constraints.gridx;
            this.add((Component)this.nonPersistenceRadioButton, constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 3;
            constraints.weightx = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 5;
            this.add((Component)emptyLabel, constraints);
        }
    }

    private class OtherPropertiesPanel
    extends JPanel {
    }

    private class PressurePropertiesPanel
    extends JPanel {
    }

    private class RemoveDeviceActionListener
    implements ActionListener {
        private RemoveDeviceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String controllerType = (String)SampleEnvironmentPanel.this.controllerTypeBox.getSelectedItem();
            Device controllerItem = (Device)SampleEnvironmentPanel.this.controllerBox.getSelectedItem();
            logger.debug("Attempting to remove: " + controllerItem);
            String deviceDestroyMessage = "device destroy " + controllerItem;
            SampleEnvironmentPanel.this.sendManager.addMessage(deviceDestroyMessage);
            SampleEnvironmentPanel.this.addButton.setEnabled(true);
            SampleEnvironmentPanel.this.updateButton.setEnabled(false);
            SampleEnvironmentPanel.this.removeButton.setEnabled(false);
            SampleEnvironmentPanel.this.listBox.clearSelection();
            SampleEnvironmentPanel.this.listBoxFlag = false;
            if (controllerType.equals(SampleEnvironmentPanel.OTHER)) {
                SampleEnvironmentPanel.this.aliasField.setText(SampleEnvironmentPanel.EMPTY);
                SampleEnvironmentPanel.this.aliasField.setEnabled(true);
            }
        }
    }

    private class TemperaturePropertiesPanel
    extends JPanel {
        public JTextField maxUpperTiltField;
        public JTextField maxLowerTiltField;
        public JComboBox sampleChannelBox;
        public JComboBox controlChannelBox;
        public JRadioButton kelvinRadioButton;
        public JRadioButton celsiusRadioButton;
        public Vector<Character> numChannelList;

        public TemperaturePropertiesPanel() {
            this.setLayout(new GridBagLayout());
            JLabel maxUpperTiltLabel = SampleEnvironmentPanel.this.createLabel(I18N.getString("sampleEnvironment.upperTilt"), true);
            JLabel maxLowerTiltLabel = SampleEnvironmentPanel.this.createLabel(I18N.getString("sampleEnvironment.lowerTilt"), true);
            JLabel unitMeasurementLabel = new JLabel(I18N.getString("sampleEnvironment.unitOfMeasurement"));
            JLabel sampleChannelLabel = new JLabel(I18N.getString("sampleEnvironment.sampleChannel"));
            JLabel controlChannelLabel = new JLabel(I18N.getString("sampleEnvironment.controlChannel"));
            JLabel emptyLabel = new JLabel(" ");
            JLabel tiltWarningMessageLabel = SampleEnvironmentPanel.this.createLabel(I18N.getString("sampleEnvironment.TiltWarningMessage"), true);
            ButtonGroup unitGroup = new ButtonGroup();
            GridBagConstraints constraints = new GridBagConstraints();
            this.numChannelList = new Vector();
            this.sampleChannelBox = new JComboBox<Character>(this.numChannelList);
            this.controlChannelBox = new JComboBox<Character>(this.numChannelList);
            this.kelvinRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.kelvin"));
            this.celsiusRadioButton = new JRadioButton(I18N.getString("sampleEnvironment.celsius"));
            this.maxUpperTiltField = new JTextField(11);
            this.maxLowerTiltField = new JTextField(11);
            this.kelvinRadioButton.setEnabled(false);
            this.celsiusRadioButton.setEnabled(false);
            unitGroup.add(this.kelvinRadioButton);
            unitGroup.add(this.celsiusRadioButton);
            constraints.fill = 0;
            constraints.gridwidth = 5;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(0, 5, 0, 5);
            constraints.gridx = 0;
            constraints.gridy = 0;
            this.add((Component)tiltWarningMessageLabel, constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.gridy = 0;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.gridwidth = 1;
            constraints.insets = new Insets(5, 0, 0, 5);
            constraints.gridx = 0;
            constraints.gridy = 1;
            this.add((Component)maxUpperTiltLabel, constraints);
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            ++constraints.gridx;
            this.add((Component)maxLowerTiltLabel, constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 0, 0, 5);
            constraints.gridx = 0;
            constraints.gridy = 2;
            this.add((Component)this.maxUpperTiltField, constraints);
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            ++constraints.gridx;
            this.add((Component)this.maxLowerTiltField, constraints);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 5, 0, 0);
            constraints.gridx = 0;
            constraints.gridy = 3;
            this.add((Component)unitMeasurementLabel, constraints);
            ++constraints.gridx;
            this.add((Component)this.kelvinRadioButton, constraints);
            constraints.insets = new Insets(5, 0, 0, 30);
            ++constraints.gridx;
            this.add((Component)this.celsiusRadioButton, constraints);
            ++constraints.gridx;
            this.add((Component)emptyLabel, constraints);
            constraints.fill = 2;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(5, 0, 0, 15);
            constraints.gridx = 0;
            constraints.gridy = 4;
            this.add((Component)sampleChannelLabel, constraints);
            ++constraints.gridx;
            this.add((Component)this.sampleChannelBox, constraints);
            ++constraints.gridx;
            this.add((Component)controlChannelLabel, constraints);
            constraints.insets = new Insets(5, 0, 0, 0);
            ++constraints.gridx;
            this.add((Component)this.controlChannelBox, constraints);
        }
    }

    private class UpdateDeviceActionListener
    implements ActionListener {
        private UpdateDeviceActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Device controllerItem = (Device)SampleEnvironmentPanel.this.controllerBox.getSelectedItem();
            String controllerTypeItem = (String)SampleEnvironmentPanel.this.controllerTypeBox.getSelectedItem();
            logger.debug("Attempting to update device: " + controllerItem);
            if (SampleEnvironmentPanel.this.isErrorMessage()) {
                return;
            }
            if (SampleEnvironmentPanel.this.updateTiltDevices(controllerTypeItem)) {
                if (controllerTypeItem == SampleEnvironmentPanel.TEMPERATURE) {
                    String upperTiltLimitMessage = "device setproperty " + controllerItem + " " + "upperTiltLimit " + SampleEnvironmentPanel.this.tempProperties.maxUpperTiltField.getText();
                    String lowerTiltLimitMessage = "device setproperty " + controllerItem + " " + "lowerTiltLimit " + SampleEnvironmentPanel.this.tempProperties.maxLowerTiltField.getText();
                    String sampleChannelMessage = "device setproperty " + controllerItem + " " + "sampleSensorIndex " + SampleEnvironmentPanel.this.tempProperties.sampleChannelBox.getSelectedIndex();
                    String controlChannelMessage = "device setproperty " + controllerItem + " " + "controlSensorIndex " + SampleEnvironmentPanel.this.tempProperties.controlChannelBox.getSelectedIndex();
                    SampleEnvironmentPanel.this.sendManager.addMessage(upperTiltLimitMessage);
                    SampleEnvironmentPanel.this.sendManager.addMessage(lowerTiltLimitMessage);
                    SampleEnvironmentPanel.this.sendManager.addMessage(sampleChannelMessage);
                    SampleEnvironmentPanel.this.sendManager.addMessage(controlChannelMessage);
                } else if (controllerTypeItem == SampleEnvironmentPanel.MAGNET) {
                    int i = SampleEnvironmentPanel.this.magnetProperties.persistenceRadioButton.isSelected() ? 1 : 0;
                    String persistenceFlagMessage = "device setproperty " + controllerItem + " " + "persistenceFlag " + Integer.toString(i);
                    SampleEnvironmentPanel.this.sendManager.addMessage(persistenceFlagMessage);
                } else if (controllerTypeItem != SampleEnvironmentPanel.PRESSURE) {
                    // empty if block
                }
            } else {
                JOptionPane.showMessageDialog(SampleEnvironmentPanel.this.realParent, I18N.getString("sampleEnvironment.incompatibleLimits"));
            }
        }
    }
}

