/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.data.Sample;
import ice.event.SamplePropertyChangedEvent;
import ice.event.SamplePropertyChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceViewPanel;
import ice.swing.IceTextField;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PreferencesManager;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public abstract class BaseSampleAlignmentPanel
extends IceViewPanel
implements SamplePropertyChangedListener {
    protected static Logger logger = Logger.getLogger("PanelLogger.tas.SampleAlignmentPanel");
    protected SendQueueManager sendManager;
    protected Sample sample;
    protected IceTextField aField;
    protected IceTextField bField;
    protected IceTextField cField;
    protected IceTextField alphaField;
    protected IceTextField betaField;
    protected IceTextField gammaField;
    protected JLabel aLabel;
    protected JLabel bLabel;
    protected JLabel cLabel;
    protected JLabel alphaLabel;
    protected JLabel betaLabel;
    protected JLabel gammaLabel;
    protected JLabel aUnitLabel;
    protected JLabel bUnitLabel;
    protected JLabel cUnitLabel;
    protected JLabel alphaUnitLabel;
    protected JLabel betaUnitLabel;
    protected JLabel gammaUnitLabel;
    protected Action setSampleParametersAction;
    protected Action resetSampleParameterFieldsAction;
    private Controller controller;

    public BaseSampleAlignmentPanel() throws IcePanelException {
        super(I18N.getString("UBSampleAlignmentPanel.name"));
    }

    private void initBaseSampleAlignmentPanel() {
        this.controller = Controller.getReference();
        this.sample = this.controller.getSample();
        this.sendManager = this.controller.getSendManager();
        int fieldValueLength = 3;
        try {
            fieldValueLength = Integer.parseInt(PreferencesManager.getPreferenceString("sampleParameter.fieldValueLength"));
        }
        catch (NumberFormatException nfe) {
            String message = "Unable to get sample field value length.  Using default of " + fieldValueLength + ".  THIS SHOULDN'T HAPPEN!";
            logger.error(message, nfe);
        }
        this.aField = new IceTextField(5);
        this.bField = new IceTextField(fieldValueLength);
        this.cField = new IceTextField(fieldValueLength);
        this.alphaField = new IceTextField(fieldValueLength);
        this.betaField = new IceTextField(fieldValueLength);
        this.gammaField = new IceTextField(fieldValueLength);
        this.aLabel = new JLabel(I18N.getString("sample.a.label"));
        this.bLabel = new JLabel(I18N.getString("sample.b.label"));
        this.cLabel = new JLabel(I18N.getString("sample.c.label"));
        this.alphaLabel = new JLabel(I18N.getString("sample.alpha.label"));
        this.betaLabel = new JLabel(I18N.getString("sample.beta.label"));
        this.gammaLabel = new JLabel(I18N.getString("sample.gamma.label"));
        this.aUnitLabel = new JLabel(I18N.getString("angstrom.symbol"));
        this.bUnitLabel = new JLabel(I18N.getString("angstrom.symbol"));
        this.cUnitLabel = new JLabel(I18N.getString("angstrom.symbol"));
        this.alphaUnitLabel = new JLabel(I18N.getString("degree.symbol"));
        this.betaUnitLabel = new JLabel(I18N.getString("degree.symbol"));
        this.gammaUnitLabel = new JLabel(I18N.getString("degree.symbol"));
        this.aField.setColumns(5);
        this.bField.setColumns(5);
        this.cField.setColumns(5);
        this.aLabel.setName("a");
        this.bLabel.setName("b");
        this.cLabel.setName("c");
        this.alphaLabel.setName("alpha");
        this.betaLabel.setName("beta");
        this.gammaLabel.setName("gamma");
        this.setSampleParametersAction = new SetSampleParamsAction();
        this.resetSampleParameterFieldsAction = new ResetSampleParametersAction();
        try {
            this.sample.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("BaseSampleAlignment.initBaseSampleAlignmentPanel can't add listener " + e);
        }
    }

    @Override
    protected abstract void buildGUI();

    @Override
    protected abstract void init();

    @Override
    public final void processIcePanel() throws IcePanelException {
        try {
            this.initBaseSampleAlignmentPanel();
            this.init();
            this.buildGUI();
        }
        catch (Exception e) {
            this.handleIcePanelException(this.getName(), e);
        }
    }

    @Override
    public void actionPerformed(SamplePropertyChangedEvent pce) {
        Object source = pce.getSource();
        String propertyName = pce.getPropertyName();
        Object newValue = pce.getNewValue();
        SwingUtilities.invokeLater(new UpdateSampleFieldRunnable(propertyName, newValue));
    }

    protected void updateSampleField(String propertyName, Object value) {
    }

    public class ResetSampleParametersAction
    extends AbstractAction {
        public ResetSampleParametersAction() {
            super(I18N.getString("resetMessage"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseSampleAlignmentPanel.this.aField.setText(String.valueOf(BaseSampleAlignmentPanel.this.sample.getA()));
            BaseSampleAlignmentPanel.this.bField.setText(String.valueOf(BaseSampleAlignmentPanel.this.sample.getB()));
            BaseSampleAlignmentPanel.this.cField.setText(String.valueOf(BaseSampleAlignmentPanel.this.sample.getC()));
            BaseSampleAlignmentPanel.this.alphaField.setText(String.valueOf(BaseSampleAlignmentPanel.this.sample.getAlpha()));
            BaseSampleAlignmentPanel.this.betaField.setText(String.valueOf(BaseSampleAlignmentPanel.this.sample.getBeta()));
            BaseSampleAlignmentPanel.this.gammaField.setText(String.valueOf(BaseSampleAlignmentPanel.this.sample.getGamma()));
        }
    }

    public class SetSampleParamsAction
    extends AbstractAction {
        public SetSampleParamsAction() {
            super(I18N.getString("applyMessage"));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (this.determineValidity()) {
                Double a = Double.valueOf(BaseSampleAlignmentPanel.this.aField.getText());
                Double b = Double.valueOf(BaseSampleAlignmentPanel.this.bField.getText());
                Double c = Double.valueOf(BaseSampleAlignmentPanel.this.cField.getText());
                Double alpha = Double.valueOf(BaseSampleAlignmentPanel.this.alphaField.getText());
                Double beta = Double.valueOf(BaseSampleAlignmentPanel.this.betaField.getText());
                Double gamma = Double.valueOf(BaseSampleAlignmentPanel.this.gammaField.getText());
                StringBuilder commandBuilder = new StringBuilder("sample setlattice");
                commandBuilder.append(" -a ");
                commandBuilder.append(a);
                commandBuilder.append(" -b ");
                commandBuilder.append(b);
                commandBuilder.append(" -c ");
                commandBuilder.append(c);
                commandBuilder.append(" -alpha ");
                commandBuilder.append(alpha);
                commandBuilder.append(" -beta ");
                commandBuilder.append(beta);
                commandBuilder.append(" -gamma ");
                commandBuilder.append(gamma);
                BaseSampleAlignmentPanel.this.sendManager.addMessage(commandBuilder.toString());
            }
        }

        public boolean determineValidity() {
            boolean allValid = true;
            LinkedHashMap<IceTextField, Boolean> validNumberMap = new LinkedHashMap<IceTextField, Boolean>();
            LinkedHashMap<IceTextField, JLabel> fieldLabelMap = new LinkedHashMap<IceTextField, JLabel>();
            String errorMsg = I18N.getString("invalidNumberError");
            StringBuilder errorMsgSuffixBuilder = new StringBuilder();
            validNumberMap.put(BaseSampleAlignmentPanel.this.aField, BaseSampleAlignmentPanel.this.aField.containsNonNegativeNumber());
            validNumberMap.put(BaseSampleAlignmentPanel.this.bField, BaseSampleAlignmentPanel.this.bField.containsNonNegativeNumber());
            validNumberMap.put(BaseSampleAlignmentPanel.this.cField, BaseSampleAlignmentPanel.this.cField.containsNonNegativeNumber());
            validNumberMap.put(BaseSampleAlignmentPanel.this.alphaField, BaseSampleAlignmentPanel.this.alphaField.containsNonNegativeNumber());
            validNumberMap.put(BaseSampleAlignmentPanel.this.betaField, BaseSampleAlignmentPanel.this.betaField.containsNonNegativeNumber());
            validNumberMap.put(BaseSampleAlignmentPanel.this.gammaField, BaseSampleAlignmentPanel.this.gammaField.containsNonNegativeNumber());
            fieldLabelMap.put(BaseSampleAlignmentPanel.this.aField, BaseSampleAlignmentPanel.this.aLabel);
            fieldLabelMap.put(BaseSampleAlignmentPanel.this.bField, BaseSampleAlignmentPanel.this.bLabel);
            fieldLabelMap.put(BaseSampleAlignmentPanel.this.cField, BaseSampleAlignmentPanel.this.cLabel);
            fieldLabelMap.put(BaseSampleAlignmentPanel.this.alphaField, BaseSampleAlignmentPanel.this.alphaLabel);
            fieldLabelMap.put(BaseSampleAlignmentPanel.this.betaField, BaseSampleAlignmentPanel.this.betaLabel);
            fieldLabelMap.put(BaseSampleAlignmentPanel.this.gammaField, BaseSampleAlignmentPanel.this.gammaLabel);
            for (JComponent field : validNumberMap.keySet()) {
                if (((Boolean)validNumberMap.get(field)).booleanValue()) continue;
                allValid = false;
                errorMsgSuffixBuilder.append(", " + ((JLabel)fieldLabelMap.get(field)).getName());
            }
            if (allValid) {
                return true;
            }
            errorMsg = errorMsg.concat(errorMsgSuffixBuilder.substring(2));
            BaseSampleAlignmentPanel.this.throwErrorDialog(I18N.getString("invalidNumber.title"), errorMsg);
            return false;
        }
    }

    protected class UpdateSampleFieldRunnable
    implements Runnable {
        protected String propertyName;
        protected Object newValue;

        public UpdateSampleFieldRunnable(String propertyName, Object newValue) {
            this.propertyName = propertyName;
            this.newValue = newValue;
        }

        @Override
        public void run() {
            if (Sample.aFieldName.equals(this.propertyName)) {
                BaseSampleAlignmentPanel.this.aField.setText(this.newValue.toString());
            } else if (Sample.bFieldName.equals(this.propertyName)) {
                BaseSampleAlignmentPanel.this.bField.setText(this.newValue.toString());
            } else if (Sample.cFieldName.equals(this.propertyName)) {
                BaseSampleAlignmentPanel.this.cField.setText(this.newValue.toString());
            } else if (Sample.alphaFieldName.equals(this.propertyName)) {
                BaseSampleAlignmentPanel.this.alphaField.setText(this.newValue.toString());
            } else if (Sample.betaFieldName.equals(this.propertyName)) {
                BaseSampleAlignmentPanel.this.betaField.setText(this.newValue.toString());
            } else if (Sample.gammaFieldName.equals(this.propertyName)) {
                BaseSampleAlignmentPanel.this.gammaField.setText(this.newValue.toString());
            }
        }
    }
}

