/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.tas.macs;

import com.l2fprod.common.swing.JTaskPaneGroup;
import ice.Controller;
import ice.communication.CommunicationManager;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.Instrument;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.ListControlEvent;
import ice.event.ListControlListener;
import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.FitData;
import ice.gui.core.PlotPanel;
import ice.swing.ListControl;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import ptolemy.plot.Plot;

public class LiveDataPanel
extends PlotPanel
implements ItemListener,
ListControlListener,
DataMessageListener,
DeviceListListener,
DeviceValueChangedListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.LiveDataLogger");
    private static final int NUM_OF_PLOT_COLORS = 11;
    public static final String DIFF = "DIFF";
    public static final String SPEC = "SPEC";
    public static final String TIME = "Time";
    public static final String MONITOR = "Monitor";
    public static final String DET = "Det";
    public static final String KIDNEY = "KIDNEY";
    public static final String DATA = "DATA";
    public static final String DETPOS = "DetPos";
    public static final String PTAI = "PTAI";
    public static final String A4 = "A4";
    public static final String NO_FIT = "Do Not Show Fit";
    public static final String FLAT_FIT = "P0";
    public static final String LINEAR_FIT = "P1";
    public static final String QUADRATIC_FIT = "P2";
    public static final String MON = "Mon";
    private Instrument instrument;
    private TreeMap<Integer, TreeMap<String, Double>> counterMap;
    private TreeMap<Integer, TreeMap<String, Double>> deviceMap;
    private TreeMap<Integer, TreeMap<String, Double>> detPosMap;
    private JComboBox xVarComboBox;
    private ListControl listControl;
    private Plot plot;
    private Plot fitPlot;
    private JPanel statusBar;
    private JLabel currPointLabel;
    private JLabel totalPointsLabel;
    protected int numScanPoints;
    private ArrayList<String> selectedCounters;
    private String selectedDevice;
    private TreeMap<String, ArrayList<Double>> yFitPointsMap;
    private TreeMap<String, ArrayList<Double>> xFitPointsMap;
    private ArrayList<String> allDeviceNames;
    private ArrayList<String> allCounterNames;
    private JComboBox fitComboBox;
    private Controller controller;

    public LiveDataPanel() throws IcePanelException {
        super("Live Data");
    }

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        this.instrument = this.controller.getInstrument();
        this.plot = new Plot();
        this.plot.setMarksStyle("various");
        this.fitPlot = new Plot();
        this.fitPlot.setMarksStyle("none");
        this.counterMap = new TreeMap();
        this.deviceMap = new TreeMap();
        this.detPosMap = new TreeMap();
        this.yFitPointsMap = new TreeMap();
        this.xFitPointsMap = new TreeMap();
        this.statusBar = new JPanel();
        this.currPointLabel = new JLabel();
        this.totalPointsLabel = new JLabel();
        this.selectedCounters = new ArrayList();
        this.selectedDevice = null;
        this.allCounterNames = new ArrayList();
        this.allDeviceNames = new ArrayList();
        this.controller.getDeviceListeners().add(this);
        this.controller.addDeviceListListener(this);
        CommunicationManager comManager = this.controller.getCommMgr();
        try {
            this.instrument.addPropertyChangeListener(this);
            comManager.addDataMessageListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("LiveDataPanel.init could not add listener " + e);
        }
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        JLabel xVarLabel = new JLabel("Devices:");
        String[] emptyList1 = new String[]{"N/A"};
        this.xVarComboBox = new JComboBox<String>(emptyList1);
        this.xVarComboBox.addItemListener(this);
        JTaskPaneGroup taskPanel = new JTaskPaneGroup();
        taskPanel.setTitle("Properties");
        taskPanel.setLayout(new GridBagLayout());
        GridBagConstraints taskConstraints = new GridBagConstraints();
        this.listControl = new ListControl(this.instrument.getName());
        this.listControl.addListControlListener(this);
        this.selectedCounters = new ArrayList<String>(this.listControl.getSelectedItems());
        this.resizePlot(this.selectedCounters);
        String[] fitOptions = new String[]{NO_FIT, FLAT_FIT, LINEAR_FIT, QUADRATIC_FIT};
        this.fitComboBox = new JComboBox<String>(fitOptions);
        this.fitComboBox.setSelectedIndex(0);
        this.fitComboBox.addItemListener(this);
        taskConstraints.gridheight = 3;
        taskPanel.add((Component)this.listControl, taskConstraints);
        taskConstraints.insets = new Insets(15, 10, 0, 0);
        taskConstraints.anchor = 18;
        taskConstraints.fill = 2;
        taskConstraints.gridheight = 1;
        taskPanel.add((Component)xVarLabel, taskConstraints);
        taskConstraints.gridx = 1;
        taskConstraints.gridy = 1;
        mainConstraints.fill = 2;
        taskPanel.add((Component)this.xVarComboBox, taskConstraints);
        taskConstraints.gridx = 1;
        taskConstraints.gridy = 2;
        taskPanel.add((Component)this.fitComboBox, taskConstraints);
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.fill = 0;
        mainPanel.add((Component)taskPanel, mainConstraints);
        mainConstraints.ipady = 0;
        ++mainConstraints.gridy;
        mainConstraints.fill = 2;
        mainConstraints.weightx = 1.0;
        mainConstraints.weighty = 0.0;
        mainPanel.add((Component)this.plot, mainConstraints);
        this.add(mainPanel);
        this.buildStatusBar();
        Thread thread1 = new Thread(new UpdateScanVars(this.xVarComboBox));
        SwingUtilities.invokeLater(thread1);
    }

    private void buildStatusBar() {
        this.statusBar.setLayout(new BoxLayout(this.statusBar, 0));
        this.currPointLabel.setText("Current Point: N/A");
        this.totalPointsLabel.setText("Total Points: N/A");
        this.statusBar.add(this.currPointLabel);
        this.statusBar.add(new JLabel(", "));
        this.statusBar.add(this.totalPointsLabel);
        this.layeredStatusPane.add((Component)this.statusBar, new Integer(1));
        this.layeredStatusPane.revalidate();
        this.layeredStatusPane.repaint();
    }

    protected void setupForNewScan(int numPoints, String fileName) {
        this.numScanPoints = numPoints;
        logger.debug("new data point set");
        this.clearGraphs("File: " + fileName);
        this.currPointLabel.setText("Current Point: N/A");
        this.totalPointsLabel.setText("Total Points: " + this.numScanPoints);
        this.deviceMap.clear();
        this.counterMap.clear();
        this.xFitPointsMap.clear();
        this.yFitPointsMap.clear();
        this.detPosMap.clear();
        PlotPanel.ResetGraph rg = new PlotPanel.ResetGraph(this.plot, "File: " + fileName, "Counters", "Devices");
        SwingUtilities.invokeLater(rg);
    }

    private synchronized void plotPoint(int dataset, double x, double y) {
        SwingUtilities.invokeLater(new PlotPanel.PlotPoint(this.plot, dataset, x, y, false, y - Math.sqrt(y), y + Math.sqrt(y), true));
    }

    public synchronized void clearGraphs(String title) {
        logger.debug("Clearing graph.");
        SwingUtilities.invokeLater(new PlotPanel.ClearGraph(this.plot, title));
    }

    public synchronized void resizePlot(int numOfChannels) {
        logger.debug("resizing the plot.");
        SwingUtilities.invokeLater((PlotPanel)this.new PlotPanel.ResizePlot(this.plot, numOfChannels));
        Container topParent = this.getParent();
        if (topParent != null) {
            this.revalidate();
            topParent.repaint();
        }
    }

    public synchronized void resizePlot(ArrayList<String> items) {
        logger.debug("resizing the plot.");
        SwingUtilities.invokeLater((PlotPanel)this.new PlotPanel.ResizePlot(this.plot, items));
        Container topParent = this.getParent();
        if (topParent != null) {
            this.revalidate();
            topParent.repaint();
        }
    }

    private void plotA4DetPositions() {
        int firstPoint = this.deviceMap.firstKey();
        int lastPoint = this.deviceMap.lastKey();
        int i = firstPoint;
        while (i <= lastPoint) {
            TreeMap<String, Double> xValues = this.detPosMap.get(i);
            TreeMap<String, Double> yValues = this.counterMap.get(i);
            int dataset = 0;
            for (String key : this.selectedCounters) {
                Double yValue = yValues.get(key);
                String detCounter = null;
                Pattern pattern = Pattern.compile("(\\d+)");
                Matcher matcher = pattern.matcher(key);
                if (matcher.find()) {
                    detCounter = matcher.group(1);
                }
                Double xValue = null;
                if (detCounter != null) {
                    xValue = xValues.get(DETPOS + detCounter);
                } else {
                    TreeMap<String, Double> deviceValues = this.deviceMap.get(i);
                    xValue = deviceValues.get(A4);
                }
                if (xValue != null && yValue != null) {
                    this.plotPoint(dataset++, xValue, yValue);
                    continue;
                }
                logger.error(" RG Plotting Error: Unable to get points to plot for: " + key);
            }
            ++i;
        }
    }

    public synchronized void replotGraph() {
        int size = this.deviceMap.size();
        if (size == 0) {
            return;
        }
        PlotPanel.ClearGraph clearGraph = new PlotPanel.ClearGraph(this.plot, null);
        SwingUtilities.invokeLater(clearGraph);
        if (this.selectedDevice == null) {
            return;
        }
        if (this.selectedDevice.equalsIgnoreCase(A4)) {
            this.plotA4DetPositions();
        } else {
            int firstPoint = this.deviceMap.firstKey();
            int lastPoint = this.deviceMap.lastKey();
            int i = firstPoint;
            while (i <= lastPoint) {
                TreeMap<String, Double> xValues = this.deviceMap.get(i);
                TreeMap<String, Double> yValues = this.counterMap.get(i);
                if (xValues != null) {
                    Double xValue = xValues.get(this.selectedDevice);
                    int dataset = 0;
                    for (String key : this.selectedCounters) {
                        Double yValue = yValues.get(key);
                        if (xValue != null && yValue != null) {
                            this.plotPoint(dataset++, xValue, yValue);
                            continue;
                        }
                        logger.error(" RG Plotting Error: Unable to get points to plot for: " + key);
                    }
                } else {
                    System.out.println("no data available for " + this.selectedDevice);
                }
                ++i;
            }
        }
        String fitOption = (String)this.fitComboBox.getSelectedItem();
        if (!fitOption.equalsIgnoreCase(NO_FIT)) {
            if (this.selectedDevice.equalsIgnoreCase(A4)) {
                this.plotA4FittedSelectedCounters(fitOption);
            } else {
                this.plotFittedSelectedCounters(fitOption);
            }
        }
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 1) {
            Object object = ie.getSource();
            if (object == this.xVarComboBox) {
                JComboBox cb = (JComboBox)object;
                this.selectedDevice = (String)cb.getSelectedItem();
                this.listControl.updateCurrentDevice(this.selectedDevice);
                this.replotGraph();
            } else if (object == this.fitComboBox) {
                this.replotGraph();
            }
        } else {
            this.replotGraph();
        }
    }

    @Override
    public void selectionChanged(ListControlEvent lce) {
        this.selectedCounters = new ArrayList<String>(lce.getSelectedItems());
        SwingUtilities.invokeLater(new PlotPanel.ClearGraph(this.plot, null));
        this.resizePlot(this.selectedCounters);
        this.replotGraph();
    }

    @Override
    public void updateLockState() {
    }

    private void plotFittedSelectedCounters(String fitOption) {
        int offset = this.selectedCounters.size() / 11 + 1;
        int counter = 0;
        int pos = 0;
        this.calculateFitPoints(fitOption);
        for (String key : this.selectedCounters) {
            pos = counter + offset * 11;
            this.plot.setMarksStyle("none", pos);
            ++counter;
            logger.error("offset " + offset + " size " + this.selectedCounters.size() + " pos " + pos);
            if (this.xFitPointsMap.size() == 0) {
                return;
            }
            ArrayList<Double> xValues = this.xFitPointsMap.get(String.valueOf(this.selectedDevice) + key + fitOption);
            ArrayList<Double> yValues = this.yFitPointsMap.get(String.valueOf(this.selectedDevice) + key + fitOption);
            if (xValues == null || yValues == null) {
                logger.error("fit point does not exist for: " + this.selectedDevice + key + fitOption);
                return;
            }
            int i = 0;
            while (i < xValues.size()) {
                if (xValues != null && yValues != null) {
                    SwingUtilities.invokeLater(new PlotPanel.PlotPoint(this.plot, pos, xValues.get(i), yValues.get(i), true, true));
                } else {
                    logger.error("RDM Fitting Error: Unable to get points to plot for: " + key);
                }
                ++i;
            }
        }
    }

    private void plotA4FittedSelectedCounters(String fitOption) {
        int offset = this.selectedCounters.size() / 11 + 1;
        int counter = 0;
        int pos = 0;
        this.calculateA4FitPoints(fitOption);
        pos = counter + offset * 11;
        ++counter;
        this.plot.setMarksStyle("none", pos);
        logger.debug("offset " + offset + " size " + this.selectedCounters.size() + " pos " + pos);
        if (this.xFitPointsMap.size() == 0) {
            return;
        }
        ArrayList<Double> xValues = this.xFitPointsMap.get(String.valueOf(this.selectedCounters.toString()) + fitOption);
        ArrayList<Double> yValues = this.yFitPointsMap.get(String.valueOf(this.selectedCounters.toString()) + fitOption);
        if (xValues != null && yValues != null) {
            int i = 0;
            while (i < xValues.size()) {
                SwingUtilities.invokeLater(new PlotPanel.PlotPoint(this.plot, pos, xValues.get(i), yValues.get(i), true, true));
                ++i;
            }
        } else {
            logger.error("Plotting Fitted Points Error: Unable to get points: the values are null ");
        }
    }

    @Override
    public void actionPerformed(DataMessageEvent dme) {
        if (dme.isNewStart()) {
            this.setupForNewScan(dme.getNumPoints(), dme.getFilename());
            return;
        }
        if (this.numScanPoints == 0) {
            this.setupForNewScan(20, "undefined");
        }
        if (dme.hasFinished()) {
            String fitOption = (String)this.fitComboBox.getSelectedItem();
            if (!fitOption.equalsIgnoreCase(NO_FIT)) {
                if (this.selectedDevice.equalsIgnoreCase(A4)) {
                    this.plotA4FittedSelectedCounters(fitOption);
                } else {
                    this.plotFittedSelectedCounters(fitOption);
                }
            }
            return;
        }
        if (!dme.hasFitData()) {
            int pointNum = dme.getPointNum();
            this.currPointLabel.setText("Current Point: " + pointNum);
            Map<String, Double> pointMap = dme.getPointMap();
            this.parseMessage(pointNum, pointMap);
            if (this.selectedDevice != null && this.selectedDevice.equalsIgnoreCase(A4)) {
                this.plotA4DetPositions();
            } else {
                this.plotSelectedCounters(pointMap);
            }
        }
    }

    private void plotSelectedCounters(Map<String, Double> pointMap) {
        Double xValue = pointMap.get(this.selectedDevice);
        int dataset = 0;
        for (String key : this.selectedCounters) {
            Double yValue = pointMap.get(key);
            if (xValue != null && yValue != null) {
                this.plotPoint(dataset++, xValue, yValue);
                continue;
            }
            logger.error(" RDM Plotting Error: Unable to get points to plot for: " + key);
        }
    }

    private void parseDeviceAndCounterNames(ArrayList<String> message) {
        this.allDeviceNames.clear();
        for (String value : message) {
            if (value.matches("(?i)^DIFF.*") || value.matches("(?i)^SPEC.*") || value.matches("(?i)^Time.*") || value.matches("(MON)") || value.matches("(MONITOR)")) {
                this.allCounterNames.add(value);
                continue;
            }
            if (value.matches("(?i)^DetPos.*")) continue;
            this.allDeviceNames.add(value);
        }
    }

    private void parseMessage(int pos, Map<String, Double> pointMap) {
        TreeMap<String, Double> xValues = new TreeMap<String, Double>();
        TreeMap<String, Double> yValues = new TreeMap<String, Double>();
        TreeMap<String, Double> yDetPosValues = new TreeMap<String, Double>();
        for (String key : pointMap.keySet()) {
            if (key.startsWith(DIFF) || key.startsWith(SPEC) || key.startsWith(TIME) || key.startsWith(MON)) {
                yValues.put(key, pointMap.get(key));
                continue;
            }
            if (!key.startsWith(DETPOS)) continue;
            yDetPosValues.put(key, pointMap.get(key));
        }
        this.detPosMap.put(pos, yDetPosValues);
        this.counterMap.put(pos, yValues);
        int i = 0;
        while (i < this.xVarComboBox.getModel().getSize()) {
            String key = (String)this.xVarComboBox.getModel().getElementAt(i);
            xValues.put(key, pointMap.get(key));
            ++i;
        }
        this.deviceMap.put(pos, xValues);
    }

    private void calculateFitPoints(String fitOption) {
        double[] x = new double[this.counterMap.size()];
        double[] y = new double[this.counterMap.size()];
        int firstRecordedPoint = this.deviceMap.firstKey();
        Set<Integer> devicePoints = this.deviceMap.keySet();
        for (Integer point : devicePoints) {
            TreeMap<String, Double> xValues = this.deviceMap.get(point);
            try {
                x[point.intValue() - firstRecordedPoint] = xValues.get(this.selectedDevice);
            }
            catch (Exception e) {
                logger.error("Live Data Panel Error", e.getCause());
            }
        }
        for (String yKey : this.selectedCounters) {
            if (this.yFitPointsMap.containsKey(String.valueOf(this.selectedDevice) + yKey + fitOption)) continue;
            Set<Integer> points = this.counterMap.keySet();
            for (Integer point : points) {
                TreeMap<String, Double> yValues = this.counterMap.get(point);
                try {
                    y[point.intValue() - firstRecordedPoint] = yValues.get(yKey);
                }
                catch (Exception e) {
                    logger.error("Live Data Panel Error", e.getCause());
                }
            }
            FitData.calculateFitPoints(x, y, fitOption);
            ArrayList<Double> yFitPoints = FitData.getYFitPoints();
            ArrayList<Double> xFitPoints = FitData.getXFitPoints();
            if (yFitPoints.size() == 0) continue;
            this.yFitPointsMap.put(String.valueOf(this.selectedDevice) + yKey + fitOption, yFitPoints);
            this.xFitPointsMap.put(String.valueOf(this.selectedDevice) + yKey + fitOption, xFitPoints);
        }
    }

    private void calculateA4FitPoints(String fitOption) {
        int size = this.selectedCounters.size() * this.detPosMap.size();
        double[] x = new double[size];
        double[] y = new double[size];
        int xCtr = 0;
        int firstPoint = this.detPosMap.firstKey();
        int lastPoint = this.detPosMap.lastKey();
        for (String key : this.selectedCounters) {
            int i = firstPoint;
            while (i <= lastPoint) {
                TreeMap<String, Double> xValues = this.detPosMap.get(i);
                TreeMap<String, Double> yValues = this.counterMap.get(i);
                String detCounter = null;
                Pattern pattern = Pattern.compile("(\\d+)");
                Matcher matcher = pattern.matcher(key);
                if (matcher.find()) {
                    detCounter = matcher.group(1);
                }
                if (detCounter != null) {
                    try {
                        x[xCtr] = xValues.get(DETPOS + detCounter);
                        y[xCtr++] = yValues.get(key);
                    }
                    catch (Exception e) {
                        logger.error("Live Data Panel Error", e.getCause());
                    }
                }
                ++i;
            }
        }
        FitData.calculateFitPoints(x, y, fitOption);
        ArrayList<Double> yFitPoints = FitData.getYFitPoints();
        ArrayList<Double> xFitPoints = FitData.getXFitPoints();
        if (yFitPoints.size() != 0) {
            this.yFitPointsMap.put(String.valueOf(this.selectedCounters.toString()) + fitOption, yFitPoints);
            this.xFitPointsMap.put(String.valueOf(this.selectedCounters.toString()) + fitOption, xFitPoints);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        int index;
        String name;
        ArrayList<InstalledDevice> addedDevices = dle.getDevicesAdded();
        List<InstalledDevice> removedDevices = dle.getDevicesRemoved();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.xVarComboBox.getModel();
        for (InstalledDevice addDevice : addedDevices) {
            name = addDevice.getName();
            index = model.getIndexOf(name);
            if (index == -1) {
                model.addElement(name);
            }
            try {
                addDevice.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                e.printStackTrace();
            }
        }
        for (InstalledDevice removeDevice : removedDevices) {
            name = removeDevice.getName();
            index = model.getIndexOf(name);
            if (index == -1) continue;
            model.removeElementAt(index);
        }
        Thread thread2 = new Thread(new UpdateScanVars(this.xVarComboBox));
        SwingUtilities.invokeLater(thread2);
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent dvce) {
        String propertyName = dvce.getPropertyName();
        if (propertyName.equalsIgnoreCase("alias")) {
            String alias2 = (String)dvce.getNewValue();
            InstalledDevice device = (InstalledDevice)dvce.getSource();
            String name = device.getRealName();
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.xVarComboBox.getModel();
            model.removeElement(name);
            model.addElement(alias2);
        }
    }

    private class UpdateScanVars
    implements Runnable {
        private JComboBox scanVarComboBox;

        public UpdateScanVars(JComboBox scanVarComboBox) {
            this.scanVarComboBox = scanVarComboBox;
        }

        @Override
        public void run() {
            Controller controller = Controller.getReference();
            ArrayList<InstalledDevice> devices = controller.getDeviceList();
            this.scanVarComboBox.removeAllItems();
            for (InstalledDevice device : devices) {
                InstalledDevice.Type deviceType = device.getType();
                if (deviceType == InstalledDevice.Type.counter) continue;
                String deviceName = device.getName();
                this.scanVarComboBox.addItem(deviceName);
            }
            if (this.scanVarComboBox.getModel().getSize() > 1) {
                this.scanVarComboBox.setSelectedIndex(0);
            }
        }
    }
}

