/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.tas;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.event.communication.InstrumentChangeEvent;
import ice.event.communication.InstrumentChangeListener;
import ice.event.communication.util.UBMatrixAskCommandListenerUtil;
import ice.exceptions.IcePanelException;
import ice.exceptions.IcePanelUncheckedException;
import ice.gui.core.IceViewPanel;
import ice.gui.tas.BaseSampleAlignmentPanel;
import ice.gui.tas.SampleAlignmentNonWizardPanel;
import ice.gui.tas.bt7.sampleAlignment.SampleAlignmentComboBox;
import ice.gui.tas.bt7.sampleAlignment.SampleAlignmentMenuItem;
import ice.gui.tas.bt7.sampleAlignment.SampleAlignmentModes;
import ice.gui.tas.bt7.sampleAlignment.ubMatrix.UBSampleAlignmentPanel;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class SampleAlignmentPanel
extends IceViewPanel
implements ActionListener,
InstrumentChangeListener {
    private static final String ALIGMENT_COMBO_BOX_LABEL_KEY = "ice.gui.tas.bt7.CompositeSampleAlignement.AlignmentComboBoxLabel";
    protected static final int SAMPLE_ALIGNNMENT_COMBOBOX_LABEL_INDEX = 0;
    protected static final int SAMPLE_ALIGNNMENT_COMBOBOX_INDEX = 1;
    protected static final int SAMPLE_ALIGNMENT_PANEL_INDEX = 2;
    private static final long serialVersionUID = 1L;
    private static final String NAME_KEY = "ice.gui.tas.bt7.CompositeSampleAlignement.name";
    JScrollPane scrollPane;
    protected SendQueueManager sendManager;
    protected SampleAlignmentComboBox sampleAlignmentComboBox;
    protected Hashtable<SampleAlignmentModes, BaseSampleAlignmentPanel> sampleAlignmentPanels;
    private Controller controller;

    public SampleAlignmentPanel() throws IcePanelException {
        super("Sample Alignment");
    }

    @Override
    protected void init() {
        String name = null;
        this.controller = Controller.getReference();
        this.sendManager = this.controller.getSendManager();
        try {
            this.controller.getCommMgr().addInstrumentChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("CompositeSampleAlignment.init can't add listener " + e);
        }
        this.sampleAlignmentPanels = new Hashtable();
        name = I18N.getString(NAME_KEY);
        this.setName(name);
    }

    protected GridBagConstraints getCleanGridBagConstraints() {
        GridBagConstraints returnValue = null;
        Insets itemInset = null;
        itemInset = new Insets(2, 5, 2, 5);
        returnValue = new GridBagConstraints();
        returnValue.fill = 2;
        returnValue.anchor = 18;
        returnValue.insets = itemInset;
        returnValue.weightx = 1.0;
        returnValue.weighty = 0.0;
        return returnValue;
    }

    @Override
    protected void buildGUI() {
        SampleAlignmentNonWizardPanel nonUBSampleAlignmentPanel;
        UBSampleAlignmentPanel ubSampleAlignmentPanel;
        GridBagLayout gridBagLayout = null;
        JLabel label = null;
        GridBagConstraints gridBagConstraints = null;
        String alignmentLabel = null;
        gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        alignmentLabel = I18N.getString(ALIGMENT_COMBO_BOX_LABEL_KEY);
        label = new JLabel(alignmentLabel);
        gridBagConstraints = this.getCleanGridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)label, gridBagConstraints);
        gridBagConstraints = this.getCleanGridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        this.sampleAlignmentComboBox = new SampleAlignmentComboBox();
        this.add((Component)this.sampleAlignmentComboBox, gridBagConstraints);
        this.sampleAlignmentComboBox.addActionListener(this);
        try {
            ubSampleAlignmentPanel = new UBSampleAlignmentPanel();
            nonUBSampleAlignmentPanel = new SampleAlignmentNonWizardPanel();
        }
        catch (IcePanelException e1) {
            throw new IcePanelUncheckedException(e1);
        }
        this.addPanel(SampleAlignmentModes.UB_ON, ubSampleAlignmentPanel);
        this.addPanel(SampleAlignmentModes.UB_OFF, nonUBSampleAlignmentPanel);
        if (this.controller.getInstrument().isUbMode()) {
            this.setMode(SampleAlignmentModes.UB_ON);
        } else {
            this.setMode(SampleAlignmentModes.UB_OFF);
        }
        try {
            this.controller.addSampleChangeListener(nonUBSampleAlignmentPanel);
            this.controller.getCommMgr().addAngleCalcListener(nonUBSampleAlignmentPanel);
            this.controller.addSampleChangeListener(ubSampleAlignmentPanel);
            this.controller.getCommMgr().addAngleCalcListener(ubSampleAlignmentPanel);
            this.controller.getCommMgr().addUBMatrixAskCommandListener(ubSampleAlignmentPanel);
            this.controller.getCommMgr().addUBMatrixChangeListener(ubSampleAlignmentPanel);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("CompositeSampleAlignment.init could not add listener " + e);
        }
    }

    public void addPanel(SampleAlignmentModes mode, BaseSampleAlignmentPanel sampleAlignmentPanel) {
        this.sampleAlignmentPanels.put(mode, sampleAlignmentPanel);
    }

    public void setMode(SampleAlignmentModes mode) {
        Container bugWorkAround;
        BaseSampleAlignmentPanel newPanel = null;
        GridBagConstraints gridBagConstraints = null;
        this.sampleAlignmentComboBox.setSelected(mode, true);
        int componentCount = this.getComponentCount();
        if (componentCount > 2) {
            this.remove(2);
            this.invalidate();
        }
        if ((newPanel = this.sampleAlignmentPanels.get((Object)mode)) != null) {
            gridBagConstraints = this.getCleanGridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            this.add((Component)newPanel, gridBagConstraints);
            newPanel.invalidate();
        }
        if ((bugWorkAround = this.getParent()) != null) {
            ((JViewport)bugWorkAround).removeAll();
            ((JViewport)bugWorkAround).add(this);
        }
        if (mode == SampleAlignmentModes.UB_ON) {
            String askCmd = UBMatrixAskCommandListenerUtil.buildUBPrintCommand();
            this.sendManager.addMessage(askCmd);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object theSource = null;
        theSource = e.getSource();
        if (theSource instanceof SampleAlignmentComboBox) {
            String actionCommand = null;
            actionCommand = e.getActionCommand();
            if (actionCommand.compareTo("SampleAlignmentComboBoxChanged") == 0) {
                SampleAlignmentMenuItem selected = null;
                selected = (SampleAlignmentMenuItem)this.sampleAlignmentComboBox.getSelectedItem();
                if (selected != null) {
                    String theCommand = null;
                    SampleAlignmentModes theMode = null;
                    theMode = selected.getMode();
                    theCommand = theMode.command();
                    this.sendManager.addMessage(theCommand);
                }
            }
        }
    }

    @Override
    public synchronized void actionPerformed(InstrumentChangeEvent ice) {
        if (this.controller.isInstrumentInitialized()) {
            if (this.controller.getInstrument().isUbMode()) {
                this.setMode(SampleAlignmentModes.UB_ON);
            } else {
                this.setMode(SampleAlignmentModes.UB_OFF);
            }
        }
    }
}

