/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.gui.panel.sans.subpanels.autodata.RunListTable;
import ice.gui.panel.sans.subpanels.autodata.SansTableModel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.swing.JTable;

public class TableTextPrintable
implements Printable {
    private static final String emptySpace = "";
    private static final String fontName = "Courier New";
    private static final int fontSize = 10;
    private RunListTable tableManager;
    private JTable table;
    private SansTableModel tableModel;
    private ArrayList<String> columnNames;
    private int from;
    private int to;
    private int[] pageBreaks;
    String[] textLines;
    String headerLine;
    ArrayList<Integer> colWidths;
    final String headerText;
    final String footerText;

    public TableTextPrintable(RunListTable tableManager, int from, int to, String header, String footer) {
        this.tableManager = tableManager;
        this.from = from;
        this.to = to;
        this.headerText = header;
        this.footerText = footer;
        this.init();
    }

    private void init() {
        this.table = this.tableManager.getRunListTable();
        this.tableModel = (SansTableModel)this.table.getModel();
        this.columnNames = this.tableModel.getHeaderNames();
        this.colWidths = new ArrayList();
        int rowCount = this.table.getRowCount();
        if (this.from < 0) {
            this.from = 0;
        }
        if (this.to > rowCount) {
            this.to = rowCount;
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D graphics = (Graphics2D)g;
        Font font = new Font(fontName, 0, 10);
        FontMetrics metrics = g.getFontMetrics(font);
        int lineHeight = metrics.getHeight();
        graphics.setColor(Color.black);
        metrics = graphics.getFontMetrics();
        graphics.setFont(font);
        if (this.pageBreaks == null) {
            this.contvertTableRowsToText();
            int linesPerPage = (int)(pageFormat.getImageableHeight() / (double)lineHeight);
            int numBreaks = (this.textLines.length - 1) / linesPerPage;
            this.pageBreaks = new int[numBreaks];
            int b = 0;
            while (b < numBreaks) {
                this.pageBreaks[b] = (b + 1) * linesPerPage;
                ++b;
            }
        }
        if (pageIndex > this.pageBreaks.length) {
            return 1;
        }
        graphics.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int y = 0;
        int start = pageIndex == 0 ? 0 : this.pageBreaks[pageIndex - 1];
        int end = pageIndex == this.pageBreaks.length ? this.textLines.length : this.pageBreaks[pageIndex];
        double pageWidth = pageFormat.getImageableWidth();
        String extra = "ABC";
        Rectangle2D bounds = metrics.getStringBounds(String.valueOf(this.headerLine) + extra, null);
        int widthInPixels = (int)bounds.getWidth();
        int lineWidth = metrics.stringWidth(String.valueOf(this.headerLine) + extra);
        double scale = pageWidth / (double)widthInPixels;
        if (scale > 1.0) {
            scale = 1.0;
        }
        graphics.scale(scale, scale);
        int line = start;
        while (line < end) {
            y += lineHeight;
            String textLine = this.textLines[line];
            if (textLine.equals(emptySpace)) {
                graphics.drawLine(0, y, lineWidth, y);
            }
            graphics.drawString(this.textLines[line], 0, y);
            ++line;
        }
        return 0;
    }

    private void contvertTableRowsToText() {
        if (this.textLines == null) {
            ArrayList<String> lines = new ArrayList<String>();
            Object[] header = this.tableManager.getColumnNamesForPrinting();
            if (header != null) {
                this.headerLine = this.rowToString(header, header);
                lines.add(this.headerLine);
                lines.add(emptySpace);
            }
            int i = this.from - 1;
            while (i < this.to) {
                Object[] row = this.tableManager.getRowForPrinting(i);
                if (row != null) {
                    String line = this.rowToString(row, header);
                    lines.add(line);
                }
                ++i;
            }
            this.textLines = new String[lines.size()];
            if (this.headerText != null) {
                lines.add(0, this.headerText);
                lines.add(1, emptySpace);
            }
            if (this.footerText != null) {
                lines.add(emptySpace);
                lines.add(this.footerText);
            }
            this.textLines = lines.toArray(this.textLines);
        }
    }

    private String rowToString(Object[] row, Object[] header) {
        StringBuffer line = new StringBuffer();
        int i = 0;
        while (i < row.length) {
            String value = row[i].toString();
            String colName = header[i].toString();
            int width = colName.length();
            String format = "%-" + width + "s|";
            if (value.length() > width) {
                value = value.substring(0, width - 1);
            }
            String formattedValue = String.format(format, value);
            line = line.append(formattedValue);
            ++i;
        }
        return line.toString();
    }
}

