/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels.autodata;

import ice.IcePanelManager;
import ice.event.IceClientErrorEvent;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceDialog;
import ice.gui.panel.sans.subpanels.autodata.PatchPropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.JFrame;

public class PatchPropertiesDialog
extends IceDialog {
    private static final String TITLE_KEY = "Patch Properties";
    private static final long serialVersionUID = 1L;
    private static PatchPropertiesDialog instance;
    private PatchPropertiesPanel controlPanel;

    private PatchPropertiesDialog(Frame arg0) throws HeadlessException, IcePanelException {
        super(arg0);
        this.init();
    }

    private void init() throws IcePanelException {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.controlPanel = new PatchPropertiesPanel();
        this.add((Component)this.controlPanel, "Center");
        this.pack();
    }

    public static PatchPropertiesDialog getInstance(JFrame parent, String low, String high) {
        if (instance == null) {
            try {
                instance = new PatchPropertiesDialog(parent);
            }
            catch (HeadlessException e) {
                e.printStackTrace();
            }
            catch (IcePanelException e) {
                IceClientErrorEvent event = new IceClientErrorEvent(parent, e);
                IcePanelManager panelManager = IcePanelManager.getReference();
                panelManager.notifyIceClientErrorListeners(event);
            }
        }
        if (instance != null) {
            instance.centerOnParent();
            instance.populateRange(low, high);
            instance.setVisible(true);
        }
        return instance;
    }

    private void populateRange(String low, String high) {
        this.controlPanel.setBufferRange(low, high);
    }

    public static PatchPropertiesDialog getInstance() {
        return instance;
    }
}

