/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.DeviceAddCommand;
import ice.commands.DeviceDestroyCommand;
import ice.commands.DeviceSetPropertyCommand;
import ice.commands.MoveCommand;
import ice.data.InstalledDevice;
import ice.data.InstalledTempDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.event.communication.EmptyDocumentListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.communication.ChangeTempControllerMenuItemsChangedListener;
import ice.gui.panel.sans.communication.TempDeviceChangedListener;
import ice.gui.panel.sans.controls.BlueBoxTemperatureControlPanel;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.HoldTimeControlPanel;
import ice.gui.panel.sans.controls.SampleTemperatureControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.controls.SansDeviceControlNoScalePanel;
import ice.gui.panel.sans.controls.TemperatureDeviceChangerControlPanel;
import ice.gui.panel.sans.controls.buttons.SampleTemperatureButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SampleTemperature
extends SansIcePanel
implements DeviceListListener,
ChangeTempControllerMenuItemsChangedListener,
ActionListener,
DeviceValueChangedListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger("ErrorLogger");
    public static final String SANS_TEMPERATURE_ALIAS = "Temp";
    public static final String preset_timeout = "Temp Timeout";
    public static final String preset_tolerance = "Temp Tolerance";
    public static final String DUMMYTEMP_NAME = "DUMMYTEMP";
    private static final String title = "Sample Temperature";
    public static final String NOT_ATTACHED_LABEL = "ERR No Temp Dev Set";
    public static final String NOT_ATTACHED_ERROR = "There is no temperature device set as the standard temperature device (Temp).";
    private TemperatureDeviceChangerControlPanel tempDeviceSelectionPanel;
    private BlueBoxTemperatureControlPanel blueBoxTemperatureControlPanel;
    private SampleTemperatureControlPanel sampleTemperatureControlPanel;
    private HoldTimeControlPanel holdTimeControlPanel;
    private SansDeviceControlNoScalePanel absoluteErrorControlPanel;
    private SampleTemperatureButtonControlPanel buttonPanel;
    private ArrayList<TempDeviceChangedListener> tempDeviceChangedListeners;
    private InstalledTempDevice currentTempDevice;
    protected static final String TEMPERATURE_CONTROL_PANEL_NAME = "Temperature";

    public SampleTemperature() throws IcePanelException {
        super(SANS_TEMPERATURE_ALIAS, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.tempDeviceSelectionPanel, mainBagConstraints);
        this.tempDeviceSelectionPanel.addChangeTempControllerMenuItemsChangedListener(this);
        this.tempDeviceSelectionPanel.addActionListener(this);
        this.addTempDeviceChangedListener(this.tempDeviceSelectionPanel);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.sampleTemperatureControlPanel, mainBagConstraints);
        this.addTempDeviceChangedListener(this.sampleTemperatureControlPanel);
        mainBagConstraints.gridx = 0;
        ++mainBagConstraints.gridy;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.absoluteErrorControlPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        ++mainBagConstraints.gridy;
        mainBagConstraints.gridwidth = 1;
        this.add((Component)this.holdTimeControlPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        ++mainBagConstraints.gridy;
        mainBagConstraints.gridwidth = 1;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.add((Component)this.blueBoxTemperatureControlPanel, mainBagConstraints);
        this.addTempDeviceChangedListener(this.blueBoxTemperatureControlPanel);
        this.blueBoxTemperatureControlPanel.addActionListener(this);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        ++mainBagConstraints.gridy;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.buttonPanel.addActionListener(this);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        ++mainBagConstraints.gridy;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.findCurrentTemperatureDevicesByAlias();
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
        this.setIcePanelAsParent(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.tempDeviceChangedListeners = new ArrayList();
        this.buttonPanel = new SampleTemperatureButtonControlPanel(this);
        this.tempDeviceSelectionPanel = new TemperatureDeviceChangerControlPanel();
        this.sampleTemperatureControlPanel = new SampleTemperatureControlPanel(TEMPERATURE_CONTROL_PANEL_NAME, SANS_TEMPERATURE_ALIAS);
        this.sampleTemperatureControlPanel.listenToTargetEmptyDocumentEvent(this);
        this.absoluteErrorControlPanel = new SansDeviceControlDoubleNoScalePanel("Absolute Error", SANS_TEMPERATURE_ALIAS, false);
        this.holdTimeControlPanel = new HoldTimeControlPanel();
        this.blueBoxTemperatureControlPanel = new BlueBoxTemperatureControlPanel();
        this.helpPanel = new HelpPanel();
        Controller.getReference().addDeviceListListener(this);
        this.errorPanel.listenForDeviceErrors(SANS_TEMPERATURE_ALIAS);
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        super.documentChanged(e);
        SANSDecimalFormattedTextField textField = (SANSDecimalFormattedTextField)e.getSource();
        SansDeviceControlDoubleNoScalePanel parent = (SansDeviceControlDoubleNoScalePanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        NumberOutOfRangeListener.NumberRange inRange = NumberOutOfRangeListener.NumberRange.IN_RANGE;
        boolean buttonOn = false;
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        inRange = textField.inRange();
        boolean bl = buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange != NumberOutOfRangeListener.NumberRange.OUT_OF_RANGE;
        if (name != null && name.equals(TEMPERATURE_CONTROL_PANEL_NAME)) {
            this.buttonPanel.enableF17Move(buttonOn);
        }
    }

    public void addTempDeviceChangedListener(TempDeviceChangedListener listener) {
        this.tempDeviceChangedListeners.add(listener);
    }

    public boolean removeTempDeviceChangedListener(TempDeviceChangedListener listener) {
        return this.tempDeviceChangedListeners.remove(listener);
    }

    protected void findCurrentTemperatureDevicesByAlias() {
        String temperatureDeviceName = null;
        Controller controller = Controller.getReference();
        InstalledDevice currTempDevice = controller.getDeviceParent(SANS_TEMPERATURE_ALIAS);
        if (currTempDevice != null) {
            temperatureDeviceName = currTempDevice.getRealName();
        }
        if (temperatureDeviceName != null && temperatureDeviceName.equalsIgnoreCase(DUMMYTEMP_NAME)) {
            if (currTempDevice != null && currTempDevice instanceof InstalledTempDevice) {
                if (this.currentTempDevice != null && this.currentTempDevice != currTempDevice) {
                    this.currentTempDevice.removeValueChangeListener(this);
                    this.stopListeningForDeviceErrors(temperatureDeviceName);
                }
                this.currentTempDevice = (InstalledTempDevice)currTempDevice;
                try {
                    this.currentTempDevice.addValueChangeListener(this);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("SampleTemperature.findTemperatureDevicesByAlias " + e);
                }
                this.listenForDeviceErrors(temperatureDeviceName);
                this.notifyTempDeviceChangedListeners(this.currentTempDevice, TempDeviceChangedListener.EventType.ADDED);
                this.setFieldsFromDevice(this.currentTempDevice);
                this.sampleTemperatureControlPanel.setEnabled(false);
                this.absoluteErrorControlPanel.setEnabled(false);
                this.holdTimeControlPanel.setEnabled(false);
            } else {
                if (this.currentTempDevice != null) {
                    this.stopListeningForDeviceErrors(this.currentTempDevice.getName());
                    this.currentTempDevice.removeValueChangeListener(this);
                }
                this.currentTempDevice = null;
                this.listenForDeviceErrors(temperatureDeviceName);
                this.notifyTempDeviceChangedListeners(this.currentTempDevice, TempDeviceChangedListener.EventType.ADDED);
                this.setFieldsFromDevice(this.currentTempDevice);
                this.sampleTemperatureControlPanel.setEnabled(false);
                this.absoluteErrorControlPanel.setEnabled(false);
                this.holdTimeControlPanel.setEnabled(false);
            }
        } else if (currTempDevice != null && controller.getDevice(temperatureDeviceName).getType() == InstalledDevice.Type.environment) {
            if (this.currentTempDevice != null && this.currentTempDevice.getName() != temperatureDeviceName) {
                this.stopListeningForDeviceErrors(this.currentTempDevice.getName());
                this.currentTempDevice.removeValueChangeListener(this);
            }
            this.currentTempDevice = (InstalledTempDevice)controller.getDevice(temperatureDeviceName);
            try {
                this.currentTempDevice.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("SmapleTemperature.findCurrentTemperatureDevicesByAlias " + e);
            }
            this.listenForDeviceErrors(temperatureDeviceName);
            this.notifyTempDeviceChangedListeners(this.currentTempDevice, TempDeviceChangedListener.EventType.ADDED);
            this.setFieldsFromDevice(this.currentTempDevice);
            this.sampleTemperatureControlPanel.setEnabled(true);
            this.absoluteErrorControlPanel.setEnabled(true);
            this.holdTimeControlPanel.setEnabled(true);
        } else {
            if (this.currentTempDevice != null) {
                this.stopListeningForDeviceErrors(this.currentTempDevice.getRealName());
                this.currentTempDevice.removeValueChangeListener(this);
            }
            this.setFieldsFromDevice(null);
            this.sampleTemperatureControlPanel.setEnabled(false);
            this.absoluteErrorControlPanel.setEnabled(false);
            this.holdTimeControlPanel.setEnabled(false);
        }
        this.tempDeviceSelectionPanel.setEnabled(true);
        InstalledDevice blueBoxTemp = controller.getDevice("BLUEBOXTEMPERATURE");
        if (blueBoxTemp != null) {
            this.notifyTempDeviceChangedListeners((InstalledTempDevice)blueBoxTemp, TempDeviceChangedListener.EventType.ADDED);
        }
    }

    public void checkForAndHandleDummyTemp(InstalledTempDevice tempDevice) {
        String realName = tempDevice.getRealName();
        if (realName.equalsIgnoreCase(DUMMYTEMP_NAME)) {
            this.sampleTemperatureControlPanel.setEnabled(false);
            this.absoluteErrorControlPanel.setEnabled(false);
            this.holdTimeControlPanel.setEnabled(false);
        } else {
            this.sampleTemperatureControlPanel.setEnabled(true);
            this.absoluteErrorControlPanel.setEnabled(true);
            this.holdTimeControlPanel.setEnabled(true);
        }
    }

    protected void notifyTempDeviceChangedListeners(InstalledTempDevice theDevice, TempDeviceChangedListener.EventType eventType) {
        TempDeviceChangedListener.TempDeviceChangedEvent aEvent = null;
        aEvent = new TempDeviceChangedListener.TempDeviceChangedEvent(theDevice, eventType);
        for (TempDeviceChangedListener aListener : this.tempDeviceChangedListeners) {
            aListener.tempDeviceChanged(aEvent);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        List<InstalledDevice> removedDevices = null;
        ArrayList<InstalledDevice> addedDevices = null;
        String alias2 = null;
        String realName = null;
        removedDevices = dle.getDevicesRemoved();
        for (InstalledDevice removeMe : removedDevices) {
            if (!(removeMe instanceof InstalledTempDevice)) continue;
            alias2 = removeMe.getAlias();
            realName = removeMe.getRealName();
            if (alias2 != null && alias2.equalsIgnoreCase(SANS_TEMPERATURE_ALIAS) || this.currentTempDevice != null && realName.equalsIgnoreCase(this.currentTempDevice.getRealName())) {
                this.currentTempDevice.removeValueChangeListener(this);
                this.currentTempDevice = null;
                this.sampleTemperatureControlPanel.setEnabled(false);
                this.absoluteErrorControlPanel.setEnabled(false);
                this.holdTimeControlPanel.setEnabled(false);
                this.stopListeningForDeviceErrors(realName);
            }
            this.notifyTempDeviceChangedListeners((InstalledTempDevice)removeMe, TempDeviceChangedListener.EventType.REMOVED);
        }
        addedDevices = dle.getDevicesAdded();
        for (InstalledDevice addMe : addedDevices) {
            if (addMe instanceof InstalledTempDevice && addMe.getAlias() != null && addMe.getAlias().equalsIgnoreCase(SANS_TEMPERATURE_ALIAS)) {
                alias2 = addMe.getAlias();
                realName = addMe.getRealName();
                this.errorPanel.clearErrors();
                this.currentTempDevice = (InstalledTempDevice)addMe;
                try {
                    this.currentTempDevice.addValueChangeListener(this);
                }
                catch (ICEListenerListExceptionBase e) {
                    logger.error("SampleTemperature.deviceListUpdated " + e);
                }
                this.checkForAndHandleDummyTemp((InstalledTempDevice)addMe);
                this.listenForDeviceErrors(realName);
                this.notifyTempDeviceChangedListeners((InstalledTempDevice)addMe, TempDeviceChangedListener.EventType.ADDED);
                continue;
            }
            if (addMe.getAlias() == null || !addMe.getAlias().equalsIgnoreCase(SANS_TEMPERATURE_ALIAS) || addMe.getRealName() == null || !addMe.getRealName().equalsIgnoreCase(DUMMYTEMP_NAME)) continue;
            this.sampleTemperatureControlPanel.setEnabled(false);
            this.absoluteErrorControlPanel.setEnabled(false);
            this.holdTimeControlPanel.setEnabled(false);
            this.errorPanel.clearErrors();
        }
        this.findCurrentTemperatureDevicesByAlias();
        this.setFieldsFromDevice(this.currentTempDevice);
    }

    @Override
    public void updateDeviceControls() {
    }

    protected void enableEntryControlPanels(boolean enabled) {
        this.sampleTemperatureControlPanel.setEnabled(enabled);
        this.blueBoxTemperatureControlPanel.setEnabled(enabled);
    }

    @Override
    public void tempControllerMenuItemsChanged(TemperatureDeviceChangerControlPanel.TemperatureDeviceSelectionComboBox temperatureDeviceSelectionComboBox) {
    }

    protected void addTempDeviceToServer(String deviceName) {
        this.addTempDeviceToServer(deviceName, true);
    }

    protected void addDummyTempToServer() {
        String aliasName = SANS_TEMPERATURE_ALIAS;
        try {
            DeviceAddCommand deviceAddCommand = new DeviceAddCommand(DUMMYTEMP_NAME, DeviceAddCommand.DeviceType.Placeholder, null, null, null, null, false, aliasName);
            deviceAddCommand.runAsynchronous();
            if (deviceAddCommand.isError()) {
                String responseString = null;
                responseString = deviceAddCommand.getResponse();
                throw new Exception(responseString);
            }
        }
        catch (Exception e) {
            this.errorPanel.setError(e.getMessage());
        }
    }

    protected void addTempDeviceToServer(String deviceName, boolean makeAlias) {
        DeviceAddCommand deviceAddCommand = null;
        try {
            String aliasName = makeAlias ? SANS_TEMPERATURE_ALIAS : null;
            deviceAddCommand = new DeviceAddCommand(deviceName, DeviceAddCommand.DeviceType.ENV, null, null, null, null, false, aliasName);
            deviceAddCommand.runAsynchronous();
            if (deviceAddCommand.isError()) {
                String responseString = null;
                responseString = deviceAddCommand.getResponse();
                throw new Exception(responseString);
            }
        }
        catch (Exception e) {
            this.errorPanel.setError(e.getMessage());
        }
    }

    protected void setServerTempAlias(String deviceName) {
        if (Controller.getReference().getDevice(SANS_TEMPERATURE_ALIAS) != null) {
            try {
                DeviceDestroyCommand destroyCmd = new DeviceDestroyCommand(SANS_TEMPERATURE_ALIAS);
                destroyCmd.runSynchronous();
            }
            catch (NoClientAPIInstanceException e) {
                logger.error("SampleTemperature.setServerTempAlias " + e);
                this.errorPanel.setError(e.getMessage());
            }
            catch (ICEListenerListExceptionBase e) {
                logger.error("SampleTemperature.setServerTempAlias " + e);
                this.errorPanel.setError(e.getMessage());
            }
        }
        try {
            DeviceAddCommand deviceAddCommand = new DeviceAddCommand(SANS_TEMPERATURE_ALIAS, deviceName);
            deviceAddCommand.runAsynchronous();
            if (deviceAddCommand.isError()) {
                String responseString = null;
                responseString = deviceAddCommand.getResponse();
                throw new Exception(responseString);
            }
        }
        catch (Exception e) {
            logger.error("SampleTemperature.setServerTempAlias " + e);
            this.errorPanel.setError(e.getMessage());
        }
    }

    protected void removeTempDeviceFromServer(String deviceName) {
        DeviceDestroyCommand deviceDestroyCommand = null;
        try {
            deviceDestroyCommand = new DeviceDestroyCommand(deviceName);
            deviceDestroyCommand.runAsynchronous();
            if (deviceDestroyCommand.isError()) {
                String responseString = null;
                responseString = deviceDestroyCommand.getResponse();
                throw new Exception(responseString);
            }
        }
        catch (Exception e) {
            this.errorPanel.setError(e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = null;
        source = e.getSource();
        if (source instanceof JButton) {
            String actionCommand = null;
            actionCommand = e.getActionCommand();
            this.findCurrentTemperatureDevicesByAlias();
            if (actionCommand.equalsIgnoreCase("Set")) {
                this.setSansTempDeviceFromPanel();
            } else if (actionCommand.equalsIgnoreCase("Add Blue Box")) {
                this.addTempDeviceToServer("BlueBoxTemperature", false);
            } else if (actionCommand.equalsIgnoreCase("Remove Blue Box")) {
                this.removeTempDeviceFromServer("BlueBoxTemperature");
            } else if (actionCommand.equalsIgnoreCase("MOVETOTARGET")) {
                this.moveTempController();
            }
        }
    }

    protected void setSansTempDeviceFromPanel() {
        String selectedController = null;
        String currentController = null;
        selectedController = this.tempDeviceSelectionPanel.getTargetValue();
        if (!selectedController.equalsIgnoreCase(currentController = this.tempDeviceSelectionPanel.getCurrentValue())) {
            try {
                this.errorPanel.clearErrors();
                if (this.currentTempDevice != null) {
                    this.removeTempDeviceFromServer(currentController);
                } else if (this.isDummySet()) {
                    this.removeTempDeviceFromServer(DUMMYTEMP_NAME);
                }
                if (Controller.getReference().getDevice(selectedController) != null) {
                    this.setServerTempAlias(selectedController);
                } else if (!selectedController.equalsIgnoreCase(DUMMYTEMP_NAME)) {
                    this.addTempDeviceToServer(selectedController, true);
                }
                this.findCurrentTemperatureDevicesByAlias();
            }
            catch (Exception ex) {
                logger.debug(ex);
            }
        }
    }

    public void clearTargets() {
        this.sampleTemperatureControlPanel.setTargetValue("");
        this.absoluteErrorControlPanel.setTargetValue("");
        this.holdTimeControlPanel.setTargetValue("");
    }

    protected void moveTempController() {
        block11: {
            if (this.currentTempDevice == null) {
                return;
            }
            MoveCommand moveCommand = null;
            String temperature = null;
            String absoluteError = null;
            String holdTime = null;
            String currentDeviceName = null;
            temperature = this.sampleTemperatureControlPanel.getTargetValue();
            absoluteError = this.absoluteErrorControlPanel.getTargetValue();
            holdTime = this.holdTimeControlPanel.getTargetValue();
            currentDeviceName = this.currentTempDevice.getRealName();
            if (currentDeviceName != null) {
                boolean succeeded = false;
                try {
                    try {
                        Hashtable<String, String> properties = new Hashtable<String, String>();
                        if (temperature == null || temperature.equals("")) break block11;
                        try {
                            double newPosition = Double.parseDouble(temperature);
                            properties.put("timeout", holdTime);
                            properties.put("tolerance", absoluteError);
                            String value = null;
                            Set keys = null;
                            keys = properties.keySet();
                            for (String key : keys) {
                                value = (String)properties.get(key);
                                if (value == null || value.equals("")) continue;
                                DeviceSetPropertyCommand deviceSetPropertyCommand = new DeviceSetPropertyCommand(currentDeviceName, key, value);
                                deviceSetPropertyCommand.runAsynchronous();
                                boolean bl = succeeded = !deviceSetPropertyCommand.isError() && deviceSetPropertyCommand.isSuccess();
                                if (succeeded) continue;
                                this.errorPanel.setError(deviceSetPropertyCommand.getResponse());
                            }
                            properties = null;
                            moveCommand = new MoveCommand(currentDeviceName, newPosition, properties);
                            moveCommand.runAsynchronous();
                            boolean bl = succeeded = !moveCommand.isError() && moveCommand.isSuccess();
                            if (!succeeded) {
                                this.errorPanel.setError(moveCommand.getResponse());
                            }
                        }
                        catch (NumberFormatException e) {
                            this.errorPanel.setError("Internal ICE error: " + e.toString());
                        }
                    }
                    catch (NoClientAPIInstanceException e) {
                        this.errorPanel.setError("Internal ICE error: " + e.toString());
                        this.clearTargets();
                        this.buttonPanel.enableF17Move(false);
                    }
                }
                finally {
                    this.clearTargets();
                    this.buttonPanel.enableF17Move(false);
                }
            }
        }
    }

    public boolean isDummySet() {
        return Controller.getReference().getDevice(DUMMYTEMP_NAME) != null && Controller.getReference().getDevice(DUMMYTEMP_NAME).getAlias() != null && Controller.getReference().getDevice(DUMMYTEMP_NAME).getAlias().equalsIgnoreCase(SANS_TEMPERATURE_ALIAS);
    }

    protected void setFieldsFromDevice(InstalledDevice aDevice) {
        String currentValue = "";
        String units = "";
        String absoulteError = "";
        boolean isFixed = false;
        Double tolerence = null;
        Double timeOut = null;
        if (aDevice != null) {
            double min = Double.MIN_VALUE;
            double max = Double.MAX_VALUE;
            currentValue = aDevice.getCurrValue();
            units = aDevice.getUnits();
            tolerence = aDevice.getTolerance();
            timeOut = ((InstalledTempDevice)aDevice).getTimeout();
            isFixed = aDevice.isFixed();
            units = aDevice.getUnits();
            min = aDevice.getLowerLimit();
            max = aDevice.getUpperLimit();
            this.sampleTemperatureControlPanel.setTargetMinMax(min, max);
        } else if (this.isDummySet()) {
            this.tempDeviceSelectionPanel.setCurrentValue("N/A");
        } else {
            this.tempDeviceSelectionPanel.setCurrentValue("");
            this.errorPanel.setError(NOT_ATTACHED_ERROR);
        }
        this.sampleTemperatureControlPanel.setCurrentValue(currentValue);
        this.sampleTemperatureControlPanel.setCurrentUnits(units);
        this.sampleTemperatureControlPanel.setTargetUnits(units);
        this.absoluteErrorControlPanel.setCurrentUnits(units);
        this.absoluteErrorControlPanel.setTargetUnits(units);
        this.holdTimeControlPanel.setCurrentUnits("min x 10");
        this.holdTimeControlPanel.setTargetUnits("min x 10");
        if (tolerence != null) {
            absoulteError = tolerence.toString();
        }
        this.absoluteErrorControlPanel.setCurrentValue(absoulteError);
        if (timeOut != null) {
            String timeOutString = "";
            Double temp = 0.0;
            timeOutString = timeOut.toString();
            try {
                temp = Double.parseDouble(timeOutString) / 600.0;
                timeOutString = temp.toString();
            }
            catch (NumberFormatException e) {
                timeOutString = "";
            }
            this.holdTimeControlPanel.setCurrentValue(timeOutString);
        } else {
            this.holdTimeControlPanel.setCurrentValue("");
        }
        this.sampleTemperatureControlPanel.setFixed(isFixed);
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
        if (changedDevice == this.currentTempDevice) {
            this.setFieldsFromDevice(this.currentTempDevice);
        }
    }
}

