/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.Instrument;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.NumberOutOfRangeListener;
import ice.event.communication.EmptyDocumentListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.NewSamplePositionControlPanel;
import ice.gui.panel.sans.controls.SampleChangerControlPanel;
import ice.gui.panel.sans.controls.SansDeviceButtonControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlDoubleNoScalePanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.SansDeviceWithScaleDoubleControlPanel;
import ice.gui.panel.sans.controls.buttons.SampleChangerButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.swing.SANSDecimalFormattedTextField;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SampleChangerPanel
extends SansIcePanel
implements DeviceListListener,
InstrumentValueChangedListener {
    protected static final String HUBER_TRANSLATION_PANEL_NAME = "Sample Position";
    protected static final String HUMBER_ROTATION_PANEL_NAME = "Sample Rotation Angle";
    private static Logger logger = Logger.getLogger("ErrorLogger");
    public static final String sampleTranslation = "SampleTranslation";
    public static final String sampleRotation = "SampleRotation";
    public static final String samplePosition = "SamplePosition";
    private static final String zeroSamplePositon = "ZeroSamplePosition";
    private static final String title = "Sample Changer Position/Rotation";
    private SansDeviceWithScaleDoubleControlPanel samplePositionPanel;
    private SansDeviceControlDoubleNoScalePanel sampleRotationPanel;
    private SampleChangerControlPanel sampleHolderPanel;
    private NewSamplePositionControlPanel zeroSamplePanel;
    private SansDeviceButtonControlPanel initSampleRotBtn;
    private SampleChangerButtonControlPanel buttonPanel;
    protected Hashtable<JTextField, Boolean> targetsEmpty;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;

    public SampleChangerPanel() throws IcePanelException {
        super(samplePosition, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.sampleHolderPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.samplePositionPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.zeroSamplePanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.sampleRotationPanel, mainBagConstraints);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.initSampleRotBtn, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.targetsEmpty = new Hashtable();
        this.samplePositionPanel = new SansDeviceWithScaleDoubleControlPanel(HUBER_TRANSLATION_PANEL_NAME, samplePosition, sampleTranslation, "cm");
        this.samplePositionPanel.listenToTargetsEmptyDocumentEvents(this);
        this.sampleRotationPanel = new SansDeviceControlDoubleNoScalePanel(HUMBER_ROTATION_PANEL_NAME, sampleRotation, "deg");
        this.sampleRotationPanel.listenToTargetEmptyDocumentEvent(this);
        this.zeroSamplePanel = new NewSamplePositionControlPanel();
        this.zeroSamplePanel.setKeyStroke(112);
        this.buttonPanel = new SampleChangerButtonControlPanel(this);
        this.helpPanel = new HelpPanel();
        this.sampleHolderPanel = new SampleChangerControlPanel("Sample Changer", "sampleChangerBlock");
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
        Instrument instrument = this.controller.getInstrument();
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("SampleChangerPanel" + e);
        }
        String command = "device set samplerotation 0";
        String buttonName = "F12: Initialize Sample Rotaion Angle";
        this.initSampleRotBtn = new SansDeviceButtonControlPanel(buttonName, sampleRotation, command);
        this.initSampleRotBtn.setKeyStroke(115);
    }

    @Override
    public void documentChanged(EmptyDocumentListener.EmptyDocumentEvent e) {
        super.documentChanged(e);
        SANSDecimalFormattedTextField textField = (SANSDecimalFormattedTextField)e.getSource();
        SansDeviceControlPanel parent = (SansDeviceControlPanel)textField.getParent();
        String name = parent.getControlName();
        EmptyDocumentListener.EmptyDocumentState state = e.getState();
        NumberOutOfRangeListener.NumberRange inRange = textField.inRange();
        if (state == EmptyDocumentListener.EmptyDocumentState.FORMATTING) {
            return;
        }
        boolean buttonOn = state == EmptyDocumentListener.EmptyDocumentState.HAS_TEXT && inRange == NumberOutOfRangeListener.NumberRange.IN_RANGE;
        String text = textField.getText();
        if (name != null && name.equals(HUBER_TRANSLATION_PANEL_NAME)) {
            String textFieldName = textField.getName();
            if (textFieldName.equals("TARGET")) {
                this.buttonPanel.enableMoveToTargetPosBtn(buttonOn);
            }
        } else if (name != null && name.equals(HUMBER_ROTATION_PANEL_NAME)) {
            this.buttonPanel.enableMoveToTargetRotAngleBtn(buttonOn);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null) continue;
            if (device.getName().equalsIgnoreCase(samplePosition)) {
                device.removeValueChangeListener(this.samplePositionPanel);
                continue;
            }
            if (device.getName().equalsIgnoreCase(sampleRotation)) {
                device.removeValueChangeListener(this.sampleRotationPanel);
                continue;
            }
            if (!device.getName().equalsIgnoreCase(sampleTranslation)) continue;
            device.removeValueChangeListener(this.samplePositionPanel);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            try {
                String currentValue;
                if (device.getName() == null) continue;
                Double max = device.getUpperLimit();
                Double min = device.getLowerLimit();
                if (device.getName().equalsIgnoreCase(samplePosition)) {
                    device.addValueChangeListener(this.samplePositionPanel);
                    currentValue = device.getCurrValue().toString();
                    this.samplePositionPanel.setCurrentValue(currentValue);
                    this.samplePositionPanel.setFixed(device.isFixed());
                    this.samplePositionPanel.setTargetMinMax(min, max);
                    continue;
                }
                if (device.getName().equalsIgnoreCase(sampleRotation)) {
                    device.addValueChangeListener(this.sampleRotationPanel);
                    currentValue = device.getCurrValue().toString();
                    this.sampleRotationPanel.setCurrentValue(currentValue);
                    this.sampleRotationPanel.setFixed(device.isFixed());
                    this.sampleRotationPanel.setTargetMinMax(min, max);
                    continue;
                }
                if (!device.getName().equalsIgnoreCase(sampleTranslation)) continue;
                device.addValueChangeListener(this.samplePositionPanel);
                currentValue = device.getCurrValue().toString();
                this.samplePositionPanel.setCurrentTranslationValue(currentValue);
                this.samplePositionPanel.setTargetTranMinMax(min, max);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("BeamStopPanel.updateDeviceControls " + e);
            }
        }
    }

    public SansDeviceControlPanel getSamplePositionPanel() {
        return this.samplePositionPanel;
    }

    public SansDeviceControlPanel getSampleRotaitonPanel() {
        return this.sampleRotationPanel;
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent pce) {
        String propertyName = pce.getPropertyName();
        "defaultSampleChanger".equals(propertyName);
    }

    @Override
    protected void restoreDefaults() {
        this.sampleHolderPanel.setCurrentSampleHolder();
        this.samplePositionPanel.clearTargetValue();
        this.sampleRotationPanel.clearTargetValue();
    }
}

