/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.Controller;
import ice.communication.CommunicationManager;
import ice.data.Queue;
import ice.data.tas.bt7.Instrument;
import ice.event.QueueChangedEvent;
import ice.event.QueueChangedListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.actions.scans.KeyStrokeAction;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.buttons.AutoCollectionButtonControlPanel;
import ice.gui.panel.sans.controls.buttons.StartAutoCollectionButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.gui.panel.sans.subpanels.autodata.RunListTable;
import ice.util.ConversionUtilities;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AutoDataCollectionPanel
extends SansIcePanel
implements ChangeListener,
QueueChangedListener,
InstrumentValueChangedListener {
    private static final long serialVersionUID = -5002924492362398838L;
    private static Logger logger = Logger.getLogger("ErrorLogger");
    public static final String title = "Automatic Data Collection";
    private StartAutoCollectionButtonControlPanel startButtonControl;
    private AutoCollectionButtonControlPanel editRunsButtonControl;
    protected RunListTable runListTable;
    private Queue serverQueue;
    private JLabel estimatedTimeLabel;
    private Controller controller;
    private boolean isListening;

    public AutoDataCollectionPanel() throws IcePanelException {
        super(title, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 1;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.weightx = 1.0;
        mainBagConstraints.weighty = 1.0;
        this.add((Component)this.runListTable, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        mainBagConstraints.weightx = 0.0;
        mainBagConstraints.weighty = 0.0;
        this.add((Component)this.estimatedTimeLabel, mainBagConstraints);
        mainBagConstraints.weightx = 0.0;
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.editRunsButtonControl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.startButtonControl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.helpPanel = new HelpPanel();
        this.runListTable = new RunListTable(this);
        this.controller = Controller.getReference();
        this.startButtonControl = new StartAutoCollectionButtonControlPanel(this);
        this.editRunsButtonControl = new AutoCollectionButtonControlPanel(this);
        SwingUtilities.invokeLater(new UpdateCountTime());
        this.serverQueue = this.controller.getServerQueue();
        try {
            this.controller.getInstrument().addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e1) {
            e1.printStackTrace();
            logger.error("Error adding listener for autocollection panel", e1);
        }
        try {
            this.serverQueue.addChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("AutoDataCollectionPanel.init can't add listener to serveQueue " + e);
        }
        this.estimatedTimeLabel = new JLabel();
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        keyList.add(48);
        keyList.add(49);
        keyList.add(50);
        keyList.add(51);
        keyList.add(52);
        keyList.add(53);
        keyList.add(54);
        keyList.add(55);
        keyList.add(56);
        keyList.add(57);
        keyList.add(37);
        keyList.add(39);
        keyList.add(10);
        this.bindKeys(keyList);
    }

    public JTable getRunListTable() {
        return this.runListTable.getRunListTable();
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String propertyName;
        if (pce.getSource() instanceof Instrument && "defaultSampleChanger".equals(propertyName = pce.getPropertyName())) {
            System.out.println(propertyName);
        }
    }

    public JTable getRunListTableControl() {
        return this.runListTable.getRunListTable();
    }

    public RunListTable getTableManager() {
        return this.runListTable;
    }

    @Override
    public void actionPerformed(QueueChangedEvent event) {
        SwingUtilities.invokeLater(new UpdateCountTime());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    @Override
    public void performKeyAction(int keyCode) {
        if (keyCode == 10) {
            JTable runListJTable = this.runListTable.getRunListTable();
            ActionEvent event = new ActionEvent(runListJTable, -1, "EnterPressed");
            RunListTable.EnterKeyAction action = new RunListTable.EnterKeyAction(this.runListTable);
            action.actionPerformed(event);
        } else {
            this.runListTable.setRowSelectionFromKeyStroke(keyCode);
        }
    }

    @Override
    public void updateDeviceControls() {
    }

    private void bindKeys(ArrayList<Integer> keyList) {
        InputMap inputMap = this.getInputMap(2);
        for (Integer key : keyList) {
            String name = key.toString();
            inputMap.put(KeyStroke.getKeyStroke(key, 0), name);
            this.getActionMap().put(name, new KeyStrokeAction(name, key, this));
        }
    }

    @Override
    public boolean requestFocusInIceWindow() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AutoDataCollectionPanel.this.runListTable.getRunListTable().requestFocusInWindow();
            }
        });
        return true;
    }

    public boolean isListeningForServerErrors() {
        return this.isListening;
    }

    public void startListeningForServerErrors() {
        this.isListening = false;
        CommunicationManager comManager = this.controller.getCommMgr();
        try {
            comManager.addErrorListener(this.errorPanel);
            this.isListening = true;
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("Could not add AutoDataCollection Panel to ErrorMessageListner", e);
        }
    }

    public void stopListeningForServerErrors() {
        CommunicationManager comManager = this.controller.getCommMgr();
        comManager.removeErrorListener(this.errorPanel);
        this.isListening = false;
    }

    @Override
    public synchronized void actionPerformed(InstrumentValueChangedEvent event) {
        String propertyName = event.getPropertyName();
        Instrument instrument = (Instrument)event.getSource();
        if ("state".equals(propertyName)) {
            Instrument.State state = instrument.getState();
            if (state == Instrument.State.busy) {
                this.startListeningForServerErrors();
            } else if (state == Instrument.State.idle && this.isListeningForServerErrors()) {
                this.stopListeningForServerErrors();
            }
        }
    }

    @Override
    protected void updateLockState() {
        super.updateLockState();
        JTable runListTable = this.runListTable.getRunListTable();
        runListTable.setEnabled(!this.isLocked());
        runListTable.getSelectionModel().clearSelection();
    }

    private class UpdateCountTime
    implements Runnable {
        private UpdateCountTime() {
        }

        @Override
        public void run() {
            Double estimatedTime = AutoDataCollectionPanel.this.serverQueue.getEstimatedCompletionTime();
            if (estimatedTime.isInfinite()) {
                AutoDataCollectionPanel.this.estimatedTimeLabel.setText("Total counting time is: " + estimatedTime.toString());
                return;
            }
            String time = ConversionUtilities.convertSecondsToDays(estimatedTime);
            AutoDataCollectionPanel.this.estimatedTimeLabel.setText("Total counting time is: " + time);
        }
    }
}

