/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.subpanels;

import ice.ClientAPI;
import ice.Controller;
import ice.commands.DevicePositionsCommand;
import ice.data.InstalledDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.HelpPanel;
import ice.gui.panel.sans.controls.SansDeviceComboBoxWithFnScaleDoubleControlPanel;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.controls.buttons.AttenuationButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansIcePanel;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.border.LineBorder;
import org.apache.log4j.Logger;

public class AttenuationPanel
extends SansIcePanel
implements DeviceListListener,
ActionListener {
    public static final String attenuator = "Attenuator";
    public static final String attenuatorTranslation = "AttenuatorTranslation";
    public static final String title = "Attenuation Factor";
    private static Logger logger = Logger.getLogger("ErrorLogger.Attenuation");
    private SansDeviceComboBoxWithFnScaleDoubleControlPanel attenuatorControl;
    private ArrayList<InstalledDevice> allDevices;
    private Controller controller;
    private AttenuationButtonControlPanel buttonPanel;
    private HashMap<String, String> lookupTable;

    public AttenuationPanel() throws IcePanelException {
        super(attenuator, title);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new LineBorder(new Color(153, 153, 255), 1, true));
        GridBagConstraints mainBagConstraints = new GridBagConstraints();
        int y = 0;
        mainBagConstraints.anchor = 10;
        mainBagConstraints.insets = new Insets(10, 0, 10, 0);
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.titleLbl, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.anchor = 17;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.errorPanel, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.attenuatorControl, mainBagConstraints);
        mainBagConstraints.fill = 0;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.buttonPanel, mainBagConstraints);
        mainBagConstraints.fill = 2;
        mainBagConstraints.gridx = 0;
        mainBagConstraints.gridy = y++;
        this.add((Component)this.helpPanel, mainBagConstraints);
        this.updateDeviceControls();
        this.writeKeysToHelpPreferenceFile();
        this.buttonPanel.writeKeysToHelpPreferenceFile(this);
        this.readControlKeysFromHelpPreferenceFile(this);
    }

    @Override
    protected void init() {
        this.initSansIcePanel();
        this.attenuatorControl = new SansDeviceComboBoxWithFnScaleDoubleControlPanel("Attenuation", attenuator, attenuatorTranslation, "in");
        DevicePositionsCommand iCommand = null;
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            iCommand = new DevicePositionsCommand(attenuator, messageSender);
            iCommand.runSynchronous();
        }
        catch (Exception e) {
            logger.error("Error while sending a command...", e.getCause());
        }
        String[] values = iCommand.getParsedResponse();
        this.attenuatorControl.addItems(values);
        this.attenuatorControl.populateKeys(values);
        this.attenuatorControl.listenToTargetComboBoxActions(this);
        this.buttonPanel = new AttenuationButtonControlPanel(this);
        this.helpPanel = new HelpPanel();
        this.controller = Controller.getReference();
        ArrayList<InstalledDevice> devices = this.controller.getDeviceList();
        this.allDevices = new ArrayList<InstalledDevice>(devices);
        this.controller.getDeviceListeners().add(this);
        this.lookupTable = new HashMap();
        this.lookupTable.put("0.0", "NONE");
        this.lookupTable.put("1.0", "1/16");
        this.lookupTable.put("2.0", "1/8");
        this.lookupTable.put("3.0", "3/16");
        this.lookupTable.put("4.0", "1/4");
        this.lookupTable.put("5.0", "5/16");
        this.lookupTable.put("6.0", "3/8");
        this.lookupTable.put("7.0", "1/2");
        this.lookupTable.put("8.0", "5/8");
        this.lookupTable.put("9.0", "3/4");
        this.lookupTable.put("10.0", "7/8");
        this.attenuatorControl.populateValues(this.lookupTable);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JComboBox) {
            String selectedItem = (String)((JComboBox)source).getSelectedItem();
            boolean buttonOn = selectedItem != null && !selectedItem.trim().equals("");
            this.buttonPanel.enableMoveAttenuatorBtn(buttonOn);
        }
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null || !device.getName().equalsIgnoreCase(attenuator)) continue;
            device.removeValueChangeListener(this.attenuatorControl);
        }
        this.allDevices = dle.getNewList();
        this.updateDeviceControls();
    }

    @Override
    public void updateDeviceControls() {
        for (InstalledDevice device : this.allDevices) {
            if (device.getName() == null || !device.getName().equalsIgnoreCase(attenuator)) continue;
            try {
                device.addValueChangeListener(this.attenuatorControl);
                String currentValue = device.getCurrValue().toString();
                this.attenuatorControl.setCurrentValue(currentValue);
                this.attenuatorControl.setFixed(device.isFixed());
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("ErrorLogger").error("AttenuationPanel.updateDeviceControls " + e);
            }
        }
    }

    public SansDeviceControlPanel getAttenuatorControl() {
        return this.attenuatorControl;
    }
}

