/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.buttons;

import ice.gui.core.GenericIcePanel;
import ice.gui.panel.sans.controls.SansButtonPanelControl;
import ice.gui.panel.sans.subpanels.SansPanelController;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class MainMenuButtonControlPanel
extends SansButtonPanelControl {
    private static final long serialVersionUID = -1820135662111790269L;
    private static final String singleRunButtonString = "<html>Single Run <br>Setup Params</html>";
    private static final String manualOpButtonString = "<html>Manual<br> Operations</html>";
    private static final String autoDataButtonString = "<html>Automatic <br>Data Collection</html>";
    private JButton autoDataButton;
    private JButton manualOpButton;
    private JButton singleRunButton;

    public MainMenuButtonControlPanel(GenericIcePanel parentPanel) {
        super(parentPanel);
    }

    @Override
    protected void init(GenericIcePanel panel) {
        super.init(panel);
        this.singleRunButton = new JButton();
        this.singleRunButton.setText(singleRunButtonString);
        this.singleRunButton.addActionListener(new SingleRunActionListener());
        this.manualOpButton = new JButton();
        this.manualOpButton.setText(manualOpButtonString);
        this.manualOpButton.addActionListener(new ManualOperationsActionListener());
        this.autoDataButton = new JButton();
        this.addToDoNotEnableDisableOnIdleOrBusy(this.autoDataButton);
        this.autoDataButton.setText(autoDataButtonString);
        this.autoDataButton.addActionListener(new AutoDataActionListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 20;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(40, 0, 0, 20);
        this.add((Component)this.singleRunButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.manualOpButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)this.autoDataButton, gridBagConstraints);
        this.readButtonHintsFromPreferenceFile();
    }

    private class AutoDataActionListener
    implements ActionListener {
        private AutoDataActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SansPanelController swapPanel = SansPanelController.getReference();
            swapPanel.showAutoDataCollectionPanel();
        }
    }

    private class ManualOperationsActionListener
    implements ActionListener {
        private ManualOperationsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SansPanelController swapPanel = SansPanelController.getReference();
            swapPanel.showManualOperationsPanel();
        }
    }

    private class SingleRunActionListener
    implements ActionListener {
        private SingleRunActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SansPanelController swapPanel = SansPanelController.getReference();
            swapPanel.showSingleRunPanel();
        }
    }
}

