/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls.basic;

import ice.Controller;
import ice.data.InstalledDevice;
import ice.data.InstalledEnvDevice;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.gui.panel.sans.controls.basic.SansDeviceAddRemoveAction;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class SansDeviceAddRemoveButton
extends JButton
implements DeviceListListener {
    private static Logger logger = Logger.getLogger("ErrorLogger.SansDeviceAddButton");
    private static final long serialVersionUID = -773749000949103918L;
    protected static final String add = "Activate";
    protected static final String remove = "Deactivate";
    private ArrayList<String> deviceNames;
    private String buttonName;
    private ActionListener addRemoveAction;
    private HashMap<String, Boolean> availableDevices;

    public SansDeviceAddRemoveButton(String name, String deviceName) {
        this.buttonName = name;
        this.addRemoveAction = null;
        this.init();
        this.addDeviceName(deviceName);
        this.build();
    }

    public SansDeviceAddRemoveButton(String name, String deviceName, ActionListener action) {
        this.buttonName = name;
        this.addRemoveAction = action;
        this.init();
        this.addDeviceName(deviceName);
        this.build();
    }

    public SansDeviceAddRemoveButton(String name, ArrayList<String> deviceNames, ActionListener action) {
        this.buttonName = name;
        this.deviceNames = deviceNames;
        this.addRemoveAction = action;
        this.build();
    }

    protected void init() {
        this.deviceNames = new ArrayList();
        this.availableDevices = new HashMap();
    }

    public void addDeviceName(String deviceName) {
        this.deviceNames.add(deviceName);
    }

    protected void build() {
        Controller controller = Controller.getReference();
        InstalledDevice device = null;
        controller.addDeviceListListener(this);
        for (String deviceName : this.deviceNames) {
            device = controller.getFirstDevice(deviceName);
            if (device == null) {
                this.availableDevices.put(deviceName, false);
                continue;
            }
            this.availableDevices.put(deviceName, true);
        }
        if (this.availableDevices.containsValue(true)) {
            this.setActionCommand(remove);
            this.setText("Deactivate " + this.buttonName);
        } else {
            this.setActionCommand(add);
            this.setText("Activate " + this.buttonName);
        }
        if (this.addRemoveAction == null) {
            this.buildAction();
        }
    }

    @Override
    public void removeActionListener(ActionListener action) {
        this.removeActionListener(action);
    }

    private void buildAction() {
        SansDeviceAddRemoveAction action = new SansDeviceAddRemoveAction(this);
        this.addActionListener(action);
    }

    public ArrayList<String> getDeviceNames() {
        return this.deviceNames;
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        List<InstalledDevice> installedDevices = null;
        String alias2 = null;
        String realName = null;
        installedDevices = dle.getDevicesRemoved();
        for (InstalledDevice removeMe : installedDevices) {
            if (!(removeMe instanceof InstalledEnvDevice)) continue;
            alias2 = removeMe.getAlias();
            realName = removeMe.getRealName();
            if (!this.deviceNames.contains(realName)) continue;
            this.availableDevices.put(realName, false);
        }
        installedDevices = dle.getDevicesAdded();
        for (InstalledDevice addMe : installedDevices) {
            if (!(addMe instanceof InstalledEnvDevice)) continue;
            alias2 = addMe.getAlias();
            realName = addMe.getRealName();
            if (!this.deviceNames.contains(realName)) continue;
            this.availableDevices.put(realName, true);
        }
        if (this.availableDevices.containsValue(true)) {
            this.setActionCommand(remove);
            this.setText("Deactivate " + this.buttonName);
        } else {
            this.setActionCommand(add);
            this.setText("Activate " + this.buttonName);
        }
    }
}

