/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.data.InstalledDevice;
import ice.data.InstalledTempDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.gui.panel.sans.controls.SansScanDeviceControlPanel;
import ice.gui.panel.sans.controls.SansScanDeviceDoubleNoEmptyControlPanel;
import ice.gui.panel.sans.data.SansScan;
import ice.gui.panel.sans.swing.SansDeviceNameLabel;
import java.util.ArrayList;

public class SansScanTempDeviceControlNonEmptyPanel
extends SansScanDeviceDoubleNoEmptyControlPanel {
    private static final long serialVersionUID = 5175016417103007656L;
    protected ArrayList<SansScanDeviceControlPanel> propertyControls;

    public SansScanTempDeviceControlNonEmptyPanel(String name, String deviceName, SansScan.DeviceType type) {
        super(name, deviceName, type);
    }

    public SansScanTempDeviceControlNonEmptyPanel(String labelName, String deviceName, String propertyName, String units) {
        super(labelName, deviceName, propertyName, units);
    }

    public SansScanTempDeviceControlNonEmptyPanel(String name, String deviceName, String units) {
        super(name, deviceName, units);
    }

    public SansScanTempDeviceControlNonEmptyPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    @Override
    protected void init() {
        super.init();
        this.propertyControls = new ArrayList();
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        for (SansScanDeviceControlPanel propertyControl : this.propertyControls) {
            if (propertyControl == null) continue;
            propertyControl.setDisabled(disabled);
        }
    }

    @Override
    public void setFixed(boolean fixed) {
        super.setFixed(fixed);
        for (SansScanDeviceControlPanel propertyControl : this.propertyControls) {
            if (propertyControl == null) continue;
            propertyControl.setFixed(fixed);
            SansDeviceNameLabel nameLabel = propertyControl.getDeviceLabel();
            nameLabel.setFixed(fixed);
        }
    }

    public void addPropertyControl(SansScanDeviceControlPanel dependantControl) {
        this.propertyControls.add(dependantControl);
    }

    public ArrayList<SansScanDeviceControlPanel> getPropertyControls() {
        return this.propertyControls;
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent evt) {
        block7: {
            String currentValue;
            InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
            if (!changedDevice.getName().equalsIgnoreCase(this.deviceName)) break block7;
            if (evt.getPropertyName().equalsIgnoreCase("currValue") && this.isFixed()) {
                currentValue = changedDevice.getCurrValue();
                this.setCurrentValue(currentValue);
            }
            if (evt.getPropertyName().equalsIgnoreCase("fixed")) {
                if (changedDevice.isFixed()) {
                    currentValue = changedDevice.getCurrValue();
                    this.setCurrentValue(currentValue);
                    this.setFixed(true);
                    for (SansScanDeviceControlPanel propertyControl : this.propertyControls) {
                        if (propertyControl.getDeviceName().equals("Temp Tolerance")) {
                            String propValue = changedDevice.getTolerance().toString();
                            propertyControl.setCurrentValue(propValue);
                            continue;
                        }
                        if (!propertyControl.getDeviceName().equals("HoldTime")) continue;
                        Double timeOut = ((InstalledTempDevice)changedDevice).getTimeout();
                        timeOut = timeOut / 600.0;
                        propertyControl.setCurrentValue(timeOut.toString());
                    }
                } else {
                    this.setCurrentValue(this.scanValue);
                    this.setFixed(false);
                    for (SansScanDeviceControlPanel propertyControl : this.propertyControls) {
                        String scanValue = propertyControl.getScanValue();
                        propertyControl.setCurrentValue(scanValue);
                    }
                }
            }
        }
    }
}

