/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.IcePanelManager;
import ice.event.IceClientErrorEvent;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.SansDeviceButtonControlPanel;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import ice.swing.buttons.KeyResponseButton;
import ice.util.HelpPropertiesManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class NewSamplePositionControlPanel
extends SansDeviceButtonControlPanel {
    private KeyResponseButton newZeroPositionBtn;
    private JLabel zeroLabel;
    private JTextField zeroTextField;
    private static final String actionName = "F9: Redefine Sample Position";

    public NewSamplePositionControlPanel(String name, String deviceName, String command) {
        super(name, deviceName, command);
    }

    public NewSamplePositionControlPanel() {
        super(actionName, actionName, (String)null);
    }

    @Override
    protected void init() {
        super.init();
        this.zeroLabel = new JLabel();
        this.zeroTextField = new JTextField();
        this.newZeroPositionBtn = new KeyResponseButton(actionName, actionName, 112);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.newZeroPositionBtn.setHorizontalAlignment(2);
        QueuedAction someAction = new QueuedAction();
        this.newZeroPositionBtn.addActionListener(someAction);
        this.add((Component)this.newZeroPositionBtn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.zeroLabel.setText("New Sample Position");
        this.add((Component)this.zeroLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.zeroTextField.setText(" ");
        this.zeroTextField.setPreferredSize(new Dimension(60, 20));
        this.add((Component)this.zeroTextField, gridBagConstraints);
    }

    @Override
    public String getCurrentValue() {
        return this.zeroTextField.getText();
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setCurrentValue(String value) {
        this.zeroTextField.setText(value);
    }

    @Override
    public void setTargetValue(String value) {
    }

    @Override
    public void setKeyStroke(int keyStroke) {
        this.keyStroke = keyStroke;
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(keyStroke, 0), this.deviceName);
        Action action = this.newZeroPositionBtn.getAction();
        this.getActionMap().put(this.deviceName, action);
    }

    @Override
    public String getHint() {
        return this.newZeroPositionBtn.getToolTipText();
    }

    @Override
    public void setHint(String hint) {
        this.newZeroPositionBtn.setToolTipText(hint);
    }

    @Override
    public void readHintsFromPreferenceFile() {
        super.readHintsFromPreferenceFile();
        String name = this.zeroLabel.getText().replace(" ", "");
        name = name.replace(":", "");
        String key = String.valueOf(this.getParent().getClass().getName()) + "." + this.getClass().getSimpleName() + "." + name + ".hint";
        String controlHint = HelpPropertiesManager.getPreferenceString(key);
        if (!controlHint.equals("undefined")) {
            this.setHint(controlHint);
        }
    }

    private class QueuedAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            String cValue = NewSamplePositionControlPanel.this.getCurrentValue();
            if ((cValue = cValue.trim()).equals("")) {
                return;
            }
            try {
                double value = Double.parseDouble(NewSamplePositionControlPanel.this.getCurrentValue());
            }
            catch (NumberFormatException ne) {
                IcePanelException ipe = new IcePanelException("Incorrect value format, please insert numeric value");
                IceClientErrorEvent errorEvent = new IceClientErrorEvent(NewSamplePositionControlPanel.this, ipe);
                IcePanelManager panelManager = IcePanelManager.getReference();
                panelManager.notifyIceClientErrorListeners(errorEvent);
                NewSamplePositionControlPanel.this.setCurrentValue(" ");
            }
            String command = "device set SamplePosition " + NewSamplePositionControlPanel.this.getCurrentValue();
            SansCommandManager.takeQueuedAction(command);
            NewSamplePositionControlPanel.this.setCurrentValue(" ");
        }
    }
}

