/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.communication;

import ice.ClientAPI;
import ice.IcePanelManager;
import ice.commands.DeviceFreeCommand;
import ice.commands.QueuedCommand;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class FixDeviceActionListener
implements ActionListener {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    SansDeviceControlPanel devicePanel;
    IcePanelManager panelManager;

    public FixDeviceActionListener(SansDeviceControlPanel panel) {
        this.devicePanel = panel;
        this.panelManager = IcePanelManager.getReference();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!(event.getSource() instanceof JCheckBox)) {
            return;
        }
        JCheckBox fixedCheckBox = (JCheckBox)event.getSource();
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            String deviceName = this.devicePanel.getDeviceName();
            if (fixedCheckBox.isSelected()) {
                QueuedCommand command = new QueuedCommand("device fix " + deviceName, messageSender);
                command.runAsynchronous();
            } else {
                DeviceFreeCommand freeCommand = new DeviceFreeCommand(deviceName, messageSender);
                freeCommand.runAsynchronous();
            }
        }
        catch (Exception e) {
            logger.error("Sample Panel Error", e.getCause());
            e.printStackTrace();
        }
    }
}

