/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.actions;

import ice.gui.panel.sans.actions.SansButtonAction;
import ice.gui.panel.sans.communication.SansCommandResponseEvent;
import ice.gui.panel.sans.communication.SansCommandResponseListener;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import ice.gui.panel.sans.subpanels.autodata.RunListTable;
import ice.gui.panel.sans.subpanels.autodata.SansTableModel;
import ice.util.ConversionUtilities;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class DryRunListAction
extends SansButtonAction
implements SansCommandResponseListener {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private static final String error = "N/A";
    private SansTableModel tableModel;
    private RunListTable table;

    public DryRunListAction(String name, RunListTable table) {
        super(name);
        this.table = table;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int from = Integer.valueOf(this.rangePanel.getLowRangeValue());
        int to = Integer.valueOf(this.rangePanel.getHighRangeValue());
        try {
            String message = "scan howlong " + from + " " + to + " -s -v";
            SansCommandManager.takeImmediateAction(message, "howlong", this);
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }

    @Override
    public void actionPerformed(SansCommandResponseEvent e) {
        String tag = e.getTag();
        String response = (String)e.getSource();
        String dryRunMessage = "Total counting time is ";
        try {
            Double timeInSec = Double.valueOf(response);
            dryRunMessage = String.valueOf(dryRunMessage) + timeInSec + " sec";
            if (timeInSec.intValue() > 60) {
                String timeInHrs = ConversionUtilities.convertSecondsToDays(timeInSec);
                dryRunMessage = String.valueOf(dryRunMessage) + "or " + timeInHrs;
            }
        }
        catch (Exception ex) {
            dryRunMessage = String.valueOf(dryRunMessage) + error;
        }
        Container window = this.table.getTopLevelAncestor();
        JOptionPane.showMessageDialog(window, dryRunMessage, this.name, 1);
    }
}

