/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.IcePanelManager;
import ice.communication.SendQueueManager;
import ice.data.BaseScan;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.InstalledDevice;
import ice.data.Resource;
import ice.data.ScanList;
import ice.event.LoadSaveableIcePanelEvent;
import ice.event.LoadSaveableIcePanelListener;
import ice.exceptions.IcePanelException;
import ice.exceptions.IcePanelUncheckedException;
import ice.gui.core.EditMultipleScansDialog;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceViewPanel;
import ice.gui.core.IceWindow;
import ice.jython.management.PythonContainer;
import ice.swing.Bag;
import ice.swing.IceFileTableModel;
import ice.swing.IceFileTree;
import ice.swing.IceFileTreeCellRenderer;
import ice.swing.ResourceMgrTableCellRenderer;
import ice.swing.ResourceMgrTreeModel;
import ice.swing.ScanTableModel;
import ice.swing.actions.IceMenuAction;
import ice.swing.datatransfer.IceFileTreeTransferHandler;
import ice.swing.datatransfer.ResourceTableTransferHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;

public class ResourceManagerPanel
extends IceViewPanel
implements TreeSelectionListener,
MouseListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.ResourceMgrLogger");
    private SendQueueManager sendManager;
    private IceFileTree fileTree;
    private ResourceMgrTreeModel fileTreeModel;
    private JXTable fileTable;
    private ScanTableModel scanTableModel;
    private IceFileTableModel iceFileTableModel;
    private JPopupMenu popupMenu;
    private TablePopupListener tpl;
    private JMenuItem editItem;
    private DeleteAction deleteAction;
    private JMenuItem deleteMenuItem;
    private LoadScanListAction loadScanListAction;
    private JMenuItem loadScanListItem;
    private JMenuItem loadPythonItem;
    private LoadEditMultipleScansWindowAction loadEditMultScansWindowAction;
    private JMenuItem loadEditMultScansWindowItem;
    protected ArrayList<InstalledDevice> deviceList;
    private HashMap<String, IceMenuAction> actionList;
    private IceMenuAction saveScanListAction;
    private Controller controller;

    public ResourceManagerPanel() throws IcePanelException {
        super("Resource Manager");
        this.deleteMenuItem = new JMenuItem(this.deleteAction);
    }

    @Override
    protected void init() {
        this.deleteAction = new DeleteAction();
        this.tpl = new TablePopupListener();
        this.loadEditMultScansWindowAction = new LoadEditMultipleScansWindowAction();
        this.loadScanListAction = new LoadScanListAction();
        this.controller = Controller.getReference();
        this.sendManager = this.controller.getSendManager();
        IceFile rootFile = this.controller.getRootFile();
        ScanList scanList = this.controller.getServerScanList();
        ArrayList<InstalledDevice> deviceList = this.controller.getDeviceList();
        this.fileTreeModel = new ResourceMgrTreeModel(rootFile, scanList);
        this.fileTree = new IceFileTree(this.fileTreeModel, this.sendManager);
        this.fileTree.setCellRenderer(new IceFileTreeCellRenderer());
        this.fileTree.setTransferHandler(new IceFileTreeTransferHandler(this.sendManager));
        this.fileTree.addTreeSelectionListener(this);
        this.fileTree.addMouseListener(this);
        this.scanTableModel = new ScanTableModel(scanList);
        this.iceFileTableModel = new IceFileTableModel(rootFile);
        this.popupMenu = new JPopupMenu();
        this.editItem = new JMenuItem(new EditResourceAction());
        this.loadEditMultScansWindowItem = new JMenuItem(this.loadEditMultScansWindowAction);
        this.deleteMenuItem = new JMenuItem(this.deleteAction);
        this.loadScanListItem = new JMenuItem(this.loadScanListAction);
        this.loadPythonItem = new JMenuItem(new LoadPythonAction());
        this.fileTable = new JXTable();
        this.fileTable.setShowGrid(false);
        this.fileTable.setDragEnabled(true);
        this.fileTable.setTransferHandler(new ResourceTableTransferHandler(this.sendManager));
        this.fileTable.setSelectionMode(2);
        this.saveScanListAction = new SaveScanListAction();
        this.actionList = new HashMap();
        this.actionList.put("Save", this.saveScanListAction);
        this.initState();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        JScrollPane navPanel = new JScrollPane(this.createNavPanel(), 20, 30);
        JPanel filePanel = this.createFilePanel();
        navPanel.getVerticalScrollBar().setUnitIncrement(7);
        JSplitPane splitPane = new JSplitPane(1, navPanel, filePanel);
        this.add(splitPane);
    }

    private void initState() {
        this.fileTable.setModel(this.iceFileTableModel);
        this.fileTable.setDefaultRenderer(IceFile.class, new ResourceMgrTableCellRenderer());
        this.fileTable.setDefaultRenderer(BaseScan.class, new ResourceMgrTableCellRenderer());
        this.fileTable.addMouseListener(this.tpl);
    }

    private JPanel createNavPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        constraints.inset(0, 0, 0, 0);
        int x = 0;
        int y = 0;
        int maxRows = 2;
        boolean maxCols = true;
        JLabel folderLabel = new JLabel("Folders");
        folderLabel.setBorder(new BevelBorder(0));
        panel.add((Component)folderLabel, constraints.cell(x, y).fillx());
        panel.add((Component)this.fileTree, constraints.cell(x, ++y).fillboth());
        return panel;
    }

    private JPanel createFilePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        constraints.inset(0, 0, 0, 0);
        int x = 0;
        int y = 0;
        JScrollPane scrollPane = new JScrollPane(this.fileTable);
        panel.add((Component)scrollPane, constraints.cell(x, y).fillboth());
        return panel;
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
    }

    @Override
    public IceMenuAction getIceMenuAction(String actionName) {
        IceMenuAction action = this.actionList.get(actionName);
        if (action == null) {
            return new IceMenuAction(actionName);
        }
        return action;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath selectionPath;
        Object source = null;
        source = e.getSource();
        if (source instanceof IceFileTree && (selectionPath = this.fileTree.getSelectionPath()) != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            Object object = node.getUserObject();
            if (object instanceof IceFile) {
                this.iceFileTableModel.setRoot((IceFile)object);
                this.fileTable.setModel(this.iceFileTableModel);
            } else if (object instanceof String && object.equals("Server Scan List")) {
                this.fileTable.setModel(this.scanTableModel);
            }
            this.fileTable.setSortable(false);
            this.fileTable.setSortable(true);
            this.fileTable.updateUI();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class DeleteAction
    extends GenericIcePanel.ConfirmableAction {
        public DeleteAction() {
            super("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String title = "Confirm Remove";
            String message = "Are you sure you want to remove ";
            int[] selectedRows = ResourceManagerPanel.this.fileTable.getSelectedRows();
            int length = selectedRows.length;
            if (length == 0) {
                return;
            }
            message = length == 1 ? String.valueOf(message) + "'" + ResourceManagerPanel.this.fileTable.getModel().getValueAt(selectedRows[0], 0).toString() + "'?" : String.valueOf(message) + "these files?";
            ArrayList<JButton> btns = this.createOkCancelBtns();
            ResourceManagerPanel.this.throwConfirmDialog(title, message, btns);
        }

        @Override
        public void confirmed() {
            String namePrefixAndSuffix = "";
            int[] selectedRows = ResourceManagerPanel.this.fileTable.getSelectedRows();
            TableModel model = ResourceManagerPanel.this.fileTable.getModel();
            int i = 0;
            while (i < selectedRows.length) {
                Object obj = model.getValueAt(selectedRows[i], 0);
                String name = ((Resource)obj).getName();
                if (name.contains(" ")) {
                    namePrefixAndSuffix = "\"";
                }
                if (obj instanceof IceFile) {
                    IceFile file;
                    String path = "";
                    IceFile parent = file = (IceFile)obj;
                    while (!parent.isMagicWord()) {
                        path = "/" + parent.getName() + path;
                        parent = parent.getParent();
                    }
                    if (path.length() > 0) {
                        path = path.substring(1);
                    }
                    path = String.valueOf(parent.getName()) + ":" + path;
                    String message = "file delete " + namePrefixAndSuffix + path + namePrefixAndSuffix;
                    ResourceManagerPanel.this.sendManager.addMessage(message, true);
                } else if (obj instanceof BaseScan) {
                    ResourceManagerPanel.this.sendManager.addMessage("scan delete " + namePrefixAndSuffix + ((BaseScan)obj).getName() + namePrefixAndSuffix, true);
                }
                ++i;
            }
        }

        @Override
        public void declined() {
        }
    }

    private class EditResourceAction
    extends AbstractAction {
        public EditResourceAction() {
            super("Edit");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            IceWindow window = null;
            IcePanelManager panelManager = IcePanelManager.getReference();
            window = panelManager.getIceWindow(ResourceManagerPanel.this);
            if (window == null) {
                logger.error("No window is associated with this panel");
                throw new IcePanelUncheckedException("No window is associated with this panel");
            }
            int[] rows = ResourceManagerPanel.this.fileTable.getSelectedRows();
            int length = rows.length;
            int i = 0;
            while (i < length) {
                Object obj = ResourceManagerPanel.this.fileTable.getValueAt(rows[i], 0);
                if (obj instanceof Resource) {
                    IceFileType theFileType = null;
                    theFileType = ((Resource)obj).getFileType();
                    if (theFileType == IceFileType.directory) {
                        ResourceManagerPanel.this.iceFileTableModel.setRoot((IceFile)obj);
                        ResourceManagerPanel.this.fileTable.setModel(ResourceManagerPanel.this.iceFileTableModel);
                        ResourceManagerPanel.this.fileTable.setSortable(false);
                        ResourceManagerPanel.this.fileTable.setSortable(true);
                        ResourceManagerPanel.this.fileTable.updateUI();
                    } else {
                        ArrayList<LoadSaveableIcePanelListener> Listeners = window.getLoadSaveableIcePanelListeners();
                        for (LoadSaveableIcePanelListener listener : Listeners) {
                            LoadSaveableIcePanelEvent event = new LoadSaveableIcePanelEvent(window, null, (Resource)obj);
                            listener.instantiateSaveableIcePanel(event);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private class EditScanAsTextAction
    extends AbstractAction {
        public EditScanAsTextAction() {
            super("Edit as Text");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ResourceManagerPanel.this.fileTree.getSelectionPath().getLastPathComponent();
            Object obj = node.getUserObject();
            Resource rc = null;
            if (obj instanceof Resource) {
                rc = (Resource)obj;
            } else if (obj instanceof String) {
                String name = (String)obj;
                IceFile file = new IceFile(name, "", IceFileType.scan);
                rc = file;
            }
            IceWindow window = null;
            IcePanelManager panelManager = IcePanelManager.getReference();
            window = panelManager.getIceWindow(ResourceManagerPanel.this);
            if (window == null) {
                throw new IcePanelUncheckedException("No window is associated with this panel");
            }
            ArrayList<LoadSaveableIcePanelListener> Listeners = window.getLoadSaveableIcePanelListeners();
            for (LoadSaveableIcePanelListener listener : Listeners) {
                LoadSaveableIcePanelEvent event = new LoadSaveableIcePanelEvent(window, null, rc, true);
                listener.instantiateSaveableIcePanel(event);
            }
        }
    }

    private class LoadEditMultipleScansWindowAction
    extends AbstractAction {
        public LoadEditMultipleScansWindowAction() {
            super("Edit Scan Parameters");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] rows = ResourceManagerPanel.this.fileTable.getSelectedRows();
            ArrayList<BaseScan> scans = new ArrayList<BaseScan>();
            int i = 0;
            while (i < rows.length) {
                try {
                    Object object = ResourceManagerPanel.this.fileTable.getValueAt(rows[i], 0);
                    scans.add((BaseScan)object);
                }
                catch (ClassCastException cce) {
                    logger.error("Non-BaseScan included in list of scans to be edited.  Ignoring.  THIS SHOULD NOT HAPPEN.", cce);
                }
                ++i;
            }
            if (scans.size() > 0) {
                Container parent = ResourceManagerPanel.this.getFinalParent();
                if (!(parent instanceof JFrame)) {
                    parent = null;
                }
                EditMultipleScansDialog dialog = new EditMultipleScansDialog((JFrame)parent, scans);
                dialog.setLocationRelativeTo(ResourceManagerPanel.this);
                try {
                    dialog.setVisible(true);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    logger.error("ArryIndexOutOfBoundsException in LoadEditMultipleScansWindowAction.actionPerformed.");
                }
            }
        }
    }

    private class LoadPythonAction
    extends AbstractAction {
        public LoadPythonAction() {
            super("Load (Python)");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int row = ResourceManagerPanel.this.fileTable.getSelectedRow();
            Object obj = ResourceManagerPanel.this.fileTable.getModel().getValueAt(row, 0);
            String message = "";
            PythonContainer pythonContainer = null;
            message = String.valueOf(message) + ((IceFile)obj).getName() + " not found!";
            pythonContainer = PythonContainer.getReference();
            boolean succeeded = false;
            succeeded = pythonContainer.loadRemotePythonFile((IceFile)obj);
            if (!succeeded) {
                ResourceManagerPanel.this.throwErrorDialog("Error", message);
            }
        }
    }

    private class LoadScanListAction
    extends AbstractAction {
        public LoadScanListAction() {
            super("Load (Scanlist)");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int row = ResourceManagerPanel.this.fileTable.getSelectedRow();
            Object obj = ResourceManagerPanel.this.fileTable.getModel().getValueAt(row, 0);
            ResourceManagerPanel.this.sendManager.addMessage("scan loadlist " + obj.toString());
        }
    }

    private class SaveScanListAction
    extends IceMenuAction {
        public SaveScanListAction() {
            super("Save Scan List");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String filename = "";
            while (filename.length() == 0) {
                filename = JOptionPane.showInputDialog(ResourceManagerPanel.this, (Object)"What do you want to save this scan list as?");
                if (filename != null) continue;
                return;
            }
            if (!filename.toUpperCase().endsWith(IceFileType.scanList.getExtension().toUpperCase())) {
                filename = filename.concat(IceFileType.scanList.getExtension());
            }
            ResourceManagerPanel.this.sendManager.addMessage("scan listbackup " + filename);
        }
    }

    private class TablePopupListener
    extends MouseAdapter {
        private TablePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.processClick(me);
            this.maybeShowPopup(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            this.maybeShowPopup(me);
        }

        private void processClick(MouseEvent me) {
            int columnIndex = ResourceManagerPanel.this.fileTable.columnAtPoint(me.getPoint());
            int rowIndex = ResourceManagerPanel.this.fileTable.rowAtPoint(me.getPoint());
            IcePanelManager panelManager = IcePanelManager.getReference();
            IceWindow window = panelManager.getIceWindow(ResourceManagerPanel.this);
            if (window == null) {
                logger.error("IceWindow does not exist for this panel ResourceManagerPanel");
            }
            logger.debug("modifier: " + this.isModifierFree(me));
            if (me.getButton() == 1 && me.getClickCount() == 2 && this.isModifierFree(me)) {
                ActionEvent theEvent = null;
                theEvent = new ActionEvent(window, 1001, "");
                new EditResourceAction().actionPerformed(theEvent);
            }
        }

        private void maybeShowPopup(MouseEvent me) {
            if (me.isPopupTrigger()) {
                this.determineMenuState(me);
                this.loadMenu(me);
            }
        }

        private void determineMenuState(MouseEvent me) {
            int[] rows = ResourceManagerPanel.this.fileTable.getSelectedRows();
            boolean includesFiles = false;
            boolean includesDirectory = false;
            boolean includesScanListOrXML = false;
            boolean includesScan = false;
            boolean includesLoadPython = false;
            int i = 0;
            while (i < rows.length) {
                Object object = ResourceManagerPanel.this.fileTable.getValueAt(rows[i], 0);
                if (object instanceof IceFile) {
                    includesFiles = true;
                    IceFile file = (IceFile)object;
                    IceFileType fileType = file.getFileType();
                    if (IceFileType.xml == fileType || IceFileType.directory == fileType) {
                        includesScanListOrXML = true;
                    } else if (IceFileType.directory == fileType) {
                        includesDirectory = true;
                    } else if (IceFileType.pythonScript == fileType) {
                        includesLoadPython = true;
                    }
                } else if (object instanceof BaseScan) {
                    includesScan = true;
                }
                ++i;
            }
            if (!includesDirectory && !includesScan && includesScanListOrXML) {
                ResourceManagerPanel.this.popupMenu.add(ResourceManagerPanel.this.loadScanListItem);
            } else {
                ResourceManagerPanel.this.popupMenu.remove(ResourceManagerPanel.this.loadScanListItem);
            }
            if (includesLoadPython) {
                ResourceManagerPanel.this.popupMenu.add(ResourceManagerPanel.this.loadPythonItem);
            } else {
                ResourceManagerPanel.this.popupMenu.remove(ResourceManagerPanel.this.loadPythonItem);
            }
            if (includesFiles && !includesDirectory) {
                ResourceManagerPanel.this.popupMenu.add(ResourceManagerPanel.this.deleteMenuItem);
            } else {
                ResourceManagerPanel.this.popupMenu.remove(ResourceManagerPanel.this.deleteMenuItem);
            }
            if (includesScan && !includesDirectory && !includesFiles) {
                ResourceManagerPanel.this.popupMenu.add(ResourceManagerPanel.this.loadEditMultScansWindowItem);
            } else {
                ResourceManagerPanel.this.popupMenu.remove(ResourceManagerPanel.this.loadEditMultScansWindowItem);
            }
        }

        private boolean isModifierFree(MouseEvent me) {
            return !me.isAltDown() && !me.isAltGraphDown() && !me.isControlDown() && !me.isShiftDown();
        }

        private void loadMenu(MouseEvent me) {
            int index = ResourceManagerPanel.this.fileTable.getSelectedRow();
            if (index == -1) {
                return;
            }
            ResourceManagerPanel.this.popupMenu.remove(ResourceManagerPanel.this.editItem);
            if (ResourceManagerPanel.this.fileTable.getValueAt(index, 0) instanceof BaseScan) {
                ResourceManagerPanel.this.popupMenu.insert(ResourceManagerPanel.this.editItem, 0);
            }
            ResourceManagerPanel.this.popupMenu.show(me.getComponent(), me.getX(), me.getY());
        }
    }
}

