/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.Global;
import ice.communication.SendQueueManager;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.Resource;
import ice.event.ModifyEvent;
import ice.event.ModifyListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceEditPanel;
import ice.gui.core.editorPanel.ResourceTexteditor;
import ice.swing.actions.IceMenuAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ResourceEditorPanel
extends IceEditPanel
implements ModifyListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.EditorLogger");
    private static int maxTabLength = 12;
    protected SendQueueManager sendManager;
    protected Pattern nameCheckPattern;
    protected JPopupMenu popupMenu;
    protected MouseAdapter popupListener;
    protected IceFile rootFile;
    private ResourceTexteditor resourceEditorPane;
    private CloseAction closeAction;
    private CutAction cutAction;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private SelectAllAction selectAllAction;
    private SelectNoneAction selectNoneAction;
    private HashMap<String, IceMenuAction> actionList;
    private Controller controller;
    private int panelNumber;

    public ResourceEditorPanel(Resource file) throws IcePanelException {
        super("Untitled", file);
    }

    @Override
    protected void init() {
        this.setName("Resource Editor");
        this.controller = Controller.getReference();
        this.sendManager = this.controller.getSendManager();
        this.rootFile = this.controller.getRootFile();
        this.nameCheckPattern = Pattern.compile("[A-Za-z][A-Za-z0-9_\\.]*");
        this.closeAction = new CloseAction("Close");
        this.cutAction = new CutAction("Cut");
        this.copyAction = new CopyAction("Copy");
        this.pasteAction = new PasteAction("Paste");
        this.saveAction = new SaveAction("Save");
        this.saveAsAction = new SaveAsAction("Save As...");
        this.selectAllAction = new SelectAllAction("Select All");
        this.selectNoneAction = new SelectNoneAction("Select None");
        this.actionList = new HashMap();
        this.actionList.put("Close", this.closeAction);
        this.actionList.put("Cut", this.cutAction);
        this.actionList.put("Copy", this.copyAction);
        this.actionList.put("Paste", this.pasteAction);
        this.actionList.put("Save", this.saveAction);
        this.actionList.put("Select All", this.selectAllAction);
        this.actionList.put("Select None", this.selectNoneAction);
        this.actionList.put("Save As...", this.saveAsAction);
        this.panelNumber = Global.getPanelNumber();
        Global.incrementPanelNumber();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.closeAction);
        this.popupListener = new PopupListener(this.popupMenu);
        this.addMouseListener(this.popupListener);
        this.addMouseListener(this.popupListener);
    }

    @Override
    protected void loadResource() {
        if (this.resource == null) {
            this.resource = new IceFile(null, " ", IceFileType.unknown);
        }
        this.resourceEditorPane = new ResourceTexteditor(this.resource);
        this.add(this.resourceEditorPane);
        this.resourceEditorPane.addModifyListener(this);
        this.updateName();
    }

    public static IceFileType[] getSupportedFileTypes() {
        IceFileType[] fileTypes = new IceFileType[]{IceFileType.sequence, IceFileType.pythonScript, IceFileType.xml};
        return fileTypes;
    }

    private String getAbbreviatedName(String name) {
        if (name.length() > maxTabLength) {
            char[] newChars = new char[maxTabLength - 3];
            name.getChars(0, maxTabLength - 3, newChars, 0);
            return String.valueOf(new String(newChars)) + this.panelNumber + "...";
        }
        return name;
    }

    private void updateName() {
        String resourceName = this.resourceEditorPane.getResourceName();
        if (this.resourceEditorPane.isUnnamed()) {
            String newName = "*" + this.resourceEditorPane.getResourceName();
            this.setName(newName);
            this.notifyNameChangeListeners(newName, resourceName);
        } else if (this.resourceEditorPane.isModified()) {
            String newName = "*" + this.resourceEditorPane.getResourceName();
            this.setName(newName);
            this.notifyNameChangeListeners(newName, resourceName);
        } else {
            String oldName = this.getName();
            String newName = this.resourceEditorPane.getResourceName();
            this.setName(newName);
            this.notifyNameChangeListeners(newName, oldName);
        }
    }

    private boolean saveResource(boolean saveAs) {
        boolean cancelPressed = false;
        String response = null;
        String magicWord = null;
        if (this.resourceEditorPane.isUnnamed() || saveAs) {
            Boolean validResponse;
            SaveDialog saveDialog = new SaveDialog((Frame)this.getFinalParent());
            do {
                saveDialog.setVisible(true);
                response = saveDialog.getFilename();
                magicWord = saveDialog.getMagicWord();
                cancelPressed = saveDialog.isCancelPressed();
                if (cancelPressed) break;
                if (response == null || response.compareTo("") == 0) {
                    JOptionPane.showMessageDialog(this, "File name may not have a length of zero!");
                    validResponse = false;
                    continue;
                }
                if (!response.endsWith(this.resourceEditorPane.getExtension())) {
                    response = String.valueOf(response) + this.resourceEditorPane.getExtension();
                }
                String extension = null;
                int extensionStart = -1;
                extensionStart = response.lastIndexOf(".");
                if (extensionStart != -1) {
                    extension = response.substring(extensionStart);
                    this.resourceEditorPane.setExtension(extension);
                }
                int indexOfFile = -1;
                IceFile theDirectory = null;
                this.rootFile = this.controller.getRootFile();
                indexOfFile = this.rootFile.getIndexOfChild(magicWord);
                theDirectory = this.rootFile.getChildAt(indexOfFile);
                if ((indexOfFile = theDirectory.getIndexOfChild(response)) == -1) {
                    if (this.nameCheckPattern.matcher(response).matches()) {
                        Resource resource = this.resourceEditorPane.getResource();
                        if (resource instanceof IceFile) {
                            ((IceFile)resource).setParent(theDirectory);
                        }
                        this.resourceEditorPane.setResourceName(response);
                        validResponse = true;
                        continue;
                    }
                    JOptionPane.showMessageDialog(this, "Resource names must begin with a letter and may only contain alphanumeric, '_', or '.' characters!");
                    validResponse = false;
                    continue;
                }
                JOptionPane.showMessageDialog(this, "A resource with that name  already exists!");
                validResponse = false;
            } while (!validResponse.booleanValue());
            saveDialog.dispose();
        }
        boolean returnValue = false;
        if (!cancelPressed) {
            String oldName = this.getName();
            if (response != null) {
                if (this.resource != null) {
                    IceFile newFile = null;
                    newFile = (IceFile)this.resource.cloneWithNewListeners();
                    newFile.setName(response);
                    this.resource = newFile;
                    this.resourceEditorPane.saveResource(this.sendManager, (IceFile)this.resource);
                }
                this.setName(response);
                this.notifyNameChangeListeners(response, oldName);
                returnValue = true;
            } else {
                this.resourceEditorPane.saveResource(this.sendManager);
            }
        }
        return returnValue;
    }

    private boolean closeResource() {
        if (this.resourceEditorPane.isModified()) {
            int response = JOptionPane.showConfirmDialog(this, "This resource has not been saved.\nDo you want to save before closing?", "Confirm Close", 1);
            if (response == 2) {
                return false;
            }
            if (response == 0 && !this.saveResource(false)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean panelClosing() {
        return this.closeResource();
    }

    @Override
    public IceMenuAction getIceMenuAction(String actionName) {
        IceMenuAction action = this.actionList.get(actionName);
        if (action == null) {
            return new IceMenuAction(actionName);
        }
        return action;
    }

    @Override
    public void stateModified(ModifyEvent me) {
        this.updateName();
    }

    private class CloseAction
    extends IceMenuAction {
        public CloseAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ResourceEditorPanel.this.closeResource();
        }
    }

    private class CopyAction
    extends IceMenuAction {
        public CopyAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ResourceEditorPanel.this.resourceEditorPane.copyResource();
        }
    }

    private class CutAction
    extends IceMenuAction {
        public CutAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ResourceEditorPanel.this.resourceEditorPane.cutResource();
        }
    }

    private class PasteAction
    extends IceMenuAction {
        public PasteAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ResourceEditorPanel.this.resourceEditorPane.pasteResource();
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private JPopupMenu menu;

        PopupListener(JPopupMenu menu) {
            this.menu = menu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ResourceEditorPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    protected class SaveAction
    extends IceMenuAction {
        public SaveAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ResourceEditorPanel.this.saveResource(false);
        }
    }

    protected class SaveAsAction
    extends IceMenuAction {
        public SaveAsAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ResourceEditorPanel.this.saveResource(true);
        }
    }

    private class SaveDialog
    extends JDialog
    implements ActionListener {
        private JTextField filenameField;
        private JComboBox locationCB;
        private JComboBox fileTypeCB;
        private JButton saveBtn;
        private JButton cancelBtn;
        protected String filename;
        protected String magicWord;
        protected boolean cancelPressed;

        public SaveDialog(Frame parent) {
            super(parent);
            this.filename = null;
            this.magicWord = null;
            this.cancelPressed = false;
            this.filenameField = new JTextField(10);
            String[] magicWords = new String[]{"Current Experiment", "Common"};
            this.locationCB = new JComboBox<String>(magicWords);
            this.fileTypeCB = new JComboBox();
            this.fileTypeCB.addItem(IceFileType.sequence);
            this.fileTypeCB.addItem(IceFileType.pythonScript);
            this.fileTypeCB.addItem(IceFileType.xml);
            this.saveBtn = new JButton("Save");
            this.cancelBtn = new JButton("Cancel");
            this.saveBtn.addActionListener(this);
            this.cancelBtn.addActionListener(this);
            this.buildGUI();
            this.setLocationRelativeTo(parent);
        }

        public void buildGUI() {
            this.setModal(true);
            this.setResizable(false);
            this.setTitle("Save Queue");
            this.setDefaultCloseOperation(2);
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.weightx = 0.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            contentPane.add((Component)new JLabel("File name:"), constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            contentPane.add((Component)this.filenameField, constraints);
            constraints.weightx = 0.0;
            ++constraints.gridx;
            contentPane.add((Component)new JLabel(""), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            contentPane.add((Component)new JLabel("File Type:"), constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            contentPane.add((Component)this.fileTypeCB, constraints);
            constraints.weightx = 0.0;
            ++constraints.gridx;
            contentPane.add((Component)new JLabel(""), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            contentPane.add((Component)new JLabel("Location:"), constraints);
            ++constraints.gridx;
            constraints.weightx = 1.0;
            contentPane.add((Component)this.locationCB, constraints);
            constraints.weightx = 0.0;
            ++constraints.gridx;
            contentPane.add((Component)new JLabel(""), constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            contentPane.add((Component)new JLabel(""), constraints);
            ++constraints.gridx;
            JPanel btnPanel = new JPanel();
            btnPanel.add(this.saveBtn);
            btnPanel.add(this.cancelBtn);
            constraints.gridwidth = 2;
            contentPane.add((Component)btnPanel, constraints);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.cancelPressed = false;
            if (ae.getSource() == this.cancelBtn) {
                this.cancelPressed = true;
                this.setVisible(false);
            } else if (ae.getSource() == this.saveBtn) {
                Resource theResource = null;
                this.filename = this.filenameField.getText();
                if (this.filename.length() != 0) {
                    IceFileType selectedFileType = null;
                    String extension = null;
                    selectedFileType = (IceFileType)((Object)this.fileTypeCB.getSelectedItem());
                    extension = selectedFileType.getExtension();
                    if (!this.filename.endsWith(extension)) {
                        this.filename = this.filename.concat(extension);
                    }
                    theResource = ResourceEditorPanel.this.getResource();
                    theResource.setFileType(selectedFileType);
                    if (((String)this.locationCB.getSelectedItem()).equals("Personal")) {
                        this.magicWord = "USER";
                    } else if (((String)this.locationCB.getSelectedItem()).equals("Current Experiment")) {
                        this.magicWord = "EXPT";
                    } else if (((String)this.locationCB.getSelectedItem()).equals("Common")) {
                        this.magicWord = "COMM";
                    }
                    this.setVisible(false);
                } else {
                    JOptionPane.showMessageDialog(this, "You must enter a file name!");
                }
            }
        }

        public String getFilename() {
            return this.filename;
        }

        public String getMagicWord() {
            return this.magicWord;
        }

        public boolean isCancelPressed() {
            return this.cancelPressed;
        }
    }

    private class SelectAllAction
    extends IceMenuAction {
        public SelectAllAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ResourceEditorPanel.this.resourceEditorPane.selectAll();
        }
    }

    private class SelectNoneAction
    extends IceMenuAction {
        public SelectNoneAction(String actionName) {
            super(actionName);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ResourceEditorPanel.this.resourceEditorPane.selectNone();
        }
    }
}

