/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.startup;

import ice.IconManager;
import ice.event.StartUpEvent;
import ice.event.StartUpListener;
import ice.gui.core.startup.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class StartUpWindow
extends JWindow
implements StartUpListener {
    private static final String TITLE_KEY = "Starting ICE Client...";
    private static final long serialVersionUID = 1L;
    private static StartUpWindow instance;
    private JLabel notifications;

    private StartUpWindow() throws HeadlessException {
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.notifications = new JLabel();
        this.notifications.setOpaque(true);
        this.notifications.setBackground(Color.white);
        this.notifications.setText("Initializing Components...");
        ImageIcon logoIcon = IconManager.getIcon("ice.logo");
        ImagePanel imagePanel = new ImagePanel(logoIcon);
        this.add((Component)imagePanel, "Center");
        this.add((Component)this.notifications, "South");
        this.pack();
        this.setAlwaysOnTop(true);
        this.setLocation(0, 0);
    }

    public static StartUpWindow getInstance() {
        if (instance == null) {
            instance = new StartUpWindow();
        }
        return instance;
    }

    public void updateNotification(String message) {
        System.out.println(message);
        if (instance.isVisible()) {
            this.notifications.setText(message);
            Rectangle bounds = this.notifications.getBounds();
            this.notifications.paintImmediately(0, 0, bounds.width, bounds.height);
        }
    }

    void run(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeLater(r);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setLocationTopMiddle() {
        if (instance != null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            int width = this.getSize().width;
            Rectangle bounds = ge.getMaximumWindowBounds();
            this.setLocation(bounds.width / 2 - width / 2, 0);
        }
    }

    @Override
    public void actionPerformed(StartUpEvent sup) {
        StartUpEvent.MessageType type = sup.getType();
        String message = sup.getMessage();
        switch (type) {
            case MESSAGE: {
                this.updateNotification(message);
                break;
            }
            case KILL: {
                this.killThisWindow();
            }
        }
    }

    private void killThisWindow() {
        System.out.println("Close start up window");
        this.dispose();
    }
}

