/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses;

import ice.data.InstalledDevice;
import ice.gui.core.rangeClasses.DeviceValue.DeviceValue;
import ice.gui.core.rangeClasses.DeviceValue.DoubleDeviceValue;
import ice.gui.core.rangeClasses.DeviceValue.HKLDeviceValue;
import ice.gui.core.rangeClasses.DeviceValue.StringDeviceValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultStyledDocument;

public class RangePanel
extends JTabbedPane {
    protected DeviceValue startValue = new HKLDeviceValue();
    protected DeviceValue stopValue = new HKLDeviceValue();
    protected DeviceValue incrementValue = new HKLDeviceValue();
    protected DeviceValue centerValue = new HKLDeviceValue();
    protected rangeTabPanel initFinalTab = null;
    protected rangeTabPanel initStepTab = null;
    protected rangeTabPanel centerStepTab = null;
    protected JLabel commentInitFinalTabLabel = new JLabel();
    protected JLabel commentInitStepTabLabel = new JLabel();
    protected JLabel commentCenterStepTabLabel = new JLabel();
    protected JLabel comment2InitFinalTabLabel = new JLabel();
    protected JLabel comment2InitStepTabLabel = new JLabel();
    protected JLabel comment2CenterStepTabLabel = new JLabel();
    protected ArrayList<InstalledDevice> deviceList;
    protected DefaultComboBoxModel deviceComboBoxModel;
    protected static final String deviceBoxLabelString = "Device:";
    protected static final String startLabelString = "Initial:";
    protected static final String stopLabelString = "Final:";
    protected static final String centerLabelString = "Center:";
    protected static final String incrementLabelString = "increment:";
    protected static final String initialFinalTabName = "Initial/Final";
    protected static final String initialStepTabName = "Initial/increment";
    protected static final String centerIncrementTabName = "Center/increment";
    protected static final String commentInitialText = "Comment";
    protected static final String comment2InitialText = "Comment Line 2";
    protected static final GridBagConstraints deviceLabelConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 0), 0, 5);
    protected static final GridBagConstraints deviceComboBoxConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 10), 5, 5);
    protected static final GridBagConstraints value1LabelConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 0), 0, 5);
    protected static final GridBagConstraints value1ControlConstraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 5), 5, 5);
    protected static final GridBagConstraints value2LabelConstraints = new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 10, 0, 10), 0, 5);
    protected static final GridBagConstraints value2ControlConstraints = new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 5, 5);
    protected static final GridBagConstraints comment1LabelConstraints = new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 2, new Insets(5, 10, 5, 5), 0, 5);

    public RangePanel(ArrayList<InstalledDevice> deviceList) {
        this.deviceList = deviceList;
        this.deviceComboBoxModel = new DefaultComboBoxModel<InstalledDevice>(new Vector<InstalledDevice>(deviceList));
        this.initFinalTab = new rangeTabPanel(new JComboBox(this.deviceComboBoxModel), this.startValue.getControl(), startLabelString, this.stopValue.getControl(), stopLabelString, commentInitialText, comment2InitialText);
        this.initStepTab = new rangeTabPanel(new JComboBox(this.deviceComboBoxModel), this.startValue.getControl(), startLabelString, this.incrementValue.getControl(), incrementLabelString, commentInitialText, comment2InitialText);
        this.centerStepTab = new rangeTabPanel(new JComboBox(this.deviceComboBoxModel), this.centerValue.getControl(), centerLabelString, this.incrementValue.getControl(), incrementLabelString, commentInitialText, comment2InitialText);
        this.addTab(initialFinalTabName, null, this.initFinalTab, "Use this tab for initial/final range type.");
        this.addTab(initialStepTabName, null, this.initStepTab, "Use this tab for initial/increment range type.");
        this.addTab(centerIncrementTabName, null, this.centerStepTab, "Use this tab for center/increment range type.");
        this.setDeviceComment(((InstalledDevice)this.deviceComboBoxModel.getSelectedItem()).getName());
    }

    @Override
    public void setEnabled(boolean enabled) {
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setEnabled(enabled);
            ++n2;
        }
        super.setEnabled(enabled);
    }

    public void setDeviceValueTypes(String device) {
        if (device.equals("Q")) {
            this.startValue = new HKLDeviceValue();
            this.stopValue = new HKLDeviceValue();
            this.centerValue = new HKLDeviceValue();
            this.incrementValue = new HKLDeviceValue();
        } else if (device.equals("Qx") || device.equals("Qy") || device.equals("Qz")) {
            this.startValue = new DoubleDeviceValue();
            this.stopValue = new DoubleDeviceValue();
            this.centerValue = new DoubleDeviceValue();
            this.incrementValue = new DoubleDeviceValue();
        } else {
            this.startValue = new StringDeviceValue();
            this.stopValue = new StringDeviceValue();
            this.centerValue = new StringDeviceValue();
            this.incrementValue = new DoubleDeviceValue();
        }
        this.initFinalTab.setValue1(this.startValue.getControl());
        this.initFinalTab.setValue2(this.stopValue.getControl());
        this.initStepTab.setValue1(this.startValue.getControl());
        this.initStepTab.setValue2(this.incrementValue.getControl());
        this.centerStepTab.setValue1(this.centerValue.getControl());
        this.centerStepTab.setValue2(this.incrementValue.getControl());
        this.repaint();
        this.updateUI();
    }

    public String getRangeText() {
        String rangeText = "RANGE=" + ((InstalledDevice)this.deviceComboBoxModel.getSelectedItem()).toString() + "=";
        switch (this.getSelectedIndex()) {
            case 0: {
                rangeText = String.valueOf(rangeText) + this.startValue.getValueString() + " " + this.stopValue.getValueString() + " s";
                break;
            }
            case 1: {
                rangeText = String.valueOf(rangeText) + this.startValue.getValueString() + " " + this.incrementValue.getValueString() + " i";
                break;
            }
            case 2: {
                rangeText = String.valueOf(rangeText) + this.centerValue.getValueString() + " " + this.incrementValue.getValueString();
            }
        }
        return rangeText;
    }

    public boolean validateData() {
        switch (this.getSelectedIndex()) {
            case 0: {
                return this.startValue.validateData() && this.stopValue.validateData();
            }
            case 1: {
                return this.startValue.validateData() && this.incrementValue.validateData();
            }
            case 2: {
                return this.centerValue.validateData() && this.incrementValue.validateData();
            }
        }
        return false;
    }

    public String getErrorText() {
        String errorText = String.valueOf(((InstalledDevice)this.deviceComboBoxModel.getSelectedItem()).getName()) + " range: ";
        switch (this.getSelectedIndex()) {
            case 0: {
                if (this.validateData()) {
                    return "";
                }
                if (!this.startValue.validateData()) {
                    errorText = String.valueOf(errorText) + "Start Value " + this.startValue.getErrorText() + "  ";
                }
                if (!this.stopValue.validateData()) {
                    errorText = String.valueOf(errorText) + "Stop Value " + this.stopValue.getErrorText() + "  ";
                }
                return errorText;
            }
            case 1: {
                if (this.validateData()) {
                    return "";
                }
                if (!this.startValue.validateData()) {
                    errorText = String.valueOf(errorText) + "Start Value " + this.startValue.getErrorText() + "  ";
                }
                if (!this.incrementValue.validateData()) {
                    errorText = String.valueOf(errorText) + "Increment Value " + this.incrementValue.getErrorText() + "  ";
                }
                return errorText;
            }
            case 2: {
                if (this.validateData()) {
                    return "";
                }
                if (!this.centerValue.validateData()) {
                    errorText = String.valueOf(errorText) + "Center Value " + this.centerValue.getErrorText() + "  ";
                }
                if (!this.incrementValue.validateData()) {
                    errorText = String.valueOf(errorText) + "Increment Value " + this.incrementValue.getErrorText() + "  ";
                }
                return errorText;
            }
        }
        return "Invalid range type";
    }

    public void setComment(String comment) {
        this.initFinalTab.setComment(comment);
        this.centerStepTab.setComment(comment);
        this.initStepTab.setComment(comment);
    }

    public void setDeviceComment(String deviceName) {
        if (deviceName.equals("Q")) {
            this.setComment("Remember: Setting a Q range with an angle range present may cause problems.  Note: Edit vector scan dialog will show the range type of the E range, not the Q range.");
        } else if (deviceName.equals("Qx") || deviceName.equals("Qy") || deviceName.equals("Qz")) {
            this.setComment("All target scans must contain a Q range of the same range type, or scan operation will fail.");
        } else if (deviceName.equals("A1") || deviceName.equals("A2") || deviceName.equals("A3") || deviceName.equals("A4") || deviceName.equals("A5") || deviceName.equals("A6")) {
            this.setComment("Remember: Setting an angle range with a Q range may cause problems.");
        } else {
            this.setComment("");
        }
    }

    public String getSelectedDeviceName() {
        return ((InstalledDevice)this.deviceComboBoxModel.getSelectedItem()).getName();
    }

    protected class deviceChangeListener
    implements ActionListener {
        protected deviceChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            RangePanel.this.setDeviceValueTypes(((InstalledDevice)RangePanel.this.deviceComboBoxModel.getSelectedItem()).getName());
            RangePanel.this.setDeviceComment(((InstalledDevice)RangePanel.this.deviceComboBoxModel.getSelectedItem()).getName());
        }
    }

    protected class rangeTabPanel
    extends JPanel {
        protected JComboBox deviceComboBox = null;
        protected JComponent value1 = null;
        protected JComponent value2 = null;
        protected JLabel valueLabel1 = null;
        protected JLabel valueLabel2 = null;
        protected JTextArea commentTextArea = null;
        protected static final int commentRows = 2;
        protected static final int commentCols = 20;

        public rangeTabPanel(JComboBox deviceComboBox, JComponent value1Control, String valueLabel1String, JComponent value2Control, String valueLabel2String, String comment1, String comment2) {
            this.setLayout(new GridBagLayout());
            this.deviceComboBox = deviceComboBox;
            this.add((Component)new JLabel(RangePanel.deviceBoxLabelString), deviceLabelConstraints);
            this.add((Component)deviceComboBox, deviceComboBoxConstraints);
            deviceComboBox.addActionListener(new deviceChangeListener());
            this.valueLabel1 = new JLabel(valueLabel1String);
            this.value1 = value1Control;
            this.add((Component)this.valueLabel1, value1LabelConstraints);
            this.add((Component)value1Control, value1ControlConstraints);
            this.valueLabel2 = new JLabel(valueLabel2String);
            this.value2 = value2Control;
            this.add((Component)this.valueLabel2, value2LabelConstraints);
            this.add((Component)value2Control, value2ControlConstraints);
            this.commentTextArea = new JTextArea(comment1);
            this.commentTextArea.setRows(2);
            this.commentTextArea.setColumns(30);
            this.commentTextArea.setEditable(false);
            this.commentTextArea.setWrapStyleWord(true);
            this.commentTextArea.setLineWrap(true);
            this.commentTextArea.setDocument(new DefaultStyledDocument());
            this.commentTextArea.setForeground(Color.BLACK);
            this.commentTextArea.setBackground(this.getBackground());
            this.commentTextArea.setToolTipText("Hints for setting this device's range field");
            this.add((Component)this.commentTextArea, comment1LabelConstraints);
        }

        public void setValue1(JComponent value1Control) {
            this.remove(this.value1);
            this.value1 = value1Control;
            this.add((Component)this.value1, value1ControlConstraints);
        }

        public void setValue2(JComponent value2Control) {
            this.remove(this.value2);
            this.value2 = value2Control;
            this.add((Component)this.value2, value2ControlConstraints);
        }

        public void setComment(String comment1String) {
            this.commentTextArea.setText(comment1String);
        }

        public String getComment() {
            return this.commentTextArea.getText();
        }

        @Override
        public void setEnabled(boolean enabled) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                c.setEnabled(enabled);
                ++n2;
            }
            super.setEnabled(enabled);
        }
    }
}

