/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses.DeviceValue;

import ice.gui.core.rangeClasses.DeviceValue.DeviceValue;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class StringDeviceValue
extends DeviceValue {
    private static Logger logger = Logger.getLogger("ScanOperation.DoubleDeviceValue");
    private String value;
    public static final int DEFAULTWIDTH = 22;
    protected PlainDocument controlDocument = new PlainDocument();

    public StringDeviceValue(String value) {
        this.value = value;
        this.valid = true;
        this.controlDocument.addDocumentListener(new ControlDocumentListener());
    }

    public StringDeviceValue() {
        this.value = "";
        this.valid = true;
        this.controlDocument.addDocumentListener(new ControlDocumentListener());
    }

    @Override
    public boolean parseString(String value) {
        this.value = value;
        this.valid = true;
        return true;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    @Override
    public String getValueString() {
        return this.value;
    }

    @Override
    public JComponent getControl() {
        return new JTextField(this.controlDocument, this.value, 22);
    }

    @Override
    public String getErrorText() {
        if (this.validateData()) {
            return "";
        }
        return "Invalid";
    }

    protected void updateFromControlDocument() {
        try {
            this.value = this.controlDocument.getText(0, this.controlDocument.getLength());
        }
        catch (Exception e) {
            this.value = "";
        }
    }

    protected class ControlDocumentListener
    implements DocumentListener {
        protected ControlDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            StringDeviceValue.this.updateFromControlDocument();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            StringDeviceValue.this.updateFromControlDocument();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            StringDeviceValue.this.updateFromControlDocument();
        }
    }
}

