/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controls.serverFileView;

import ice.data.IceFile;
import ice.data.IceFileType;
import ice.gui.core.controls.serverFileView.FilterPanel;
import ice.gui.core.controls.serverFileView.ServerFileSelectionView;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.core.controls.serverFileView.communication.FileSelectionDoubleClickListener;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public class ServerFileSelectionDialog
extends JDialog
implements ActionListener,
FileSelectionDoubleClickListener,
ItemListener {
    private static final String TITLE = "Load File From Server";
    protected ServerFileSelectionView serverFileSelectionView = null;
    protected Object returnValue = null;
    protected ServerFolderView.ViewTypes viewType;
    protected FilterPanel filterPanel = new FilterPanel();
    protected ButtonPanel buttonPanel = null;

    private ServerFileSelectionDialog(ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionDialog(Dialog owner, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, modal);
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc2) throws HeadlessException {
        super(owner, title, modal, gc2);
    }

    private ServerFileSelectionDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
    }

    private ServerFileSelectionDialog(Dialog owner, String title, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title);
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionDialog(Dialog owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner);
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionDialog(Frame owner, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, modal);
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc2) {
        super(owner, title, modal, gc2);
    }

    private ServerFileSelectionDialog(Frame owner, String title, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title, modal);
        this.init(viewType, defaultFolder);
    }

    private ServerFileSelectionDialog(Frame owner, String title, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title);
        this.init(viewType, defaultFolder);
    }

    protected ServerFileSelectionDialog(Frame owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, TITLE, true);
        this.init(viewType, defaultFolder);
    }

    protected void init(ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) {
        this.viewType = viewType;
        this.buildGUI(defaultFolder);
    }

    protected void buildGUI(ServerFolderView.ValidServerFolders defaultFolder) {
        JPanel contentPanel = null;
        GridBagConstraints gridBagConstraints = null;
        GridBagLayout gridBagLayout = null;
        this.setSize(500, 300);
        contentPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        contentPanel.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.serverFileSelectionView = new ServerFileSelectionView(this.viewType, defaultFolder);
        contentPanel.add((Component)this.serverFileSelectionView, gridBagConstraints);
        this.serverFileSelectionView.addFileSelectionDoubleClickListner(this);
        this.setContentPane(contentPanel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.filterPanel, gridBagConstraints);
        this.filterPanel.addItemListener(this);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.buttonPanel = new ButtonPanel();
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane theRootPane = super.createRootPane();
        EscapeKeyAction escapeAction = new EscapeKeyAction();
        EnterKeyAction returnAction = new EnterKeyAction();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = theRootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        theRootPane.getActionMap().put("ESCAPE", escapeAction);
        stroke = KeyStroke.getKeyStroke("ENTER");
        inputMap = theRootPane.getInputMap(2);
        inputMap.put(stroke, "ENTER");
        theRootPane.getActionMap().put("ENTER", returnAction);
        return theRootPane;
    }

    public static Object openSelectionDialog(Frame owner, ServerFolderView.ViewTypes viewType) {
        return ServerFileSelectionDialog.openSelectionDialog(owner, viewType);
    }

    public static Object openSelectionDialog(Frame owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder, IceFileType filterType) {
        Object returnValue = null;
        ServerFileSelectionDialog serverFileSelectionDialog = null;
        serverFileSelectionDialog = new ServerFileSelectionDialog(owner, viewType, defaultFolder);
        serverFileSelectionDialog.returnValue = null;
        serverFileSelectionDialog.setLocationRelativeTo(owner);
        if (filterType != null) {
            serverFileSelectionDialog.filterPanel.setSelectedItem(filterType);
        }
        serverFileSelectionDialog.setVisible(true);
        return serverFileSelectionDialog.returnValue;
    }

    public static Object selectIceFileFromServer(Frame owner, IceFileType filterType, ServerFolderView.ValidServerFolders defaultFolder) {
        IceFile returnValue = null;
        returnValue = (IceFile)ServerFileSelectionDialog.openSelectionDialog(owner, ServerFolderView.ViewTypes.NO_SCAN, defaultFolder, filterType);
        return returnValue;
    }

    public static Object selectScanFromServer(Frame owner) {
        IceFile returnValue = null;
        returnValue = (IceFile)ServerFileSelectionDialog.openSelectionDialog(owner, ServerFolderView.ViewTypes.SCAN_ONLY);
        return returnValue;
    }

    public static Object selectScanOrFileFromServer(Frame owner, IceFileType filterType, ServerFolderView.ValidServerFolders defaultFolder) {
        IceFile returnValue = null;
        returnValue = (IceFile)ServerFileSelectionDialog.openSelectionDialog(owner, ServerFolderView.ViewTypes.BOTH, defaultFolder, filterType);
        return returnValue;
    }

    @Override
    public void fileSelectionDoubleClick(Object theFileClickedOn) {
        this.returnValue = theFileClickedOn;
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = null;
        Object actionSource = null;
        actionSource = e.getSource();
        if (actionSource instanceof JButton) {
            actionCommand = e.getActionCommand();
            if (actionCommand.compareToIgnoreCase("OK") == 0) {
                this.returnValue = this.serverFileSelectionView.getCurrentSelectedItem();
            } else if (actionCommand.compareTo("Cancel") == 0) {
                this.returnValue = null;
            }
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = null;
        int itemStateChange = 1;
        item = e.getItem();
        itemStateChange = e.getStateChange();
        if (item instanceof IceFileType && itemStateChange == 1) {
            String regex = ((IceFileType)((Object)item)).getRegex();
            this.serverFileSelectionView.setFilter(regex);
        } else if (item instanceof String) {
            this.serverFileSelectionView.setFilter(null);
        }
    }

    protected class ButtonPanel
    extends JPanel {
        protected JButton cancelButton;
        protected JButton okButton;

        public ButtonPanel() {
            this.init();
        }

        protected void init() {
            this.buildGUI();
        }

        protected void buildGUI() {
            GridBagConstraints buttonPaneConstraints = null;
            GridBagLayout gridBagLayout = null;
            gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            buttonPaneConstraints = new GridBagConstraints();
            buttonPaneConstraints.gridx = 0;
            buttonPaneConstraints.gridy = 0;
            buttonPaneConstraints.fill = 0;
            buttonPaneConstraints.weightx = 0.0;
            buttonPaneConstraints.weighty = 0.0;
            buttonPaneConstraints.anchor = 14;
            buttonPaneConstraints.insets = new Insets(10, 5, 10, 5);
            this.cancelButton = new JButton("Cancel");
            this.add((Component)this.cancelButton, buttonPaneConstraints);
            this.cancelButton.addActionListener(ServerFileSelectionDialog.this);
            buttonPaneConstraints.gridx = 1;
            this.okButton = new JButton("OK");
            this.add((Component)this.okButton, buttonPaneConstraints);
            this.okButton.addActionListener(ServerFileSelectionDialog.this);
        }

        protected void clickOk() {
            this.okButton.doClick();
        }

        protected void clickCancel() {
            this.cancelButton.doClick();
        }
    }

    protected class EnterKeyAction
    extends AbstractAction {
        protected EnterKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerFileSelectionDialog.this.buttonPanel.clickOk();
        }
    }

    protected class EscapeKeyAction
    extends AbstractAction {
        protected EscapeKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerFileSelectionDialog.this.buttonPanel.clickCancel();
        }
    }
}

