/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controls.serverFileView;

import ice.data.BaseScan;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.gui.core.IceDialog;
import ice.gui.core.controls.serverFileView.FilterPanel;
import ice.gui.core.controls.serverFileView.ServerFileSelectionView;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.core.controls.serverFileView.communication.FileSelectionChangedListener;
import ice.gui.core.controls.serverFileView.communication.FileSelectionDoubleClickListener;
import ice.gui.core.controls.serverFileView.data.ScanFolder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ServerFileSaveDialog
extends IceDialog
implements ActionListener,
FileSelectionDoubleClickListener,
FileSelectionChangedListener,
ItemListener,
TreeSelectionListener,
DocumentListener {
    protected static final String ERROR_TITLE = "Error";
    protected static final String ERROR_MESSAGE = "You must select and folder and provide a file name!";
    private static final String TITLE = "Save File To Server";
    protected ServerFileSelectionView serverFileSelectionView = null;
    protected TextEntryPanel textEntryPanel = null;
    protected FileNameAndParent returnValue = null;
    protected ServerFolderView.ViewTypes viewType;
    protected String currentExtension;
    protected FilterPanel filterPanel;
    protected ButtonPanel buttonPanel;
    protected boolean noValidFolderSelection;
    protected boolean fileNameIsEmpty;

    private ServerFileSaveDialog(ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Dialog owner, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, modal);
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc2) throws HeadlessException {
        super(owner, title, modal, gc2);
    }

    private ServerFileSaveDialog(Dialog owner, String title, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title, modal);
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Dialog owner, String title, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title);
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Dialog owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner);
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Frame owner, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, modal);
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc2) {
        super(owner, title, modal, gc2);
    }

    private ServerFileSaveDialog(Frame owner, String title, boolean modal, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title, modal);
        this.init(viewType, defaultFolder, false);
    }

    private ServerFileSaveDialog(Frame owner, String title, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) throws HeadlessException {
        super(owner, title);
        this.init(viewType, defaultFolder, false);
    }

    protected ServerFileSaveDialog(Frame owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder, boolean disableFilterCombo) throws HeadlessException {
        super(owner, TITLE, true);
        this.init(viewType, defaultFolder, disableFilterCombo);
    }

    protected void init(ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder, boolean disableFilterCombo) {
        this.viewType = viewType;
        this.currentExtension = "";
        this.buttonPanel = null;
        this.noValidFolderSelection = false;
        this.fileNameIsEmpty = true;
        this.buildGUI(disableFilterCombo, defaultFolder);
    }

    protected void buildGUI(boolean disableFilterCombo, ServerFolderView.ValidServerFolders defaultFolder) {
        JPanel contentPanel = null;
        GridBagConstraints gridBagConstraints = null;
        GridBagLayout gridBagLayout = null;
        this.setSize(500, 400);
        contentPanel = new JPanel();
        gridBagLayout = new GridBagLayout();
        contentPanel.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.serverFileSelectionView = new ServerFileSelectionView(this.viewType, defaultFolder);
        contentPanel.add((Component)this.serverFileSelectionView, gridBagConstraints);
        this.serverFileSelectionView.addFileSelectionDoubleClickListner(this);
        this.serverFileSelectionView.addFileSelectionChangedListener(this);
        this.serverFileSelectionView.listenToFolderValueChange(this);
        this.setContentPane(contentPanel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.filterPanel = new FilterPanel();
        this.add((Component)this.filterPanel, gridBagConstraints);
        this.filterPanel.addItemListener(this);
        if (this.viewType == ServerFolderView.ViewTypes.SCAN_ONLY || disableFilterCombo) {
            this.filterPanel.setEnable(false);
        }
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.textEntryPanel = new TextEntryPanel();
        this.add((Component)this.textEntryPanel, gridBagConstraints);
        this.textEntryPanel.listenToDocument(this);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        this.buttonPanel = new ButtonPanel();
        this.add((Component)this.buttonPanel, gridBagConstraints);
        this.determinInitialOKState();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane theRootPane = super.createRootPane();
        EscapeKeyAction escapeAction = new EscapeKeyAction();
        EnterKeyAction returnAction = new EnterKeyAction();
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = theRootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        theRootPane.getActionMap().put("ESCAPE", escapeAction);
        stroke = KeyStroke.getKeyStroke("ENTER");
        inputMap = theRootPane.getInputMap(2);
        inputMap.put(stroke, "ENTER");
        theRootPane.getActionMap().put("ENTER", returnAction);
        return theRootPane;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object item = null;
        int itemStateChange = 1;
        item = e.getItem();
        itemStateChange = e.getStateChange();
        this.currentExtension = "";
        if (item instanceof IceFileType && itemStateChange == 1) {
            String regex = ((IceFileType)((Object)item)).getRegex();
            this.serverFileSelectionView.setFilter(regex);
            this.currentExtension = ((IceFileType)((Object)item)).getExtension();
        } else if (item instanceof String) {
            this.serverFileSelectionView.setFilter(null);
        }
    }

    protected static FileNameAndParent saveIceResourceToServer(Frame owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder) {
        return ServerFileSaveDialog.saveIceResourceToServer(owner, viewType, defaultFolder, null, false);
    }

    protected static FileNameAndParent saveIceResourceToServer(Frame owner, ServerFolderView.ViewTypes viewType, ServerFolderView.ValidServerFolders defaultFolder, IceFileType filterType, boolean disableFilterCombo) {
        ServerFileSaveDialog serverFileSaveDialog = null;
        if (owner != null) {
            serverFileSaveDialog = new ServerFileSaveDialog(owner, viewType, defaultFolder, disableFilterCombo);
            serverFileSaveDialog.returnValue = null;
            serverFileSaveDialog.setLocationRelativeTo(owner);
            if (filterType != null) {
                serverFileSaveDialog.filterPanel.setSelectedItem(IceFileType.sansConfig);
            }
            serverFileSaveDialog.setVisible(true);
            return serverFileSaveDialog.returnValue;
        }
        return null;
    }

    public static FileNameAndParent saveIceScanToServer(Frame owner) {
        FileNameAndParent fileNameAndParent = null;
        fileNameAndParent = ServerFileSaveDialog.saveIceResourceToServer(owner, ServerFolderView.ViewTypes.SCAN_ONLY, ServerFolderView.ValidServerFolders.SCAN);
        return fileNameAndParent;
    }

    public static FileNameAndParent saveIceFileOrScanToServer(Frame owner, ServerFolderView.ValidServerFolders defaultFolder) {
        return ServerFileSaveDialog.saveIceFileOrScanToServer(owner, null, defaultFolder);
    }

    public static FileNameAndParent saveIceFileOrScanToServer(Frame owner, IceFileType filterType, ServerFolderView.ValidServerFolders defaultFolder) {
        FileNameAndParent fileNameAndParent = null;
        fileNameAndParent = ServerFileSaveDialog.saveIceResourceToServer(owner, ServerFolderView.ViewTypes.BOTH, defaultFolder, filterType, false);
        return fileNameAndParent;
    }

    public static FileNameAndParent saveIceFileToServer(Frame owner, IceFileType filterType, ServerFolderView.ValidServerFolders defaultFolder, boolean disableFilterCombo) {
        FileNameAndParent fileNameAndParent = null;
        fileNameAndParent = ServerFileSaveDialog.saveIceResourceToServer(owner, ServerFolderView.ViewTypes.NO_SCAN, defaultFolder, filterType, disableFilterCombo);
        return fileNameAndParent;
    }

    public static FileNameAndParent saveIceFileToServer(Frame owner) {
        return ServerFileSaveDialog.saveIceFileToServer(owner, null, ServerFolderView.ValidServerFolders.EXPT, false);
    }

    private FileNameAndParent getCurrentFileNameAndParent() {
        FileNameAndParent fileNameAndParent = null;
        IceFile parent = null;
        String fileName = null;
        parent = this.serverFileSelectionView.getCurrentSelectedFolder();
        fileName = this.textEntryPanel.getFileName();
        if (parent != null && fileName != null && !fileName.trim().equals("")) {
            boolean endsWith = false;
            Object parentName = null;
            endsWith = fileName.endsWith(this.currentExtension);
            if (!endsWith && !(parent instanceof ScanFolder)) {
                fileName = String.valueOf(fileName) + this.currentExtension;
            }
            fileNameAndParent = new FileNameAndParent(parent, fileName);
        } else {
            this.throwErrorDialog(ERROR_TITLE, ERROR_MESSAGE);
        }
        return fileNameAndParent;
    }

    @Override
    public void fileSelectionDoubleClick(Object theFileClickedOn) {
        this.returnValue = this.getCurrentFileNameAndParent();
        if (this.returnValue != null) {
            this.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = null;
        Object actionSource = null;
        actionSource = e.getSource();
        if (actionSource instanceof JButton) {
            actionCommand = e.getActionCommand();
            if (actionCommand.compareToIgnoreCase("OK") == 0) {
                this.returnValue = this.getCurrentFileNameAndParent();
                if (this.returnValue != null) {
                    this.setVisible(false);
                }
            } else if (actionCommand.compareTo("Cancel") == 0) {
                this.returnValue = null;
                this.setVisible(false);
            }
        }
    }

    @Override
    public void fileSelectionChanged(Object selection) {
        String fileName = "";
        if (selection != null) {
            if (selection instanceof IceFile) {
                fileName = ((IceFile)selection).getName();
            } else if (selection instanceof BaseScan) {
                fileName = ((BaseScan)selection).getName();
            }
        }
        this.textEntryPanel.setFileName(fileName);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath treePath = e.getNewLeadSelectionPath();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        IceFile theDirectory = (IceFile)node.getUserObject();
        String directoryName = theDirectory.getName();
        this.noValidFolderSelection = directoryName != "/";
        this.determineOKState();
    }

    protected void determinInitialOKState() {
        IceFile dir = this.serverFileSelectionView.getCurrentSelectedFolder();
        if (dir != null) {
            String directoryName = dir.getName();
            this.noValidFolderSelection = directoryName != "/";
        }
        this.determineOKState();
    }

    protected void determineOKState() {
        boolean turnOkButtonOn = this.noValidFolderSelection && !this.fileNameIsEmpty;
        this.buttonPanel.setEnableOk(turnOkButtonOn);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        Document document = e.getDocument();
        this.fileNameIsEmpty = document.getLength() <= 0;
        this.determineOKState();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        Document document = e.getDocument();
        this.fileNameIsEmpty = document.getLength() <= 0;
        this.determineOKState();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        Document document = e.getDocument();
        this.fileNameIsEmpty = document.getLength() <= 0;
        this.determineOKState();
    }

    public class ButtonPanel
    extends JPanel {
        public static final String OK_LABEL = "OK";
        public static final String CANCEL_LABEL = "Cancel";
        protected JButton okButton = null;
        protected JButton cancelButton = null;

        public ButtonPanel() {
            this.init();
        }

        protected void init() {
            this.buildGUI();
        }

        public void setEnableOk(boolean enable) {
            this.okButton.setEnabled(enable);
        }

        protected void buildGUI() {
            GridBagConstraints buttonPaneConstraints = null;
            GridBagLayout gridBagLayout = null;
            gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            buttonPaneConstraints = new GridBagConstraints();
            buttonPaneConstraints.gridx = 0;
            buttonPaneConstraints.gridy = 0;
            buttonPaneConstraints.fill = 0;
            buttonPaneConstraints.weightx = 0.0;
            buttonPaneConstraints.weighty = 0.0;
            buttonPaneConstraints.anchor = 14;
            buttonPaneConstraints.insets = new Insets(10, 5, 10, 5);
            this.cancelButton = new JButton(CANCEL_LABEL);
            this.add((Component)this.cancelButton, buttonPaneConstraints);
            this.cancelButton.addActionListener(ServerFileSaveDialog.this);
            buttonPaneConstraints.gridx = 1;
            this.okButton = new JButton(OK_LABEL);
            this.add((Component)this.okButton, buttonPaneConstraints);
            this.okButton.addActionListener(ServerFileSaveDialog.this);
            this.setEnableOk(false);
            this.cancelButton.doClick();
        }

        protected void clickOk() {
            this.okButton.doClick();
        }

        protected void clickCancel() {
            this.cancelButton.doClick();
        }
    }

    protected class EnterKeyAction
    extends AbstractAction {
        protected EnterKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerFileSaveDialog.this.buttonPanel.clickOk();
        }
    }

    protected class EscapeKeyAction
    extends AbstractAction {
        protected EscapeKeyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ServerFileSaveDialog.this.buttonPanel.clickCancel();
        }
    }

    public class FileNameAndParent {
        private IceFile parent = null;
        private String fileName = null;

        public FileNameAndParent(IceFile parent, String fileName) {
            this.parent = parent;
            this.fileName = fileName;
        }

        public IceFile getParent() {
            return this.parent;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    protected class TextEntryPanel
    extends JPanel {
        JLabel fileNameLabel = null;
        JTextField fileNameTextBox = null;

        public TextEntryPanel() {
            this.init();
        }

        protected void init() {
            this.buildGUI();
        }

        protected void buildGUI() {
            GridBagConstraints textPaneConstraints = null;
            GridBagLayout gridBagLayout = null;
            gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            textPaneConstraints = new GridBagConstraints();
            textPaneConstraints.gridx = 0;
            textPaneConstraints.gridy = 0;
            textPaneConstraints.fill = 0;
            textPaneConstraints.weightx = 0.0;
            textPaneConstraints.weighty = 0.0;
            textPaneConstraints.anchor = 17;
            textPaneConstraints.insets = new Insets(10, 5, 10, 5);
            this.fileNameLabel = new JLabel("File name:");
            this.add((Component)this.fileNameLabel, textPaneConstraints);
            textPaneConstraints.gridx = 1;
            textPaneConstraints.weightx = 1.0;
            textPaneConstraints.fill = 2;
            this.fileNameTextBox = new JTextField();
            this.add((Component)this.fileNameTextBox, textPaneConstraints);
        }

        public void listenToDocument(DocumentListener listener) {
            this.fileNameTextBox.getDocument().addDocumentListener(listener);
        }

        public void stopListeningToDocument(DocumentListener listener) {
            this.fileNameTextBox.getDocument().removeDocumentListener(listener);
        }

        public void setFileName(String fileName) {
            if (this.fileNameTextBox != null) {
                if (fileName == null) {
                    fileName = "";
                }
                this.fileNameTextBox.setText(fileName);
            }
        }

        public String getFileName() {
            String fileName = null;
            if (this.fileNameTextBox != null) {
                fileName = this.fileNameTextBox.getText();
            }
            return fileName;
        }
    }
}

