/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.config;

import ice.Controller;
import ice.communication.SendQueueManager;
import ice.event.CloseRequestEvent;
import ice.event.CloseRequestListener;
import ice.event.ModifyEvent;
import ice.event.ModifyListener;
import ice.gui.core.config.BaseConfigPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class BaseConfigWindow
extends JDialog
implements ModifyListener,
CloseRequestListener {
    protected static Logger logger = Logger.getLogger("WidgetLogger.ConfigLogger");
    private Controller controller = Controller.getReference();
    protected SendQueueManager sendManager = this.controller.getSendManager();
    protected JTabbedPane tabbedPane;
    protected ArrayList<BaseConfigPanel> children;
    protected JButton okBtn;
    private JButton cancelBtn;
    boolean isInitComplete;
    boolean isClosed = true;

    public BaseConfigWindow(JFrame owner) {
        super((Frame)owner, "Experiment Configuration");
        this.setDefaultCloseOperation(0);
        this.setName("Experiment Configuration");
        this.children = new ArrayList();
        this.isInitComplete = false;
    }

    protected void setInitComplete(boolean isInitComplete) {
        this.isInitComplete = isInitComplete;
        if (isInitComplete) {
            this.cancelBtn.setEnabled(true);
        } else {
            this.cancelBtn.setEnabled(false);
        }
    }

    protected void buildGUI() {
        this.tabbedPane = new JTabbedPane(1, 1);
        for (BaseConfigPanel child : this.children) {
            this.tabbedPane.addTab(child.getName(), child);
        }
        this.add((Component)this.tabbedPane, "Center");
        this.okBtn = new JButton(new OKAction());
        this.cancelBtn = new JButton(new CancelAction());
        JPanel buttonPanel = this.createBtnPanel(this.okBtn, this.cancelBtn);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel requiredLabel = new JLabel("Red indicates a required field");
        requiredLabel.setForeground(new Color(200, 0, 0));
        requiredLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)requiredLabel, "West");
        bottomPanel.add((Component)buttonPanel, "East");
        this.add((Component)bottomPanel, "Last");
        this.pack();
        int width = 0;
        int tabCount = this.tabbedPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            width += this.tabbedPane.getBoundsAt((int)i).width;
            ++i;
        }
        this.setResizable(false);
    }

    public JPanel createBtnPanel(JButton okBtn, JButton cancelBtn) {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 2));
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(okBtn);
        btnPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        btnPanel.add(cancelBtn);
        return btnPanel;
    }

    @Override
    public synchronized void stateModified(ModifyEvent me) {
        if (!(me.getSource() instanceof JPanel)) {
            return;
        }
        JPanel source = (JPanel)me.getSource();
        int tabCount = this.tabbedPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            try {
                if (source == this.tabbedPane.getComponentAt(i)) {
                    boolean modified = me.isModified();
                    if (modified) {
                        this.tabbedPane.setTitleAt(i, String.valueOf(source.getName()) + "*");
                    } else {
                        this.tabbedPane.setTitleAt(i, source.getName());
                    }
                }
            }
            catch (ClassCastException cce) {
                logger.error("Object was no JScroll pane.  Ignoring.", cce);
            }
            ++i;
        }
    }

    public void loadErrorDialog(String message) {
        JButton okBtn = new JButton("OK");
        Object[] options = new Object[]{okBtn};
        JOptionPane contentPane = new JOptionPane(message, 0, 0, (Icon)UIManager.get("OptionPane.errorIcon"), options);
        final JDialog dialog = new JDialog(this, "Incomplete or Invalid Configuration", true);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
        dialog.setDefaultCloseOperation(2);
        dialog.setContentPane(contentPane);
        dialog.pack();
        Point parentLocation = this.getLocation();
        Dimension parentSize = this.getSize();
        Dimension dialogSize = dialog.getSize();
        dialog.setLocation(parentLocation.x + parentSize.width / 2 - dialogSize.width / 2, parentLocation.y + parentSize.height / 2 - dialogSize.height / 2);
        dialog.setVisible(true);
    }

    protected int findFirstIncompleteChildIndex() {
        int i = 0;
        while (i < this.children.size()) {
            if (!this.children.get(i).isCompleted()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean commitChildrenChanges() {
        for (BaseConfigPanel child : this.children) {
            if (!child.getModified()) continue;
            child.setCommitting(true);
            child.setModified(false);
            if (child.commitChanges(this.sendManager)) continue;
            child.setCommitting(false);
            return false;
        }
        return true;
    }

    @Override
    public void requestClose(CloseRequestEvent cre) {
        for (BaseConfigPanel child : this.children) {
            child.setModified(false);
        }
        this.setVisible(false);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 205 && this.isClosed) {
            this.isClosed = false;
            if (this.findFirstIncompleteChildIndex() == -1) {
                this.setInitComplete(true);
            } else {
                this.setInitComplete(false);
            }
            for (BaseConfigPanel child : this.children) {
                child.reload();
                child.setCommitting(false);
            }
        } else if (e.getID() == 201) {
            if (this.isInitComplete) {
                this.requestClose(new CloseRequestEvent(this));
                super.processWindowEvent(e);
            }
        } else if (e.getID() == 202) {
            this.isClosed = true;
        }
    }

    protected class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", "Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            BaseConfigWindow.this.requestClose(new CloseRequestEvent(this));
        }
    }

    protected class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", "OK");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int childIndex = BaseConfigWindow.this.findFirstIncompleteChildIndex();
            if (childIndex == -1) {
                if (BaseConfigWindow.this.commitChildrenChanges()) {
                    BaseConfigWindow.this.requestClose(new CloseRequestEvent(this));
                }
            } else {
                BaseConfigWindow.this.tabbedPane.setSelectedIndex(childIndex);
                BaseConfigWindow.this.loadErrorDialog(BaseConfigWindow.this.children.get(childIndex).getCompletionErrorString());
            }
        }
    }
}

