/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.event.communication.DataMessageEvent;
import ice.event.communication.DataMessageListener;
import ice.event.communication.FitResultEvent;
import ice.event.communication.FitResultListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceViewPanel;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import ptolemy.plot.Plot;

public abstract class PlotPanel
extends IceViewPanel
implements PropertyChangeListener,
DataMessageListener,
FitResultListener,
InstrumentValueChangedListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.LiveDataLogger");

    public PlotPanel() throws IcePanelException {
    }

    protected PlotPanel(String name) throws IcePanelException {
        super(name);
    }

    public double getGaussianPoint(ArrayList<Double> fitPoints, double x) {
        double fact = 1.665109;
        double min = Double.MIN_VALUE;
        try {
            double xDiff = x - fitPoints.get(4);
            double widthInv = 1.665109 / fitPoints.get(5);
            double expArg = xDiff * widthInv;
            double deriv1 = Math.exp(-expArg * expArg);
            double deriv2 = 2.0 * fitPoints.get(3) * xDiff * widthInv * deriv1;
            double amplitude = fitPoints.get(3) * deriv1;
            double y = amplitude + fitPoints.get(0) + fitPoints.get(1) * x + fitPoints.get(2) * (x * x);
            return y;
        }
        catch (Exception e) {
            logger.error("Can not calculate gaussian fit point", e);
            return Double.MIN_VALUE;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void receiveDataMsg(DataMessageEvent de) {
    }

    public synchronized void selectDevice(String deviceName) {
    }

    @Override
    public void actionPerformed(FitResultEvent fre) {
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent event) {
    }

    public class ClearGraph
    implements Runnable {
        private Plot plot;
        private String title;

        public ClearGraph(Plot plot, String title) {
            this.plot = plot;
            this.title = title;
        }

        public ClearGraph(Plot plot) {
            this.plot = plot;
        }

        @Override
        public void run() {
            this.plot.clear(false);
            this.plot.setXRange(0.0, 1.0);
            this.plot.setYRange(0.0, 1.0);
            if (this.title != null) {
                this.plot.setTitle(this.title);
            }
            this.plot.repaint();
        }
    }

    public class PlotPoint
    implements Runnable {
        private Plot plot;
        private int dataset = 0;
        private double xPoint;
        private double yPoint;
        private boolean connected = false;
        private Double lowerErrorBar = null;
        private Double upperErrorBar = null;
        private boolean autofit = true;

        @Override
        public void run() {
            if (this.lowerErrorBar != null && this.upperErrorBar != null) {
                this.plot.addPointWithErrorBars(this.dataset, this.xPoint, this.yPoint, this.lowerErrorBar, this.upperErrorBar, this.connected);
            } else {
                this.plot.addPoint(this.dataset, this.xPoint, this.yPoint, this.connected);
            }
            if (this.autofit) {
                this.plot.fillPlot();
            }
        }

        public PlotPoint(Plot plot, int dataset, double xPoint, double yPoint, boolean connected, Double lowerErrorBar, Double upperErrorBar, boolean autofit) {
            this.plot = plot;
            this.dataset = dataset;
            this.xPoint = xPoint;
            this.yPoint = yPoint;
            this.connected = connected;
            this.lowerErrorBar = lowerErrorBar;
            this.upperErrorBar = upperErrorBar;
            this.autofit = autofit;
        }

        public PlotPoint(Plot plot, int dataset, double point, double point2, boolean connected, boolean autofit) {
            this.plot = plot;
            this.dataset = dataset;
            this.xPoint = point;
            this.yPoint = point2;
            this.connected = connected;
            this.autofit = autofit;
        }

        public PlotPoint(Plot plot, int dataset, double point, double point2, boolean connected) {
            this.plot = plot;
            this.dataset = dataset;
            this.xPoint = point;
            this.yPoint = point2;
            this.connected = connected;
        }

        public PlotPoint(Plot plot, int dataset, double point, double point2) {
            this.plot = plot;
            this.dataset = dataset;
            this.xPoint = point;
            this.yPoint = point2;
        }
    }

    public class ResetGraph
    implements Runnable {
        private Plot plot;
        private String title;
        private String xLabel;
        private String yLabel;

        public ResetGraph(Plot plot, String title, String label, String label2) {
            this.plot = plot;
            this.title = title;
            this.xLabel = label;
            this.yLabel = label2;
        }

        @Override
        public void run() {
            this.plot.clear(false);
            this.plot.setXRange(0.0, 1.0);
            this.plot.setYRange(0.0, 1.0);
            if (this.title != null) {
                this.plot.setTitle(this.title);
            }
            if (this.xLabel != null) {
                this.plot.setXLabel(this.xLabel);
            }
            if (this.yLabel != null) {
                this.plot.setYLabel(this.yLabel);
            }
            this.plot.repaint();
        }
    }

    public class ResizePlot
    implements Runnable {
        private Plot plot;
        private int numOfItems;
        private ArrayList<String> list;

        public ResizePlot(Plot plot, ArrayList<String> items) {
            this.plot = plot;
            this.numOfItems = items.size();
            this.list = items;
        }

        public ResizePlot(Plot plot, int num) {
            this.plot = plot;
            this.numOfItems = num;
        }

        @Override
        public void run() {
            int offset = 500 - this.numOfItems * 10;
            int spacing = 4;
            int height = this.getFontHeight(this.plot) + spacing;
            int size = this.numOfItems * height + offset;
            this.plot.setSize(this.plot.getWidth(), size);
            this.plot.clearLegends();
            try {
                int i = 0;
                while (i < this.numOfItems) {
                    this.plot.addLegend(i, this.list.get(i));
                    ++i;
                }
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
            this.plot.repaint();
        }

        private int getFontHeight(Plot plot1) {
            int fontHeight = 0;
            Font font = plot1.getFont();
            FontMetrics fm = plot1.getFontMetrics(font);
            fontHeight = fm.getHeight();
            return fontHeight;
        }
    }
}

