/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.Controller;
import ice.IcePanelManager;
import ice.IconManager;
import ice.communication.SendQueueManager;
import ice.data.tas.bt7.Instrument;
import ice.event.IceWindowCloseListener;
import ice.event.IceWindowEvent;
import ice.event.IceWindowOpenListener;
import ice.event.LoadIcePanelEvent;
import ice.event.LoadIcePanelListener;
import ice.event.LoadSaveableIcePanelEvent;
import ice.event.LoadSaveableIcePanelListener;
import ice.event.NameChangeEvent;
import ice.event.NameChangeListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.event.request.ChangeAdminModeReqListener;
import ice.event.request.ChangeExpReqListener;
import ice.event.request.ChangeInstrReqListener;
import ice.event.request.ExitReqListener;
import ice.event.request.IcePanelCloseListener;
import ice.event.request.IceWindowRequest;
import ice.event.request.LoadExpConfigReqListener;
import ice.event.request.PanelCloseEvent;
import ice.event.request.ReconnectReqListener;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceEditPanel;
import ice.gui.core.TearTabbedPane;
import ice.gui.core.reportBugDialog.ReportBugDialog;
import ice.gui.tas.bt7.scan.BaseScanPanel;
import ice.swing.Bag;
import ice.swing.buttons.SmallPausePlayButton;
import ice.swing.buttons.SmallStopButton;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class IceWindow
extends JFrame
implements KeyEventDispatcher,
NameChangeListener,
ChangeListener {
    public static final String MENU_ACTION_SAVE = "Save";
    public static final String MENU_ACTION_SAVE_AS = "Save As...";
    public static final String MENU_ACTION_CUT = "Cut";
    public static final String MENU_ACTION_COPY = "Copy";
    public static final String MENU_ACTION_PASTE = "Paste";
    public static final String MENU_ACTION_CUSTOMIZE = "Customize...";
    public static final String MENU_ACTION_PRINT = "Print";
    public static final String MENU_ACTION_SELECT_ALL = "Select All";
    public static final String MENU_ACTION_SELECT_NONE = "Select None";
    public static final String MENU_ACTION_CLOSE = "Close";
    public static final String MENU_ACTION_CLOSE_ALL = "Close All";
    public static final String MENU_ACTION_EXIT = "Exit";
    public static final String MENU_ACTION_CLOSE_OTHERS = "Exit";
    public static int windowCounter = 1;
    private static Logger logger = Logger.getLogger("WidgetLogger.MainWindowLogger");
    private static Logger errorLogger = Logger.getLogger("ErrorLogger");
    private Instrument instrument;
    private SendQueueManager sendManager;
    private JPanel parentPanel;
    private TearTabbedPane tabbedPane;
    private JPanel statusPanel;
    private InstrumentStateLabel instrumentStateLabel;
    private SmallStopButton stopBtn;
    private SmallPausePlayButton playPauseBtn;
    private JMenu viewMenu;
    private JMenu newMenu;
    private JMenu windowMenu;
    private JMenuItem saveItem;
    private JMenuItem saveAsItem;
    private JMenuItem printItem;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem selectAllItem;
    private JMenuItem selectNoneItem;
    private JMenuItem customizeItem;
    private Point windowLocation;
    private Dimension windowSize;
    private ArrayList<IceWindowCloseListener> windowCloseListeners;
    private ArrayList<IceWindowOpenListener> windowOpenListeners;
    private LinkedHashMap<String, JMenuItem> openedPanels;
    private ArrayList<LoadIcePanelListener> loadIcePanelListeners;
    private ArrayList<LoadSaveableIcePanelListener> loadSaveableIcePanelListeners;
    private ArrayList<IcePanelCloseListener> panelCloseListeners;
    private ArrayList<ReconnectReqListener> reconnectListeners;
    private ArrayList<ChangeInstrReqListener> changeInstrumentListeners;
    private ArrayList<ChangeExpReqListener> changeExpListeners;
    private ArrayList<ChangeAdminModeReqListener> adminModeListeners;
    private ArrayList<ExitReqListener> exitListeners;
    private ArrayList<LoadExpConfigReqListener> expConfigListeners;
    private Controller controller;
    public static final String WINDOW_TITLE_KEY = "title";

    public IceWindow() {
        this.windowLocation = new Point(0, 0);
        this.init();
        this.buildGUI();
    }

    public IceWindow(Point p) {
        this.windowLocation = p;
        this.init();
        this.buildGUI();
    }

    private void init() {
        this.controller = Controller.getReference();
        this.instrument = this.controller.getInstrument();
        this.sendManager = this.controller.getSendManager();
        logger.debug("icon: " + this.getIconImage());
        this.statusPanel = new JPanel(new CardLayout());
        this.statusPanel.setBorder(new BevelBorder(1));
        this.tabbedPane = new TearTabbedPane(this);
        Instrument.State state = this.instrument.getState();
        String message = "N/A";
        if (state != null) {
            message = state.toString().toUpperCase();
        }
        this.instrumentStateLabel = new InstrumentStateLabel(message);
        try {
            this.instrument.addPropertyChangeListener(this.instrumentStateLabel);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ICEWindow.init  " + e);
        }
        this.stopBtn = new SmallStopButton(this.sendManager);
        this.playPauseBtn = new SmallPausePlayButton(this.instrument, this.sendManager);
        this.saveItem = new JMenuItem();
        this.saveAsItem = new JMenuItem();
        this.printItem = new JMenuItem();
        this.cutItem = new JMenuItem();
        this.copyItem = new JMenuItem();
        this.pasteItem = new JMenuItem();
        this.selectAllItem = new JMenuItem();
        this.selectNoneItem = new JMenuItem();
        this.customizeItem = new JMenuItem();
        this.openedPanels = new LinkedHashMap();
        this.panelCloseListeners = new ArrayList();
        this.reconnectListeners = new ArrayList();
        this.changeInstrumentListeners = new ArrayList();
        this.changeExpListeners = new ArrayList();
        this.adminModeListeners = new ArrayList();
        this.exitListeners = new ArrayList();
        this.expConfigListeners = new ArrayList();
        this.windowCloseListeners = new ArrayList();
        this.windowOpenListeners = new ArrayList();
        this.loadIcePanelListeners = new ArrayList();
        this.loadSaveableIcePanelListeners = new ArrayList();
        this.tabbedPane.addChangeListener(this);
        this.addWindowFocusListener(new WindowFocusAdapter());
    }

    private void buildGUI() {
        String name = "ICE Window - " + windowCounter++;
        this.setName(name);
        this.setDefaultCloseOperation(0);
        this.parentPanel = (JPanel)this.getContentPane();
        this.parentPanel.setLayout(new BorderLayout(0, 0));
        Bag constraints = new Bag();
        constraints.inset(0);
        this.setJMenuBar(this.buildStaticWindowMenu());
        this.parentPanel.add((Component)this.createToolBar(), "First");
        this.parentPanel.add((Component)this.tabbedPane, "Center");
        this.parentPanel.add((Component)this.statusPanel, "Last");
    }

    private JMenuItem getMenuItemByText(JMenu theMenu, String text) {
        JMenuItem theItem = null;
        Component menuComponent = null;
        String menuText = null;
        int numberOfItems = theMenu.getMenuComponentCount();
        int i = 0;
        while (i < numberOfItems) {
            menuComponent = theMenu.getMenuComponent(i);
            menuText = ((JMenuItem)menuComponent).getText();
            if (menuText.equals(text)) {
                theItem = (JMenuItem)menuComponent;
                break;
            }
            ++i;
        }
        return theItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMenuItem(String itemText, boolean saveable) {
        JMenuItem theMenuItem = null;
        JMenu theMenu = null;
        theMenu = !saveable ? this.viewMenu : this.newMenu;
        JMenu jMenu = theMenu;
        synchronized (jMenu) {
            theMenuItem = this.getMenuItemByText(theMenu, itemText);
            if (theMenuItem != null) {
                theMenu.remove(theMenuItem);
            }
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMenuItem(JMenuItem item, boolean saveable) {
        if (!saveable) {
            JMenu jMenu = this.viewMenu;
            synchronized (jMenu) {
                item.setAction(new LoadIcePanelAction(item.getText()));
                this.viewMenu.add(item);
            }
        }
        JMenu jMenu = this.newMenu;
        synchronized (jMenu) {
            item.setAction(new LoadSaveableIcePanelAction(item.getText()));
            this.newMenu.add(item);
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildDynamicWindowMenu(HashMap<String, Boolean> menuInfo) {
        for (String s : menuInfo.keySet()) {
            JMenu jMenu;
            Boolean saveable = menuInfo.get(s);
            JMenuItem item = new JMenuItem(s);
            if (!saveable.booleanValue()) {
                jMenu = this.viewMenu;
                synchronized (jMenu) {
                    item.setAction(new LoadIcePanelAction(item.getText()));
                    this.viewMenu.add(item);
                    continue;
                }
            }
            jMenu = this.newMenu;
            synchronized (jMenu) {
                item.setAction(new LoadSaveableIcePanelAction(item.getText()));
                this.newMenu.add(item);
            }
        }
        this.invalidate();
    }

    private JMenuBar buildStaticWindowMenu() {
        JMenuBar menuBar = new JMenuBar();
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setName("Window");
        this.viewMenu = new JMenu("Open View");
        this.windowMenu.add(this.viewMenu);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setName("File");
        this.newMenu = new JMenu("New");
        fileMenu.add(this.newMenu);
        JMenuItem openItem = new JMenuItem();
        OpenAction oa = new OpenAction();
        openItem.setAction(new OpenAction());
        fileMenu.add(openItem);
        JMenuItem closeItem = new JMenuItem();
        closeItem.setAction(new CloseAction());
        fileMenu.add(closeItem);
        fileMenu.addSeparator();
        fileMenu.add(this.saveItem);
        fileMenu.add(this.saveAsItem);
        fileMenu.addSeparator();
        fileMenu.add(this.printItem);
        fileMenu.addSeparator();
        JMenuItem reconnectItem = new JMenuItem();
        reconnectItem.setAction(new ReconnectAction());
        fileMenu.add(reconnectItem);
        JMenuItem changeInstrumentItem = new JMenuItem();
        changeInstrumentItem.setAction(new ChangeInstrumentAction());
        fileMenu.add(changeInstrumentItem);
        JMenuItem changeExpItem = new JMenuItem();
        changeExpItem.setAction(new ChangeExpAction());
        fileMenu.add(changeExpItem);
        JMenuItem adminModeItem = new JMenuItem();
        adminModeItem.setAction(new AdminModeAction());
        fileMenu.add(new AdminModeAction());
        fileMenu.addSeparator();
        fileMenu.add(new ExitAction());
        JMenuItem expConfigItem = new JMenuItem(new ExpConfigAction());
        JMenuItem optionsItem = new JMenuItem(new OptionsAction());
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(this.cutItem);
        editMenu.add(this.copyItem);
        editMenu.add(this.pasteItem);
        editMenu.addSeparator();
        editMenu.add(this.selectAllItem);
        editMenu.add(this.selectNoneItem);
        editMenu.addSeparator();
        editMenu.add(expConfigItem);
        editMenu.add(this.customizeItem);
        editMenu.add(optionsItem);
        JMenu helpMenu = new JMenu("Help");
        JMenuItem menu_help = new JMenuItem("Help Contents");
        helpMenu.add(menu_help);
        helpMenu.add(new LoadBugReportAction());
        helpMenu.add(new LoadAboutAction());
        HelpSet helpSet = this.loadDocumentationHelpSet();
        HelpBroker helpBroker = helpSet.createHelpBroker();
        menu_help.addActionListener(new CSH.DisplayHelpFromSource(helpBroker));
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(this.windowMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private HelpSet loadDocumentationHelpSet() {
        String hsName = "UserManual/jhelpset.hs";
        HelpSet hs = new HelpSet();
        try {
            ClassLoader cl = IceWindow.class.getClassLoader();
            URL hsURL = HelpSet.findHelpSet(cl, hsName);
            hs = new HelpSet(null, hsURL);
        }
        catch (Exception ee) {
            ee.printStackTrace();
            System.out.println("HelpSet " + hsName + " not found");
        }
        return hs;
    }

    private JPanel createToolBar() {
        JLabel separator = new JLabel(" | ");
        separator.setForeground(Color.gray);
        JPanel panel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        constraints.inset(0, 1, 0, 1);
        int x = 0;
        int y = 0;
        panel.add((Component)new JLabel(""), constraints.cell(x, y).fillx());
        panel.add((Component)this.instrumentStateLabel, constraints.cell(++x, y));
        panel.add((Component)separator, constraints.cell(++x, y));
        panel.add((Component)this.stopBtn, constraints.cell(++x, y));
        panel.add((Component)this.playPauseBtn, constraints.cell(++x, y));
        return panel;
    }

    public Rectangle getTabBar() {
        Point paneLocation = this.tabbedPane.getLocation();
        SwingUtilities.convertPointToScreen(paneLocation, this.tabbedPane);
        Dimension paneSize = this.tabbedPane.getSize();
        Rectangle tabBounds = this.tabbedPane.getBoundsAt(0);
        Point tabBarLocation = tabBounds.getLocation();
        SwingUtilities.convertPointToScreen(tabBarLocation, this.tabbedPane);
        return new Rectangle(tabBarLocation.x, tabBarLocation.y, paneSize.width, tabBounds.height);
    }

    public void showGUI() {
        Point location = null;
        Dimension size = null;
        size = this.windowSize;
        location = this.windowLocation;
        this.pack();
        if (size == null) {
            size = this.getSize();
            size.width += 30;
        }
        this.setSize(size);
        this.setLocation(location);
        this.setVisible(true);
    }

    public void addTabbedMouseListener(MouseListener ml) {
        this.tabbedPane.addMouseListener(ml);
    }

    public void addTabbedMouseMotionListener(MouseMotionListener mml) {
        this.tabbedPane.addMouseMotionListener(mml);
    }

    public void addPanelTab(GenericIcePanel panel) {
        int index = this.addTab(panel);
        panel.panelAddedToWindow();
        this.giveFocus(panel);
    }

    public void addPanelTab(GenericIcePanel panel, int index) {
        this.addTab(panel, index);
        panel.panelAddedToWindow();
        this.giveFocus(panel);
    }

    private synchronized int addTab(GenericIcePanel somePanel) {
        int index = this.tabbedPane.getTabCount();
        this.addTab(somePanel, index);
        return index;
    }

    private synchronized void addTab(GenericIcePanel somePanel, int index) {
        boolean withScrollBar;
        boolean bl = withScrollBar = !somePanel.panelHandlesScrollBar();
        if (withScrollBar) {
            JScrollPane scrollPane = new JScrollPane(somePanel, 20, 30);
            scrollPane.getVerticalScrollBar().setUnitIncrement(7);
            scrollPane.setName(somePanel.getName());
            this.tabbedPane.insertTab(scrollPane.getName(), somePanel.getIcon(), scrollPane, null, index);
        } else {
            this.tabbedPane.insertTab(somePanel.getName(), somePanel.getIcon(), somePanel, null, index);
        }
        JPanel statusBar = somePanel.getStatusBar();
        String name = somePanel.getName();
        if (name != null) {
            this.statusPanel.add((Component)statusBar, name);
            if (somePanel instanceof IceEditPanel) {
                logger.debug("saveable panel");
                ((IceEditPanel)somePanel).addNameChangeListener(this);
            }
        } else {
            String errorString = "getName returned null from " + somePanel.getClass();
            logger.error(errorString);
            System.err.println(errorString);
        }
    }

    public Component getSelectedComponent() {
        return this.tabbedPane.getSelectedComponent();
    }

    public Rectangle getSelectedScreenBounds() {
        Rectangle bounds = this.tabbedPane.getSelectedComponent().getBounds();
        Point p = new Point(bounds.x, bounds.y);
        SwingUtilities.convertPointToScreen(p, this.tabbedPane);
        bounds.x = p.x;
        bounds.y = p.y;
        return bounds;
    }

    public void removeTab(Component comp) {
        Component thePanel = comp;
        if (comp instanceof JScrollPane) {
            JViewport theViewPort = null;
            theViewPort = ((JScrollPane)comp).getViewport();
            thePanel = theViewPort.getView();
        }
        if (thePanel instanceof GenericIcePanel) {
            ((GenericIcePanel)thePanel).panelRemovedFromWindow();
        }
        this.tabbedPane.remove(comp);
        this.statusPanel.remove(comp);
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public void setSelectedIndex(int index) {
        this.tabbedPane.setSelectedIndex(index);
    }

    public int indexOfComponent(Component comp) {
        return this.tabbedPane.indexOfComponent(comp);
    }

    public void addDragSourceListener(DragSourceListener dsl) {
        this.tabbedPane.addDragSourceListener(dsl);
    }

    private void die() {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof JScrollPane) {
                JScrollPane scrollPane = (JScrollPane)comp;
                comp = ((JScrollPane)comp).getViewport().getComponent(0);
                scrollPane.getViewport().removeAll();
            }
            ++i;
        }
    }

    public void addIceWindowCloseListener(IceWindowCloseListener mwl) {
        this.windowCloseListeners.add(mwl);
    }

    public void removeIceWindowCloseListener(IceWindowCloseListener mwl) {
        this.windowCloseListeners.remove(mwl);
    }

    private void notifyAllWindowClosingListeners(IceWindowEvent event) {
        int i = 0;
        while (i < this.windowCloseListeners.size()) {
            this.windowCloseListeners.get(i).windowClosing(event);
            ++i;
        }
    }

    public void addIceWindowOpenListener(IceWindowOpenListener mwl) {
        this.windowOpenListeners.add(mwl);
    }

    public void removeIceWindowOpenListener(IceWindowOpenListener mwl) {
        this.windowOpenListeners.remove(mwl);
    }

    public void notifyAllWindowOpenListeners(IceWindowEvent event) {
        int i = 0;
        while (i < this.windowOpenListeners.size()) {
            this.windowOpenListeners.get(i).windowOpen(event);
            ++i;
        }
    }

    private void notifyAllPanelClosingListeners(PanelCloseEvent event) {
        int i = 0;
        while (i < this.panelCloseListeners.size()) {
            this.panelCloseListeners.get(i).panelClosed(event);
            ++i;
        }
    }

    public boolean giveFocus(GenericIcePanel panel) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof JScrollPane) {
                comp = ((JScrollPane)comp).getViewport().getComponent(0);
            }
            if (comp == panel) {
                logger.debug("component getting focus: " + comp);
                this.tabbedPane.setSelectedIndex(i);
                return true;
            }
            ++i;
        }
        logger.debug("Unable to find panel to give focus.  Aborting.");
        return false;
    }

    public void propertyChange(PropertyChangeEvent pce) {
        Object source = pce.getSource();
        if (source instanceof KeyboardFocusManager) {
            Component component = ((KeyboardFocusManager)pce.getSource()).getFocusOwner();
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent ke) {
        return false;
    }

    public int indexAtLocation(int x, int y) {
        return this.tabbedPane.indexAtLocation(x, y);
    }

    private synchronized boolean closeAllPanels() {
        logger.debug("close selected");
        int tabCount = this.tabbedPane.getTabCount();
        Component[] components = this.tabbedPane.getComponents();
        int i = 0;
        while (i < tabCount) {
            Component comp = components[i];
            GenericIcePanel panel = null;
            panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
            if (!panel.panelClosing()) {
                return false;
            }
            this.removeTab(comp);
            ++i;
        }
        return true;
    }

    public int indexAtScreenLocation(Point p) {
        Point location = new Point(p);
        logger.debug("p: " + p);
        SwingUtilities.convertPointFromScreen(location, this.tabbedPane);
        logger.debug("p: " + p);
        logger.debug("location: " + location);
        return this.tabbedPane.indexAtLocation(location.x, location.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanClosed(BaseScanPanel bsp) {
        JMenuItem item = null;
        JMenu jMenu = this.viewMenu;
        synchronized (jMenu) {
            bsp.removeNameChangeListener(this);
            LinkedHashMap<String, JMenuItem> linkedHashMap = this.openedPanels;
            synchronized (linkedHashMap) {
                item = (JMenuItem)this.openedPanels.remove(bsp.getName());
            }
            if (item != null) {
                this.viewMenu.remove(item);
            } else {
                logger.error("Scan was never in the window menu.  Ignoring.  This shouldn't happen!");
            }
        }
    }

    public void addPanelCloseListener(IcePanelCloseListener pcl) {
        this.panelCloseListeners.add(pcl);
    }

    public void removePanelCloseListener(IcePanelCloseListener pcl) {
        this.panelCloseListeners.remove(pcl);
    }

    public void addReconnectReqListener(ReconnectReqListener rrl) {
        this.reconnectListeners.add(rrl);
    }

    public void removeReconnectReqListener(ReconnectReqListener rrl) {
        this.reconnectListeners.remove(rrl);
    }

    public void addChangeInstrumentReqListener(ChangeInstrReqListener cirl) {
        this.changeInstrumentListeners.add(cirl);
    }

    public void removeChangeInstrumentReqListener(ChangeInstrReqListener cirl) {
        this.changeInstrumentListeners.remove(cirl);
    }

    public void addChangeExpReqListener(ChangeExpReqListener cerl) {
        this.changeExpListeners.add(cerl);
    }

    public void removeChangeExpReqListener(ChangeExpReqListener cerl) {
        this.changeExpListeners.remove(cerl);
    }

    public void addChangeAdminModeReqListener(ChangeAdminModeReqListener caml) {
        this.adminModeListeners.add(caml);
    }

    public void removeChangeAdminModeReqListener(ChangeAdminModeReqListener caml) {
        this.adminModeListeners.remove(caml);
    }

    public void addExitReqListener(ExitReqListener erl) {
        this.exitListeners.add(erl);
    }

    public void removeExitReqListener(ExitReqListener erl) {
        this.exitListeners.remove(erl);
    }

    public void addLoadExpConfigReqListener(LoadExpConfigReqListener lecrl) {
        this.expConfigListeners.add(lecrl);
    }

    public void removeLoadExpConfigReqListener(LoadExpConfigReqListener lecrl) {
        this.expConfigListeners.remove(lecrl);
    }

    public void addLoadIcePanelListener(LoadIcePanelListener lipl) {
        this.loadIcePanelListeners.add(lipl);
    }

    public void removeLoadPanelReqListener(LoadIcePanelListener lipl) {
        this.loadIcePanelListeners.remove(lipl);
    }

    public void addLoadSaveableIcePanelListener(LoadSaveableIcePanelListener lsipl) {
        this.loadSaveableIcePanelListeners.add(lsipl);
    }

    public void removeLoadSaveablePanelListener(LoadSaveableIcePanelListener lsipl) {
        this.loadSaveableIcePanelListeners.remove(lsipl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nameChanged(NameChangeEvent nce) {
        try {
            GenericIcePanel panel = (GenericIcePanel)nce.getSource();
            String panelName = panel.getName();
            String oldName = nce.getOldName();
            GenericIcePanel genericIcePanel = panel;
            synchronized (genericIcePanel) {
                JMenuItem item = this.openedPanels.get(oldName);
                if (item != null) {
                    item.setText(panelName);
                    this.openedPanels.remove(oldName);
                    this.openedPanels.put(panelName, item);
                    IcePanelManager panelManager = IcePanelManager.getReference();
                    panelManager.updateIceWindowMenus(this.getTitle(), panelName, oldName);
                } else {
                    logger.error("Menu item was not in menu.  Ignoring.  This shouldn't happen!. No it should if the name was changed");
                }
            }
            int index = this.findPanel(panel);
            if (index != -1) {
                String name = nce.getNewName();
                if (name.length() > 12) {
                    name = String.valueOf(name.substring(0, 9)) + "...";
                }
                Thread thread2 = new Thread(new SetTabTitle(index, name, this.tabbedPane));
                SwingUtilities.invokeLater(thread2);
            }
        }
        catch (Exception e) {
            logger.error("Unable to change tab title.  This shouldn't happen.  Aborting.", e);
        }
    }

    public void selectPanel(GenericIcePanel thePanel) {
        int indexOfPanel = -1;
        indexOfPanel = this.findPanel(thePanel);
        if (indexOfPanel != -1) {
            this.setSelectedIndex(indexOfPanel);
        }
    }

    private int findPanel(GenericIcePanel panel) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof JScrollPane) {
                comp = ((JScrollPane)comp).getViewport().getComponent(0);
            }
            if (comp == panel) {
                return i;
            }
            ++i;
        }
        logger.error("Error finding panel (" + panel.getName() + ").  This shouldn't happen.");
        return -1;
    }

    public ArrayList<String> getAllPanelsNames() {
        ArrayList<String> panelNames = new ArrayList<String>();
        int tabCount = this.tabbedPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            Component comp = this.tabbedPane.getComponentAt(i);
            if (comp instanceof JScrollPane) {
                comp = ((JScrollPane)comp).getViewport().getComponent(0);
            }
            panelNames.add(comp.getClass().getSimpleName());
            ++i;
        }
        return panelNames;
    }

    @Override
    public void setTitle(String title) {
        String oldTitle = this.getTitle();
        super.setTitle(title);
    }

    @Override
    public synchronized void stateChanged(ChangeEvent ce) {
        logger.debug("icon: " + this.getIconImage());
        if (ce.getSource() != this.tabbedPane) {
            return;
        }
        Component comp = this.getSelectedComponent();
        GenericIcePanel panel = null;
        panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
        if (panel != null) {
            logger.debug("new tab in focus: " + panel.getName());
            String name = String.valueOf(panel.getName()) + ": " + this.getName();
            this.setIcon(panel);
            this.setTitle(name);
            this.saveItem.setAction(panel.getIceMenuAction(MENU_ACTION_SAVE));
            this.saveAsItem.setAction(panel.getIceMenuAction(MENU_ACTION_SAVE_AS));
            this.printItem.setAction(panel.getIceMenuAction(MENU_ACTION_PRINT));
            this.cutItem.setAction(panel.getIceMenuAction(MENU_ACTION_CUT));
            this.copyItem.setAction(panel.getIceMenuAction(MENU_ACTION_COPY));
            this.pasteItem.setAction(panel.getIceMenuAction(MENU_ACTION_PASTE));
            this.selectAllItem.setAction(panel.getIceMenuAction(MENU_ACTION_SELECT_ALL));
            this.selectNoneItem.setAction(panel.getIceMenuAction(MENU_ACTION_SELECT_NONE));
            this.customizeItem.setAction(panel.getIceMenuAction(MENU_ACTION_CUSTOMIZE));
            ((CardLayout)this.statusPanel.getLayout()).show(this.statusPanel, panel.getName());
            panel.requestFocusInIceWindow();
            this.parentPanel.invalidate();
            this.parentPanel.repaint();
        }
    }

    private void setIcon(GenericIcePanel panel) {
        ImageIcon icon = panel.getIcon();
        if (icon != null) {
            this.setIconImage(icon.getImage());
        } else {
            try {
                this.setIconImage(IconManager.getIcon("default").getImage());
            }
            catch (NullPointerException npe) {
                logger.error("Unable to load default icon!  THIS SHOULDN'T HAPPEN!", npe);
            }
        }
    }

    public boolean closePanel(GenericIcePanel thePanel) {
        Container theParent = null;
        Container whatToRemove = thePanel;
        theParent = thePanel.getParent();
        if (theParent != null) {
            if (theParent instanceof JViewport) {
                whatToRemove = ((JViewport)theParent).getParent();
            }
            if (!thePanel.panelClosing()) {
                return false;
            }
            this.removeTab(whatToRemove);
            PanelCloseEvent pce = new PanelCloseEvent(this, thePanel);
            this.notifyAllPanelClosingListeners(pce);
        }
        return true;
    }

    @Override
    public void processWindowEvent(WindowEvent we) {
        if (we.getID() == 201) {
            ArrayList<String> panels = this.getAllPanelsNames();
            logger.debug("panel size: " + panels.size());
            boolean closeResults = this.closeAllPanels();
            if (!closeResults) {
                return;
            }
            IceWindowEvent event = new IceWindowEvent(this, panels);
            this.notifyAllWindowClosingListeners(event);
        }
        super.processWindowEvent(we);
    }

    public ArrayList<LoadSaveableIcePanelListener> getLoadSaveableIcePanelListeners() {
        return this.loadSaveableIcePanelListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIceWindowMenu(HashMap<String, ArrayList<String>> windowMenuInfo) {
        JMenu jMenu = this.windowMenu;
        synchronized (jMenu) {
            LinkedHashMap<String, JMenuItem> linkedHashMap = this.openedPanels;
            synchronized (linkedHashMap) {
                this.windowMenu.removeAll();
                this.windowMenu.add(this.viewMenu);
                this.openedPanels.clear();
                Set<String> windowNames = windowMenuInfo.keySet();
                for (String windowName : windowNames) {
                    JMenu newWindow = new JMenu(windowName);
                    this.windowMenu.add(newWindow);
                    ArrayList<String> items = windowMenuInfo.get(windowName);
                    for (String itemName : items) {
                        JMenuItem item = new JMenuItem(itemName);
                        item.setAction(new LoadIcePanelAction(item.getText()));
                        newWindow.add(item);
                        this.openedPanels.put(itemName, item);
                    }
                    this.windowMenu.add(newWindow);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMenu findMenu(String name) {
        Component[] list;
        JMenu menu = null;
        Component[] componentArray = list = this.windowMenu.getComponents();
        synchronized (list) {
            int i = 0;
            while (i < list.length) {
                String compName;
                Component component = list[i];
                if (component instanceof JMenu && (compName = (menu = (JMenu)component).getText()).equals(name)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return menu;
                }
                ++i;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return menu;
        }
    }

    public void setIceWindowLocation(Point p) {
        this.windowLocation = p;
    }

    public void setIceWindowSize(Dimension d) {
        this.windowSize = d;
    }

    @Override
    public String getTitle() {
        String title = super.getTitle();
        if (title == null || title.equals("")) {
            title = this.getName();
        }
        return title;
    }

    private class AdminModeAction
    extends AbstractAction {
        public AdminModeAction() {
            this.putValue("Name", "Administrative Mode");
            this.putValue("MnemonicKey", new Integer(65));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            logger.debug("admin mode selected");
        }
    }

    private class ChangeExpAction
    extends AbstractAction {
        public ChangeExpAction() {
            this.putValue("Name", "Change Experiment");
            this.putValue("MnemonicKey", new Integer(88));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            IceWindowRequest mwr = new IceWindowRequest(IceWindow.this);
            Iterator iterator = IceWindow.this.changeExpListeners.iterator();
            while (iterator.hasNext()) {
                ((ChangeExpReqListener)iterator.next()).requestChangeExperiment(mwr);
            }
        }
    }

    private class ChangeInstrumentAction
    extends AbstractAction {
        public ChangeInstrumentAction() {
            this.putValue("Name", "Change Instrument");
            this.putValue("MnemonicKey", new Integer(73));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("change instrument selected");
            IceWindowRequest mwr = new IceWindowRequest(IceWindow.this);
            Iterator iterator = IceWindow.this.changeInstrumentListeners.iterator();
            while (iterator.hasNext()) {
                ((ChangeInstrReqListener)iterator.next()).requestChangeInstrument(mwr);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("Name", IceWindow.MENU_ACTION_CLOSE);
            this.putValue("MnemonicKey", new Integer(67));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("close selected");
            Component comp = IceWindow.this.getSelectedComponent();
            GenericIcePanel panel = null;
            panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
            IceWindow.this.closePanel(panel);
        }
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("MnemonicKey", new Integer(69));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("exit selected via " + ae.getSource().getClass());
            Iterator iterator = IceWindow.this.exitListeners.iterator();
            while (iterator.hasNext()) {
                ((ExitReqListener)iterator.next()).requestExit();
            }
        }
    }

    private class ExpConfigAction
    extends AbstractAction {
        public ExpConfigAction() {
            this.putValue("Name", "Experiment Configuration...");
            this.putValue("MnemonicKey", new Integer(69));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            IceWindow.this.sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults temperature", false);
            IceWindow.this.sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults magnet", false);
            IceWindow.this.sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults pressure", false);
            IceWindow.this.sendManager.addMessage("ask GETAVAILABLEDEVICEDEFAULTS getdevicedefaults other", false);
            logger.debug("Request to load exp config window via " + ae.getClass().getName());
            IceWindowRequest mwr = new IceWindowRequest(IceWindow.this);
            Iterator iterator = IceWindow.this.expConfigListeners.iterator();
            while (iterator.hasNext()) {
                ((LoadExpConfigReqListener)iterator.next()).requestLoadExpConfig(mwr);
            }
        }
    }

    protected class InstrumentStateLabel
    extends JLabel
    implements InstrumentValueChangedListener {
        public InstrumentStateLabel(String message) {
            super("<html><b>Instrument State: </b>" + message + "</html>");
        }

        @Override
        public void actionPerformed(InstrumentValueChangedEvent pce) {
            if (pce.getPropertyName().equals("state")) {
                String newLabelText = "<html><b>Instrument State: </b>" + IceWindow.this.instrument.getState().toString().toUpperCase() + "</html>";
                this.setText(newLabelText);
            }
        }
    }

    private class LoadAboutAction
    extends AbstractAction {
        public LoadAboutAction() {
            this.putValue("Name", "About Ice Client");
            this.putValue("MnemonicKey", new Integer(65));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            logger.debug("load about selected");
        }
    }

    private class LoadBugReportAction
    extends AbstractAction {
        public LoadBugReportAction() {
            this.putValue("Name", "User Request and Bug Submission");
            this.putValue("MnemonicKey", new Integer(82));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ReportBugDialog reportBugDialog = null;
            try {
                reportBugDialog = ReportBugDialog.getInstance(IceWindow.this);
            }
            finally {
                logger.debug("load bug report selected");
            }
        }
    }

    private class LoadIcePanelAction
    extends AbstractAction {
        public LoadIcePanelAction(String name) {
            this.putValue("Name", name);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String name = (String)this.getValue("Name");
            Iterator iterator = IceWindow.this.loadIcePanelListeners.iterator();
            while (iterator.hasNext()) {
                LoadIcePanelEvent event = new LoadIcePanelEvent(IceWindow.this, name);
                ((LoadIcePanelListener)iterator.next()).instantiateIcePanel(event);
            }
        }
    }

    private class LoadSaveableIcePanelAction
    extends AbstractAction {
        public LoadSaveableIcePanelAction(String name) {
            this.putValue("Name", name);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JMenuItem item = (JMenuItem)ae.getSource();
            String name = item.getText();
            Iterator iterator = IceWindow.this.loadSaveableIcePanelListeners.iterator();
            while (iterator.hasNext()) {
                LoadSaveableIcePanelEvent event = new LoadSaveableIcePanelEvent(IceWindow.this, name, null);
                ((LoadSaveableIcePanelListener)iterator.next()).instantiateSaveableIcePanel(event);
            }
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            this.putValue("Name", "Open...");
            this.putValue("MnemonicKey", new Integer(79));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            logger.debug("open selected");
            JFileChooser fc = new JFileChooser();
            Component comp = IceWindow.this.getSelectedComponent();
            GenericIcePanel panel = null;
            panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
            fc.setDialogTitle("Open File");
            int result = fc.showOpenDialog(panel);
        }
    }

    private class OptionsAction
    extends AbstractAction {
        public OptionsAction() {
            this.putValue("Name", "Options...");
            this.putValue("MnemonicKey", new Integer(79));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            logger.debug("options selected");
        }
    }

    private class ReconnectAction
    extends AbstractAction {
        public ReconnectAction() {
            this.putValue("Name", "Reconnect");
            this.putValue("MnemonicKey", new Integer(82));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            logger.debug("reconnect selected");
        }
    }

    private class SetSizeandLocationRunnable
    implements Runnable {
        private Point location;
        private Dimension size;

        public SetSizeandLocationRunnable(Point location, Dimension size) {
            this.location = location;
            this.size = size;
        }

        @Override
        public void run() {
            try {
                IceWindow.this.pack();
                if (this.size == null) {
                    this.size = IceWindow.this.getSize();
                    this.size.width += 30;
                }
                IceWindow.this.setSize(this.size);
                IceWindow.this.setLocation(this.location);
            }
            catch (RuntimeException re) {
                System.out.println(re);
            }
        }
    }

    private class SetTabTitle
    implements Runnable {
        private int index;
        private String title;
        private JTabbedPane tabbedPane;

        public SetTabTitle(int index, String title, JTabbedPane tabbedPane) {
            this.index = index;
            this.title = title;
            this.tabbedPane = tabbedPane;
        }

        @Override
        public void run() {
            try {
                this.tabbedPane.setTitleAt(this.index, this.title);
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    private class TabLeftAction
    extends AbstractAction {
        private TabLeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("tab left");
        }
    }

    private class TabRightAction
    extends AbstractAction {
        private TabRightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("tab right");
        }
    }

    private class UndoAction
    extends AbstractAction {
        public UndoAction() {
            this.putValue("Name", "Undo");
            this.putValue("MnemonicKey", new Integer(85));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            logger.debug("undo selected");
        }
    }

    private class WindowFocusAdapter
    implements WindowFocusListener {
        private WindowFocusAdapter() {
        }

        @Override
        public void windowGainedFocus(WindowEvent arg0) {
            Component comp = IceWindow.this.getSelectedComponent();
            GenericIcePanel panel = null;
            panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
            if (panel != null) {
                panel.requestFocusInIceWindow();
            }
        }

        @Override
        public void windowLostFocus(WindowEvent arg0) {
        }
    }
}

