/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.swing.IceTextField;
import ice.util.I18N;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class IceDialog
extends JDialog {
    public IceDialog() {
    }

    public IceDialog(Frame owner) {
        super(owner);
    }

    public IceDialog(Dialog owner) {
        super(owner);
    }

    public IceDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public IceDialog(Frame owner, String title) {
        super(owner, title);
    }

    public IceDialog(Dialog owner, boolean modal) {
        super(owner, modal);
    }

    public IceDialog(Dialog owner, String title) {
        super(owner, title);
    }

    public IceDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public IceDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public IceDialog(Frame owner, String title, boolean modal, GraphicsConfiguration gc2) {
        super(owner, title, modal, gc2);
    }

    public IceDialog(Dialog owner, String title, boolean modal, GraphicsConfiguration gc2) {
        super(owner, title, modal, gc2);
    }

    public boolean determineNumberValidityWithDialog(Map<IceTextField, String> map) {
        boolean allValid = true;
        String errorMsg = I18N.getString("invalidNumberError");
        StringBuilder invalidFields = new StringBuilder();
        for (IceTextField field : map.keySet()) {
            if (field.containsNumber()) continue;
            allValid = false;
            invalidFields.append(", " + map.get(field));
        }
        if (allValid) {
            return true;
        }
        errorMsg = errorMsg.concat(invalidFields.substring(2));
        this.throwErrorDialog(I18N.getString("invalidNumber.title"), errorMsg);
        return false;
    }

    public void centerOnParent() {
        Container parent = null;
        parent = this.getParent();
        if (parent != null) {
            Point parentLocation = parent.getLocation();
            Dimension parentSize = this.getParent().getSize();
            Dimension dialogSize = this.getSize();
            this.setLocation(parentLocation.x + parentSize.width / 2 - dialogSize.width / 2, parentLocation.y + parentSize.height / 2 - dialogSize.height / 2);
        }
    }

    public void throwErrorDialog(String title, String message) {
        JButton okBtn = new JButton("OK");
        Object[] options = new Object[]{okBtn};
        JOptionPane optionPane = new JOptionPane(message, 0, -1, (Icon)UIManager.get("OptionPane.errorIcon"), options);
        final JDialog errorDialog = new JDialog(this);
        errorDialog.setTitle(title);
        errorDialog.setModal(true);
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                errorDialog.dispose();
            }
        });
        errorDialog.setDefaultCloseOperation(2);
        errorDialog.setContentPane(optionPane);
        errorDialog.pack();
        errorDialog.setLocationRelativeTo(this);
        errorDialog.setVisible(true);
    }

    public String getUserSelection() {
        return null;
    }
}

