/*
 * Decompiled with CFR 0.152.
 */
package ice.data.tas.bt7;

import ice.data.tas.bt7.PeakSet;
import ice.event.UBMatrixPropertyChangedEvent;
import ice.event.UBMatrixPropertyChangedListener;
import ice.event.tas.bt7.PeakSetListModifiedEvent;
import ice.event.tas.bt7.PeakSetListModifiedListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;

public class UBMatrix {
    public static String referencePlaneFieldName = "referencePlane";
    public static String inputChangedSinceLastCalcFieldName = "inputChangedSinceLastCalc";
    public static String primaryPeakSetFieldName = "primaryPeakSet";
    protected ReferencePlane referencePlane = ReferencePlane.UNKNOWN;
    protected Boolean inputChangedSinceLastCalc = null;
    protected PeakSet primaryPeakSet = null;
    protected ArrayList<PeakSet> peakSetList = new ArrayList();
    protected ICEListenerList<UBMatrixPropertyChangedListener, UBMatrixPropertyChangedEvent> propertyChangeListeners = new ICEListenerList();
    protected ICEListenerList<PeakSetListModifiedListener, PeakSetListModifiedEvent> peakSetListModifiedListeners = new ICEListenerList();

    public boolean isInputChangedSinceLastCalc() {
        return this.inputChangedSinceLastCalc;
    }

    public void setInputChangedSinceLastCalc(boolean newInputChangedSinceLastCalc) {
        Boolean oldInputChangedSinceLastCalc = this.inputChangedSinceLastCalc;
        this.inputChangedSinceLastCalc = newInputChangedSinceLastCalc;
        this.notifyPropertyChangeListeners(inputChangedSinceLastCalcFieldName, oldInputChangedSinceLastCalc, this.inputChangedSinceLastCalc);
    }

    public PeakSet getPrimaryPeakSet() {
        return this.primaryPeakSet;
    }

    public void setPrimaryPeakSet(PeakSet newPrimaryPeakSet) {
        this.primaryPeakSet = newPrimaryPeakSet;
    }

    public void setPrimaryPeakSet(Integer newPrimaryPeakSetID) {
        boolean successful = false;
        PeakSet oldPrimaryPeakSet = this.primaryPeakSet;
        if (newPrimaryPeakSetID == null) {
            this.primaryPeakSet = null;
            successful = true;
        } else {
            int size = this.peakSetList.size();
            int i = 0;
            while (i < size) {
                if (this.peakSetList.get(i).getId() == newPrimaryPeakSetID.intValue()) {
                    this.primaryPeakSet = this.peakSetList.get(i);
                    successful = true;
                    break;
                }
                ++i;
            }
        }
        if (!successful) {
            throw new IllegalArgumentException("No PeakSet with specified ID exists.");
        }
        this.notifyPropertyChangeListeners(primaryPeakSetFieldName, oldPrimaryPeakSet, this.primaryPeakSet);
    }

    public ReferencePlane getReferencePlane() {
        return this.referencePlane;
    }

    public void setReferencePlane(ReferencePlane newReferencePlane) {
        ReferencePlane oldRefPlane = this.referencePlane;
        this.referencePlane = newReferencePlane;
        this.notifyPropertyChangeListeners(referencePlaneFieldName, (Object)oldRefPlane, (Object)this.referencePlane);
    }

    public void addPeakSet(PeakSet ps) {
        this.peakSetList.add(ps);
        this.notifyPeakModifiedListeners(PeakSetListModifiedEvent.EventType.PEAK_SET_ADDED, ps);
    }

    public void removePeakSet(PeakSet ps) {
        if (this.primaryPeakSet == ps) {
            this.setPrimaryPeakSet((PeakSet)null);
        }
        this.peakSetList.remove(ps);
        this.notifyPeakModifiedListeners(PeakSetListModifiedEvent.EventType.PEAK_SET_REMOVED, ps);
    }

    public ArrayList<PeakSet> getPeakSetList() {
        return this.peakSetList;
    }

    public void addPropertyChangeListener(UBMatrixPropertyChangedListener pcl) throws ICEListenerListExceptionBase {
        this.propertyChangeListeners.addListener(pcl);
    }

    public void removePropertyChangeListener(UBMatrixPropertyChangedListener pcl) {
        this.propertyChangeListeners.removeListener(pcl);
    }

    public void addPeakSetListModifiedListener(PeakSetListModifiedListener pslml) throws ICEListenerListExceptionBase {
        this.peakSetListModifiedListeners.addListener(pslml);
    }

    public void removePeakSetListModifiedListener(PeakSetListModifiedListener pslml) {
        this.peakSetListModifiedListeners.removeListener(pslml);
    }

    public PeakSet getPeakSet(int id) {
        for (PeakSet ps : this.peakSetList) {
            if (ps.getId() != id) continue;
            return ps;
        }
        return null;
    }

    public void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        UBMatrixPropertyChangedEvent event = new UBMatrixPropertyChangedEvent(this, propertyName, oldValue, newValue);
        this.propertyChangeListeners.notifyListeners(event);
    }

    public boolean removePeakSet(int id) {
        int size = this.peakSetList.size();
        int i = 0;
        while (i < size) {
            PeakSet peakSet = this.peakSetList.get(i);
            if (peakSet.getId() == id) {
                if (peakSet == this.primaryPeakSet) {
                    this.setPrimaryPeakSet((PeakSet)null);
                }
                this.peakSetList.remove(i);
                this.notifyPeakModifiedListeners(PeakSetListModifiedEvent.EventType.PEAK_SET_REMOVED, peakSet);
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void notifyPeakModifiedListeners(PeakSetListModifiedEvent.EventType eventType, PeakSet peakSet) {
        PeakSetListModifiedEvent pslme = new PeakSetListModifiedEvent(this, eventType, peakSet);
        this.peakSetListModifiedListeners.notifyListeners(pslme);
    }

    public static enum ReferencePlane {
        A,
        B,
        UNKNOWN;

    }
}

