/*
 * Decompiled with CFR 0.152.
 */
package ice.data.tas.bt7;

import ice.Global;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.Analyzer;
import ice.data.tas.bt7.Collimator;
import ice.data.tas.bt7.Monochromator;
import ice.event.communication.InstrumentChangeEvent;
import ice.event.communication.InstrumentChangeListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.event.communication.StatusChangeEvent;
import ice.event.communication.StatusChangeListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class Instrument
implements InstrumentChangeListener,
StatusChangeListener {
    private static Logger logger = Logger.getLogger("ICE.instrument");
    public static final String nameFieldName = "name";
    public static final String devicesFieldName = "devices";
    public static final String stateFieldName = "state";
    public static final String currentScanFieldName = "currentScan";
    public static final String currentScanPointFieldName = "currScanPnt";
    public static final String totalScanPointsFieldName = "totalScanPnts";
    public static final String timeFieldName = "time";
    public static final String fixedEnergyFieldName = "fixedEnergy";
    public static final String verticalFocusModeFieldName = "verticalFocusMode";
    public static final String horizontalFocusModeFieldName = "horizontalFocusMode";
    public static final String phiFieldName = "phi";
    public static final String monochromatorFieldName = "monochromator";
    public static final String analyzerFieldName = "analyzer";
    public static final String filterModesFieldName = "filterModes";
    public static final String preMonochromatorCollimatorFieldName = "preMonoCollimator";
    public static final String postMonochromatorCollimatorFieldName = "postMonoCollimator";
    public static final String preAnalyzerCollimatorFieldName = "preAnalCollimator";
    public static final String postAnalyzerCollimatorFieldName = "postAnalCollimator";
    public static final String detectorModeFieldName = "detectorMode";
    public static final String currentOwnerFieldName = "currentOwner";
    public static final String ubModeFieldName = "ubMode";
    public static final String analyzerModeFieldName = "analyzerMode";
    public static final String pathFieldName = "path";
    public static final String defaultSampleChangerFieldName = "defaultSampleChanger";
    private boolean statusInitialized = false;
    private boolean instrumentInitialized = false;
    private String name;
    private String path;
    private State state;
    private String currentScan;
    private String currentOwner;
    private long currScanPnt;
    private long totalScanPnts;
    private Date time;
    private FixedEnergy fixedEnergy;
    private VerticalFocusMode verticalFocusMode;
    private HorizontalFocusMode horizontalFocusMode;
    private double phi;
    private Monochromator monochromator;
    private Analyzer analyzer;
    private String[] filterModes;
    private Collimator preMonoCollimator;
    private Collimator postMonoCollimator;
    private Collimator preAnalCollimator;
    private Collimator postAnalCollimator;
    private DetectorMode detectorMode;
    private AnalyzerMode analyzerMode;
    protected boolean ubMode;
    private String defaultSampleChanger;
    private String[] sampleHolderPositions;
    private ArrayList<InstalledDevice> devices = new ArrayList();
    protected ICEListenerList<InstrumentValueChangedListener, InstrumentValueChangedEvent> changeListeners = new ICEListenerList();
    private static Instrument instance = null;

    public boolean isInitialized() {
        return this.statusInitialized && this.instrumentInitialized;
    }

    protected Instrument() {
        this.changeListeners.setMaxCapacity(1000);
        this.monochromator = new Monochromator();
        this.analyzer = new Analyzer();
        this.filterModes = new String[2];
        this.filterModes[0] = "In";
        this.filterModes[1] = "Out";
        String[] preMonoCollModes = new String[]{"Open", "10Min", "25Min", "50Min"};
        String[] postMonoCollModes = new String[]{"Undefined", "Open", "10Min", "25Min", "50Min", "1 inch", "1.625 inches"};
        String[] preAnalModes = new String[]{"Undefined", "Open", "20Min", "40Min", "80Min"};
        String[] postAnalModes = new String[]{"Undefined", "Open", "20Min", "40Min", "180Min"};
        this.preMonoCollimator = new Collimator(preMonoCollModes);
        this.postMonoCollimator = new Collimator(postMonoCollModes);
        this.preAnalCollimator = new Collimator(preAnalModes);
        this.postAnalCollimator = new Collimator(postAnalModes);
        this.detectorMode = DetectorMode.UNKNOWN;
        this.analyzerMode = AnalyzerMode.unknown;
        this.ubMode = false;
        this.defaultSampleChanger = "N/A";
        this.name = "";
        this.setSampleHolderPositions(null);
    }

    public static Instrument getInstance() {
        if (instance == null) {
            instance = new Instrument();
        }
        return instance;
    }

    public static void destroyInstance() {
        instance = null;
    }

    public void addPropertyChangeListener(InstrumentValueChangedListener pcl) throws ICEListenerListExceptionBase {
        this.changeListeners.addListener(pcl);
    }

    public void removePropertyChangeListener(InstrumentValueChangedListener pcl) {
        this.changeListeners.removeListener(pcl);
    }

    public void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        InstrumentValueChangedEvent pce = new InstrumentValueChangedEvent(this, propertyName, oldValue, newValue);
        this.changeListeners.notifyListeners(pce);
    }

    public String getCurrentScan() {
        return this.currentScan;
    }

    public void setCurrentScan(String currentScan) {
        String oldScan = this.currentScan;
        this.currentScan = currentScan;
        this.notifyPropertyChangeListeners(currentScanFieldName, oldScan, this.currentScan);
    }

    public ArrayList<InstalledDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(ArrayList<InstalledDevice> devices) {
        ArrayList<InstalledDevice> oldDevices = this.devices;
        this.devices = devices;
        this.notifyPropertyChangeListeners(devicesFieldName, oldDevices, this.devices);
    }

    public FixedEnergy getEiOrEfFixed() {
        return this.fixedEnergy;
    }

    public void setEiOrEfFixed(FixedEnergy fixedEnergy) {
        FixedEnergy oldFixedEnergy = this.fixedEnergy;
        this.fixedEnergy = fixedEnergy;
        this.notifyPropertyChangeListeners(fixedEnergyFieldName, (Object)oldFixedEnergy, (Object)this.fixedEnergy);
    }

    public HorizontalFocusMode getHorizontalFocusMode() {
        return this.horizontalFocusMode;
    }

    public void setHorizontalFocusMode(HorizontalFocusMode horizontalFocusMode) {
        HorizontalFocusMode oldHorizFocusMode = this.horizontalFocusMode;
        this.horizontalFocusMode = horizontalFocusMode;
        this.notifyPropertyChangeListeners(horizontalFocusModeFieldName, (Object)oldHorizFocusMode, (Object)this.horizontalFocusMode);
    }

    public VerticalFocusMode getVerticalFocusMode() {
        return this.verticalFocusMode;
    }

    public void setVerticalFocusMode(VerticalFocusMode verticalFocusMode) {
        VerticalFocusMode oldVertFocusMode = this.verticalFocusMode;
        this.verticalFocusMode = verticalFocusMode;
        this.notifyPropertyChangeListeners(verticalFocusModeFieldName, (Object)oldVertFocusMode, (Object)this.verticalFocusMode);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.notifyPropertyChangeListeners(nameFieldName, oldName, this.name);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String oldPath = this.path;
        this.path = path;
        this.notifyPropertyChangeListeners(pathFieldName, oldPath, this.path);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        State oldState = this.state;
        this.state = state;
        this.notifyPropertyChangeListeners(stateFieldName, (Object)oldState, (Object)this.state);
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        Date oldTime = this.time;
        this.time = time;
        this.notifyPropertyChangeListeners(timeFieldName, oldTime, this.time);
    }

    public long getCurrScanPnt() {
        return this.currScanPnt;
    }

    public void setCurrScanPnt(long currScanPnt) {
        long oldCurrScanPnt = this.currScanPnt;
        this.currScanPnt = currScanPnt;
        this.notifyPropertyChangeListeners(currentScanPointFieldName, oldCurrScanPnt, this.currScanPnt);
    }

    public long getTotalScanPnts() {
        return this.totalScanPnts;
    }

    public void setTotalScanPnts(long totalScanPnts) {
        long oldTotalScanPnts = this.totalScanPnts;
        this.totalScanPnts = totalScanPnts;
        this.notifyPropertyChangeListeners(totalScanPointsFieldName, oldTotalScanPnts, this.totalScanPnts);
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Monochromator getMonochromator() {
        return this.monochromator;
    }

    public String[] getFilterModes() {
        return (String[])this.filterModes.clone();
    }

    public Collimator getPostAnalCollimator() {
        return this.postAnalCollimator;
    }

    public Collimator getPostMonoCollimator() {
        return this.postMonoCollimator;
    }

    public Collimator getPreAnalCollimator() {
        return this.preAnalCollimator;
    }

    public Collimator getPreMonoCollimator() {
        return this.preMonoCollimator;
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double phi) {
        double oldPhi = this.phi;
        this.phi = phi;
        this.notifyPropertyChangeListeners(phiFieldName, oldPhi, this.phi);
    }

    public String getCurrentOwner() {
        return this.currentOwner;
    }

    public void setCurrentOwner(String currentOwner) {
        String oldOwner = this.currentOwner;
        this.currentOwner = currentOwner;
        this.notifyPropertyChangeListeners(currentOwnerFieldName, oldOwner, this.currentOwner);
    }

    public DetectorMode getDetectorMode() {
        return this.detectorMode;
    }

    public void setDetectorMode(DetectorMode detectorMode) {
        DetectorMode oldMode = this.detectorMode;
        this.detectorMode = detectorMode;
        this.notifyPropertyChangeListeners(detectorModeFieldName, (Object)oldMode, (Object)this.detectorMode);
    }

    public AnalyzerMode getAnalyzerMode() {
        return this.analyzerMode;
    }

    public void setAnalyzerMode(AnalyzerMode analyzerMode) {
        AnalyzerMode oldMode = this.analyzerMode;
        this.analyzerMode = analyzerMode;
        this.notifyPropertyChangeListeners(analyzerModeFieldName, (Object)oldMode, (Object)this.analyzerMode);
    }

    public boolean isUbMode() {
        return this.ubMode;
    }

    public void setUbMode(boolean newUBMode) {
        boolean oldUBMode = this.ubMode;
        this.ubMode = newUBMode;
        this.notifyPropertyChangeListeners(ubModeFieldName, oldUBMode, this.ubMode);
    }

    @Override
    public void statusChanged(StatusChangeEvent sce) {
        this.setState(sce.getState());
        if (sce.getInstrumentName() != null) {
            this.setName(sce.getInstrumentName());
            Global.setInstrumentName(sce.getInstrumentName());
        }
        if (sce.getInstrumentPath() != null) {
            this.setPath(sce.getInstrumentPath());
            Global.setInstrumentPath(sce.getInstrumentPath());
        }
        if (sce.getTime() != null) {
            this.setTime(sce.getTime());
        }
        if (sce.getScanPoint() != null) {
            this.setCurrScanPnt(sce.getScanPoint().intValue());
        }
        if (sce.getTotalScanPoints() != null) {
            this.setTotalScanPnts(sce.getTotalScanPoints().intValue());
        }
        if (!this.statusInitialized) {
            logger.debug("Status initialized.");
            this.statusInitialized = true;
        }
    }

    @Override
    public synchronized void actionPerformed(InstrumentChangeEvent ice) {
        if (this.getVerticalFocusMode() != ice.getVerticalFocus()) {
            this.setVerticalFocusMode(ice.getVerticalFocus());
        }
        if (this.getHorizontalFocusMode() != ice.getHorizontalFocus()) {
            this.setHorizontalFocusMode(ice.getHorizontalFocus());
        }
        if (!Global.equals(this.getPhi(), ice.getPhi())) {
            this.setPhi(ice.getPhi());
        }
        if (!Global.equals(this.getAnalyzer().getDSpacing(), ice.getAnalyzerDSpacing())) {
            logger.debug("setting analyzer d-spacing");
            this.getAnalyzer().setDSpacing(ice.getAnalyzerDSpacing());
        }
        if (!Global.equals(this.getMonochromator().getDSpacing(), ice.getMonochromatorDSpacing())) {
            this.getMonochromator().setDSpacing(ice.getMonochromatorDSpacing());
        }
        if (this.getDetectorMode() != ice.getDetectorMode()) {
            this.setDetectorMode(ice.getDetectorMode());
        }
        if (this.getAnalyzerMode() != ice.getAnalyzerMode()) {
            this.setAnalyzerMode(ice.getAnalyzerMode());
        }
        if (this.isUbMode() != ice.isUbMode()) {
            this.setUbMode(ice.isUbMode());
        }
        if (!this.getDefaultSampleChanger().equals(ice.getDefaultSampleChanger())) {
            this.setDefaultSampleChanger(ice.getDefaultSampleChanger());
        }
        this.setSampleHolderPositions(ice.getSampleHolderPositions());
        if (!this.instrumentInitialized) {
            logger.debug("Instrument initialized.");
            this.instrumentInitialized = true;
        }
    }

    public void setDefaultSampleChanger(String block) {
        String oldBlock = this.defaultSampleChanger;
        this.defaultSampleChanger = block;
        this.notifyPropertyChangeListeners(defaultSampleChangerFieldName, oldBlock, this.defaultSampleChanger);
    }

    public String getDefaultSampleChanger() {
        return this.defaultSampleChanger;
    }

    public void setSampleHolderPositions(String[] sampleHolderPositions) {
        this.sampleHolderPositions = sampleHolderPositions;
    }

    public String[] getSampleHolderPositions() {
        return this.sampleHolderPositions;
    }

    public static enum AnalyzerMode {
        flat("Flat"),
        energy("Energy"),
        unknown("Unknown");

        private String name;

        private AnalyzerMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum DetectorMode {
        SINGLEDETECTOR,
        DIFFRACTIONDETECTOR,
        POSITIONSENSITIVEDETECTOR,
        UNKNOWN;

    }

    public static enum FixedEnergy {
        initialEnergy,
        finalEnergy;

    }

    public static enum HorizontalFocusMode {
        energy,
        flat,
        point,
        venetian,
        unknown;

    }

    public static enum State {
        busy("Busy"),
        idle("Idle"),
        pause("Pause"),
        scan("Busy"),
        unknown("Unknown");

        private String name;

        private State(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum VerticalFocusMode {
        flat,
        sagittal,
        unknown;

    }
}

