/*
 * Decompiled with CFR 0.152.
 */
package ice.data.tas.bt7;

public class Collimator {
    private String[] allModes;
    private int currMode;

    public Collimator(String[] allModes) {
        this.init(allModes, 0);
    }

    public Collimator(String[] allModes, int currMode) {
        this.init(allModes, currMode);
    }

    private void init(String[] allModes, int currMode) throws IllegalArgumentException {
        int length = allModes.length;
        if (length == 0) {
            throw new IllegalArgumentException("Array of modes (first parameter) must have at least one element.");
        }
        this.allModes = new String[length];
        int i = 0;
        while (i < length) {
            this.allModes[i] = allModes[i];
            ++i;
        }
        this.currMode = currMode;
    }

    public String[] getModes() {
        return (String[])this.allModes.clone();
    }

    public String getCurrModeAsString() {
        return this.allModes[this.currMode];
    }

    public int getCurrMode() {
        return this.currMode;
    }
}

